#ifndef _WINBUF_H
#define _WINBUF_H

#ifndef __OWL_H
#   include <owl.h>
#endif
#ifndef __WINDOWSX_H
#   include <windowsx.h>  
#endif

// -------------------------------------------------------
//  TWinBuffered ("TWinBuf")
//
//  An abstract window class that tries to allocate
//  a buffer whenever its size changes (unless buffering
//  is turned off).  It then processes redraws by
//  BitBlt'ing from its buffer whenever possible.
//  
class _EXPORT TWinBuffered : public TWindow
{
public:
    TWinBuffered(PTWindowsObject AParent, 
                 LPSTR           ATitle, 
                 PTModule        AModule          = NULL,
                 BOOL            bBufferedRedraw_ = TRUE);
    virtual ~TWinBuffered();
    virtual void SetbBufferedRedraw(BOOL b);

protected:
    BOOL     bBufferedRedraw; // use a redraw buffer or not
    HBITMAP  hbmBuffer;       // our redraw buffer, if any
    SIZE     size;            // size of our client area

    virtual LPSTR GetClassName()
        { return "TWinBuffered"; }

    virtual void WMSize  (RTMessage) = [WM_FIRST + WM_SIZE];
    virtual void Paint(HDC hdc, PAINTSTRUCT&);

    //
    //  For internal use only:
    //
    virtual void prvDrawWithBuffer(HDC hdc,PAINTSTRUCT &ps);

    //
    //  Desendants must provide a version of this.
    //
    virtual void prvDraw(HDC hdc, HDC hdc2 = 0) = 0;
};
#endif // #ifndef _WINBUF_H

