/* 
 * whello.c
 *
 * James K. Lawless
 * 1622 Ave F
 * Council Bluffs, IA 51501
 *
 * This code is in reference to Steve Spector's
 * Tech Tip in the May 1993 issue of Windows/
 * DOS Developer's Journal.
 *
 * Compile (Microsoft C):
 *      nmake whello.mak
 */


#include <windows.h>

LONG FAR PASCAL  WndProc(HWND,WORD,WPARAM,LPARAM);

HWND _hMainWnd;

int PASCAL WinMain(HINSTANCE hInstance,
                       HINSTANCE hPrevInstance,
                       LPSTR lpszCmdParam, int nCmdShow)
{
   LPSTR lpszClass="HelloWin w/Return";
   MSG  msg;
   WNDCLASS wndclass;

   if(hPrevInstance) {
      HWND hWnd;
      if(GetInstanceData(hPrevInstance,
         (BYTE NEAR *)(&_hMainWnd),sizeof(HWND))==sizeof(HWND)){

         if(IsIconic(hWnd=GetLastActivePopup(_hMainWnd)))
            ShowWindow(hWnd,SW_RESTORE);

         SetActiveWindow(hWnd);

      }      
      return(0);
   }

   wndclass.style        = CS_HREDRAW | CS_VREDRAW;   
   wndclass.lpfnWndProc  = (WNDPROC)WndProc;
   wndclass.cbClsExtra   = 
   wndclass.cbWndExtra   = 0;
   wndclass.hInstance    = hInstance;
   wndclass.hIcon        = LoadIcon(NULL, 
                             IDI_APPLICATION);
   wndclass.hCursor      = LoadCursor(NULL,IDC_ARROW);
   wndclass.hbrBackground= GetStockObject(WHITE_BRUSH);
   wndclass.lpszMenuName = NULL;
   wndclass.lpszClassName=lpszClass;

   RegisterClass(&wndclass);
   _hMainWnd=CreateWindow(lpszClass,
                     lpszClass,
                     WS_OVERLAPPEDWINDOW | WS_VISIBLE,
                     0,0,200,200,
                     NULL,
                     NULL,
                     hInstance,
                     NULL);

   ShowWindow(_hMainWnd,nCmdShow);
   UpdateWindow(_hMainWnd);

   while(GetMessage(&msg,NULL,0,0)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
   return(msg.wParam);
}

LONG FAR PASCAL WndProc(HWND hWnd, WORD message,
                WPARAM wParam, LPARAM lParam)
{
   HDC hDC;
   PAINTSTRUCT ps;
   RECT rect;

   switch(message) {
      case WM_PAINT:
         hDC=BeginPaint(hWnd,&ps);
         GetClientRect(hWnd,&rect);
         DrawText(hDC,"Hello, Windows!",-1,&rect,
            DT_SINGLELINE|DT_CENTER|DT_VCENTER);
         EndPaint(hWnd,&ps);
         return(0);

      case WM_DESTROY:
         PostQuitMessage(0);
         return(0);
   }
   return(DefWindowProc(hWnd,message,wParam,lParam));
}
