/*
 * vformat.c:
 *  Illustrates John N. Power's technique of passing variable format
 *  strings and variable data-type parameters in printf() calls.
 * 
 * Compile & Link (Borland C):
 *  bcc vformat.c
 */

#include    "stdio.h"

#define     REAL    0
#define     INTEGER 1
#define     ERROR   2

char *fill[] = {"          ",
        " ........ " };

union number {
    double real;  /* <- Must use a double, not a float, since printf  */
    int fix;      /*      expects floats to be promoted when passed.  */
} sample;

void outnum(int type, union number *parm);

main()
{
    int i;

    for(i=1;i<11;i++){
        sample.fix = i;
        outnum(INTEGER, &sample);
        printf(*(fill + ((i % 3) == 0)));
        sample.real = sample.fix;  /* <- implied type conversion */
        outnum(REAL, &sample);
    }
    return 0;
}

char *format[] = {      "%5.2f\n",
            "%5d",
            "*ERR*" };

void outnum(int type, union number *parm)
{
    if ((type != REAL) && (type != INTEGER))
        type = ERROR;
    printf(*(format + type), *parm);

    /* Pass the entire union by value.  Let printf figure
    out how much of it to use.  This union must be the last
    variable passed to printf, since printf determines the
    locations of its parameters from the lengths of the parameters,
    as indicated by the fields in the format string.  Since not
    all of the union may be used, placing the union anywhere but
    at the end will cause printf to mislocate the following
    variables.    */
}
