/*
    RmLabel.C - Remove Disk Volume Label for DOS
    Copyright (c) Smuth Nakpansua, 1992, 1993.  All rights reserved.
    Create date:  Nov 25, 1992
    Last Update:  March 23, 1993
 
    Compile:  cl rmlabel.c dsklabel.obj     (Microsoft)
              bcc rmlabel.c dsklabel.obj    (Borland)
*/
 
#include <dos.h>
#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
 
#include "dsklabel.h"
 
int main(int argc, char **argv)
{
    int drive;
 
    printf("RmLabel - Remove Label Utility\n"
           "Copyright (c) Smuth Nakpansua, 1992, 1993.  All rights reserved\n\n");
    if (argc != 2) {
        printf("usage: RMLABEL <drive:>\n");
        return(-1);
    } /* if */
    drive = *argv[1];
    drive |= ('A' <= drive && drive <= 'Z') ? 0x20 : 0;
    drive -= ('a' - 1);
    if (strcmp(argv[1]+1, ":") != 0) {
        printf("invalid drive: %s\n", argv[1]);
        return(-1);
    } /* if */
    if (_DosRemoveVolumeLabel(drive))
        printf("Could not remove volume label\n");
    return(0);
} /* eof: main() */
 
/* eof: rmlabel.c */
