/*
    DskLabel.C - Remove & Set Disk Volume Label for DOS
    Copyright (c) Smuth Nakpansua, 1992, 1993.  All rights reserved.
    Create date:  Nov 25, 1992
    Last Update:  March 23, 1993
 
    Compile:  cl /c dsklabel.c      (Microsoft)
              bcc /c dsklabel.c     (Borland)
*/
 
#include <dos.h>
#include <io.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef __TURBOC__
#include <dir.h>
#else   /* for Microsoft C */
#include <direct.h>
#endif
 
#include "dsklabel.h"
 
int _DosRemoveVolumeLabel(int DrvNum)
{
    char disktransfer[80];  /* buffer to DTA */
    union REGS r;
    struct SREGS s;
    char cwd[90];           /* current work directory */
    void far * oldDTA;      /* old disk transfer area */
    XFCB xfcb;
    int result = 0;
    int OldDrv = 0;
 
    if (DrvNum == 0)        /* for current drive, get drive number */
#ifdef __TURBOC__
        DrvNum = getdisk() + 1;   /* 0=A, 1=B, etc */
#else
        DrvNum = _getdrive();   /* 1=A, 2=B, etc */
#endif
    else                    /* else save current drive */
#ifdef __TURBOC__
        OldDrv = getdisk();   /* 0=A, 1=B, etc */
#else
        OldDrv = _getdrive();
#endif
#ifdef __TURBOC__
    getcurdir(DrvNum, cwd); /* save current work directory */
    setdisk(DrvNum - 1);    /* change drive to DrvNum */
#else
    _getdcwd(DrvNum, cwd, sizeof(cwd)); /* save current work directory */
    _dos_setdrive(DrvNum, &r.x.ax); /* change drive to DrvNum */
#endif
    sprintf(disktransfer, "%c:\\", DrvNum + 'A' - 1);  /* make ROOT directory */
    chdir(disktransfer);    /* set to ROOT */
    r.h.ah = 0x2f;          /* get DTA address, return in ES:BX */
    intdosx(&r, &r, &s);    /* call int 21h */
#ifdef __TURBOC__
    oldDTA = MK_FP(s.es, r.x.bx);
#else
    FP_SEG(oldDTA) = s.es;  /* save it */
    FP_OFF(oldDTA) = r.x.bx;
#endif
    segread(&s);            /* get current segment register */
    s.ds = s.ss;            /* point DS:DX to @disktransfer */
    r.x.dx = (unsigned short)disktransfer;
    r.h.ah = 0x1a;          /* set DTA address to DS:DX */
    intdosx(&r, &r, &s);    /* call int 21h */
    memset((void *)&xfcb, 0, sizeof(xfcb));
    memset((void *)xfcb.name, '?', sizeof(xfcb.name)+sizeof(xfcb.ext));
    xfcb.flag = -1;         /* flag signifying extended FCB */
    xfcb.attr = 8;          /* volume attribute byte */
    xfcb.drive = (char)DrvNum;  /* drive number 1=A, 2=B, etc */
    r.h.ah = 0x11;          /* search for first match */
    r.x.dx = (unsigned short)&xfcb;
    segread(&s);
    s.ds = s.ss;
    intdosx(&r, &r, &s);    /* call int 21h */
    if (r.h.al == 0) {  /* found exists volume label, delete */
        strncpy(xfcb.name, (char *)((XFCB *)disktransfer)->name, sizeof(xfcb.name) +
          sizeof(xfcb.ext));
        r.h.ah = 0x13;      /* delete file */
        r.x.dx = (unsigned short)&xfcb;
        segread(&s);        /* point DS:DX to extended FCB for rename file */
        s.ds = s.ss;
        intdosx(&r, &r, &s);    /* call int 21h */
        result = (int)r.h.al;
    } /* if, else do nothing */
    /* restore DTA */
    s.ds = FP_SEG(oldDTA);
    r.x.dx = FP_OFF(oldDTA);
    r.h.ah = 0x1a;          /* set DTA address to DS:DX */
    intdosx(&r, &r, &s);    /* call int 21h */
    if (OldDrv)             /* if changed current drive */
#ifdef __TURBOC__
        setdisk(OldDrv);    /* change drive to DrvNum */
#else
        _dos_setdrive(OldDrv, &OldDrv);
#endif
    chdir(cwd);             /* restore active directiry */
    return(result);         /* return 0 if OK, else error */
} /* eof: _DosRemoveVolumeLabel() */
 
int _DosSetVolumeLabel(int DrvNum, char *VolumeName)
{
    char disktransfer[80];  /* buffer to DTA */
    union REGS r;
    struct SREGS s;
    char cwd[90];           /* current work directory */
    void far * oldDTA;      /* old disk transfer area */
    XFCB xfcb;
    int result = 0;
    int len = strlen(VolumeName);
    int OldDrv = 0;
 
    if (!VolumeName || len == 0)    /* if invalid name */
        return(-1);
    if (len > 11)           /* longer than DOS limited, 11 bytes */
        len = 11;
    if (DrvNum == 0)        /* for current drive, get drive number */
#ifdef __TURBOC__
        DrvNum = getdisk() + 1; /* 0=A, 1=B, etc */
#else
        DrvNum = _getdrive();   /* 1=A, 2=B, etc */
#endif
    else                    /* else save current drive */
#ifdef __TURBOC__
        OldDrv = getdisk();     /* 0=A, 1=B, etc */
#else
        OldDrv = _getdrive();
#endif
#ifdef __TURBOC__
    getcurdir(DrvNum, cwd); /* save current work directory */
    setdisk(DrvNum - 1);    /* change drive to DrvNum */
#else
    _getdcwd(DrvNum, cwd, sizeof(cwd)); /* save current work directory */
    _dos_setdrive(DrvNum, &r.x.ax); /* change drive to DrvNum */
#endif
    sprintf(disktransfer, "%c:\\", DrvNum + 'A' - 1);  /* make ROOT directory */
    chdir(disktransfer);    /* set to ROOT */
    r.h.ah = 0x2f;          /* get DTA address, return in ES:BX */
    intdosx(&r, &r, &s);    /* call int 21h */
#ifdef __TURBOC__
    oldDTA = MK_FP(s.es, r.x.bx);
#else
    FP_SEG(oldDTA) = s.es;  /* save it */
    FP_OFF(oldDTA) = r.x.bx;
#endif
    segread(&s);            /* get current segment register */
    s.ds = s.ss;            /* point DS:DX to @disktransfer */
    r.x.dx = (unsigned short)disktransfer;
    r.h.ah = 0x1a;          /* set DTA address to DS:DX */
    intdosx(&r, &r, &s);    /* call int 21h */
    memset(&xfcb, 0, sizeof(xfcb));
    memset(xfcb.name, '?', sizeof(xfcb.name)+sizeof(xfcb.ext));
    xfcb.flag = -1;         /* flag signifying extended FCB */
    xfcb.attr = 8;          /* volume attribute byte */
    xfcb.drive = (char)DrvNum;  /* drive number 1=A, 2=B, etc */
    r.h.ah = 0x11;          /* search for first match */
    r.x.dx = (unsigned short)&xfcb;
    segread(&s);
    s.ds = s.ss;
    intdosx(&r, &r, &s);    /* call int 21h */
    if (r.h.al == 0) {  /* found exists volume label, rename */
        strncpy(xfcb.name, ((XFCB *)disktransfer)->name, sizeof(xfcb.name) +
          sizeof(xfcb.ext));
        memset(xfcb.name+16, ' ', sizeof(xfcb.name) + sizeof(xfcb.ext));
        strncpy(xfcb.name+16, VolumeName, len);
        r.h.ah = 0x17;      /* rename file */
        r.x.dx = (unsigned short)&xfcb;
        segread(&s);        /* point DS:DX to extended FCB for rename file */
        s.ds = s.ss;
        intdosx(&r, &r, &s);    /* call int 21h */
        result = (int)r.h.al;
    } /* if */
    else {  /* else create */
        char vol[12];
        strncpy(vol, VolumeName, 11);
        if (strchr(vol, '.') == NULL && len > 8) {
            /* if length of filename > 8, must insert '.' */
            strncpy(vol, VolumeName, 8);
            vol[8] = '.';
            strcpy(vol + 9, VolumeName + 8);
        }
        else
            strcpy(vol, VolumeName);
        r.h.ah = 0x5b;      /* create new file */
        r.x.cx = 8;         /* volume label bit set */
        r.x.dx = (unsigned short)vol;
        segread(&s);
        s.ds = s.ss;
        intdosx(&r, &r, &s);
        result = r.x.cflag ? -1 : 0;
        if (!result) {      /* can open, close */
            r.h.ah = 0x3e;      /* close file */
            r.x.bx = r.x.ax;
            intdosx(&r, &r, &s);
        } /* if */
    } /* else */
    s.ds = FP_SEG(oldDTA);
    r.x.dx = FP_OFF(oldDTA);
    r.h.ah = 0x1a;          /* set DTA address to DS:DX */
    intdosx(&r, &r, &s);    /* call int 21h */
    if (OldDrv)
#ifdef __TURBOC__
        setdisk(OldDrv);    /* change drive to DrvNum */
#else
        _dos_setdrive(OldDrv, &OldDrv);
#endif
    chdir(cwd);
    return(result);
} /* eof: _DosSetVolumeLabel() */
 
/* eof: dsklabel.c */
