        .MODEL  MEDIUM
;***********************************************************************
;                             FINDIR.ASM
;   FINDIR [DECLARE FUNCTION FINDIR$ ()] is an assembled string function
; for compiled Microsoft BASIC programs.  It returns the complete 
path
; (including drive code) to the directory containing the executable 
file
; for the calling program.  FINDIR returns a null string if running
; under DOS versions prior to 3.0. 
;-----------------------------------------------------------------------
;              Copyright (C) 1991-92 by Murray L. Lesser
;***********************************************************************

        EXTRN B$ASSN: FAR       ;BASIC support functions in BC 4.x,
        EXTRN B$STDL: FAR       ;  and later, link libraries

.DATA
PATH    DD      ?               ;Returned string descriptor

.CODE
        PUBLIC FINDIR
FINDIR PROC
        PUSH    BP
        MOV     BP,SP
        PUSH    DI
        PUSH    SI
        MOV     AH,30H          ;Check for DOS version
        INT     21H
        CMP     AL,3            ;Version 3.0 or later?
        JB      NULLIT          ;If not, return null string
        MOV     AH,62H          ;Find PSP segment address
        INT     21H
        MOV     ES,BX           ;  and put it in ES
        MOV     AX,ES:2CH       ;Find program environment segment
        MOV     ES,AX           ;  and put it in ES
; Set up to scan for double null:
        XOR     CX,CX           ;Assume Environment less than 64K 
bytes!
        XOR     DI,DI           ;Start of environment segment
FINDIT: XOR     AL,AL
        REPNZ   SCASB           ;Find next zero byte
        MOV     AL,ES:[DI]      ;Is it followed by another?
        OR      AL,AL
        LOOPNZ  FINDIT          ;If not, keep trying
; Found double null:
        MOV     CX,-1           ;Reset CX to -1
        INC     DI              ;Skip second null and string count
        INC     DI
        INC     DI
        MOV     BX,DI           ;Save starting offset of path in BX
        REPNZ   SCASB           ;Find null after program name
        NOT     CX              ;Length of string to null
; Now, scan backwards to find last "\" in string;
        STD
        DEC     DI              ;Start at null byte
        MOV     AL,'\'
        REPNZ   SCASB
        CLD                     ;Clear direction flag
        INC     DI              ;To byte containing "\"
        CMP     AL,ES:[DI]      ;Check that it really is a "\"
        JNZ     NULLIT          ;If not, return null string

        INC     CX              ;Correct to returned string 
length
; Make into BASIC string for return:
        PUSH    ES              ;Far address of source string
        PUSH    BX
        PUSH    CX              ;Length of source string
        PUSH    DS              ;Far address of destination string
        MOV     AX,OFFSET PATH
        PUSH    AX
        XOR     AX,AX           ;Zero length of BASIC string
        PUSH    AX
        CALL    B$ASSN
DONE:   MOV     AX,OFFSET PATH  ;Return string descriptor in AX
        POP     SI
        POP     DI
        POP     BP
        RET
NULLIT: MOV     AX,OFFSET PATH  ;Make output null string
        PUSH    AX
        CALL    B$STDL
        JMP     DONE
FINDIR  ENDP
        END


