 /* compiles with MSC 4.0, TCC 2.0, or Watcom 386 8.0
 * makefile sets MSC true when using MSC 4.0 compiler.
 */

#include <dos.h>
#include <errno.h>
#include <math.h>
#include <stdio.h>
#include <time.h>
#include <string.h>
#include <signal.h>
#include <stdlib.h>
#if __TURBOC__
#include <mem.h>
#include <alloc.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <io.h>
#elif MSC
#include <memory.h>
#include <malloc.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <io.h>
#endif

#define MAIN 0
#include "makemsg.h"

char nothing[] = "";

#define MENBUFLEN 256

/* load messages into calloc'd array.
 * typical usage:
 unsigned cnt;
 int error, line;
 struct msg *txt[139];
 FILE *menufile;
    menufile = fopen("ROUTEMSG.TXT","r");
    cnt = sizeof (txt)/sizeof (char *);
    error = loadmsgs (cnt, txt, menufile, load, &line);
    if (error) {
        printf ("Error at line %d in ROUTEMSG.TXT.\n",  line);
        exit (EFORMAT);
    }
 * return number of messages in *cnt.
 * return error condition or 0 if OK.
 */
                /* ***** LOADMSGS ***** */
int loadmsgs (cnt, arp, mfile, lod)
unsigned int *cnt;
struct msg         arp[];
FILE                   *mfile;
int                             lod;
{
  int j, k, row;
  char lbuf[MENBUFLEN];

  char bufr[MENBUFLEN];
  int error=0;
  int col=-1;
    for (k = 0 ; k < *cnt ; k++ ) {
        if (NULL == fgets (lbuf, 128, mfile)) { *cnt = k-1; break; 
}
        row = atoi(lbuf);
        if (k!=row) { error++; break; }
        if (k!=(col+1)) { error++; break; }
        col = row;             /* save row for monotonicity check 
*/
        memset (bufr,0,MENBUFLEN);
        if (NULL == fgets (lbuf, 128, mfile)) { error++; break; }
        while(lbuf[0] != 4) {
            if(bufr[0]) strcat (bufr, "\n");
            if (lbuf[0] == '\n') strcat (bufr, "\n");
            else {
                lbuf[strlen (lbuf)-1] = '\000';
                strcat (bufr, lbuf);
            }
            if (NULL == fgets (lbuf, 128, mfile)) { error++; 
break; }
        }
                /* now store message in bufr away */
        if (lod) {
            j = strlen (bufr);
            arp[k].s = calloc (j+1, 1);
            if(arp[k].s == NULL) {
                fprintf(stderr,"can't alloc more memory, line 
%u\n",k);
                return(ENOMEM);
            }
            strcpy (arp[k].s, bufr);
        }
        else arp[k].s = &nothing[0];
        arp[k].index = k;
    }
    return (error);
}


