//===========================================================
// WINCMD.H -- Header File 
// Copyright (c) 1993 Douglas Boling
//===========================================================
//-----------------------------------------------------------
// Generic defines and data types
//-----------------------------------------------------------
#if !defined(WIN32)
  #define WIN16     TRUE
  #define WIN31

  #define INT       int
  #define UINT      WORD
  #define APIENTRY  PASCAL
  #define WNDPROC   FARPROC
#else
  #define WIN16     FALSE
#endif

struct decodeUINT {                         // structure associates
    UINT Code;                              // messages 
    LONG (*Fxn)(HWND, UINT, UINT, LONG);    // with a function
}; 
struct decodeCMD {                          // structure associates
    UINT Code;                              // menu IDs with a 
    LONG (*Fxn)(HWND, UINT, HWND, UINT);    // function
};
typedef struct find_t FIND_T;
//
// Function prototypes used by generic template
//
INT  APIENTRY WinMain(HANDLE, HANDLE, LPSTR, INT);
INT  InitApp(HANDLE);
INT  InitInstance(HANDLE, LPSTR, INT);
INT  TermInstance(HANDLE, INT);
LONG CALLBACK MainWndProc(HWND, UINT, UINT, LONG);
BOOL CALLBACK HelpDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK AboutDlgProc (HWND, UINT, UINT, LONG);
INT  MyDisplayDialog (HINSTANCE, LPCSTR, HWND, WNDPROC, LPARAM);
BOOL MyWritePrivateProfileInt (char *, char *, int, int, char *);
//============================================================
// Interpeter stuff
//============================================================
//
// Var list structure
//
typedef struct {
	PSTR		pszName;
	BYTE		ucType;
	BYTE		ucNameLen;
	WORD		wData;
	DWORD		dwData;
} TOKEN;
typedef TOKEN *PTOKEN;
typedef TOKEN FAR *LPTOKEN;
//
// Used for line tokenization
//
typedef struct {
	BYTE		ucLen;
	BYTE		ucType;
	PTOKEN	ptToken;
} LINETOKEN;
typedef LINETOKEN *PLINETOKEN;
typedef LINETOKEN FAR *LPLINETOKEN;

typedef struct {
	BYTE	ucLen;
	BYTE	ucType;
	UINT  	wLineLen;
	UINT  	wLineNum;
} LINESTARTTOK;
typedef LINESTARTTOK *PLINESTARTTOK;
typedef LINESTARTTOK FAR *LPLINESTARTTOK;

typedef struct {
	BYTE	ucLen;
	BYTE	ucType;
	INT 	sData;
} VARSCONST;
typedef VARSCONST *PVARSCONST;
typedef VARSCONST FAR *LPVARSCONST;

typedef struct {
	BYTE	ucLen;
	BYTE	ucType;
	LONG	lData;
} VARLCONST;
typedef VARLCONST *PVARLCONST;
typedef VARLCONST FAR *LPVARLCONST;

typedef struct {
	BYTE	ucLen;
	BYTE	ucType;
	char	szData[];
} STRCONST;
typedef STRCONST *PSTRCONST;
typedef STRCONST FAR *LPSTRCONST;
//
// String Item structure
//
typedef struct {
	WORD	wLen;
	WORD	wLinkBack;
	char	szStr[];
} ITEM;
typedef ITEM *PITEM;

typedef	INT (*STATEMENTFUNC) (LPLINETOKEN *, INT);
typedef	INT (*OPFUNC) (LPLINETOKEN *, PTOKEN, PTOKEN);
typedef	INT (*FUNCFUNC) (LPLINETOKEN *, PTOKEN);
typedef	DWORD (CALLBACK CBTOKFUNC) (INT, LPTOKEN, LPSTR, BYTE, UINT, DWORD);
typedef	CBTOKFUNC FAR *LPCBTOKFUNC;

typedef struct {
	PSTR		pszName;
	BYTE		ucType;
	BYTE		ucNameLen;
	WORD		wLevel;
	STATEMENTFUNC	Fxn;
} STATEMENTTOK;
typedef STATEMENTTOK *PSTATEMENTTOK;

typedef struct {
	PSTR		pszName;
	BYTE		ucType;
	BYTE		ucNameLen;
	WORD		wLevel;
	OPFUNC	Fxn;
} OPTOK;
typedef OPTOK *POPTOK;
typedef struct {
	PSTR		pszName;
	BYTE		ucType;
	BYTE		ucNameLen;
	WORD		wData;
	FUNCFUNC	Fxn;
} FUNCTOK;
typedef FUNCTOK *PFUNCTOK;
//
// Templates for prefefined tokens
//
typedef struct {
	char	*szName;
	BYTE	ucType;
	BYTE	ucLevel;
	OPFUNC	Fxn;
} LOCALOP;
typedef LOCALOP *PLOCALOP;

typedef struct {
	char		*szName;
	BYTE		ucType;
	FUNCFUNC	Fxn;
} LOCALFUNC;
typedef LOCALFUNC *PLOCALFUNC;

typedef struct {
	char		*szName;
	BYTE		ucType;
	STATEMENTFUNC	Fxn;
} LOCALSTATEMENT;
typedef LOCALSTATEMENT *PLOCALSTATEMENT;
//
// Entry point defines for external function libs
//
typedef INT (CALLBACK LIBLOAD) (HWND, INT, INT);
typedef LIBLOAD FAR *LPLIBLOAD;
typedef INT (CALLBACK LIBRESET) (INT, FARPROC);
typedef LIBRESET FAR *LPLIBRESET;
typedef INT (CALLBACK LIBFUNC) (LPLINETOKEN *, LPTOKEN, UINT, FARPROC, HWND);
typedef LIBFUNC FAR *LPLIBFUNC;
typedef INT (CALLBACK LIBGETERR) (INT, LPSTR, INT);
typedef LIBGETERR FAR *LPLIBGETERR;
typedef INT (CALLBACK LIBGETVER) (LPWORD, LPSTR, INT);
typedef LIBGETVER FAR *LPLIBGETVER;
typedef INT (CALLBACK LIBGETHELP) (INT, LPSTR, INT);
typedef LIBGETERR FAR *LPLIBGETHELP;
 
//
// Profile String Names
//
#define     PRO_XPOS     "WinPosX"
#define     PRO_YPOS     "WinPosY"
#define     PRO_XSIZE    "WinSizeX"
#define     PRO_YSIZE    "WinSizeY"
//
// Resource Idendifiers
//
#define     IDM_OPEN       101
#define     IDM_REOPEN     102
#define     IDM_LOAD       103
#define     IDM_EXIT       104
#define     IDM_SHOWLIST   200
#define     IDM_SHOWOUT    201
#define     IDM_CLEAROUT   202
#define     IDM_MINONRUN   203
#define     IDM_HELP       300
#define     IDM_ABOUT      301

#define     IDD_LINELIST   600
#define     IDD_OUTLIST    601
#define     IDD_TOKLINE    602
#define     IDD_RUN        603
#define     IDD_STEP       604
#define     IDD_RESET      605

#define     IDD_ASKTEXT    700
#define     IDD_ASKANS     701
#define     IDD_HELPLIST   710
#define     IDD_PROGSTR    720
//
// User defined Messages
//
#define     MYMSG_REFRESH  (WM_USER+1)
//
// Interpeter constants
//
#define	WAITTIMER_ID             1

#define	MYTRUE                   1
#define	MYFALSE                  0

#define	FUNC_SKIP                1
#define	FUNC_EXECUTE             2
                                  
#define	RC_END_OF_PROGRAM        1
#define	RC_END_OF_SUB            2
#define	RC_END_OF_LOOP           3
#define	RC_END_OF_BLOCK          4

#define	ERR_SYNTAX              -1
#define	ERR_EXPECTED_NUMBER     -2
#define	ERR_DIVIDE_BY_ZERO      -3
#define	ERR_UNEXP_EOL           -4
#define	ERR_ILLEGAL_ASSIGNMENT  -5
#define	ERR_NO_END_QUOTE        -6
#define	ERR_EXTRA_CHARS         -7
#define	ERR_NO_CLOSE_PAREN      -8
#define	ERR_NO_OPEN_PAREN       -9
#define	ERR_UNKNOWN_OP          -10
#define	ERR_MULTI_DEF_LABEL     -11
#define	ERR_12                  -12
#define	ERR_RETURN_OUTSIDE_FUNC -13
#define	ERR_END_WITHOUT_DO      -14
#define	ERR_NOARGS              -15
#define	ERR_BAD_SENDKEY_STR     -16

#define	ERR_NO_TOKEN_SPACE      -17
#define	ERR_OUT_OF_MEMORY       -18
#define	ERR_FILE_TOO_BIG        -19
#define	ERR_CANNOT_OPEN_FILE    -20
#define	ERR_LINE_TOO_LONG       -21
#define	ERR_UNEXP_PROGTERM      -22
#define	ERR_UNKNOWN_CMDSWITCH   -23
#define	ERR_PARSE_UNKSYMBOL     -24
#define	ERR_NAME_TOO_LONG       -25
#define	ERR_MEM_LOCK            -26
#define	ERR_NO_TIMERS           -27
#define	ERR_OVERFLOW            -28
#define	ERR_FILE_TOO_COMPLEX    -29
#define	ERR_BAD_LIB_LOAD        -30
#define	ERR_FUNC_NOT_FOUND      -31
 
// Error nums: -32 to -63 are Windows launch error codes
#define	ERR_LAUNCH_ERR          -32
// Error nums: -64 to -249 are file open error codes
#define	ERR_FOPEN_ERR           -63 //Err codes start at 1
#define	ERR_FILE_NOT_FOUND      -65
#define	ERR_PATH_NOT_FOUND      -66
#define	ERR_INVALID_DRIVE       -78

#define	ERR_BAD_FUNC_NAME       -256
#define	ERR_BAD_FUNC            -257
#define	ERR_TOO_FEW_PARMS       -258
#define	ERR_LIBERROR_START      -2048
#define	WCH                      2048     //This number should match LibErrStart

// 1 - 31 Line token types
#define	TTYPE_LINE                1
#define	TTYPE_CMT2EOL             2
#define	TTYPE_CMTSTART            3
#define	TTYPE_CMTEND              4
#define	TTYPE_SCONST              5
#define	TTYPE_LCONST              6
#define	TTYPE_STRCONST            7
#define	TTYPE_VAR                 8
// 32 - 63 Var token types
#define	TTYPE_VARSTART           32
#define	TTYPE_NUM                32
#define	TTYPE_STR                33
#define	TTYPE_LABEL              35
#define	TTYPE_RETVAL             36
#define	TTYPE_VAREND             63
// 64 - 95 operator token types
#define	TTYPE_OPSTART            64
#define	TTYPE_LOP                64
#define	TTYPE_LUOP               65
#define	TTYPE_LOCALFUNC          66
#define	TTYPE_OPAREN             67
#define	TTYPE_CPAREN             68
#define	TTYPE_ASSIGN_CMP         69
#define	TTYPE_ASSIGN             70
#define	TTYPE_BREAK              71
#define	TTYPE_INTCMD             72
#define	TTYPE_LIBFUNC            73
#define	TTYPE_OPEND              95
// 96 - 127 statement token types
#define	TTYPE_STATEMENTSTART     96
#define	TTYPE_LSTATEMENT         96
#define	TTYPE_THENELSE           97
#define	TTYPE_BEGBLK             98
#define	TTYPE_ENDBLK             99
#define	TTYPE_BEGCALL           100
#define	TTYPE_STATEMENTEND      127
// 128 - program stuff
#define	TTYPE_EOL               128
#define	TTYPE_EOF               129
#define	TTYPE_DEL               255

// Callback function ID numbers                                    
#define	CBF_ADDTOKEN              1
#define	CBF_FINDTOKEN             2
#define	CBF_SETTOKEN              3
#define	CBF_GETTOKENVAL           4
#define	CBF_GETTOKENSTRING        5
#define	CBF_RESOLVELINE           6

