UNIT VolFuncs;
(**) INTERFACE (**)

{$IFDEF WINDOWS}
  {$DEFINE PMODE}
{$ENDIF}
{$IFDEF DPMI}
  {$DEFINE PMODE}
{$ENDIF}

{$IFNDEF PMODE}
  !! Error, this unit is Protected Mode ONLY
{$ENDIF}

USES WinProcs, WinTypes,WinDOS,Strings;

TYPE
  VolString = String[12];

  FUNCTION GetLabel(driveNum : Byte;
                    VAR V : VolString) : Boolean;
  FUNCTION SetLabel(driveNum : Byte;
                    NuLabel : VolString) : Boolean;
  FUNCTION DelLabel(driveNum : Byte) : Boolean;

(**) IMPLEMENTATION (**)
TYPE
  PExFCB = ^ExFCB;
  ExFCB = RECORD
            FF        : Byte;              {must be 0FFh}
            Reserved0 : ARRAY[1..5] OF Byte; {must be 0s}
            Attribute : Byte;
            DriveID   : Byte;
            Filename  : ARRAY[1..8] OF Char;
            Extension : ARRAY[1..3] OF Char;
            CurBlock  : Word;
            RecSize   : Word;
            FileSize  : LongInt;
            Date      : Word;
            Time      : Word;
            Reserved  : ARRAY[1..8] OF Byte;
            CurRec    : Byte;
            Relative  : LongInt;
          END;

type
  PRealModeRegs = ^TRealModeRegs;
  TRealModeRegs = record
    case Integer of
      0: (
        EDI, ESI, EBP, EXX, EBX, EDX, ECX, EAX: Longint;
        Flags, ES, DS, FS, GS, IP, CS, SP, SS: Word);
      1: (
        DI, DIH, SI, SIH, BP, BPH, XX, XXH: Word;
        case Integer of
          0: (
            BX, BXH, DX, DXH, CX, CXH, AX, AXH: Word);
          1: (
            BL, BH, BLH, BHH, DL, DH, DLH, DHH,
            CL, CH, CLH, CHH, AL, AH, ALH, AHH: Byte));
  end;

procedure RealModeInt(Int: Byte; var Regs: TRealModeRegs); assembler;
asm
   MOV   BL,Int
   XOR   BH,BH
   XOR   CX,CX
   LES   DI,Regs
   MOV   AX,0300H
   INT   31H
end;

var
  Reg: TRealModeRegs; { Registers Structure used by DPMI Simulate Real mode interrupt }

  FUNCTION GetLabel(driveNum : Byte;
                    VAR V : VolString) : Boolean;
  CONST
    Any : String[5] = ':\*.*';
  VAR
    SR   : TSearchRec;
    Mask : array[0..fsPathName] of char;
    P    : Byte;
    SRName : String[12];
  BEGIN
    IF DriveNum > 0 THEN
      Mask[0] := Char(DriveNum + ord('@'))
    ELSE GetCurDir(Mask,0);
    Move(Any[1], Mask[1], 5);
    Mask[6] := #0;
    FindFirst(Mask, faVolumeID, SR);
    WHILE (SR.Attr AND faVolumeID = 0) AND
          (DosError = 0) DO
      FindNext(SR);
    IF DosError = 0 THEN
      BEGIN
        SRName := StrPas(SR.Name);
        FillChar(V[1], 11, ' ');
        V[0] := #11;
        P := Pos('.', SRName);
        IF P = 0 THEN
          Move(SRName[1], V[1], length(SRName))
        ELSE
          BEGIN
            Move(SRName[1], V[1], pred(P));
            Move(SRName[P+1], V[9], length(SRName)-P);
          END;
        GetLabel := TRUE;
      END
    ELSE GetLabel := FALSE;
  END;

  FUNCTION SetLabel(driveNum : Byte;
                    NuLabel : VolString) : Boolean;

  VAR E  : PExFCB;
      DosMem : longint;
  BEGIN
    DosMem := GlobalDosAlloc(Sizeof(ExFCB));
    E := Ptr(LoWord(DosMem),0);
    WITH E^ DO
      BEGIN
        FF        := $FF;
        FillChar(Reserved0, 5, 0);
        Attribute := faVolumeID;
        DriveID   := DriveNum;
        FillChar(FileName, 8, ' ');
        FillChar(Extension, 3, ' ');
        Move(NuLabel[1], Filename, length(NuLabel));
      END;
    with Reg do
      begin
      DS := HiWord(DosMem);
      DX := 0;
      AX := $1600;
      RealModeInt($21,Reg);
      Inc(AL);
	  SetLabel := Boolean(AL);
      { Following code added by Pat Ritchey, borland support, thanks Pat }
	  if AL=1 then
         begin                    
         DS := HiWord(DosMem);   
         DX := 0;                
         AX := $1000;            
         RealModeInt($21,Reg);   
         end;                    
      end;
    GlobalDosFree(LoWord(DosMem));
  END;

  FUNCTION DelLabel(driveNum : Byte) : Boolean;
  VAR E   : PExFCB;
      DosMem : longint;
  BEGIN
    DosMem := GlobalDosAlloc(Sizeof(ExFCB));
    E := Ptr(LoWord(DosMem),0);
    WITH E^ DO
      BEGIN
        FF        := $FF;
        FillChar(Reserved0, 5, 0);
        Attribute := faVolumeID;
        DriveID   := DriveNum;
        FillChar(FileName, 8, '?');
        FillChar(Extension, 3, '?');
      END;
    FillChar(Reg,Sizeof(Reg),0);
    With Reg do
      begin
      DS := HiWord(DosMem);
      DX := 0;
      AX := $1300;
      RealModeInt($21,Reg);
      Inc(AL);
      DelLabel := Boolean(AL);
      end;
    GlobalDosFree(LoWord(DosMem));
  END;
END.
