{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Custom Control Library                           		*}
{*                                                                    *}
{*		 Version 1.02                                                		*}
{*                                                                    *}
{*     Object Windows Library Extension for Borland Pascal v7.0       *}
{*                                                                    *}
{*     and Turbo Pascal for Windows v 1.5                             *}
{*                                                                    *}
{*		 MWCC.TPU/MWCC.TPW : Object Unit                              	*}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	Application    := MWCC Object Unit

	File           := MWCC.pas

	Units Required := MWCC.res and MWCC.dll

	Purpose        := Sample Code Only

	Tabs           := 2

	Screen         := 800 * 600

	Date           := July, 1993.

	This code is included as example only and it is not intended to be recomplied for use in
	place of the Object Unit that came with the library. 

	This library is based on sample source code freely availible on the compuserve BPascal forum.
	Without that code this library would not have been possible.

	Just a few short notes of explanation;

			1. You will notice some DLL functions listed below that aren't mentioned in MWCC.hlp.
				 That's because they won't be of much use to you. They're specialised functions
				 and procedures that are used to break MWCC.DLL's code up into reuseable blocks.

			2. The MWCC and SFX objects are not derived from a common ancestor. Apart from creating
				 too many logistic problems I wanted to keep each class separate so future additions,
				 changes or improvements would be easy.

			3. All the painting function are in MWCC.DLL along with the standard button resources.
         The source code for MWCC.DLL is not supplied.

			4. One of the many improvements I hope to make in a future version is to add the other of
				 common dialogs.

  I hope you this source code useful.

***}

unit MWCC;

{$R MWCC.Res}
{$C Moveable DemandLoad Discardable}

interface

uses Wintypes, WinProcs, Win31, ToolHelp, CommDlg, Strings, Wintools;
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

		ctl_Static        = 0;
		ctl_Recessed      = 1;
		ctl_Raised        = 2;
		ctl_Flush         = 3;
		ctl_LoRes         = 4;
		ctl_HiRes         = 5;

type

	TMinMaxInfo = array [0..4] of TPoint;
	PMinMaxInfo = ^TMinMaxInfo;

	PMWCCStatic = ^TMWCCStatic;
	TMWCCStatic = object(TStatic)
		constructor Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
											X, Y, W, H: Integer; ATextLen, AShade: Word; IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer;
															ATextLen, AShade: Word);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		StaticShade					 : Word;
		HasFont    					 : Boolean;
		TheFont              : HFont;
		LogFont              : TLogFont;
		FontSize, FontHeight : Integer;
		CRect        		  	 : TRect;
	end;

	PMWCCBmpButton = ^TMWCCBmpButton;
	TMWCCBmpButton = object(TButton)
		constructor Init(AParent: PWindowsObject; AnID, X, Y: Integer;
										 IsDefault: Boolean; iBmp: Integer; AStyle: Word);
    destructor Done; virtual;
		procedure DrawItem(var Msg:tMessage); virtual;
		procedure WMSetFocus (var Msg: TMessage); virtual wm_First + wm_SetFocus;
	private
		BM                          : TBitmap;
		UpBmp, DownBmp, FocusBmp    : HBitmap;
		iUpBmp, iDownBmp, iFocusBmp : Integer;
		Style                       : Word;
		ResHdl                      : THandle;
		Default                     : Boolean;
		CRect        		            : TRect;
	end;

	PMsgBoxButton = ^TMsgBoxButton;
	TMsgBoxButton = object(TMWCCBmpButton)
		procedure WMkeyDown (var Msg: TMessage); virtual wm_First + wm_KeyDown;
	end;

	PMWCCButton = ^TMWCCButton;
	TMWCCButton = object(TButton)
		Constructor Init (AParent: PWindowsObject; AnID: Integer; AText: PChar; X, Y, W, H: Integer;
											ABmp: PChar; AStyle: Word);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure DrawItem(var Msg: TMessage);
	private
		Bmp          				 : HBitmap;
		BM            			 : TBitMap;
		bmX, bmY, Ofs 			 : Integer;
		HasFont       			 : Boolean;
		TheFont              : HFont;
		LogFont              : TLogFont;
		FontSize, FontHeight : Integer;
		Style         			 : Word;
		WinRect       			 : TRect;
		szTitle       			 : array[0..50] of Char;
	end;

	PMWCCGroupBox = ^TMWCCGroupBox;
	TMWCCGroupBox = object(TGroupBox)
		constructor Init (AParent: PWindowsObject; AnId: Integer; AText: PChar; X, Y, W, H: Integer;
											IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer; AText: PChar);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMSize (var Msg: TMessage); virtual wm_First + wm_Size;
		procedure WMEnable (var Msg: TMessage); virtual wm_First + wm_Enable;
	private
		BkStatic, GroupStatic : PMWCCStatic;
		FromResource          : Boolean;
		CRect                 : TRect;
	end;

	PMWCCScrollBar = ^TMWCCScrollBar;
	TMWCCScrollBar = object(TScrollBar)
		constructor Init (AParent: PWindowsObject; AnId: Integer; X, Y, W, H: Integer;
											IsHScrollBar: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer);
		destructor Done; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		CRect : TRect;
	end;

	PMWCCRadioButton = ^TMWCCRadioButton;
	TMWCCRadioButton = object(TRadioButton)
		constructor Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
											X, Y, W, H: Integer; AGroup: PGroupBox; IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMEnable (var Msg: TMessage); virtual wm_First + wm_Enable;
		procedure BMSetCheck (var Msg: TMessage); virtual wm_First + bm_SetCheck;
		procedure BMSetState (var Msg: TMessage); virtual wm_First + bm_SetState;
	private
		HasFont 						 : Boolean;
		TheFont              : HFont;
		LogFont              : TLogFont;
		FontSize, FontHeight : Integer;
		CRect  							 : TRect;
	end;

	PMWCCCheckBox = ^TMWCCCheckBox;
	TMWCCCheckBox = object(TCheckBox)
		constructor Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
											X, Y, W, H: Integer; AGroup: PGroupBox; IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMEnable (var Msg: TMessage); virtual wm_First + wm_Enable;
		procedure BMSetCheck (var Msg: TMessage); virtual wm_First + bm_SetCheck;
		procedure BMSetState (var Msg: TMessage); virtual wm_First + bm_SetState;
	private
		HasFont 						 : Boolean;
		TheFont              : HFont;
		LogFont              : TLogFont;
		FontSize, FontHeight : Integer;
		CRect   						 : TRect;
	end;

	PMWCCEdit = ^TMWCCEdit;
	TMWCCEdit = object(TEdit)
		constructor Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar; X, Y, W, H,
											ATextLen: Integer; Multiline, IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer; ATextLen: Word);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		HasFont 						 : Boolean;
		TheFont              : HFont;
		LogFont              : TLogFont;
		FontSize, FontHeight : Integer;
		CRect					       : TRect;
	end;

	PMWCCComboBox = ^TMWCCComboBox;
	TMWCCComboBox = object(TComboBox)
		constructor Init (AParent: PWindowsObject; AnId: Integer; X, Y, W, H: Integer;
											AStyle, ATextLen: Word; IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer; ATextLen: Word);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		HasFont              : Boolean;
		TheFont              : HFont;
		LogFont              : TLogFont;
		FontSize, FontHeight : Integer;
		CRect						     : TRect;
	end;

	PMWCCListBox = ^TMWCCListBox;
	TMWCCListBox = object(TListBox)
		constructor Init (AParent: PWindowsObject; AnId: Integer; X, Y, W, H: Integer;
											IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		HasFont 						 : Boolean;
		TheFont              : HFont;
		LogFont              : TLogFont;
		FontSize, FontHeight : Integer;
		CRect, WinRect			 : TRect;
	end;

	PCommonDlg = ^TCommonDlg;
	TCommonDlg = object(TDialog)
  private
		constructor Init(AParent: PWindowsObject; AName: PChar);
		destructor Done; virtual;
		function Create: Boolean; virtual;
    function Execute: Integer; virtual;
		function DlgTitle: PChar; virtual;
		procedure Ok(var msg :TMessage); virtual id_First + id_Ok;
		procedure Cancel(var msg :TMessage); virtual id_First + id_Cancel;
	end;

	PFileNameDlg = ^TFileNameDlg;
	TFileNameDlg = object(TCommonDlg)
		FilePath : array[0..255] of Char;
		FileTitle : array[0..12] of Char;
		OpenFileName     : TOpenFileName;
		constructor Init(AParent: PWindowsObject; AName: PChar; IsOpen: Boolean);
		destructor Done; virtual;
		function DefSpec: PChar; virtual;
    function DefExt: PChar; virtual;
    function DefSpecPos: Byte; virtual;
		function OpenFlags: Longint; virtual;
		function DlgTitle: PChar; virtual;
		function DoExec: Boolean; virtual;
    function Execute: Integer; virtual;
	private
		Open                   : Boolean;
 end;

	PMsgBoxWindow = ^TMsgBoxWindow;
	TMsgBoxWindow = object(TWindow)
	private
		LastModal         : PWindowsObject;
		LastWnd           : HWnd;
		Complete, NoClose : Boolean;
		Stat              : PMWCCStatic;
		Reply             : Integer;
		Def1, Def2, Def3  : Boolean;
		PBut              : PWindowsObject;
		HBut              : PButton;
		But1, But2, But3, But4, But5, But6, But7 : PMsgBoxButton;
		constructor Init (AParent: PWindowsObject; ATxt, ACaption: PChar; ATextType: Word);
		function  CanClose: Boolean; virtual;
		procedure SetUpWindow; virtual;
		procedure Paint(PaintDC: HDC; var PS: TPaintStruct); virtual;
		procedure WMDrawItem (var Msg: TMessage); virtual wm_First + wm_DrawItem;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure EndWin (AReply: Integer);
		procedure OK (var Msg: TMessage); virtual id_First + id_Ok;
		procedure Cancel (var Msg: TMessage); virtual id_First + id_Cancel;
		procedure Abort (var Msg: TMessage); virtual id_First + id_Abort;
		procedure Retry (var Msg: TMessage); virtual id_First + id_Retry;
		procedure Ignore (var Msg: TMessage); virtual id_First + id_Ignore;
		procedure Yes (var Msg: TMessage); virtual id_First + id_Yes;
		procedure No (var Msg: TMessage); virtual id_First + id_No;
		procedure WMClose (var Msg: TMessage); virtual wm_First + wm_Close;
		procedure BeginModal;
		procedure EndModal;
	end;

	PMWCCMsgBoxWindow = ^TMWCCMsgBoxWindow;
	TMWCCMsgBoxWindow = object(TMsgBoxWindow)
	private
		BkBmp          : HBitmap;
		BkBrush        : HBrush;
		CRect, WinRect : TRect;
		constructor Init (AParent: PWindowsObject; ATxt, ACaption: PChar; ATextType: Word;
											ABmp: PChar);
		function  CanClose: Boolean; virtual;
		function 	GetClassName : PChar; virtual;
		procedure SetUpWindow; virtual;
		procedure Paint(PaintDC: HDC; var PS : TPaintStruct); virtual;
	end;

	PMWCCFileNameDlg = ^TMWCCFileNameDlg;
	TMWCCFileNameDlg = object(TFileNameDlg)
		OkBtn, CancelBtn : PMWCCBmpButton;
		constructor Init (AParent: PWindowsObject; AName, ABmp: PChar; IsOpen: Boolean);
		destructor Done; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMDrawItem (var msg :TMessage); virtual wm_First + wm_DrawItem;
	private
		BMP, BkBrush : HBitmap;
		CtlStyle     : Boolean;
		CRect        : TRect;
		LB1, LB2   	 : PMWCCListBox;
		EC           : PMWCCEdit;
		CB1, CB2     : PMWCCComboBox;
		CBox         : PMWCCCheckBox;
		ST           : PMWCCEdit;
	end;

	PMWCCDialog = ^TMWCCDialog;
	TMWCCDialog = object(TDialog)
		constructor Init (AParent: PWindowsObject; AName, ABmp: PChar);
		destructor Done; virtual;
		function GetClassName: PChar; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		BMP, BkBrush   : HBitmap;
		CtlStyle       : Boolean;
		CRect, WinRect : TRect;
		MinMaxInfo     : PMinMaxInfo;
	end;

	PMWCCDlgWindow = ^TMWCCDlgWindow;
	TMWCCDlgWindow = object(TDlgWindow)
		IsSizeable, SFXFrame : Boolean;
		constructor Init (AParent: PWindowsObject; AName, ABmp: PChar);
		destructor Done; virtual;
		function GetClassName: PChar; virtual;
		procedure SetUpWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMSize (var Msg: TMessage); virtual wm_First + wm_Size;
		procedure WMMove (var Msg: TMessage); virtual wm_First + wm_Move;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	private
		BMP, BkBrush      : HBitmap;
		CtlStyle, IsMenu,
		IsScroller        : Boolean;
		CRect, WinRect    : TRect;
		MinMaxInfo        : PMinMaxInfo;
	end;

	PMWCCWindow = ^TMWCCWindow;
	TMWCCWindow = object(TWindow)
		IsSizeable, SFXFrame : Boolean;
		constructor Init (AParent: PWindowsObject; AName, ABmp: PChar);
		destructor Done; virtual;
		function GetClassName: PChar; virtual;
		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure Paint(PaintDC: HDC; var PaintInfo : TPaintStruct); virtual;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMSize (var Msg: TMessage); virtual wm_First + wm_Size;
		procedure WMMove (var Msg: TMessage); virtual wm_First + wm_Move;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	private
		BMP, BkBrush      : HBitmap;
		CtlStyle, IsMenu,
		IsScroller        : Boolean;
		CRect, WinRect    : TRect;
		MinMaxInfo        : PMinMaxInfo;
	end;

	PSFXMsgBoxWindow = ^TSFXMsgBoxWindow;
	TSFXMsgBoxWindow = object(TMsgBoxWindow)
	private
		CtlStyle   : Boolean;
		MinMaxInfo : PMinMaxInfo;
		szTitle    : array[0..144] of char;
		WinRect    : TRect;
		constructor Init (AParent: PWindowsObject; ATxt, ACaption: PChar; ATextType: Word);
		function 	GetClassName : PChar; virtual;
		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMNCCalcSize (var Msg: TMessage); virtual wm_First + wm_NCCalcSize;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	end;

	PSFXFileNameDlg = ^TSFXFileNameDlg;
	TSFXFileNameDlg = object(TFileNameDlg)
		OkBtn, CancelBtn : PMWCCBmpButton;
		constructor Init (AParent: PWindowsObject; AName: PChar; IsOpen: Boolean);
		destructor Done; virtual;
		procedure SetUpWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMNCCalcSize (var Msg: TMessage); virtual wm_First + wm_NCCalcSize;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
		procedure WMDrawItem (var msg :TMessage); virtual wm_First + wm_DrawItem;
	private
		CtlStyle   : Boolean;
		szTitle    : array[0..144] of char;
		WinRect    : TRect;
		LB1, LB2   : PMWCCListBox;
		EC         : PMWCCEdit;
		CB1, CB2   : PMWCCComboBox;
		CBox       : PMWCCCheckBox;
	end;

	PSFXDialog = ^TSFXDialog;
	TSFXDialog = object(TDialog)
		constructor Init (AParent: PWindowsObject; AName: PChar);
		destructor Done; virtual;
		function 	GetClassName : PChar; virtual;
		procedure SetUpWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMNCCalcSize (var Msg: TMessage); virtual wm_First + wm_NCCalcSize;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	private
		CtlStyle : Boolean;
		szTitle  : array[0..144] of char;
		WinRect  : TRect;
	end;

	PSFXDlgWindow = ^TSFXDlgWindow;
	TSFXDlgWindow = object(TDlgWindow)
		IsSizeable : Boolean;
		constructor Init (AParent: PWindowsObject; AName: PChar);
		destructor Done; virtual;
		function 	GetClassName : PChar; virtual;
		procedure SetUpWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMNCCalcSize (var Msg: TMessage); virtual wm_First + wm_NCCalcSize;
		procedure WMSize (var Msg: TMessage); virtual wm_First + wm_Size;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	private
		CtlStyle   : Boolean;
		MinMaxInfo : PMinMaxInfo;
		szTitle    : array[0..144] of char;
		WinRect    : TRect;
	end;

	PSFXWindow = ^TSFXWindow;
	TSFXWindow = object(TWindow)
		IsSizeable : Boolean;
		constructor Init(AParent: PWindowsObject; AName: PChar);
		destructor Done; virtual;
		function 	GetClassName : PChar; virtual;
		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMNCCalcSize (var Msg: TMessage); virtual wm_First + wm_NCCalcSize;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMSize (var Msg: TMessage); virtual wm_First + wm_Size;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	private
		CtlStyle   : Boolean;
		MinMaxInfo : PMinMaxInfo;
		szTitle    : array[0..144] of char;
		WinRect    : TRect;
	end;

	function  MWCCMsgBox (Parent: PWindowsObject; Txt, Caption: PChar; TextType: Word;
											 ABmp: PChar): Integer;

	function  SFXMsgBox (Parent: PWindowsObject; Txt, Caption: PChar; TextType: Word): Integer;

	procedure CreateDefaultFont (var LogFont: TLogFont; IsBold: Boolean);

	procedure Draw3DBorder (Wnd: HWnd; X, Y, W, H: Integer; Shade: Word);

	procedure DrawRadioButton (Wnd: HWnd; X, Y: Integer; Resolution: Word);

	procedure DrawButton (Wnd: HWnd; Title: PChar; Bmp: HBitmap; Style: Word; var Msg: TMessage);

	procedure DrawBmpButton (Wnd: HWnd; UpBmp, DownBmp, FocusBmp: HBitmap; Style: Word;
													 var Msg: TMessage);

	procedure BlackFrame (DC: HDC; X, Y, W, H: Integer);

	procedure Paint3DFrame (PaintDC: HDC; X, Y, W, H: Integer; FrW, FrH: Word);

	procedure Draw3DFrame (Wnd: HWnd);

	procedure DrawSFXFrame (Wnd: HWnd);

implementation

const

	idw_Static                = 50;
	idw_BkStatic              = 51;
	CurModal : PWindowsObject = nil;

var

	HLib : THandle;
	MsgBmp  : HBitmap;

{********** Externals **********}

procedure CreateDefaultFont; external 'MWCC' Index 1;

procedure Draw3DBorder; external 'MWCC' Index 2;

procedure DrawRadioButton; external 'MWCC' Index 3;

procedure DrawButton; external 'MWCC' Index 4;

procedure DrawBmpButton; external 'MWCC' Index 5;

procedure BlackFrame; external 'MWCC' Index 6;

procedure Paint3DFrame; external 'MWCC' Index 7;

procedure Draw3DFrame; external 'MWCC' Index 8;

procedure DrawSFXFrame; external 'MWCC' Index 9;

{********** Global Functions and Procedures **********}

function GetProgWin: PWindow;
begin
	if Application = nil then
		GetProgWin := nil
	else
		GetProgWin := PWindow(Application^.MainWindow);
end;

procedure HandleMessage;
var
	Msg: TMsg;
begin
	if PeekMessage(Msg, 0, 0, 0, pm_Remove) then
	begin
		if not Application^.ProcessAppMsg(Msg) then
		begin
			if Msg.Message <> wm_KillFocus then
			begin
				TranslateMessage(Msg);
				DispatchMessage(Msg);
			end
			else
				MessageBeep(10);
		end;
	end;
end;

function RunModal (P: PMsgBoxWindow; CallDone: Boolean): Integer;
begin
	P^.BeginModal;
	while not P^.Complete do
		HandleMessage;
	P^.EndModal;
	RunModal := P^.Reply;
	if CallDone then
		P^.Done;
end;

procedure LoadBmp(wBmp: Word);
begin
	if wBmp = 0 then
	begin
		MsgBmp := 0;
		Exit;
	end;
	if wBmp = 64 then MsgBmp := LoadBitmap(HLib, PChar(1904));
	if wBmp = 48 then MsgBmp := LoadBitmap(HLib, PChar(1903));
	if wBmp = 16 then MsgBmp := LoadBitmap(HLib, PChar(1901));
	if wBmp = 32 then MsgBmp := LoadBitmap(HLib, PChar(1902));
end;

function MWCCMsgBox (Parent: PWindowsObject; Txt, Caption: PChar; TextType: Word;
										 ABmp: PChar): Integer;
var
	 P : PMsgBoxWindow;
begin
	 if Parent = nil then Exit;
	 MWCCMsgBox := RunModal(New(PMWCCMsgBoxWindow, Init(Parent, Txt, Caption,
															TextType, ABmp)), True);
end;

function SFXMsgBox (Parent: PWindowsObject; Txt, Caption: PChar; TextType: Word): Integer;
var
	 P : PMsgBoxWindow;
begin
	 if Parent = nil then Exit;
	 SFXMsgBox := RunModal(New(PSFXMsgBoxWindow, Init(Parent, Txt, Caption, TextType)), True);
end;

{********** TCommDlg **********}

constructor TCommonDlg.Init(AParent: PWindowsObject; AName: PChar);
begin
	TDialog.init(AParent, AName);
	DisableTransfer;
end;

destructor TCommonDlg.Done;
begin
	TDialog.done
end;

function TCommonDlg.Create :Boolean;
begin
  Abstract
end;

function TCommonDlg.Execute:Integer;
var
  Result :Integer;
begin
  Result := CommDlgExtendedError;
  if Result = 0 then
    Execute := id_Ok
	else
    Execute := -Result;
end;

function TCommonDlg.DlgTitle :PChar;
begin
  DlgTitle := nil
end;

procedure TCommonDlg.Ok(var msg :TMessage);
begin
	Msg.Result := Word(not CanClose)
end;

procedure TCommonDlg.Cancel(var msg :TMessage);
begin
  Msg.Result := 0
end;

{********** TFileNameDlg **********}

constructor TFileNameDlg.Init(AParent: PWindowsObject; AName: PChar; IsOpen: Boolean);
begin
	TCommonDlg.init(AParent, AName);
	Open := IsOpen;
  FillChar(FilePath, sizeOf(FilePath), #0);
	FillChar(FileTitle, sizeOf(FileTitle), #0);
	FillChar(OpenFileName, SizeOf(TOpenFileName), #0);
end;

destructor TFileNameDlg.Done;
begin
	TCommonDlg.Done;
end;

function TFileNameDlg.DefSpec: PChar;
begin
	DefSpec := 'All Files (*.*)'#0'*.*'#0
end;

function TFileNameDlg.DefSpecPos: Byte;
begin
  DefSpecPos := 1;
end;

function TFileNameDlg.DefExt: PChar;
begin
	DefExt := '*'
end;

function TFileNameDlg.OpenFlags: Longint;
begin
	if Open then
		OpenFlags := ofn_PathMustExist or ofn_HideReadOnly
  else
		OpenFlags := ofn_PathMustExist or ofn_HideReadOnly or ofn_NoReadOnlyReturn;
end;

function TFileNameDlg.DlgTitle :PChar;
begin
	if Open then
		DlgTitle := 'File Open'
	else
		DlgTitle := 'File Save As';
end;

function TFileNameDlg.DoExec: Boolean;
begin
	if Open then
    DoExec := GetOpenFileName(OpenFileName)
  else
		DoExec := GetSaveFileName(OpenFileName);
end;

function TFileNameDlg.Execute: Integer;
var
	Result       : Integer;
	OldKBHandler : PWindowsObject;
begin
	with OpenFileName do
  begin
		lStructSize := sizeof(OpenFileName);
		HInstance := System.HInstance;
		if Parent <> nil then
      HWndOwner := Parent^.HWindow
		else
      HWndOwner := 0;
		lpstrTitle := DlgTitle;
		lpTemplateName := Attr.Name;
		lpstrFilter := DefSpec;
		nFilterIndex := DefSpecPos;
		lpstrDefExt := DefExt;
		lpstrFile := FilePath;
		lpstrFileTitle := FileTitle;
		Flags := OpenFlags;
		if (lpTemplateName <> nil) then
			Flags := Flags or ofn_EnableTemplate
		else
			lpTemplateName := nil;
		nMaxFile      := sizeOf(FilePath);
		nMaxFileTitle := sizeOf(FileTitle);
		lCustData    := Longint(@Self);
		move(Self.Instance, lpfnHook, sizeOf(lpfnHook));
		Flags := Flags or ofn_EnableHook;
	end;
	OldKbHandler := Application^.KBHandlerWnd;
	IsModal := True;
	if DoExec then
		Execute := id_Ok
	else
	begin
		Result := CommDlgExtendedError;
		if Result = 0 then
			Execute := id_Cancel
		else
		begin
			Execute := -Result;
			Status  := em_InvalidWindow;
		end;
	end;
	HWindow := 0;
	IsModal := False;
	Application^.KBHandlerWnd := OldKbHandler;
end;

{********** TMsgBoxWindow **********}

constructor TMsgBoxWindow.Init (AParent: PWindowsObject; ATxt, ACaption: PChar; ATextType: Word) ;
begin
	if (ATextType >= 4096) and (ATextType < 8192) then
	begin
		MessageBox(0, ATxt, ACaption, ATextType);
		Halt;
	end;
	TWindow.Init (AParent, ACaption);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	HLib := LoadLibrary ('MWCC.dll');
	if HLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	SetFlags(wb_MDIChild, False);
	DefaultProc := @DefWindowProc;
	EnableKBHandler;
	Def1 := False;
	Def2 := False;
	Def3 := False;
	NoClose := False;
	Complete := False;
end;

function TMsgBoxWindow.CanClose;
begin
	CanClose := not NoClose;
	if MsgBmp <> 0 then DeleteObject(MsgBmp);
	FreeLibrary(HLib);
end;

procedure TMsgBoxWindow.SetUpWindow;
var
	SysMenu : HMenu;
begin
	TWindow.SetUpWindow;
	SysMenu := GetSystemMenu(HWindow, False);
	DeleteMenu(SysMenu, 0, mf_ByPosition);
	DeleteMenu(SysMenu, 1, mf_ByPosition);
	DeleteMenu(SysMenu, 1, mf_ByPosition);
	DeleteMenu(SysMenu, 1, mf_ByPosition);
	DeleteMenu(SysMenu, 1, mf_ByPosition);
	DeleteMenu(SysMenu, 1, mf_ByPosition);
	DeleteMenu(SysMenu, 1, mf_ByPosition);
	DeleteMenu(SysMenu, 1, mf_ByPosition);
	CenterOverScreen(HWindow);
	if NoClose then
		EnableMenuItem(SysMenu, sc_Close, mf_Disabled + mf_Grayed);
	SetFocus(PBut^.HWindow);
end;

procedure TMsgBoxWindow.Paint(PaintDC: HDC; var PS: TPaintStruct);
var
	OldObject: THandle;
	MemDC: HDC;
	a, b: Integer;
begin
	if GetSystemMetrics(sm_CYSize) = 26 then
	begin
		a := 7; b := 7;
		Draw3DBorder(HWindow, 16, 20, 437, 124, ctl_Recessed);
	end
	else
	begin
		a := 0;	b := 0;
		Draw3DBorder(HWindow, 16, 20, 339, 100, ctl_Recessed);
	end;
	if MsgBmp <> 0 then
	begin
		MemDC := CreateCompatibleDC(PaintDC);
		OldObject := SelectObject(MemDC, MsgBmp);
		BitBlt(PaintDC, 25+a, 29+b, 48, 64, MemDC, 0, 0, SrcCopy);
		SelectObject(MemDC, OldObject);
		DeleteDC(MemDC);
	end;
end;

procedure TMsgBoxWindow.WMDrawItem(var Msg:tMessage);
begin
	with PDrawItemStruct(Msg.lParam)^ do
		case CtlType of
			odt_Button:
        case CtlID of
					id_Ok : But1^.DrawItem(Msg);
					id_Cancel : But2^.DrawItem(Msg);
					id_Abort : But3^.DrawItem(Msg);
					id_Retry : But4^.DrawItem(Msg);
					id_Ignore : But5^.DrawItem(Msg);
					id_Yes : But6^.DrawItem(Msg);
					id_No : But7^.DrawItem(Msg);
				end;
    end;
end;

procedure TMsgBoxWindow.WMCtlColor(var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TWindow.DefWndProc(Msg);
	end;
end;

procedure TMsgBoxWindow.EndWin (AReply: Integer);
begin
	if CanClose then
	begin
		Reply := AReply;
		Complete := True;
	end;
end;

procedure TMsgBoxWindow.OK (var Msg: TMessage);
begin
	EndWin(GetDlgCtrlID(GetFocus));
end;

procedure TMsgBoxWindow.Cancel (var Msg: TMessage);
begin
	EndWin(id_Cancel);
end;

procedure TMsgBoxWindow.Abort (var Msg: TMessage);
begin
	 EndWin(id_Abort);
end;

procedure TMsgBoxWindow.Retry (var Msg: TMessage);
begin
	 EndWin(id_Retry);
end;

procedure TMsgBoxWindow.Ignore (var Msg: TMessage);
begin
	 EndWin(id_Ignore);
end;

procedure TMsgBoxWindow.Yes (var Msg: TMessage);
begin
	 EndWin(id_Yes);
end;

procedure TMsgBoxWindow.No (var Msg: TMessage);
begin
	 EndWin(id_No);
end;

procedure TMsgBoxWindow.WMClose (var Msg: TMessage);
begin
	Cancel(Msg);
end;

procedure TMsgBoxWindow.BeginModal;
begin
	LastWnd := GetFocus;
	if CurModal = nil then
		LastModal := GetProgWin
	else
		LastModal := CurModal;
	EnableWindow(Parent^.HWindow, False);
	Application^.MakeWindow(@self);
	CurModal := @self;
end;

procedure TMsgBoxWindow.EndModal;
begin
	EnableWindow(Parent^.HWindow, True);
	SetFocus(LastWnd);
	CurModal := LastModal;
end;

{********** TSFXWindow **********}

constructor TSFXWindow.Init (AParent: PWindowsObject; AName: PChar);
begin
	TWindow.Init(AParent, AName);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	Attr.Style := ws_OverlappedWindow or ws_Visible and not ws_VScroll and not ws_HScroll;
	IsSizeable := True;
end;

destructor TSFXWindow.Done;
begin
	FreeLibrary(hLib);
	TWindow.Done;
end;

function TSFXWindow.GetClassName;
begin
	GetClassName := 'SFXWindow';
end;

procedure TSFXWindow.GetWindowClass (var AWndClass: TWndClass);
begin
	TWindow.GetWindowClass(AWndClass);
	AWndClass.HBrBackground := GetStockObject(LtGray_Brush);
end;

procedure TSFXWindow.SetUpWindow;
var
	lStyle : LongInt;
begin
	TWindow.SetupWindow;
	lStyle := GetWindowLong (hWindow, gwl_Style);
	if lStyle = lStyle or ws_VScroll then lStyle := lStyle and not ws_VScroll;
	if lStyle = lStyle or ws_HScroll then lStyle := lStyle and not ws_HScroll;
	if lStyle = lStyle and not ws_ThickFrame then lStyle := lStyle or ws_ThickFrame;
	SetWindowLong (HWindow, gwl_Style, lStyle);
	if GetMenu(HWindow) <> 0 then
	begin
		DestroyMenu(GetMenu(HWindow));
		DrawMenuBar(HWindow);
	end;
end;

procedure TSFXWindow.WMNCPaint (var Msg: TMessage);
begin
	 DrawSFXFrame(HWindow);
	 GetWindowText(HWindow, szTitle, sizeof(szTitle));
	 SetWindowText(HWindow, szTitle);
	 Msg.Result := 1;
end;

procedure TSFXWindow.WMNCCalcSize (var Msg: TMessage);
type
	CRect = array[0..2] of TRect;
	PRect = ^CRect;
begin
	Inc(PRect(Msg.lParam)^[0].Top, 1);
	DefWindowProc(HWindow, wm_NCCalcSize, Msg.wParam, Msg.lParam);
end;

procedure TSFXWindow.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TWindow.DefWndProc(Msg);
	end;
end;

procedure TSFXWindow.WMSize (var Msg: TMessage);
begin
	TWindow.WMSize(Msg);
	DrawSFXFrame(HWindow);
end;

procedure TSFXWindow.WMActivate (var Msg: TMessage);
begin
	TWindow.WMActivate(Msg);
	DrawSFXFrame(HWindow);
end;

procedure TSFXWindow.WMNCActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TWindow.DefWndProc(Msg);
end;

procedure TSFXWindow.WMActivateApp (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TWindow.DefWndProc(Msg);
end;

procedure TSFXWindow.WMGetMinMaxInfo (var Msg: TMessage);
begin
	longInt(MinMaxInfo) := Msg.lParam;
	if IsSizeable then
	begin
		MinMaxInfo^[1].X :=  GetSystemMetrics(sm_CXScreen);
		MinMaxInfo^[1].Y :=  GetSystemMetrics(sm_CYScreen);
		MinMaxInfo^[2].X :=  0;
		MinMaxInfo^[2].Y :=  0;
	end
	else
	begin
		GetWindowRect(HWindow, WinRect);
		if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
		begin
			MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
		end;
	end;
end;

{********** TSFXDlgWindow **********}

constructor TSFXDlgWindow.Init (AParent: PWindowsObject; AName: PChar);
begin
	TDlgWindow.Init(AParent, AName);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	IsSizeable := True;
end;

destructor TSFXDlgWindow.Done;
begin
	FreeLibrary(hLib);
	TDlgWindow.Done;
end;

function TSFXDlgWindow.GetClassName;
begin
	GetClassName := 'SFXDlgWindow';
end;

procedure TSFXDlgWindow.SetUpWindow;
var
	lStyle : LongInt;
begin
	TDlgWindow.SetUpWindow;
	lStyle := GetWindowLong (hWindow, gwl_Style);
	if lStyle = lStyle or ws_VScroll then lStyle := lStyle and not ws_VScroll;
	if lStyle = lStyle or ws_HScroll then lStyle := lStyle and not ws_HScroll;
	if lStyle = lStyle and not ws_ThickFrame then lStyle := lStyle or ws_ThickFrame;
	SetWindowLong (HWindow, gwl_Style, lStyle);
	if GetMenu(HWindow) <> 0 then
	begin
		DestroyMenu(GetMenu(HWindow));
		DrawMenuBar(HWindow);
	end;
end;

procedure TSFXDlgWindow.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Dlg, CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TDlgWindow.DefWndProc(Msg);
	end;
end;

procedure TSFXDlgWindow.WMPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TSFXDlgWindow.WMNCPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	GetWindowText(HWindow, szTitle, sizeof(szTitle));
	SetWindowText(HWindow, szTitle);
	Msg.Result := 1;
end;

procedure TSFXDlgWindow.WMNCCalcSize (var Msg: TMessage);
type
	CRect = array[0..2] of TRect;
	PRect = ^CRect;
begin
	Inc(PRect(Msg.lParam)^[0].Top, 1);
	DefWindowProc(HWindow, wm_NCCalcSize, Msg.wParam, Msg.lParam);
end;

procedure TSFXDlgWindow.WMSize (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TSFXDlgWindow.WMActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TSFXDlgWindow.WMNCActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TSFXDlgWindow.WMActivateApp (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TSFXDlgWindow.WMGetMinMaxInfo (var Msg: TMessage);
begin
	longInt(MinMaxInfo) := Msg.lParam;
	if IsSizeable then
	begin
		MinMaxInfo^[1].X :=  GetSystemMetrics(sm_CXScreen);
		MinMaxInfo^[1].Y :=  GetSystemMetrics(sm_CYScreen);
		MinMaxInfo^[2].X :=  0;
		MinMaxInfo^[2].Y :=  0;
	end
	else
	begin
		GetWindowRect(HWindow, WinRect);
		if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
		begin
			MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
		end;
	end;
end;

{********** TSFXDialog **********}

constructor TSFXDialog.Init (AParent: PWindowsObject; AName: PChar);
begin
	TDialog.Init(AParent, AName);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
end;

destructor TSFXDialog.Done;
begin
	FreeLibrary(hLib);
	TDialog.Done;
end;

function TSFXDialog.GetClassName;
begin
	GetClassName := 'SFXDialog';
end;

procedure TSFXDialog.SetUpWindow;
var
	SysMenu : HMenu;
	lStyle  : LongInt;
begin
	TDialog.SetUpWindow;
	SysMenu := GetSystemMenu(HWindow, False);
	RemoveMenu(SysMenu, 0, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 2, mf_ByPosition);
	RemoveMenu(SysMenu, 2, mf_ByPosition);
	lStyle := GetWindowLong (hWindow, gwl_Style);
	if lStyle = lStyle or ws_VScroll then lStyle := lStyle and not ws_VScroll;
	if lStyle = lStyle or ws_HScroll then lStyle := lStyle and not ws_HScroll;
	if lStyle = lStyle and not ws_ThickFrame then lStyle := lStyle or ws_ThickFrame;
	SetWindowLong (HWindow, gwl_Style, lStyle);
	if GetMenu(HWindow) <> 0 then
	begin
		DestroyMenu(GetMenu(HWindow));
		DrawMenuBar(HWindow);
	end;
end;

procedure TSFXDialog.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Dlg, CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TDialog.DefWndProc(Msg);
	end;
end;

procedure TSFXDialog.WMPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDialog.DefWndProc(Msg);
end;

procedure TSFXDialog.WMNCPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	GetWindowText(HWindow, szTitle, sizeof(szTitle));
	SetWindowText(HWindow, szTitle);
	Msg.Result := 1;
end;

procedure TSFXDialog.WMNCCalcSize (var Msg: TMessage);
type
	CRect = array[0..2] of TRect;
	PRect = ^CRect;
begin
	Inc(PRect(Msg.lParam)^[0].Top, 1);
	DefWindowProc(HWindow, wm_NCCalcSize, Msg.wParam, Msg.lParam);
end;

procedure TSFXDialog.WMActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDialog.DefWndProc(Msg);
end;

procedure TSFXDialog.WMNCActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDialog.DefWndProc(Msg);
end;

procedure TSFXDialog.WMActivateApp (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDialog.DefWndProc(Msg);
end;

procedure TSFXDialog.WMGetMinMaxInfo (var Msg: TMessage);
type
	TMinMaxInfo = array [0..4] of TPoint;
	PMinMaxInfo = ^TMinMaxInfo;
var
	MinMaxInfo : PMinMaxInfo;
	buf : array [0..10] of Char;
begin
	longInt(MinMaxInfo) := Msg.lParam;
	GetWindowRect(HWindow, WinRect);
	if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
	begin
		MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
		MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
		MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
	end;
end;

{********** TSFXFileNameDlg **********}

constructor TSFXFileNameDlg.Init (AParent: PWindowsObject; AName: PChar; IsOpen: Boolean);
begin
	TFileNameDlg.Init(AParent, AName, IsOpen);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	EC := New(PMWCCEdit, InitResource(@Self, 1152, 21));
	LB1 := New(PMWCCListBox, InitResource(@Self, 1120));
	LB2 := New(PMWCCListBox, InitResource(@Self, 1121));
	CB1 := New(PMWCCComboBox, InitResource(@Self, 1136, 21));
	CB2 := New(PMWCCComboBox, InitResource(@Self, 1137, 21));
	if GetSystemMetrics(sm_CYSize) = 26 then
	begin
		OkBtn := New(PMWCCBmpButton, Init(@Self, id_Ok, 508, 32, False, 1, ctl_Flush));
		CancelBtn := New(PMWCCBmpButton, Init(@Self, id_Cancel, 508, 130, False, 2, ctl_Flush));
	end
	else
	begin
		OkBtn := New(PMWCCBmpButton, Init(@Self, id_Ok, 387, 26, False, 1, ctl_Flush));
		CancelBtn := New(PMWCCBmpButton, Init(@Self, id_Cancel, 387, 103, False, 2, ctl_Flush));
	end;
	CBox := New(PMWCCCheckBox, InitResource(@Self, 1040));
end;

destructor TSFXFileNameDlg.Done;
begin
	FreeLibrary(hLib);
	TFileNameDlg.Done;
end;

procedure TSFXFileNameDlg.SetUpWindow;
var
	SysMenu : HMenu;
begin
	TFileNameDlg.SetUpWindow;
	SysMenu := GetSystemMenu(HWindow, False);
	RemoveMenu(SysMenu, 0, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 2, mf_ByPosition);
	RemoveMenu(SysMenu, 2, mf_ByPosition);
	DestroyMenu(GetMenu(HWindow));
	DrawMenuBar(HWindow);
end;

procedure TSFXFileNameDlg.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Dlg, CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TFileNameDlg.DefWndProc(Msg);
	end;
end;

procedure TSFXFileNameDlg.WMPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TFileNameDlg.DefWndProc(Msg);
end;

procedure TSFXFileNameDlg.WMNCPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	GetWindowText(HWindow, szTitle, sizeof(szTitle));
	SetWindowText(HWindow, szTitle);
	Msg.Result := 1;
end;

procedure TSFXFileNameDlg.WMNCCalcSize (var Msg: TMessage);
type
	CRect = array[0..2] of TRect;
	PRect = ^CRect;
begin
	Inc(PRect(Msg.lParam)^[0].Top, 1);
	DefWindowProc(HWindow, wm_NCCalcSize, Msg.wParam, Msg.lParam);
end;

procedure TSFXFileNameDlg.WMActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TFileNameDlg.DefWndProc(Msg);
end;

procedure TSFXFileNameDlg.WMNCActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TFileNameDlg.DefWndProc(Msg);
end;

procedure TSFXFileNameDlg.WMActivateApp (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TFileNameDlg.DefWndProc(Msg);
end;

procedure TSFXFileNameDlg.WMGetMinMaxInfo (var Msg: TMessage);
type
	TMinMaxInfo = array [0..4] of TPoint;
	PMinMaxInfo = ^TMinMaxInfo;
var
	MinMaxInfo : PMinMaxInfo;
	buf : array [0..10] of Char;
begin
	longInt(MinMaxInfo) := Msg.lParam;
	GetWindowRect(HWindow, WinRect);
	if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
	begin
		MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
		MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
		MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
	end;
end;

procedure TSFXFileNameDlg.WMDrawItem(var Msg:tMessage);
begin
	with PDrawItemStruct(Msg.lParam)^ do
    case CtlType of
      odt_Button:
        case CtlID of
					id_Ok : OkBtn^.DrawItem(Msg);
					id_Cancel : CancelBtn^.DrawItem(Msg);
				end;
		end;
	TFileNameDlg.DefWndProc(Msg);
end;

{********** TSFXMsgBoxWindow **********}

constructor TSFXMsgBoxWindow.Init (AParent: PWindowsObject; ATxt, ACaption: PChar;
																	 ATextType: Word);
label
 CaseExit;
var
	a, b, c, d, e, f, X : Integer;
begin
	TMsgBoxWindow.Init(AParent, ATxt, ACaption, ATextType);
	if GetSystemMetrics(sm_CYSize) = 26 then
	begin
		a := 46; b := 33; c := 66; d:= 20; e := 76; f := 0;
		Attr.W := 475 + GetSystemMetrics(sm_CXFrame);
		Attr.H := 243 + GetSystemMetrics(sm_CYCaption) + GetSystemMetrics(sm_CYFrame);
		Stat := New(PMWCCStatic, Init(@Self, idw_Static, ATxt, 86, 30, 356, 100, 255, 0, True));
	end
	else
	begin
		a := 0; b := 0; c := 0; d:= 0; e := 0; f := -24;
		Attr.W := 378 + GetSystemMetrics(sm_CXFrame);
		Attr.H := 219 + GetSystemMetrics(sm_CYCaption) + GetSystemMetrics(sm_CYFrame);
		Stat := New(PMWCCStatic, Init(@Self, idw_Static, ATxt, 80, 30, 266, 81, 255, 0, True));
	end;
	Attr.Style := ws_Popup or ws_Visible or ws_Caption or ws_SysMenu or ws_Thickframe;
	if AtextType >= 8192 then
	begin
		ATextType := ATextType - 8192;
	end
	else
	if (ATextType >= 512) and (ATextType < 4096) then
	begin
		Def3 := True;
		ATextType := ATextType - 512;
	end
	else
	if (ATextType >= 256) and (ATextType < 512) then
	begin
		Def2 := True;
		ATextType := ATextType - 256;
	end
	else
		Def1 := True;
	case ATextType of
		0, 64, 48, 16, 32:
		begin
			But1 := New(PMsgBoxButton, Init(@Self, id_Ok, 151+a, 166+f, Def1, 1, ctl_Flush));
			PBut := But1;
			LoadBmp(ATextType);
			goto CaseExit;
		end;
		1, 65, 49, 17, 33:
		begin
			But1 := New(PMsgBoxButton, Init(@Self, id_Ok, 72+b, 166+f, Def1, 1, ctl_Flush));
			But2 := New(PMsgBoxButton, Init(@Self, id_Cancel, 224+c, 166+f, Def2, 2, ctl_Flush));
			if Def1 = True then
				PBut := But1
			else
				PBut := But2;
			LoadBmp(ATextType - 1);
			goto CaseExit;
		end;
		5, 69, 53, 21, 37:
		begin
			But4 := New(PMsgBoxButton, Init(@Self, id_Retry, 72+b, 166+f, Def1, 4, ctl_Flush));
			But2 := New(PMsgBoxButton, Init(@Self, id_Cancel, 224+c, 166+f, Def2, 2, ctl_Flush));
			if Def1 = True then
				PBut := But4
			else
				PBut := But2;
			LoadBmp(ATextType - 5);
			goto CaseExit;
		end;
		4, 68, 52, 20, 36:
		begin
			But6 := New(PMsgBoxButton, Init(@Self, id_Yes, 72+b, 166+f, Def1, 6, ctl_Flush));
			But7 := New(PMsgBoxButton, Init(@Self, id_No, 224+c, 166+f, Def2, 7, ctl_Flush));
			if Def1 = True then
				PBut := But6
			else
				PBut := But7;
			LoadBmp(ATextType - 4);
			goto CaseExit;
		end;
		3, 67, 51, 19, 35:
		begin
			But6 := New(PMsgBoxButton, Init(@Self, id_Yes, 34+d, 166+f, Def1, 6, ctl_Flush));
			But7 := New(PMsgBoxButton, Init(@Self, id_No, 151+a, 166+f, Def2, 7, ctl_Flush));
			But2 := New(PMsgBoxButton, Init(@Self, id_Cancel, 266+e, 166+f, Def3, 2, ctl_Flush));
			if Def1 = True then
				PBut := But6
			else
			if Def2 = True then
				PBut := But7
			else
				PBut := But2;
			LoadBmp(ATextType - 3);
			goto CaseExit;
		end;
		2, 66, 50, 18, 34:
		begin
			But3 := New(PMsgBoxButton, Init(@Self, id_Abort, 34+d, 166+f, Def1, 3, ctl_Flush));
			But4 := New(PMsgBoxButton, Init(@Self, id_Retry, 151+a, 166+f, Def2, 4, ctl_Flush));
			But5 := New(PMsgBoxButton, Init(@Self, id_Ignore, 266+e, 166+f, Def3, 5, ctl_Flush));
			if Def1 = True then
				PBut := But3
			else
			if Def2 = True then
				PBut := But4
			else
				PBut := But5;
			LoadBmp(ATextType - 2);
			goto CaseExit;
		end;
	end;
	CaseExit:
	HBut := New(PButton, Init(@Self, id_Ok, '', 0, 0, 0, 0, False));
	HBut^.Attr.Style := HBut^.Attr.Style and not ws_TabStop;
end;

function TSFXMsgBoxWindow.GetClassName;
begin
	GetClassName := 'SFXMsgBoxWindow';
end;

procedure TSFXMsgBoxWindow.GetWindowClass (var AWndClass: TWndClass);
begin
	TMsgBoxWindow.GetWindowClass(AWndClass);
	AWndClass.HBrBackground := GetStockObject(LtGray_Brush);
end;

procedure TSFXMsgBoxWindow.WMPaint (var Msg: TMessage);
begin
	TMsgBoxWindow.WMPaint(Msg);
	DrawSFXFrame(HWindow);
end;

procedure TSFXMsgBoxWindow.WMNCPaint (var Msg: TMessage);
begin
	 DrawSFXFrame(HWindow);
	 GetWindowText(HWindow, szTitle, sizeof(szTitle));
	 SetWindowText(HWindow, szTitle);
	 Msg.Result := 1;
end;

procedure TSFXMsgBoxWindow.WMNCCalcSize (var Msg: TMessage);
type
	CRect = array[0..2] of TRect;
	PRect = ^CRect;
begin
	Inc(PRect(Msg.lParam)^[0].Top, 1);
	DefWindowProc(HWindow, wm_NCCalcSize, Msg.wParam, Msg.lParam);
end;

procedure TSFXMsgBoxWindow.WMActivate (var Msg: TMessage);
begin
	TMsgBoxWindow.WMActivate(Msg);
	DrawSFXFrame(HWindow);
end;

procedure TSFXMsgBoxWindow.WMNCActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TMsgBoxWindow.DefWndProc(Msg);
end;

procedure TSFXMsgBoxWindow.WMActivateApp (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TMsgBoxWindow.DefWndProc(Msg);
end;

procedure TSFXMsgBoxWindow.WMGetMinMaxInfo (var Msg: TMessage);
begin
	longInt(MinMaxInfo) := Msg.lParam;
	GetWindowRect(HWindow, WinRect);
	if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
	begin
		MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
		MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
		MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
	end;
end;

{********** TMWCCWindow **********}

constructor TMWCCWindow.Init (AParent: PWindowsObject; AName, ABmp: PChar);
begin
	TWindow.Init(AParent, AName);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	Bmp := LoadBitmap(HLib, ABmp);
	if Bmp <> 0 then BkBrush := CreatePatternBrush(Bmp);
	Attr.Style := ws_OverlappedWindow or ws_Visible;
	SFXFrame := False;
	IsSizeable := True;
	IsScroller := False;
	IsMenu := False;
end;

destructor TMWCCWindow.Done;
begin
	if Bmp <> 0 then
	begin
		DeleteObject(Bmp);
		DeleteObject(BkBrush);
	end;
	FreeLibrary(hLib);
	TWindow.Done;
end;

function TMWCCWindow.GetClassName: PChar;
begin
	GetClassName := 'MWCCWindow';
end;

procedure TMWCCWindow.GetWindowClass(var AWndClass: TWndClass);
begin
	TWindow.GetWindowClass(AWndClass);
	if Bmp <> 0 then
		AWndClass.HBrBackground := BkBrush
	else
		AWndClass.HBrBackground := GetStockObject(LtGray_Brush);
end;

procedure TMWCCWindow.SetUpWindow;
var
	lStyle : LongInt;
begin
	TWindow.SetUpWindow;
	lStyle := GetWindowLong (HWindow, gwl_Style);
	if (lStyle = lStyle or ws_VScroll) or (lStyle = lStyle or ws_HScroll) then
		IsScroller := True;
	if GetMenu(HWindow) <> 0 then
		IsMenu := True;
end;

procedure TMWCCWindow.WMCtlColor(var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TWindow.DefWndProc(Msg);
	end;
end;

procedure TMWCCWindow.Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);
var
	W, H: Integer;
begin
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	Draw3DBorder(HWindow, 1, 1, W-2, H-2, ctl_Raised);
end;

procedure TMWCCWindow.WMSize (var Msg: TMessage);
begin
	TWindow.WMSize(Msg);
	if SFXFrame then Draw3DFrame(HWindow);
end;

procedure TMWCCWindow.WMMove (var Msg: TMessage);
begin
	TWindow.WMMove(Msg);
	if SFXFrame then Draw3DFrame(HWindow);
end;

procedure TMWCCWindow.WMNCPaint (var Msg: TMessage);
var
	szTitle : array[0..50] of Char;
begin
	if SFXFrame then Draw3DFrame(HWindow);
	if IsScroller or IsMenu or (not SFXFrame) then
		TWindow.DefWndProc(Msg)
	else
	begin
		GetWindowText(HWindow, szTitle, sizeof(szTitle));
		SetWindowText(HWindow, szTitle);
		Msg.Result := 1;
	end;
end;

procedure TMWCCWindow.WMActivate (var Msg: TMessage);
begin
	TWindow.WMActivate(Msg);
	if SFXFrame then Draw3DFrame(HWindow);
end;

procedure TMWCCWindow.WMNCActivate (var Msg: TMessage);
begin
	if SFXFrame then Draw3DFrame(HWindow);
	TWindow.DefWndProc(Msg);
end;

procedure TMWCCWindow.WMActivateApp (var Msg: TMessage);
begin
	if SFXFrame then Draw3DFrame(HWindow);
	TWindow.DefWndProc(Msg);
end;

procedure TMWCCWindow.WMGetMinMaxInfo (var Msg: TMessage);
begin
	longInt(MinMaxInfo) := Msg.lParam;
	if IsSizeable and SFXFrame then
	begin
		MinMaxInfo^[1].X :=  GetSystemMetrics(sm_CXScreen);
		MinMaxInfo^[1].Y :=  GetSystemMetrics(sm_CYScreen);
		MinMaxInfo^[2].X :=  0;
		MinMaxInfo^[2].Y :=  0;
	end
	else
	if IsSizeable and not SFXFrame then
		TWindow.DefWndProc(Msg)
	else 
	begin
		GetWindowRect(HWindow, WinRect);
		if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
		begin
			MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
		end;
	end;
end;

{********** TMWCCDlgWindow **********}

constructor TMWCCDlgWindow.Init (AParent: PWindowsObject; AName, ABmp: PChar);
begin
	TDlgWindow.Init(AParent, AName);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	Bmp := LoadBitmap(hLib, ABmp);
	if Bmp <> 0 then BkBrush := CreatePatternBrush(Bmp);
	SFXFrame := False;
	IsSizeable := True;
	IsScroller := False;
	IsMenu := False;
end;

destructor TMWCCDlgWindow.Done;
begin
	if Bmp <> 0 then
	begin
		DeleteObject(Bmp);
		DeleteObject(BkBrush);
	end;
	FreeLibrary(hLib);
	TDlgWindow.Done;
end;

function TMWCCDlgWindow.GetClassName: PChar;
begin
	GetClassName := 'MWCCDlgWindow';
end;

procedure TMWCCDlgWindow.SetUpWindow;
var
	lStyle : LongInt;
begin
	TDlgWindow.SetUpWindow;
	lStyle := GetWindowLong (HWindow, gwl_Style);
	if (lStyle = lStyle or ws_VScroll) or (lStyle = lStyle or ws_HScroll) then
		IsScroller := True;
	if GetMenu(HWindow) <> 0 then
		IsMenu := True;
end;

procedure TMWCCDlgWindow.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Dlg:
		begin
			SetBkMode(Msg.WParam, Transparent);
			if Bmp <> 0 then
				Msg.Result := BkBrush
			else
				Msg.Result := GetStockObject(LtGray_Brush);
		end;
		CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TDlgWindow.DefWndProc(Msg);
	end;
end;

procedure TMWCCDlgWindow.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	W, H : Integer;
begin
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, 1, 1, W-2, H-2, ctl_Raised);
	EndPaint(HWindow, PS);
end;

procedure TMWCCDlgWindow.WMNCPaint (var Msg: TMessage);
var
	szTitle : array[0..50] of Char;
begin
	if SFXFrame then Draw3DFrame(HWindow);
	if IsScroller or IsMenu or (not SFXFrame) then
		TDlgWindow.DefWndProc(Msg)
	else
	begin
		GetWindowText(HWindow, szTitle, sizeof(szTitle));
		SetWindowText(HWindow, szTitle);
		Msg.Result := 1;
	end;
end;

procedure TMWCCDlgWindow.WMSize (var Msg: TMessage);
begin
	if SFXFrame then Draw3DFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TMWCCDlgWindow.WMMove (var Msg: TMessage);
begin
	if SFXFrame then Draw3DFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TMWCCDlgWindow.WMActivate (var Msg: TMessage);
begin
	if SFXFrame then Draw3DFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TMWCCDlgWindow.WMNCActivate (var Msg: TMessage);
begin
	if SFXFrame then Draw3DFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TMWCCDlgWindow.WMActivateApp (var Msg: TMessage);
begin
	if SFXFrame then Draw3DFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TMWCCDlgWindow.WMGetMinMaxInfo (var Msg: TMessage);
begin
	longInt(MinMaxInfo) := Msg.lParam;
	if IsSizeable and SFXFrame then
	begin
		MinMaxInfo^[1].X :=  GetSystemMetrics(sm_CXScreen);
		MinMaxInfo^[1].Y :=  GetSystemMetrics(sm_CYScreen);
		MinMaxInfo^[2].X :=  0;
		MinMaxInfo^[2].Y :=  0;
	end
	else
	if IsSizeable and not SFXFrame then
		TDlgWindow.DefWndProc(Msg)
	else 
	begin
		GetWindowRect(HWindow, WinRect);
		if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
		begin
			MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
		end;
	end;
end;

{********** TMWCCDialog **********}

constructor TMWCCDialog.Init (AParent: PWindowsObject; AName, ABmp: PChar);
begin
	TDialog.Init(AParent, AName);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	Bmp := LoadBitmap(hLib, ABmp);
	if Bmp <> 0 then BkBrush := CreatePatternBrush(Bmp);
end;

destructor TMWCCDialog.Done;
begin
	if Bmp <> 0 then
	begin
		DeleteObject(Bmp);
		DeleteObject(BkBrush);
	end;
	FreeLibrary(hLib);
	TDialog.Done;
end;

function TMWCCDialog.GetClassName: PChar;
begin
	GetClassName := 'MWCCDialog';
end;

procedure TMWCCDialog.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Dlg:
		begin
			SetBkMode(Msg.WParam, Transparent);
			if Bmp <> 0 then
				Msg.Result := BkBrush
			else
				Msg.Result := GetStockObject(LtGray_Brush);
		end;
		CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TDialog.DefWndProc(Msg);
	end;
end;

procedure TMWCCDialog.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	W, H : Integer;
begin
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, 1, 1, W-2, H-2, ctl_Raised);
	EndPaint(HWindow, PS);
end;

{********** TMWCCFileNameDlg **********}

constructor TMWCCFileNameDlg.Init (AParent: PWindowsObject; AName, ABmp: PChar; IsOpen: Boolean);
begin
	TFileNameDlg.Init(AParent, AName, IsOpen);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	Bmp := LoadBitmap(hLib, ABmp);
	if Bmp <> 0 then BkBrush := CreatePatternBrush(Bmp);
	EC := New(PMWCCEdit, InitResource(@Self, 1152, 21));
	LB1 := New(PMWCCListBox, InitResource(@Self, 1120));
	LB2 := New(PMWCCListBox, InitResource(@Self, 1121));
	CB1 := New(PMWCCComboBox, InitResource(@Self, 1136, 21));
	CB2 := New(PMWCCComboBox, InitResource(@Self, 1137, 21));
	if GetSystemMetrics(sm_CYSize) = 26 then
	begin
		OkBtn := New(PMWCCBmpButton, Init(@Self, id_Ok, 510, 40, False, 1, ctl_Flush));
		CancelBtn := New(PMWCCBmpButton, Init(@Self, id_Cancel, 510, 133, False, 2, ctl_Flush));
	end
	else
	begin
		OkBtn := New(PMWCCBmpButton, Init(@Self, id_Ok, 389, 33, False, 1, ctl_Flush));
		CancelBtn := New(PMWCCBmpButton, Init(@Self, id_Cancel, 389, 108, False, 2, ctl_Flush));
	end;
	CBox := New(PMWCCCheckBox, InitResource(@Self, 1040));
	ST := New(PMWCCEdit, InitResource(@Self, 1088, 50));
end;

destructor TMWCCFileNameDlg.Done;
begin
	if Bmp <> 0 then
	begin
		DeleteObject(Bmp);
		DeleteObject(BkBrush);
	end;
	FreeLibrary(hLib);
	TFileNameDlg.Done;
end;

procedure TMWCCFileNameDlg.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Dlg:
		begin
			SetBkMode(Msg.WParam, Transparent);
			if Bmp <> 0 then
				Msg.Result := BkBrush
			else
				Msg.Result := GetStockObject(LtGray_Brush);
		end;
		CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TFileNameDlg.DefWndProc(Msg);
	end;
end;

procedure TMWCCFileNameDlg.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	W, H : Integer;
begin
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, 1, 1, W-2, H-2, ctl_Raised);
	EndPaint(HWindow, PS);
end;

procedure TMWCCFileNameDlg.WMDrawItem(var Msg:tMessage);
begin
	with PDrawItemStruct(Msg.lParam)^ do
    case CtlType of
      odt_Button:
				case CtlID of
					id_Ok : OkBtn^.DrawItem(Msg);
					id_Cancel : CancelBtn^.DrawItem(Msg);
				end;
		end;
	TFileNameDlg.DefWndProc(Msg);
end;

{********** TMWCCMsgBoxWindow **********}

constructor TMWCCMsgBoxWindow.Init (AParent: PWindowsObject; ATxt, ACaption: PChar;
																		ATextType: Word; ABmp: PChar);
label
 CaseExit;
var
	a, b, c, d, e, f, X : Integer;
begin
	TMsgBoxWindow.Init(AParent, ATxt, ACaption, ATextType);
	if GetSystemMetrics(sm_CYSize) = 26 then
	begin
		a := 46; b := 33; c := 66; d:= 20; e := 76; f := 0;
		Attr.W := 486 + GetSystemMetrics(sm_CXFrame);
		Attr.H := 248 + GetSystemMetrics(sm_CYCaption) + GetSystemMetrics(sm_CYFrame);
		Stat := New(PMWCCStatic, Init(@Self, idw_Static, ATxt, 88, 32, 364, 100, 255, 0, True));
	end
	else
	begin
		a := 0; b := 0; c := 0; d:= 0; e := 0; f := -24;
		Attr.W := 388 + GetSystemMetrics(sm_CXFrame);
		Attr.H := 224 + GetSystemMetrics(sm_CYCaption) + GetSystemMetrics(sm_CYFrame);
		Stat := New(PMWCCStatic, Init(@Self, idw_Static, ATxt, 84, 32, 272, 81, 255, 0, True));
	end;
	Attr.Style := ws_Popup or ws_Visible or ws_Caption or ws_SysMenu;
	Attr.ExStyle := ws_Ex_DlgModalFrame;
	if AtextType >= 8192 then
	begin
		ATextType := ATextType - 8192;
	end
	else
	if (ATextType >= 512) and (ATextType < 4096) then
	begin
		Def3 := True;
		ATextType := ATextType - 512;
	end
	else
	if (ATextType >= 256) and (ATextType < 512) then
	begin
		Def2 := True;
		ATextType := ATextType - 256;
	end
	else
		Def1 := True;
	case ATextType of
		0, 64, 48, 16, 32:
		begin
			But1 := New(PMsgBoxButton, Init(@Self, id_Ok, 154+a, 170+f, Def1, 1, ctl_Flush));
			LoadBmp(ATextType);
			PBut := But1;
			goto CaseExit;
		end;
		1, 65, 49, 17, 33:
		begin
			But1 := New(PMsgBoxButton, Init(@Self, id_Ok, 78+b, 170+f, Def1, 1, ctl_Flush));
			But2 := New(PMsgBoxButton, Init(@Self, id_Cancel, 232+c, 170+f, Def2, 2, ctl_Flush));
			LoadBmp(ATextType - 1);
			if Def1 = True then
				PBut := But1
			else
				PBut := But2;
			goto CaseExit;
		end;
		5, 69, 53, 21, 37:
		begin
			But4 := New(PMsgBoxButton, Init(@Self, id_Retry, 78+b, 170+f, Def1, 4, ctl_Flush));
			But2 := New(PMsgBoxButton, Init(@Self, id_Cancel, 232+c, 170+f, Def2, 2, ctl_Flush));
			if Def1 = True then
				PBut := But4
			else
				PBut := But2;
			LoadBmp(ATextType - 5);
			goto CaseExit;
		end;
		4, 68, 52, 20, 36:
		begin
			But6 := New(PMsgBoxButton, Init(@Self, id_Yes, 78+b, 170+f, Def1, 6, ctl_Flush));
			But7 := New(PMsgBoxButton, Init(@Self, id_No, 232+c, 170+f, Def2, 7, ctl_Flush));
			if Def1 = True then
				PBut := But6
			else
				PBut := But7;
			LoadBmp(ATextType - 4);
			goto CaseExit;
		end;
		3, 67, 51, 19, 35:
		begin
			But6 := New(PMsgBoxButton, Init(@Self, id_Yes, 40+d, 170+f, Def1, 6, ctl_Flush));
			But7 := New(PMsgBoxButton, Init(@Self, id_No, 157+a, 170+f, Def2, 7, ctl_Flush));
			But2 := New(PMsgBoxButton, Init(@Self, id_Cancel, 272+e, 170+f, Def3, 2, ctl_Flush));
			if Def1 = True then
				PBut := But6
			else
			if Def2 = True then
				PBut := But7
			else
				PBut := But2;
			LoadBmp(ATextType - 3);
			goto CaseExit;
		end;
		2, 66, 50, 18, 34:
		begin
			But3 := New(PMsgBoxButton, Init(@Self, id_Abort, 40+d, 170+f, Def1, 3, ctl_Flush));
			But4 := New(PMsgBoxButton, Init(@Self, id_Retry, 157+a, 170+f, Def2, 4, ctl_Flush));
			But5 := New(PMsgBoxButton, Init(@Self, id_Ignore, 272+e, 170+f, Def3, 5, ctl_Flush));
			if Def1 = True then
				PBut := But3
			else
			if Def2 = True then
				PBut := But4
			else
				PBut := But5;
			LoadBmp(ATextType - 2);
			goto CaseExit;
		end;
	end;
	CaseExit:
  BkBmp := 0;
	BkBmp := LoadBitmap(HLib, ABmp);
	if BkBmp <> 0 then BkBrush := CreatePatternBrush(BkBmp);
	HBut := New(PButton, Init(@Self, id_Ok, '', 0, 0, 0, 0, False));
	HBut^.Attr.Style := HBut^.Attr.Style and not ws_TabStop;
end;

function TMWCCMsgBoxWindow.CanClose;
begin
	if BkBmp <> 0 then
  begin
		DeleteObject(BkBmp);
		DeleteObject(BkBrush);
  end;
end;

function TMWCCMsgBoxWindow.GetClassName: PChar;
begin
	GetClassName := 'MWCCMsgBoxWindow';
end;

procedure TMWCCMsgBoxWindow.SetUpWindow;
begin
	TMsgBoxWindow.SetUpWindow;
	if BkBmp <> 0 then
		SetClassWord(HWindow, gcw_HbrBackground, BkBrush)
	else
		SetClassWord(HWindow, gcw_HbrBackground, GetStockObject(LtGray_Brush));
end;

procedure TMWCCMsgBoxWindow.Paint(PaintDC: HDC; var PS: TPaintStruct);
var
	OldBrush, NewBrush : HBrush;
	OldObject : THandle;
	MemDC : HDC;
	FRect : TRect;
	g, W, H : Integer;
begin
	GetClientRect (HWindow, CRect);
	with CRect do
	begin
		W :=  Right;
		H :=  Bottom;
	end;
	Draw3DBorder(HWindow, 1, 1, W-2, H-2, ctl_Raised);
	if GetSystemMetrics(sm_CYSize) = 26 then
	begin
		g := 24;
		Draw3DBorder(HWindow, 22, 22, 438, 126, ctl_Recessed);
	end
	else
	begin
		g := 0;
		Draw3DBorder(HWindow, 22, 22, 340, 102, ctl_Recessed);
	end;
	with FRect do
	begin
		Left := 23;
		Top := 23;
		Right := W-23;
		Bottom := 123 + g;
	end;
	FillRect(PaintDC, FRect, GetStockObject(LtGray_Brush));
	if MsgBmp <> 0 then
	begin
		MemDC := CreateCompatibleDC(PaintDC);
		OldObject := SelectObject(MemDC, MsgBmp);
		BitBlt(PaintDC, 30, 32, 48, 64, MemDC, 0, 0, SrcCopy);
		SelectObject(MemDC, OldObject);
		DeleteDC(MemDC);
	end;
end;

{********** TMWCCListBox **********}

constructor TMWCCListBox.Init (AParent: PWindowsObject; AnId: Integer;
															 X, Y, W, H: Integer; IsBold: Boolean);
begin
	TListBox.Init(AParent, AnID, X, Y, W, H);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	Attr.Style := Attr.Style or lbs_DisableNoScroll;
	CreateDefaultFont(LogFont, IsBold);
	HasFont := True;
end;

constructor TMWCCListBox.InitResource (AParent: PWindowsObject; AnId: Integer);
begin
	TListBox.InitResource(AParent, AnID);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	HasFont := False;
end;

destructor TMWCCListBox.Done;
begin
	if HasFont = True then DeleteObject(TheFont);
	FreeLibrary(hLib);
	TListBox.Done;
end;

procedure TMWCCListBox.SetupWindow;
var
	CPt1, CPt2 : TPoint;
begin
	TListBox.SetupWindow;
	if HasFont = true then
	begin
		TheFont := CreateFontIndirect(LogFont);
		SendMessage(HWindow, wm_SetFont, TheFont, 1);
	end;
	GetWindowRect(HWindow, WinRect);
	with WinRect do
	begin
		CPt1.X := Left;
		CPt1.Y := Top;
		CPt2.X := Right;
		CPt2.Y := Bottom;
	end;
	ScreenToClient(Parent^.HWindow, CPt1);
	ScreenToClient(Parent^.HWindow, CPt2);
	SetWindowPos(HWindow, 0, CPt1.X+2, CPt1.Y+2, (CPt2.X-CPt1.X)-4, (CPt2.Y-CPt1.Y)-4, swp_NoZOrder);
	UpdateWindow(Parent^.HWindow);
end;

procedure TMWCCListBox.WMPaint (var Msg: TMessage);
var
	PS   : TPaintstruct;
	W, H : Integer;
	lStyle : LongInt;
begin
	TListBox.WMPaint(Msg);
	lStyle := GetWindowLong(HWindow, gwl_Style);
	GetClientRect (HWindow, CRect);
	W := CRect.Right + GetSystemMetrics(sm_CXVScroll) - 1;
	if (lStyle = lStyle or ws_HScroll) then
		H := CRect.Bottom + GetSystemMetrics(sm_CYHScroll) - 1
	else
		H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, -1, -1, W+2, H+2, ctl_Recessed);
	EndPaint(HWindow, PS);
end;

{********** TMWCCComboBox **********}

constructor TMWCCComboBox.Init (AParent: PWindowsObject; AnId: Integer; X, Y, W, H: Integer;
																AStyle, ATextLen: Word; IsBold: Boolean);
begin
	TComboBox.Init(AParent, AnID, X, Y, W, H, Astyle, ATextLen);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	CreateDefaultFont(LogFont, IsBold);
	HasFont := True;
end;

constructor TMWCCComboBox.InitResource (AParent: PWindowsObject; AnId: Integer; ATextlen: Word);
begin
	TComboBox.InitResource(AParent, AnID, ATextLen);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	HasFont := False;
end;

destructor TMWCCComboBox.Done;
begin
	if HasFont = True then DeleteObject(TheFont);
	FreeLibrary(hLib);
	TComboBox.Done;
end;

procedure TMWCCComboBox.SetupWindow;
begin
	TComboBox.SetupWindow;
	if HasFont = true then
	begin
		TheFont := CreateFontIndirect(LogFont);
		SendMessage(HWindow, wm_SetFont, TheFont, 1);
	end;
end;

procedure TMWCCComboBox.WMPaint (var Msg: TMessage);
var
	PS       : TPaintstruct;
	PaintDC  : HDC;
	OldBrush : HBrush;
	W, H     : Integer;
	FRect    : TRect;
	lStyle   : LongInt;
begin
	TComboBox.WMPaint(Msg);
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	lStyle := GetWindowLong (HWindow, gwl_Style);
	BeginPaint(HWindow, PS);
	if lStyle = lStyle or cbs_DropDownList then
		Draw3DBorder(HWindow, 0, 0, W, H, ctl_Recessed)
	else
	if lStyle = lStyle or cbs_DropDown then
	begin
		if GetSystemMetrics(sm_CYSize) = 26 then
		begin
			Draw3DBorder(HWindow, 0, 0, W-30, H, ctl_Recessed);
			Draw3DBorder(HWindow, W-21, 0, 21, H, ctl_Recessed);
			FRect.Left := W-28;
			FRect.Top  := 0;
			FRect.Right := W-23;
			FRect.Bottom := H;
		end
		else
		begin
			Draw3DBorder(HWindow, 0, 0, W-26, H, ctl_Recessed);
			Draw3DBorder(HWindow, W-17, 0, 17, H, ctl_Recessed);
			FRect.Left := W-24;
			FRect.Top  := 0;
			FRect.Right := W-19;
			FRect.Bottom := H;
		end;
		PaintDC := GetDC(HWindow);
		FillRect(PaintDC, FRect, GetStockObject(LtGray_Brush));
		ReleaseDC(HWindow, PaintDC);
	end;
	EndPaint(HWindow, PS);
end;

{********** TMWCCEdit **********}

constructor TMWCCEdit.Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar; X, Y, W, H,
														ATextLen: Integer; Multiline, IsBold: Boolean);
begin
	TEdit.Init(AParent, AnID, ATitle, X, Y, W, H, ATextlen, Multiline);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	CreateDefaultFont(LogFont, IsBold);
	HasFont := True;
end;

constructor TMWCCEdit.InitResource (AParent: PWindowsObject; AnId: Integer; ATextLen: Word);
begin
	TEdit.InitResource(AParent, AnID, ATextLen);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	HasFont := False;
end;

destructor TMWCCEdit.Done;
begin
	if HasFont = true then DeleteObject(TheFont);
	FreeLibrary(hLib);
	TEdit.Done;
end;

procedure TMWCCEdit.SetupWindow;
begin
	TEdit.SetupWindow;
	if HasFont = true then
	begin
		TheFont := CreateFontIndirect(LogFont);
		SendMessage(HWindow, wm_SetFont, TheFont, 1);
	end;
end;

procedure TMWCCEdit.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	W, H : Integer;
	lStyle : LongInt;
begin
	TEdit.WMPaint(Msg);
	lStyle := GetWindowLong (HWindow, gwl_Style);
	GetClientRect(HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	if lStyle = lStyle or es_MultiLine then
	begin
		if lStyle = lStyle or ws_VScroll then
			W := W + GetSystemMetrics(sm_CXVScroll);
		if lStyle = lStyle or ws_VScroll then
			H := H + GetSystemMetrics(sm_CYHScroll);
	end;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, 0, 0, W, H, ctl_Recessed);
	EndPaint(HWindow, PS);
end;

{********** TMWCCCheckBox **********}

constructor TMWCCCheckBox.Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
																X, Y, W, H: Integer; AGroup: PGroupBox; IsBold: Boolean);
begin
	TCheckBox.Init(AParent, AnID, ATitle, X, Y, W, H, AGroup);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	CreateDefaultFont(LogFont, IsBold);
	HasFont := True;
end;

constructor TMWCCCheckBox.InitResource (AParent: PWindowsObject; AnId: Integer);
begin
	TCheckBox.InitResource(AParent, AnID);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	HasFont := False;
end;

destructor TMWCCCheckBox.Done;
begin
	if HasFont = true then DeleteObject(TheFont);
	FreeLibrary(hLib);
	TCheckBox.Done;
end;

procedure TMWCCCheckBox.SetupWindow;
var
	W, H    : Integer;
begin
	TCheckBox.SetupWindow;
	if HasFont = true then
	begin
		TheFont := CreateFontIndirect(LogFont);
		SendMessage(HWindow, wm_SetFont, TheFont, 1);
	end;
	GetClientRect(HWindow, CRect);
	W := CRect.Right - CRect.Left;
	H := CRect.Bottom - CRect.Top;
	if Odd(H) = True then
	begin
		SetWindowPos(HWindow, 0, 0, 0, W, H + 1, swp_NoMove or swp_NoZOrder);
	end;
end;

procedure TMWCCCheckBox.WMPaint (var Msg: TMessage);
var
	PS : TPaintStruct;
	Y  : Integer;
begin
	TCheckBox.WMPaint(Msg);
	GetClientRect (hWindow, CRect);
	Y := (CRect.Bottom - CRect.Top - 15) div 2 + 1;
	BeginPaint(HWindow, PS);
	if GetSystemMetrics(sm_CYSize) = 26 then
		Draw3DBorder(HWindow, 0, Y-1, 16, 16, ctl_Recessed)
	else
		Draw3DBorder(HWindow, 0, Y, 13, 13, ctl_Recessed);
	EndPaint(HWindow, PS);
end;

procedure TMWCCCheckBox.WMEnable (var Msg: TMessage);
begin
	WMPaint(Msg);
	Msg.Result := 0;
end;

procedure TMWCCCheckBox.BMSetCheck (var Msg: TMessage);
begin
	WMPaint(Msg);
end;

procedure TMWCCCheckBox.BMSetState (var Msg: TMessage);
begin
	WMPaint(Msg);
end;

{********** TMWCCRadioButton **********}

constructor TMWCCRadioButton.Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
																	 X, Y, W, H: Integer; AGroup: PGroupBox; IsBold: Boolean);
begin
	TRadioButton.Init(AParent, AnID, ATitle, X, Y, W, H, AGroup);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	CreateDefaultFont(LogFont, IsBold);
	HasFont := True;
end;

constructor TMWCCRadioButton.InitResource (AParent: PWindowsObject; AnId: Integer);
begin
	TRadioButton.InitResource(AParent, AnID);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	HasFont := False;
end;

destructor TMWCCRadioButton.Done;
begin
	if HasFont = true then DeleteObject(TheFont);
	FreeLibrary(hLib);
	TRadioButton.Done;
end;

procedure TMWCCRadioButton.SetupWindow;
var
	W, H    : Integer;
begin
	TRadioButton.SetupWindow;
	if HasFont = true then
	begin
		TheFont := CreateFontIndirect(LogFont);
		SendMessage(HWindow, wm_SetFont, TheFont, 1);
	end;
	GetClientRect(HWindow, CRect);
	W := CRect.Right - CRect.Left;
	H := CRect.Bottom - CRect.Top;
	if Odd(H) = True then
	begin
		SetWindowPos(HWindow, 0, 0, 0, W, H + 1, swp_NoMove or swp_NoZOrder);
	end;
end;

procedure TMWCCRadioButton.WMPaint (var Msg: TMessage);
var
	PS : TPaintStruct;
	Y  : Integer;
begin
	TRadioButton.WMPaint(Msg);
	GetClientRect(HWindow, CRect);
	Y := (CRect.Bottom - CRect.Top - 15) div 2 + 1;
	BeginPaint(HWindow, PS);
	if GetSystemMetrics(sm_CYSize) = 26 then
		DrawRadioButton(HWindow, -3, Y-4, ctl_HiRes)
	else
		DrawRadioButton(HWindow, -3, Y-3, ctl_LoRes);
	EndPaint(HWindow, PS);
end;

procedure TMWCCRadioButton.WMEnable (var Msg: TMessage);
begin
	WMPaint(Msg);
	Msg.Result := 0;
end;

procedure TMWCCRadioButton.BMSetCheck (var Msg: TMessage);
begin
	WMPaint(Msg);
	TRadioButton.DefWndProc(Msg);
end;

procedure TMWCCRadioButton.BMSetState (var Msg: TMessage);
begin
	WMPaint(Msg);
	TRadioButton.DefWndProc(Msg);
end;

{********** TMWCCScrollBar **********}

constructor TMWCCScrollBar.Init (AParent: PWindowsObject; AnId: Integer; X, Y, W, H: Integer;
																 IsHScrollBar: Boolean);
begin
	TScrollBar.Init(AParent, AnId, X, Y, W, H, IsHScrollBar);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
end;

constructor TMWCCScrollBar.InitResource (AParent: PWindowsObject; AnId: Integer);
begin
	TScrollBar.InitResource(AParent, AnID);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
end;

destructor TMWCCScrollBar.Done;
begin
	FreeLibrary(hLib);
	TScrollBar.Done;
end;

procedure TMWCCScrollBar.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	W, H : Integer;
begin
	TScrollBar.WMPaint(Msg);
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, 0, 0, W, H, ctl_Recessed);
	EndPaint(HWindow, PS);
end;

{********** TMWCCGroupBox **********}

constructor TMWCCGroupBox.Init (AParent: PWindowsObject; AnId: Integer; AText: PChar;
									X, Y, W, H: Integer; IsBold: Boolean);
begin
	TGroupBox.Init(AParent, AnID, AText, X, Y, W, H);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	GroupStatic :=	New(PMWCCStatic, Init(@Self, idw_Static, AText, 0, 0, 0, 0, 50, ctl_Static, IsBold));
	BkStatic :=	New(PMWCCStatic, Init(@Self, idw_BkStatic, '', 0, 0, 0, 0, 0, ctl_Static, False));
	FromResource := False;
end;

constructor TMWCCGroupBox.InitResource (AParent: PWindowsObject; AnId: Integer; AText: PChar);
begin
	TGroupBox.InitResource(AParent, AnID);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	GroupStatic :=	New(PMWCCStatic, Init(@Self, idw_Static, AText, 0, 0, 0, 0, 50, ctl_Static, True));
	BkStatic :=	New(PMWCCStatic, Init(@Self, idw_BkStatic, '', 0, 0, 0, 0, 0, ctl_Static, False));
	FromResource := True;
end;

destructor TMWCCGroupBox.Done;
begin
	FreeLibrary(hLib);
	TGroupBox.Done;
end;

procedure TMWCCGroupBox.SetupWindow;
var
	W, H:Integer;
	lstyle : longInt;
begin
	TGroupBox.SetupWindow;
	SetCaption(nil);
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	if FromResource then
	begin
		SetWindowPos(GroupStatic^.HWindow, 0, 3, 9, W-6, 21, swp_NoZOrder);
		SetWindowPos(BkStatic^.HWindow, 0, 3, 30, W-6, H-33, swp_NoZOrder);
	end
	else
	begin
		SetWindowPos(GroupStatic^.HWindow, 0, 3, 11, W-6, 21, swp_NoZOrder);
		SetWindowPos(BkStatic^.HWindow, 0, 3, 33, W-6, H-33, swp_NoZOrder);
	end;
end;

procedure TMWCCGroupBox.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end
		else
			TGroupBox.DefWndProc(Msg);
	end;
end;

procedure TMWCCGroupBox.WMPaint (var Msg: TMessage);
var
	PS      : TPaintStruct;
	W, H    : Integer;
begin
	TGroupBox.WMPaint(Msg);
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	if FromResource then
		Draw3DBorder(HWindow, 2, 8, W-4, H-10, ctl_Recessed)
	else
		Draw3DBorder(HWindow, 2, 10, W-4, H-10, ctl_Recessed);
	EndPaint(HWindow, PS);
end;

procedure TMWCCGroupBox.WMSize (var Msg: TMessage);
var
	W, H    : Integer;
begin
	TGroupBox.WMSize(Msg);
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	if FromResource then
	begin
		SetWindowPos(GroupStatic^.HWindow, 0, 3, 9, W-6, 21, swp_NoZOrder);
		SetWindowPos(BkStatic^.HWindow, 0, 3, 30, W-6, H-33, swp_NoZOrder);
	end
	else
	begin
		SetWindowPos(GroupStatic^.HWindow, 0, 3, 11, W-6, 21, swp_NoZOrder);
		SetWindowPos(BkStatic^.HWindow, 0, 3, 32, W-6, H-33, swp_NoZOrder);
	end;
end;

procedure TMWCCGroupBox.WMEnable (var Msg: TMessage);
begin
	if Msg.wParam <> 0 then
		EnableWindow(GroupStatic^.HWindow, True)
	else
		EnableWindow(GroupStatic^.HWindow, False);
	WMPaint(Msg);
	Msg.Result := 0;
end;

{********** TMWCCStatic **********}

constructor TMWCCStatic.Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
															X, Y, W, H: Integer; ATextLen, AShade: Word; IsBold: Boolean);
begin
	TStatic.Init(AParent, AnID, ATitle, X, Y, W, H, ATextlen);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	StaticShade := AShade;
	CreateDefaultFont(LogFont, IsBold);
	HasFont := True;
end;

constructor TMWCCStatic.InitResource (AParent: PWindowsObject; AnId: Integer;
																			ATextLen, AShade: Word);
begin
	TStatic.InitResource(AParent, AnID, ATextLen);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	StaticShade := AShade;
	HasFont := False;
end;

destructor TMWCCStatic.Done;
begin
	if HasFont = true then DeleteObject(TheFont);
	FreeLibrary(hLib);
	TStatic.Done;
end;

procedure TMWCCStatic.SetupWindow;
var
	lStyle : LongInt;
begin
	TStatic.SetupWindow;
	lStyle := GetWindowLong (hWindow, gwl_Style);
	lStyle := lStyle or ss_Left;
	if (StaticShade = ctl_Recessed) or (StaticShade = ctl_Raised) then
	begin
		lStyle := lStyle or ss_BlackFrame;
		lStyle := lStyle and not ws_Border;
	end;
	lStyle := lStyle and not ss_BlackRect;
	SetWindowLong (HWindow, gwl_Style, lStyle);
	if HasFont = true then
	begin
		TheFont := CreateFontIndirect(LogFont);
		SendMessage(HWindow, wm_SetFont, TheFont, 1);
	end;
end;

procedure TMWCCStatic.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	X, Y, W, H : Integer;
begin
	TStatic.WMPaint(Msg);
	if (StaticShade = ctl_Recessed) or (StaticShade = ctl_Raised) then
	begin
		GetClientRect (HWindow, CRect);
		with CRect do
		begin
			X := Left;
			Y := Top;
			W := Right;
			H := Bottom;
		end;
		BeginPaint(HWindow, PS);
		Draw3DBorder(HWindow, X+2, Y+2, W-4, H-4, StaticShade);
		EndPaint(HWindow, PS);
	end;
end;

{********** TMWCCButton **********}

Constructor TMWCCButton.Init (AParent: PWindowsObject; AnID: Integer; AText: PChar; X, Y, W, H:
															Integer; ABmp: PChar; AStyle: Word);
begin
	TButton.Init(Aparent, AnId, nil, X, Y, W, H, False);
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	Attr.Style := Attr.Style or bs_OwnerDraw;
	StrCopy(szTitle, AText);
	Style := AStyle;
	if szTitle[0] <> #0 then
	begin
		CreateDefaultFont(LogFont, False);
		HasFont := True;
	end
	else
	begin
		Bmp := LoadBitmap(HInstance, ABmp);
		HasFont := False;
	end;
end;

destructor TMWCCButton.Done;
begin
	if Bmp <> 0 then DeleteObject(Bmp);
	if HasFont = true then DeleteObject(TheFont);
	FreeLibrary(hLib);
	TButton.Done;
end;

procedure TMWCCButton.SetupWindow;
begin
	TButton.SetupWindow;
	if HasFont = true then
	begin
		TheFont := CreateFontIndirect(LogFont);
		SendMessage(HWindow, wm_SetFont, TheFont, 1);
	end;
end;

procedure TMWCCButton.DrawItem (var Msg: TMessage);
begin
	DrawButton (HWindow, szTitle, Bmp, Style, Msg);
end;

{**********TMWCCBmpButton**********}

constructor TMWCCBmpButton.Init(AParent: PWindowsObject; AnID, X, Y: Integer;
														 IsDefault: Boolean; iBmp: Integer; AStyle: Word);
begin
	iUpBmp := 1000 + iBmp;
	iDownBmp := 3000 + iBmp;
	iFocusBmp := 5000 + iBmp;
	Style := AStyle;
	SetErrorMode(SEM_NoOpenFileErrorBox);
	hLib := LoadLibrary ('MWCC.dll');
	if hLib < 32 then
	begin
		MessageBox(0, 'Cannot find MWCC.DLL in your Windows System subdirectory.',
									'Application Error', mb_Ok or mb_IconStop);
		TerminateApp(0, No_UAE_Box);
	end;
	SetErrorMode(0);
	if iBmp < 99 then
		ResHdl := hLib
	else
		ResHdl := HInstance;
	UpBmp := LoadBitmap(ResHdl, PChar(iUpBmp));
	GetObject(UpBmp, sizeof(BM), @BM);
	TButton.Init(AParent, AnId, nil, X, Y, BM.bmWidth,BM.bmHeight,IsDefault);
	Attr.Style := Attr.Style or bs_OwnerDraw or ws_TabStop;
	DownBmp := LoadBitmap(ResHdl, PChar(iDownBmp));
	FocusBmp := LoadBitmap(ResHdl, PChar(iFocusBmp));
	Default := IsDefault;
end;

destructor TMWCCBmpButton.Done;
begin
	DeleteObject(UpBmp);
	DeleteObject(DownBmp);
	if FocusBmp <> 0 then
		DeleteObject(FocusBmp);
	FreeLibrary(hLib);
	TButton.Done;
end;

procedure TMWCCBmpButton.DrawItem(var Msg: TMessage);
begin
	DrawBmpButton (HWindow, UpBmp, DownBmp, FocusBmp, Style, Msg);
end;

procedure TMWCCBmpButton.WMSetFocus(var Msg : TMessage);
begin
	InvalidateRect(HWindow, nil, True);
	UpdateWindow(HWindow);
	TButton.DefWndProc(Msg);
end;

{********** TMsgBoxButton **********}

procedure TMsgBoxButton.WMKeyDown(var Msg : TMessage);
var
	ID, Key: Word;
	SibWnd : HWnd;
	lStyle : LongInt;
begin
	SibWnd := 0;
	Key := Msg.WParam;
	ID := GetDlgCtrlID(HWindow);
	lStyle := GetWindowLong (hWindow, gwl_Style);
	while SibWnd = 0 do
	begin
		if ID = 7 then
			ID := 1
		else
			ID := ID + 1;
		if lStyle = lStyle or ws_TabStop then
			SibWnd := GetDlgItem(Parent^.HWindow, ID);
	end;
	case key of
		vk_Tab:
		begin
			SetFocus(SibWnd);
			TMWCCBmpButton.DefWndProc(Msg);
		end;
	end;
end;

end.