(*****************************************************************************)
(*                                                                           *)
(*        filename        : XVERSION.PAS                                     *)
(*        author          : Stefan Boether / Compuserve Id : 100023,275      *)
(*                                                 FidoNet : 2:243/91.331    *)
(*                                  Internet: 100023.275@CompuServe.COM      *)
(*        system          : BP 7.0                                           *)
(*        changes         :                                                  *)
(*        when    what                                                who    *)
(*---------------------------------------------------------------------------*)
(*****************************************************************************)
(*  Description : A object for version control !                             *)
(*****************************************************************************)
{Header-End}

UNIT  xVersion;

INTERFACE

USES  Objects, Dos;

TYPE  PVersion = ^TVersion;
      TVersion = object ( TObject )
         Name      : PString;
         LongName  : PString;
         Author    : PString;
         Company   : PString;
         Vers      : word;
         FirstDate : Longint;
         LastDate  : Longint;
         constructor Init( aName,aLongName,aAuthor,aCompany:String;
                           aVers:Word; aFirstDate,aLastDate:Longint );
         destructor  Done; virtual;
         constructor Load ( var S:TStream );
         procedure   Store( var S:TStream );
         function    GetName     : String; virtual;
         function    GetLongName : String; virtual;
         function    GetAuthor   : String; virtual;
         function    GetCompany  : String; virtual;
         function    GetVersion  : String; virtual;
         function    GetCopyRight: String; virtual;
         function    GetDate     : String; virtual;
      end;

CONST RVersion: TStreamRec = (
        ObjType : 20070;
        VmtLink : Ofs(TypeOf(TVersion)^);
        Load    : @TVersion.Load;
        Store   : @TVersion.Store);

CONST Version   : PVersion = NIL;

PROCEDURE RegisterXVersion;

IMPLEMENTATION

constructor TVersion.Init( aName,aLongName,aAuthor,aCompany:String;
                           aVers:Word; aFirstDate,aLastDate:Longint );
begin
  inherited Init;
  Name      := NewStr( aName     );
  LongName  := NewStr( aLongName );
  Author    := NewStr( aAuthor   );
  Company   := NewStr( aCompany  );
  Vers      := aVers;
  FirstDate := aFirstDate;
  LastDate  := aLastDate;
end;

destructor TVersion.Done;
begin
  DisposeStr( Name );
  DisposeStr( LongName );
  DisposeStr( Author );
  DisposeStr( Company );
  inherited Done;
end;

constructor TVersion.Load( var S:TStream );
begin
  Name     := S.ReadStr;
  LongName := S.ReadStr;
  Author   := S.ReadStr;
  Company  := S.ReadStr;
  S.Read(Vers,Sizeof(Vers));
  S.Read(FirstDate,Sizeof(FirstDate));
  S.Read(LastDate,Sizeof(LastDate));
end;

procedure TVersion.Store( var S:TStream );
begin
  S.WriteStr( Name );
  S.WriteStr( LongName );
  S.WriteStr( Author );
  S.WriteStr( Company );
  S.Write( Vers,      Sizeof(Vers));
  S.Write( FirstDate, Sizeof(FirstDate ));
  S.Write( LastDate,  Sizeof(LastDate ));
end;

function TVersion.GetName:String;
begin
  GetName := Name^;
end;

function TVersion.GetLongName:String;
begin
  GetLongName := LongName^;
end;

function TVersion.GetAuthor:String;
begin
  GetAuthor := Author^;
end;

function TVersion.GetCompany:String;
begin
  if Company^ = '' then
     GetCompany := GetAuthor
  else
     GetCompany := Company^;
end;

function TVersion.GetVersion:String;
  var s1,s2 : string[3];
begin
  Str(Lo(Vers),s1);
  Str(Hi(Vers),s2);
  GetVersion := 'Version '+s2+'.'+s1;
end;

function TVersion.GetCopyRight:String;
  var cYears : string[7];
      cTo    : string[2];
      FromYear,
      ToYear : Word;
      Tmp    : DateTime;
begin
  UnpackTime(FirstDate,Tmp);
  FromYear := Tmp.Year;
  UnpackTime(LastDate,Tmp);
  ToYear := Tmp.Year;
  Str(FromYear,cYears);
  if ToYear > FromYear then begin
     Str(ToYear-1900,cTo);
     cYears := cYears + ',' + cTo;
  end;
  GetCopyRight := 'Copyright (c) '+ cYears + ' by ' + GetAuthor;
end;

function TVersion.GetDate:String;
  var Tmp    : DateTime;
      s      : string[4];
      Result : string[15];
begin
  UnpackTime(LastDate,Tmp);
  Str(Tmp.Month,Result);
  Str(Tmp.Day,s);
  Result := Result + '/' + s;
  Str(Tmp.Year,s);
  GetDate := Result + '/' + s;
end;

procedure RegisterXVersion;
begin RegisterType(RVersion); end;

END.

