/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <stdlib.h>
#include <string.h>
#include <dos.h>

#ifdef _MSC_VER
extern char __far *_pgmptr
#else
extern char **_argv;
#endif


/***
 *  Function    :  getpgmpath
 *
 *  Description :  Transforms a filename into a full pathname
 *                 relative to program directory.
 *
 *  Parameters  :  in/out   char *filename    input filename
 *
 *  Return      :  pointer to filename    
 *
 *  Precond     :  Global variable extern char **_argv must be defined
 *                 and assign to argv in main( int argc, char *argv[] )
 *                 Built-in in Borland
 *                 Built-in in Microsoft (uses _pgmptr)
 *
 *  OS/Compiler :  MS-DOS version >= 3.0
 ***/

char *getpgmpath( char *filename )

{ char buffer[_MAX_PATH], *ptr;

  strcpy( buffer, filename );
#ifdef _MSC_VER
  strcpy( filename, _pgmptr );
#else
  strcpy( filename, _argv[0] );
#endif
  ptr = strrchr(filename, '\\');

  if ( ! ptr ) { strcpy( filename, buffer );
                 return filename;
               }

  strcpy( ptr + 1, buffer );
  strupr( filename );

  return filename;
}
