DECLARE SUB RightFlush (Text$, row%)
DECLARE SUB ErrorMessage (Text$)
DECLARE SUB BlackSquare ()
DECLARE SUB HelpMenu ()
DECLARE SUB SortMessage ()
DECLARE SUB Menu (Box() AS ANY, DOSName AS ANY, ScreenINFO AS ANY)
DECLARE SUB HelpEditOld ()
DECLARE SUB HelpPrint ()
DECLARE SUB Decode (File$, PrintLabels%)
DECLARE SUB EnterLabelData (Box() AS ANY, DOSName AS ANY, File$)
DECLARE SUB HelpInfo ()
DECLARE SUB GetColor (Box() AS ANY, cell%, element%)
DECLARE SUB GetNewColor (Box() AS ANY, cell%, element%)
DECLARE SUB NEWCursor (cell%, element%, Box() AS ANY)
DECLARE SUB OLDCursor (cell%, element%, Box() AS ANY)
DECLARE SUB HighLight ()
DECLARE SUB NormalVideo ()
DECLARE SUB Center (Text$, row%)

DEFINT A-Z

ON ERROR GOTO ErrorHandler:

TYPE ScreenType
     row AS INTEGER
     col AS INTEGER
END TYPE

DIM ScreenINFO AS ScreenType

ScreenINFO.row = CSRLIN
ScreenINFO.col = POS(0)

'$INCLUDE: 'colors.bi'
'$INCLUDE: 'const.bi'
'$INCLUDE: 'errors.bi'

TYPE Boxes
        Char AS STRING * 1
        NewData AS INTEGER
END TYPE

DIM Box(4, 60) AS Boxes

TYPE NameType
     FileName AS STRING * 8
     Extension AS STRING * 3
     ReStart AS INTEGER
     ErrorFile AS STRING * 12
END TYPE

DIM DOSName AS NameType

ReStartMenu:

DOSName.ReStart = True
CALL Menu(Box(), DOSName, ScreenINFO)

IF DOSName.ReStart = True THEN GOTO ReStartMenu:

SCREEN 0, , 0, 0: LOCATE ScreenINFO.row, ScreenINFO.col

END



ErrorHandler:

     ErrorNumber = ERR
     SELECT CASE ErrorNumber
          CASE DeviceTimeOut
               Text$ = "PRINTER: NOT ONLINE"
               ErrorMessage Text$
          CASE DeviceFault
               Text$ = "PRINTER: DEVICE FAULT"
               ErrorMessage Text$
          CASE OutOfPaper
               Text$ = "PRINTER: OUT OF PAPER(LABELS)"
               ErrorMessage Text$
          CASE BadFileName
               Text$ = "BAD FILE NAME: " + DOSName.ErrorFile
               ErrorMessage Text$
          CASE DiskFull
               Text$ = "DISK FULL - NO SPACE TO STORE DATA"
               ErrorMessage Text$
          CASE DiskNotReady
               Text$ = "DISK NOT READY"
               ErrorMessage Text$
          CASE DiskMediaError
               Text$ = "DISK MEDIA ERROR"
               ErrorMessage Text$
          CASE ELSE
               Text$ = "QuickBASIC Error Number " + STR$(ErrorNumber) + " occurred"
               ErrorMessage Text$
     END SELECT

     RESUME ReStartMenu:


SUB BlackSquare

COLOR WHITE, BLACK
PRINT "  ";
COLOR RED, WHITE

END SUB

SUB Center (Text$, row)

col = 40 - (LEN(Text$) \ 2): LOCATE row, col: PRINT Text$;

END SUB

SUB Decode (File$, PrintLabels)

row = 2: TC$ = ""
FOR col = 1 TO 14
     TC$ = TC$ + CHR$(SCREEN(row, col))
NEXT col
IF TC$ = "File not found" THEN
     TC$ = ""
     File$ = ""
     EXIT SUB
ELSE
      TC$ = ""
END IF

DecodeRestart:

File$ = ".DAT": COLOR BLACK, GREEN

OPEN File$ FOR INPUT AS #1
     FOR I = 1 TO 4
          LINE INPUT #1, a$
     NEXT I
     DO
          LINE INPUT #1, a$
          IF INSTR(a$, "") > 0 THEN
               X = X + 1
          END IF
     LOOP UNTIL EOF(1)
CLOSE #1
REDIM Stuff$(X): REDIM PrintStuff(X): I = 0
FOR I = 1 TO X: PrintStuff(I) = False: NEXT I
OPEN File$ FOR INPUT AS #1
     FOR I = 1 TO 4
          LINE INPUT #1, a$
     NEXT I
     I = 0
     DO
          LINE INPUT #1, a$
          IF INSTR(a$, "") > 0 THEN
               I = I + 1
               DO
                    CH = CH + 1
                    CH$ = MID$(a$, CH, 1)
                    IF CH$ = "" THEN EXIT DO
                    TC$ = TC$ + CH$
               LOOP
               Stuff$(I) = TC$: CH = 0: TC$ = "": CH$ = ""
          END IF
        
     LOOP UNTIL EOF(1)
CLOSE #1

PRINT


'Bubble Sort ================================================================
Limit = I: NumOfFiles$ = "# of File(s):" + STR$(Limit)
COLOR WHITE, RED: VIEW PRINT: CALL RightFlush(NumOfFiles$, 25): VIEW PRINT 2 TO 24: COLOR RED, GREEN

DO
     Switch = False
     FOR J = 1 TO (Limit - 1)
          IF Stuff$(J) > Stuff$(J + 1) THEN
               SWAP Stuff$(J), Stuff$(J + 1)
               Switch = J
          END IF
     NEXT J
     Limit = Switch
LOOP WHILE Switch
'============================================================================

IF I > 22 THEN
     JFirst = I - 22
ELSE
     JFirst = 1
END IF
HOT = I
CLS 2

DecodeHOT:
JLast = JFirst + 22: row = 1
FOR J = JFirst TO JLast
     IF J <= I THEN
          row = row + 1
          IF PrintLabels = True THEN
               IF J = HOT THEN
                    COLOR MAGENTA + BRIGHT + BLINK, GREEN
                    LOCATE row, 33: PRINT "";
                    LOCATE row, 47: PRINT "";
                    HOTrow = row
                    IF PrintStuff(J) = True THEN
                         COLOR BROWN + BRIGHT, MAGENTA
                    ELSE
                         COLOR BROWN + BRIGHT, GREEN
                    END IF
               ELSE
                    COLOR GREEN, GREEN
                    LOCATE row, 33: PRINT " ";
                    LOCATE row, 47: PRINT " ";
                    IF PrintStuff(J) = False THEN
                         COLOR BROWN, GREEN
                    ELSE
                         COLOR MAGENTA + BRIGHT, MAGENTA
                    END IF
               END IF
               Center Stuff$(J), row
          ELSE
               IF J = HOT THEN
                    COLOR BROWN + BRIGHT, MAGENTA
               ELSE
                    COLOR BROWN, GREEN
               END IF
               Center Stuff$(J), row
          END IF
     END IF
NEXT J

DecodeLOOP:
DO
     Choice$ = INKEY$
LOOP WHILE Choice$ = ""
IF LEN(Choice$) = 1 THEN
     SELECT CASE ASC(UCASE$(Choice$))
          CASE ENTER
               IF PrintLabels = False THEN
                    File$ = RTRIM$(LEFT$(Stuff$(HOT), 8)) + "." + RIGHT$(Stuff$(HOT), 2) + ""
                    EXIT SUB
               ELSE
                    GOTO DecodeLOOP:
               END IF
          CASE SPACE
               IF PrintLabels = True THEN
                    IF PrintStuff(HOT) = True THEN
                         PrintStuff(HOT) = False
                         GOTO DecodeHOT:
                    ELSE
                         PrintStuff(HOT) = True
                         GOTO DecodeHOT:
                    END IF
               ELSE
                    GOTO DecodeLOOP:
               END IF
          CASE S
               IF PrintLabels = True THEN
                    FOR LAB = 1 TO I
                         PrintStuff(LAB) = True
                    NEXT LAB
                    GOTO DecodeHOT:
               ELSE
                    GOTO DecodeLOOP:
               END IF
          CASE D
               IF PrintLabels = True THEN
                    FOR LAB = 1 TO I
                         PrintStuff(LAB) = False
                    NEXT LAB
                    GOTO DecodeHOT:
               ELSE
                    GOTO DecodeLOOP:
               END IF
          CASE ESC
               File$ = ""
               EXIT SUB
          CASE ELSE
               GOTO DecodeLOOP:
     END SELECT
ELSEIF LEN(Choice$) = 2 THEN
     SELECT CASE ASC(RIGHT$(Choice$, 1))
          CASE UP
               IF HOT <= I AND HOT > 1 THEN
                    HOT = HOT - 1
                    IF HOT < JFirst THEN
                         JFirst = JFirst - 1
                    END IF
               END IF
               GOTO DecodeHOT:
          CASE PGUP
               IF HOT - 10 > 1 THEN
                    HOT = HOT - 10
                    IF HOT < JFirst THEN
                         JFirst = JFirst - 10
                    END IF
                    GOTO DecodeHOT:
               ELSE
                    GOTO HOMELoc:
               END IF
          CASE DOWN
               IF HOT < I AND HOT >= 1 THEN
                    HOT = HOT + 1
                    IF HOT > JLast THEN
                         JFirst = JFirst + 1
                    END IF
               END IF
               GOTO DecodeHOT:
          CASE PGDOWN
               IF HOT + 10 < I THEN
                    HOT = HOT + 10
                    IF HOT > JLast THEN
                         JFirst = JFirst + 10
                    END IF
                    GOTO DecodeHOT:
               ELSE
                    GOTO ENDKeyLoc:   
               END IF
          CASE HOME
HOMELoc:
               HOT = 1: JFirst = 1
               GOTO DecodeHOT:
          CASE ENDKEY
ENDKeyLoc:                
               HOT = I:
               IF I > 22 THEN
                    JFirst = I - 22
               ELSE
                    JFirst = 1
               END IF
               GOTO DecodeHOT:
          CASE DEL
               IF PrintLabels = False THEN
                    PCOPY 1, 2
                    SCREEN 0, , 2, 1
                    
                    File$ = RTRIM$(LEFT$(Stuff$(HOT), 8)) + "." + RIGHT$(Stuff$(HOT), 2)
                    COLOR RED, WHITE
                    Center "ͻ", 10
                    COLOR BROWN + BRIGHT + BLINK, WHITE: Center " Delete Address File ", 10
                    COLOR RED, WHITE
                    Center "                                                   ", 11: BlackSquare
                    Center "                                                   ", 12: BlackSquare
                    Center "                                                   ", 13: BlackSquare
                    Center "ͼ", 14: BlackSquare
                    COLOR BLACK, WHITE
                    Center "Delete " + CHR$(34) + File$ + CHR$(34) + " ? (Y/N) (ESC)", 12
                    Center " Press ESC to exit ", 14
                   
                    Blinking = False

                    Name$ = "": a$ = ""
                    FOR col = 35 TO 45
                         a$ = CHR$(SCREEN(15, col))
                         Name$ = Name$ + a$
                    NEXT col

                    IF SCREEN(16, 35) = 175 THEN
                         Blinking = True
                    END IF

                    COLOR WHITE, BLACK

                    LOCATE 15, 16
                    PRINT STRING$(53, " ");

                    IF Blinking = True THEN
                         COLOR BLACK + BRIGHT + BLINK, BLACK
                         LOCATE 15, 33: PRINT ""; : LOCATE 15, 47: PRINT "";
                    END IF
                   
                    COLOR BLACK + BRIGHT, BLACK
                    LOCATE 15, 35: PRINT Name$;
                   
                    SCREEN 0, , 2, 2
                    DO: Choice$ = INKEY$: LOOP WHILE Choice$ = ""
                    SCREEN 0, , 1, 1
                   
                    SELECT CASE ASC(UCASE$(Choice$))
                         CASE Y
                              File$ = File$ + ""
                              KILL File$
                             
                              VIEW PRINT 2 TO 24: COLOR RED, GREEN
                              CALL SortMessage
                              SHELL "DIR *.?? > .DAT"
                             
                              row = 2: TC$ = ""
                              FOR col = 1 TO 14
                                   TC$ = TC$ + CHR$(SCREEN(row, col))
                              NEXT col
                              IF TC$ = "File not found" THEN
                                   TC$ = ""
                                   File$ = ""
                                   EXIT SUB
                              ELSE
                                   TC$ = ""
                              END IF

                              GOTO DecodeRestart:
                         CASE ELSE
                              
                              GOTO DecodeHOT:
                    END SELECT
               ELSE
                    GOTO DecodeLOOP:
               END IF
               

          CASE F7
              
               PrintContinue = False
              
               IF PrintLabels = False THEN
                    GOTO DecodeLOOP:
               END IF
              
               FOR P = 1 TO X
                    IF PrintStuff(P) = True THEN
                         PrintContinue = True
                         EXIT FOR
                    END IF
               NEXT P

               IF PrintContinue = False THEN
                    PCOPY 1, 2
                    SCREEN 0, , 2, 1
                    COLOR RED, WHITE
                    Center "ͻ", 11
                    Center "                                                                 ", 12: BlackSquare
                    Center "ͼ", 13: BlackSquare
                    Center " Press a key to exit ", 13
                    COLOR BLACK, WHITE
                    Center "Use SPACEBAR or S to select address(es) / D to DE-SELECT", 12
                    COLOR WHITE, BLACK
                    LOCATE 14, 9
                    PRINT STRING$(67, " ");
                    SCREEN 0, , 2, 2
                    DO: LOOP WHILE INKEY$ = ""
                    SCREEN 0, , 1, 1
                    GOTO DecodeHOT:
               END IF

               PCOPY 1, 2: PCOPY 1, 3: PCOPY 1, 4

               '+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
               SCREEN 0, , 4, 1

               REDIM Selection$(4)
               Selection$(1) = "_"
               Selection$(2) = "_"
               Selection$(3) = "_"
               Selection$(4) = "_"
              
               IF PrintStyle = 0 THEN PrintStyle = 1
               Selection$(PrintStyle) = "X"
              
               COLOR RED, WHITE
               Center "ͻ", 11
               Center "                                                                 ", 12: BlackSquare
               Center "ͼ", 13: BlackSquare
               Center " Select Print Style ", 11
               Center " Press ENTER to continue / ESC to Exit ", 13
               COLOR BLACK, WHITE
               Center "Normal [_]   Shadow [_]   Outline [_]   Outline with Shadow [_]", 12
               COLOR WHITE, BLACK
               LOCATE 14, 9
               PRINT STRING$(67, " ");

               IF Blinking = True THEN
                    COLOR BLACK + BRIGHT + BLINK, BLACK
                    LOCATE 14, 33: PRINT ""; : LOCATE 14, 47: PRINT "";
               END IF

               COLOR BLACK + BRIGHT, BLACK
               LOCATE 14, 35: PRINT Name$;
               COLOR BLACK, WHITE
              
               element = PrintStyle
               SELECT CASE element
                    CASE 1
                         LOCATE 12, 17
                    CASE 2
                         LOCATE 12, 30
                    CASE 3
                         LOCATE 12, 44
                    CASE 4
                         LOCATE 12, 70
               END SELECT
               PRINT Selection$(element);

               SCREEN 0, , 4, 4
PrintTypeLOOP:
               DO: Choice$ = INKEY$: LOOP WHILE Choice$ = ""
               IF LEN(Choice$) = 1 THEN
                    SELECT CASE ASC(Choice$)
                         CASE ESC
                              SCREEN 0, , 1, 1
                              GOTO DecodeHOT:
                         CASE ENTER
                              FOR element = 1 TO 4
                                   IF Selection$(element) = "X" THEN PrintStyle = element
                              NEXT element
                         CASE ELSE
                              COLOR BLACK, WHITE
                              SELECT CASE element
                                   CASE 1
                                        LOCATE 12, 17
                                   CASE 2
                                        LOCATE 12, 30
                                   CASE 3
                                        LOCATE 12, 44
                                   CASE 4
                                        LOCATE 12, 70
                              END SELECT
                              Selection$(element) = "_"
                              PRINT Selection$(element);

                              element = element + 1
                              IF element = 5 THEN element = 1
                              Selection$(element) = "X"
                              SELECT CASE element
                                   CASE 1
                                        LOCATE 12, 17
                                   CASE 2
                                        LOCATE 12, 30
                                   CASE 3
                                        LOCATE 12, 44
                                   CASE 4
                                        LOCATE 12, 70
                              END SELECT
                              PRINT Selection$(element);
                              GOTO PrintTypeLOOP:
                    END SELECT
               ELSEIF LEN(Choice$) = 2 THEN
                    SELECT CASE ASC(RIGHT$(Choice$, 1))
                         CASE RIGHT
                              COLOR BLACK, WHITE
                              Selection$(element) = "_"
                              SELECT CASE element
                                   CASE 1
                                        LOCATE 12, 17
                                   CASE 2
                                        LOCATE 12, 30
                                   CASE 3
                                        LOCATE 12, 44
                                   CASE 4
                                        LOCATE 12, 70
                              END SELECT
                              PRINT Selection$(element);
                             
                              element = element + 1
                              IF element = 5 THEN element = 1
                              SELECT CASE element
                                   CASE 1
                                        LOCATE 12, 17
                                   CASE 2
                                        LOCATE 12, 30
                                   CASE 3
                                        LOCATE 12, 44
                                   CASE 4
                                        LOCATE 12, 70
                              END SELECT
                              Selection$(element) = "X"
                              PRINT Selection$(element);
                              GOTO PrintTypeLOOP:

                         CASE LEFT, ShiftTAB
                              COLOR BLACK, WHITE
                              Selection$(element) = "_"
                              SELECT CASE element
                                   CASE 1
                                        LOCATE 12, 17
                                   CASE 2
                                        LOCATE 12, 30
                                   CASE 3
                                        LOCATE 12, 44
                                   CASE 4
                                        LOCATE 12, 70
                              END SELECT
                              PRINT Selection$(element);

                              element = element - 1
                              IF element = 0 THEN element = 4
                              SELECT CASE element
                                   CASE 1
                                        LOCATE 12, 17
                                   CASE 2
                                        LOCATE 12, 30
                                   CASE 3
                                        LOCATE 12, 44
                                   CASE 4
                                        LOCATE 12, 70
                              END SELECT
                             
                              Selection$(element) = "X"
                              PRINT Selection$(element);
                              GOTO PrintTypeLOOP:
                         CASE ELSE
                              GOTO PrintTypeLOOP:
                    END SELECT
               END IF

               '+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
               SCREEN 0, , 2, 4
             
               REDIM Selection$(4)
               Selection$(1) = "["
               Selection$(2) = "_"
               Selection$(3) = "1"
               Selection$(4) = "]"
               File$ = RTRIM$(LEFT$(Stuff$(HOT), 8)) + "." + RIGHT$(Stuff$(HOT), 2)
               COLOR RED, WHITE
               Center "ͻ", 11
               Center "                                                       ", 12: BlackSquare
               Center "ͼ", 13: BlackSquare
               Center " Press ENTER to continue / ESC to exit ", 13
               COLOR BLACK, WHITE
               Center "Enter the number of times to print selection(s): [_1]", 12
              
               Blinking = False: Name$ = "": a$ = ""

               FOR col = 35 TO 45
                    a$ = CHR$(SCREEN(14, col))
                    Name$ = Name$ + a$
               NEXT col

               IF SCREEN(14, 33) = 175 THEN
                    Blinking = True
               END IF
              
               COLOR WHITE, BLACK

               LOCATE 14, 14
               PRINT STRING$(57, " ");

               IF Blinking = True THEN
                    COLOR BLACK + BRIGHT + BLINK, BLACK
                    LOCATE 14, 33: PRINT ""; : LOCATE 14, 47: PRINT "";
               END IF

               COLOR BLACK + BRIGHT, BLACK
               LOCATE 14, 35: PRINT Name$;
              
               SCREEN 0, , 2, 2
               element = 2
               LOCATE 12, 62 + element: COLOR BROWN + BRIGHT + BLINK, WHITE: PRINT Selection$(element);
SelectionLOOP:             
               DO: Choice$ = INKEY$: LOOP WHILE Choice$ = ""
               IF LEN(Choice$) = 1 THEN
                    SELECT CASE ASC(Choice$)
                         CASE ESC
                              SCREEN 0, , 1, 1
                              GOTO DecodeHOT:
                         CASE BACKSPACE
                              COLOR BLACK
                              LOCATE 12, 62 + element
                              Selection$(element) = "_"
                              PRINT Selection$(element);
                              IF element = 2 THEN
                                   element = 3
                              ELSEIF element = 3 THEN
                                   element = 2
                              END IF
                              COLOR BROWN + BRIGHT + BLINK
                              LOCATE 12, 62 + element
                              PRINT Selection$(element);
                              GOTO SelectionLOOP:
                         CASE 48 TO 57
                              '0 to 9
                              IF element = 2 THEN
                                   COLOR BLACK
                                   LOCATE 12, 62 + element
                                   Selection$(element) = Choice$
                                   PRINT Selection$(element);
                                  
                                   COLOR BROWN + BLINK + BRIGHT
                                   element = 3
                                   LOCATE 12, 62 + element
                                   PRINT Selection$(element);
                                  
                                   GOTO SelectionLOOP:
                              ELSEIF element = 3 THEN
                                   COLOR BLACK
                                   LOCATE 12, 62 + element
                                   Selection$(element) = Choice$
                                   PRINT Selection$(element);
                                 
                                   COLOR BROWN + BLINK + BRIGHT
                                   element = 2
                                   LOCATE 12, 62 + element
                                   PRINT Selection$(element);
                                 
                                   GOTO SelectionLOOP:
                              END IF

                         CASE ENTER
                              num1$ = Selection$(2)
                              num2$ = Selection$(3)
                              IF num2$ = "_" THEN
                                   num2$ = num1$
                                   num1$ = "_"
                              END IF
                              IF num1$ = "_" THEN
                                   num1$ = "0"
                              ELSEIF num2$ = "_" THEN
                                   num2$ = "0"
                              END IF
                              num$ = num1$ + num2$
                              IF VAL(num$) = 0 THEN
                                   GOTO SelectionLOOP:
                              ELSE
                                   Counter = VAL(num$)
                              END IF
                         CASE ELSE
                              GOTO SelectionLOOP:
                    END SELECT
               ELSEIF LEN(Choice$) = 2 THEN
                    SELECT CASE ASC(RIGHT$(Choice$, 1))
                         CASE RIGHT, LEFT
                              COLOR BLACK
                              LOCATE 12, 62 + element
                              PRINT Selection$(element);
                              IF element = 2 THEN
                                   element = 3
                              ELSEIF element = 3 THEN
                                   element = 2
                              END IF
                              COLOR BROWN + BRIGHT + BLINK
                              LOCATE 12, 62 + element
                              PRINT Selection$(element);
                              GOTO SelectionLOOP:
                         CASE DEL
                              LOCATE 12, 62 + element
                              Selection$(element) = "_"
                              PRINT Selection$(element);
                              GOTO SelectionLOOP:
                         CASE ELSE
                              GOTO SelectionLOOP:
                    END SELECT

               END IF
              
               '+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
               SCREEN 0, , 3, 2
              
               'File$ = RTRIM$(LEFT$(Stuff$(HOT), 8)) + "." + RIGHT$(Stuff$(HOT), 2)
               COLOR RED, WHITE
               Center "ͻ", 11
               Center "                                               ", 12: BlackSquare
               Center "ͼ", 13: BlackSquare
               COLOR BLACK, WHITE
               Center "Press a key when ready to print / ESC to exit", 12
              
               Blinking = False: Name$ = "": a$ = ""

               FOR col = 35 TO 45
                    a$ = CHR$(SCREEN(14, col))
                    Name$ = Name$ + a$
               NEXT col

               IF SCREEN(14, 33) = 175 THEN
                    Blinking = True
               END IF
             
               COLOR WHITE, BLACK

               LOCATE 14, 18
               PRINT STRING$(49, " ");

               IF Blinking = True THEN
                    COLOR BLACK + BRIGHT + BLINK, BLACK
                    LOCATE 14, 33: PRINT ""; : LOCATE 14, 47: PRINT "";
               END IF

               COLOR BLACK + BRIGHT, BLACK
               LOCATE 14, 35: PRINT Name$;
              
               SCREEN 0, , 3, 3

               DO: Choice$ = INKEY$: LOOP WHILE Choice$ = ""
               SELECT CASE ASC(Choice$)
                    CASE ESC
                         SCREEN 0, , 1, 1
                         GOTO DecodeHOT:
                    CASE ELSE
                       IF Counter = 0 THEN Counter = 1
                         FOR P = 1 TO X
                              IF PrintStuff(P) = True THEN
                                   SELECT CASE PrintStyle
                                        CASE 1
                                             LPRINT CHR$(ESC); CHR$(113); CHR$(0); : EXIT FOR
                                        CASE 2
                                             LPRINT CHR$(ESC); CHR$(113); CHR$(2); : EXIT FOR
                                        CASE 3
                                             LPRINT CHR$(ESC); CHR$(113); CHR$(1); : EXIT FOR
                                        CASE 4
                                             LPRINT CHR$(ESC); CHR$(113); CHR$(3); : EXIT FOR
                                   END SELECT
                              END IF
                         NEXT P
                       
                    FOR P = 1 TO X
                         FOR T = 1 TO Counter
                              IF INKEY$ = CHR$(ESC) THEN
                                   SCREEN 0, , 1, 1: GOTO DecodeHOT:
                              END IF
                              IF PrintStuff(P) = True THEN
                                   File$ = LEFT$(Stuff$(P), 8) + "." + RIGHT$(Stuff$(P), 2) + ""
                                   OPEN File$ FOR INPUT AS #1
                                       
                                        REDIM Title(4): REDIM Text$(4): cell = 1
                                        DO
                                            
                                             LINE INPUT #1, Text$(cell)
                                             Title(cell) = False
                                             cell = cell + 1

                                        LOOP WHILE NOT EOF(1)
                                   CLOSE #1

                                   FOR cell = 1 TO 4
                                        FOR element = 1 TO 60
                                             IF MID$(Text$(cell), element, 1) = "_" THEN
                                                  MID$(Text$(cell), element, 1) = " "
                                             END IF
                                             SELECT CASE cell
                                                  CASE 1
                                                       SELECT CASE element
                                                            CASE 10
                                                                 IF MID$(Text$(cell), element, 1) = "X" THEN
                                                                      Title(1) = True
                                                                 END IF
                                                            CASE 22
                                                                 IF MID$(Text$(cell), element, 1) = "X" THEN
                                                                      Title(2) = True
                                                                 END IF
                                                            CASE 34
                                                                 IF MID$(Text$(cell), element, 1) = "X" THEN
                                                                      Title(3) = True
                                                                 END IF
                                                            CASE 47
                                                                 IF MID$(Text$(cell), element, 1) = "X" THEN
                                                                      Title(4) = True
                                                                 END IF
                                                       END SELECT
                                                  CASE 2
                                                       SELECT CASE element
                                                            CASE 2 TO 26
                                                                 FirstName$ = FirstName$ + MID$(Text$(cell), element, 1)
                                                            CASE 30
                                                                 MiddleInitial$ = MID$(Text$(cell), element, 1)
                                                            CASE 34 TO 58
                                                                 LastName$ = LastName$ + MID$(Text$(cell), element, 1)
                                                       END SELECT
                                                  CASE 3
                                                       SELECT CASE element
                                                            CASE 2 TO 58
                                                                 street$ = street$ + MID$(Text$(cell), element, 1)
                                                       END SELECT
                                                  CASE 4
                                                       SELECT CASE element
                                                            CASE 2 TO 45
                                                                 City$ = City$ + MID$(Text$(cell), element, 1)
                                                            CASE 49 TO 50
                                                                 State$ = State$ + MID$(Text$(cell), element, 1)
                                                            CASE 54 TO 58
                                                                 Zip$ = Zip$ + MID$(Text$(cell), element, 1)
                                                       END SELECT
                                             END SELECT
                                        NEXT element
                                   NEXT cell
                             
                                   IF Title(1) = True THEN
                                        LPRINT "Ms. ";
                                   ELSEIF Title(2) = True THEN
                                        IF Title(3) = True THEN
                                             LPRINT "Mr. & Mrs. ";
                                        ELSEIF Title(4) = True THEN
                                             LPRINT "Mr. & Dr. ";
                                        ELSE
                                             LPRINT "Mr. ";
                                        END IF
                                   ELSEIF Title(3) = True THEN
                                        IF Title(2) = True THEN
                                             LPRINT "Mr. & Mrs. ";
                                        ELSEIF Title(4) = True THEN
                                             LPRINT "Dr. & Mrs. ";
                                        ELSE
                                             LPRINT "Mrs. ";
                                        END IF
                                   ELSEIF Title(4) = True THEN
                                        IF Title(3) = True THEN
                                             LPRINT "Dr. & Mrs. ";
                                        ELSEIF Title(2) = True THEN
                                             LPRINT "Mr. & Dr. ";
                                        ELSE
                                             LPRINT "Dr. ";
                                        END IF
                                   END IF
                                  
                                   FirstName$ = RTRIM$(LTRIM$(FirstName$))
                                   LastName$ = RTRIM$(LTRIM$(LastName$))
                                   MiddleInitial$ = RTRIM$(MiddleInitial$)
                                   IF MiddleInitial$ = " " OR MiddleInitial$ = "" THEN
                                        Text$ = FirstName$ + " " + LastName$
                                   ELSE
                                        Text$ = FirstName$ + " " + MiddleInitial$ + ". " + LastName$
                                   END IF
                                   LPRINT Text$

                                   street$ = RTRIM$(LTRIM$(street$))
                                  
                                   FOR ST = 1 TO LEN(street$)
                                        IF MID$(street$, ST, 1) = "|" THEN
                                             StreetA$ = RTRIM$(LTRIM$(LEFT$(street$, ST - 1)))
                                             StreetB$ = RTRIM$(LTRIM$(RIGHT$(street$, LEN(street$) - ST)))
                                             FourLine = True
                                             EXIT FOR
                                        END IF
                                   NEXT ST

                                   IF FourLine = True THEN
                                        LPRINT StreetA$
                                        LPRINT StreetB$
                                        StreetA$ = ""
                                        StreetB$ = ""
                                   ELSE
                                        LPRINT street$
                                   END IF
                                  
                                   City$ = RTRIM$(LTRIM$(City$))
                                   Zip$ = RTRIM$(Zip$)
                                   IF RIGHT$(City$, 1) <> "," THEN
                                        IF Zip$ <> "" THEN
                                             City$ = City$ + ","
                                        END IF
                                   END IF

                                   State$ = RTRIM$(State$)
                                   
                                   Text$ = City$ + " " + State$ + "  " + Zip$
                                   LPRINT Text$

                                   SCREEN 0, , 1, 1
                                  
                                   FirstName$ = ""
                                   MiddleInitial$ = ""
                                   LastName$ = ""
                                   street$ = ""
                                   City$ = ""
                                   State$ = ""
                                   Zip$ = ""
                                  
                                   IF FourLine = True THEN
                                        LPRINT
                                        LPRINT
                                   ELSE
                                        LPRINT
                                        LPRINT
                                        LPRINT
                                   END IF

                                   FourLine = False
                             
                              END IF

                         NEXT T
                    NEXT P
                       
                    
                         FOR P = 1 TO X
                              IF PrintStuff(P) = True THEN
                                   LPRINT CHR$(ESC); CHR$(113); CHR$(0); : EXIT FOR
                              END IF
                         NEXT P

                     SCREEN 0, , 1, 1
                     GOTO DecodeHOT:
               END SELECT
              
          CASE F1
               IF PrintLabels = False THEN
                    CALL HelpEditOld
               ELSE
                    CALL HelpPrint
               END IF
               GOTO DecodeHOT:
          CASE ELSE
               GOTO DecodeLOOP:
     END SELECT
END IF







END SUB


SUB EnterLabelData (Box() AS Boxes, DOSName AS NameType, File$)

DisplayPage = 1

ReStart:

IF DOSName.ReStart = True THEN

     REDIM Text$(4): REDIM Title(4)
     Text$(1) = "        (_) MS      (_) MR      (_) MRS      (_) DR        "
     Text$(2) = "[_________________________] [_] [_________________________]"
     Text$(3) = "[_________________________________________________________]"
     Text$(4) = "[____________________________________________] [__] [_____]"

ELSE

     REDIM Text$(4): REDIM Title(4)
     OPEN File$ FOR INPUT AS #1
          
          FOR I = 1 TO 4
               LINE INPUT #1, Text$(I)
          NEXT I

     CLOSE #1

END IF

Title(1) = False
Title(2) = False
Title(3) = False
Title(4) = False

FOR cell = 1 TO 4
     FOR element = 1 TO 60
          Box(cell, element).Char = MID$(Text$(cell), element, 1)
          Box(cell, element).NewData = False
     NEXT element
NEXT cell

SCREEN 0, , 2, DisplayPage: COLOR BLACK, GREEN: CLS

Center "Enter / Edit Label Data", 5
Center Text$(1), 9
Center Text$(2), 11
Center "       (First Name)         (M)         (Last Name)        ", 12
Center Text$(3), 14
Center "(Street)", 15
Center Text$(4), 17
Center "                   (CITY)                      (ST)  (ZIP) ", 18
Center "F1 = Help  F10 = Save  ESC = Exit", 22

cell = 2: element = 2
LOCATE 11, 10 + element: COLOR BROWN + BRIGHT + BLINK, GREEN: PRINT Box(cell, element).Char;


SCREEN 0, , 2, 2

EnterDataLoop:

DO
     Choice$ = INKEY$
LOOP WHILE Choice$ = ""

IF LEN(Choice$) = 1 THEN
     SELECT CASE ASC(Choice$)
          CASE BACKSPACE
               DataModified = True
               Box(cell, element).Char = "_"
               GetColor Box(), cell, element
               OLDCursor cell, element, Box()

               SELECT CASE cell
                    CASE 1
                         SELECT CASE element
                              CASE 10
                                   cell = 4: element = 58
                              CASE 22
                                   element = 10
                              CASE 34
                                   element = 22
                              CASE 47
                                   element = 34
                         END SELECT
                    CASE 2
                         SELECT CASE element
                              CASE 2
                                   cell = 1: element = 47
                              CASE 30
                                   element = 26
                              CASE 34
                                   element = 30
                              CASE ELSE
                                   element = element - 1
                         END SELECT

                    CASE 3
                         SELECT CASE element
                              CASE 2
                                   cell = 2: element = 58
                              CASE ELSE
                                   element = element - 1
                         END SELECT
                    CASE 4
                         SELECT CASE element
                              CASE 2
                                   cell = 3: element = 58
                              CASE 49
                                   element = 45
                              CASE 54
                                   element = 50
                              CASE ELSE
                                   element = element - 1
                         END SELECT
               END SELECT

               GetNewColor Box(), cell, element
               NEWCursor cell, element, Box()
               GOTO EnterDataLoop:
              
          CASE 32, 33 TO 126
               SELECT CASE ASC(Choice$)
                    CASE 91 TO 93
                         '[ ]
                         GOTO EnterDataLoop:
               END SELECT

               DataModified = True
               Box(cell, element).NewData = True
               IF ASC(Choice$) = 32 THEN
                    Box(cell, element).Char = "_"
                    IF cell = 1 THEN
                         SELECT CASE element
                              CASE 10
                                   Title(1) = False
                              CASE 22
                                   Title(2) = False
                              CASE 34
                                   Title(3) = False
                              CASE 47
                                   Title(4) = False
                         END SELECT
                    END IF
               ELSE
                    IF cell = 1 THEN
                         Box(cell, element).Char = "X"
                         SELECT CASE element
                              CASE 10
                                   Title(1) = True
                              CASE 22
                                   Title(2) = True
                              CASE 34
                                   Title(3) = True
                              CASE 47
                                   Title(4) = True
                         END SELECT
                    ELSE
                         Box(cell, element).Char = CHR$(ASC(Choice$))
                    END IF
               END IF
               GetColor Box(), cell, element
               OLDCursor cell, element, Box()
              
               SELECT CASE cell
                    CASE 1
                         SELECT CASE element
                              CASE 10
                                   element = 22
                              CASE 22
                                   element = 34
                              CASE 34
                                   element = 47
                              CASE 47
                                   cell = 2: element = 2
                         END SELECT
                    CASE 2
                         SELECT CASE element
                              CASE 26
                                   element = 30
                              CASE 30
                                   element = 34
                              CASE 58
                                   cell = 3: element = 2
                              CASE ELSE
                                   element = element + 1
                         END SELECT

                    CASE 3
                         SELECT CASE element
                              CASE 58
                                   cell = 4: element = 2
                              CASE ELSE
                                   element = element + 1
                         END SELECT
                    CASE 4
                         SELECT CASE element
                              CASE 45
                                   element = 49
                              CASE 50
                                   element = 54
                              CASE 58
                                   cell = 1: element = 10
                              CASE ELSE
                                   element = element + 1
                         END SELECT
               END SELECT
              
               GetNewColor Box(), cell, element
               NEWCursor cell, element, Box()

               GOTO EnterDataLoop:
          CASE TABkey
TABKeyLoc:             
               GetColor Box(), cell, element
               OLDCursor cell, element, Box()
              
               SELECT CASE cell
                    CASE 1
                         SELECT CASE element
                              CASE 10
                                   element = 22
                              CASE 22
                                   element = 34
                              CASE 34
                                   element = 47
                              CASE 47
                                   cell = 2: element = 2
                         END SELECT
                   
                    CASE 2
                         SELECT CASE element
                              CASE IS < 30
                                   element = 30
                              CASE IS = 30
                                   element = 34
                              CASE IS >= 34
                                   cell = 3: element = 2
                         END SELECT
                    CASE 3
                         cell = 4: element = 2
                    CASE 4
                         IF element < 49 THEN
                              element = 49
                         ELSEIF element >= 49 AND element <= 50 THEN
                              element = 54
                         ELSEIF element >= 50 THEN
                              cell = 1: element = 10
                         END IF
               END SELECT
              
               GetNewColor Box(), cell, element
               NEWCursor cell, element, Box()
               GOTO EnterDataLoop:
          CASE ENTER
               GOTO TABKeyLoc:
          CASE ESC
               IF DataModified = True THEN
F10Save:                                              
                    COLOR BLACK, WHITE
                    Center "Save Data? (Y/N) (ESC)", 20
                    DO
                         Choice$ = INKEY$
                    LOOP WHILE Choice$ = ""
                    SELECT CASE ASC(UCASE$(Choice$))
                         CASE ESC
                              COLOR GREEN, GREEN
                              Center "Save Data? (Y/N) (ESC)", 20
                              COLOR BLACK, GREEN
                              F10Pressed = False
                              GOTO EnterDataLoop:
                         CASE Y
                             
                              File$ = ""
                              FirstName$ = ""
                              MiddleInitial$ = ""

                              MiddleInitial$ = Box(2, 30).Char
                              FOR I = 2 TO 26
                                   a$ = Box(2, I).Char
                                   IF a$ = "_" THEN a$ = ""
                                   FirstName$ = FirstName$ + a$
                              NEXT I
                              
                              FOR I = 34 TO 58
                                   a$ = Box(2, I).Char
                                   SELECT CASE a$
                                        CASE "_", "."
                                             a$ = ""
                                        CASE ","
                                             a$ = "_"
                                   END SELECT
                                   
                                   File$ = File$ + a$
                              NEXT I
                             
                              File$ = RTRIM$(LTRIM$(File$))
                              IF File$ = "" THEN File$ = "????????"
                              DOSName.FileName = File$

                              DOSName.Extension = LEFT$(LTRIM$(FirstName$), 1) + MiddleInitial$ + ""
                              File$ = DOSName.FileName + "." + DOSName.Extension

                              DOSName.ErrorFile = File$
                              OPEN File$ FOR OUTPUT AS #1
                                   FOR c = 1 TO 4
                                        FOR e = 1 TO 59
                                             SaveLine$ = SaveLine$ + Box(c, e).Char
                                        NEXT e
                                        PRINT #1, SaveLine$
                                        SaveLine$ = ""
                                   NEXT c
                              CLOSE #1
                              DataModified = False
                              DOSName.ReStart = True
                              IF F10Pressed = True THEN
                                   F10Pressed = False
                                   DisplayPage = 2
                                   GOTO ReStart:
                              ELSE
                                   EXIT SUB
                              END IF
                         CASE N
                              COLOR GREEN, GREEN
                              Center "Save Data? (Y/N) (ESC)", 20
                              COLOR BLACK, GREEN
                              DataModified = False
                              DOSName.ReStart = True
                              IF F10Pressed = True THEN
                                   F10Pressed = False
                                   DisplayPage = 2
                                   GOTO ReStart:
                              ELSE
                                   EXIT SUB
                              END IF
                             
                         CASE ELSE
                    END SELECT
               ELSE
                    DOSName.ReStart = True
                    EXIT SUB
               END IF
          CASE ELSE
     END SELECT
ELSEIF LEN(Choice$) = 2 THEN
     SELECT CASE ASC(RIGHT$(Choice$, 1))
         
          CASE CntrlRIGHT
               GOTO TABKeyLoc:
          CASE ShiftTAB, CntrlLEFT
               GetColor Box(), cell, element
               OLDCursor cell, element, Box()
               SELECT CASE cell
                    CASE 1
                         SELECT CASE element
                              CASE 10
                                   cell = 4: element = 54
                              CASE 22
                                   element = 10
                              CASE 34
                                   element = 22
                              CASE 47
                                   element = 34
                         END SELECT
                    CASE 2
                         IF element = 2 THEN
                              cell = 1: element = 47
                         ELSEIF element > 2 AND element <= 30 THEN
                              element = 2
                         ELSEIF element = 34 THEN
                              element = 30
                         ELSEIF element > 34 THEN
                              element = 34
                         END IF
                    CASE 3
                         IF element = 2 THEN
                              cell = 2: element = 34
                         ELSEIF element > 2 THEN
                              element = 2
                         END IF
                    CASE 4
                         IF element = 2 THEN
                              cell = 3: element = 2
                         ELSEIF element > 2 AND element < 49 THEN
                              element = 2
                         ELSEIF element = 49 THEN
                              element = 2
                         ELSEIF element > 49 AND element <= 50 THEN
                              element = 49
                         ELSEIF element = 54 THEN
                              element = 49
                         ELSEIF element > 54 THEN
                              element = 54
                         END IF
               END SELECT
             
               GetNewColor Box(), cell, element
               NEWCursor cell, element, Box()
               GOTO EnterDataLoop:

          CASE UP

               GetColor Box(), cell, element
               OLDCursor cell, element, Box()
              
               IF cell = 1 THEN
                    cell = 4
               ELSE
                    cell = cell - 1
               END IF
               element = 2
               IF cell = 1 THEN element = 10
              
               GetNewColor Box(), cell, element
               NEWCursor cell, element, Box()
               GOTO EnterDataLoop:
             
          CASE DOWN
              
               GetColor Box(), cell, element
               OLDCursor cell, element, Box()

               IF cell = 4 THEN
                    cell = 1
               ELSE
                    cell = cell + 1
               END IF
               element = 2
               IF cell = 1 THEN element = 10
              
               GetNewColor Box(), cell, element
               NEWCursor cell, element, Box()
               GOTO EnterDataLoop:
             
          CASE RIGHT
              
               GetColor Box(), cell, element
               OLDCursor cell, element, Box()
              
               SELECT CASE cell
                    CASE 1
                         SELECT CASE element
                              CASE 10
                                   element = 22
                              CASE 22
                                   element = 34
                              CASE 34
                                   element = 47
                              CASE 47
                                   cell = 2: element = 2
                         END SELECT
                    CASE 2
                         SELECT CASE element
                              CASE 26
                                   element = 30
                              CASE 30
                                   element = 34
                              CASE 58
                                   cell = 3: element = 2
                              CASE ELSE
                                   element = element + 1
                         END SELECT

                    CASE 3
                         SELECT CASE element
                              CASE 58
                                   cell = 4: element = 2
                              CASE ELSE
                                   element = element + 1
                         END SELECT
                    CASE 4
                         SELECT CASE element
                              CASE 45
                                   element = 49
                              CASE 50
                                   element = 54
                              CASE 58
                                   cell = 1: element = 10
                              CASE ELSE
                                   element = element + 1
                         END SELECT
               END SELECT
               GetNewColor Box(), cell, element
               NEWCursor cell, element, Box()
               GOTO EnterDataLoop:
             
          CASE LEFT
               GetColor Box(), cell, element
               OLDCursor cell, element, Box()
             
               SELECT CASE cell
                    CASE 1
                         SELECT CASE element
                              CASE 10
                                   cell = 4: element = 58
                              CASE 22
                                   element = 10
                              CASE 34
                                   element = 22
                              CASE 47
                                   element = 34
                         END SELECT
                    CASE 2
                         SELECT CASE element
                              CASE 2
                                   cell = 1: element = 47
                              CASE 30
                                   element = 26
                              CASE 34
                                   element = 30
                              CASE ELSE
                                   element = element - 1
                         END SELECT

                    CASE 3
                         SELECT CASE element
                              CASE 2
                                   cell = 2: element = 58
                              CASE ELSE
                                   element = element - 1
                         END SELECT
                    CASE 4
                         SELECT CASE element
                              CASE 2
                                   cell = 3: element = 58
                              CASE 49
                                   element = 45
                              CASE 54
                                   element = 50
                              CASE ELSE
                                   element = element - 1
                         END SELECT
               END SELECT
               GetNewColor Box(), cell, element
               NEWCursor cell, element, Box()
               GOTO EnterDataLoop:

          CASE HOME
              
               GetColor Box(), cell, element
               OLDCursor cell, element, Box()
               cell = 2: element = 2
               GetNewColor Box(), cell, element
               NEWCursor cell, element, Box()
               GOTO EnterDataLoop:

          CASE ENDKEY
               
               GetColor Box(), cell, element
               OLDCursor cell, element, Box()
               cell = 4: element = 2
               GetNewColor Box(), cell, element
               NEWCursor cell, element, Box()
               GOTO EnterDataLoop:

          CASE DEL
              
               DataModified = True
               Box(cell, element).Char = "_"
              
               IF Box(cell, element + 1).Char <> "]" THEN
                    IF cell > 1 THEN
                         Tempelement = element
                         DO
                              
                              Box(cell, element).Char = Box(cell, element + 1).Char
                              GetColor Box(), cell, element
                              OLDCursor cell, element, Box()
                              element = element + 1

                         LOOP UNTIL Box(cell, element + 1).Char = "]"
                         IF Box(cell, element).Char <> "_" THEN
                              Box(cell, element).Char = "_"
                              GetColor Box(), cell, element
                              OLDCursor cell, element, Box()
                         END IF
                         element = Tempelement
                    END IF
               END IF

               GetNewColor Box(), cell, element
               NEWCursor cell, element, Box()
               GOTO EnterDataLoop:

          CASE INS
              
               DataModified = True
               Tempelement = element
              
               IF Box(cell, element + 1).Char <> "]" THEN
                    IF cell > 1 THEN
              
                         DO
                             
                              IF Box(cell, element).Char <> "_" THEN
                                   Maxelement = element + 1
                              END IF

                              element = element + 1

                         LOOP UNTIL Box(cell, element + 1).Char = "]"

                         FOR element = Maxelement TO Tempelement STEP -1
                              Box(cell, element).Char = Box(cell, element - 1).Char
                              Box(cell, element).NewData = True
                              GetColor Box(), cell, element
                              OLDCursor cell, element, Box()
                         NEXT element
                        
                         element = Tempelement
                         Box(cell, element).Char = "_"
                    END IF
               END IF
               GetNewColor Box(), cell, element
               NEWCursor cell, element, Box()
               GOTO EnterDataLoop:

         
          CASE F1
              
               CALL HelpInfo
               GOTO EnterDataLoop:

          CASE F10
               F10Pressed = True
               GOTO F10Save:

          CASE ELSE
               GOTO EnterDataLoop:
     END SELECT
END IF



END SUB



SUB ErrorMessage (Text$)

VIEW PRINT: BEEP

COLOR RED, WHITE
Center "ͻ", 13
Center "                                                              ", 14: BlackSquare
Center "ͼ", 15: BlackSquare

COLOR RED + BLINK, WHITE
Center " ERROR HAS OCCURRED ", 13
COLOR RED, WHITE

Center " Press a Key to Exit ", 15

COLOR BROWN + BRIGHT, WHITE
Center Text$, 14

COLOR WHITE, BLACK
LOCATE 16, 10: PRINT STRING$(64, " ");
COLOR BLACK, WHITE

DO: LOOP WHILE INKEY$ = ""


END SUB

SUB GetColor (Box() AS Boxes, cell, element)

IF Box(cell, element).NewData = True THEN
     IF Box(cell, element).Char = "_" THEN
          COLOR BLACK, GREEN
     ELSE
          COLOR WHITE + BRIGHT, GREEN
     END IF
ELSE
     COLOR BLACK, GREEN
END IF

END SUB

SUB GetNewColor (Box() AS Boxes, cell, element)

COLOR BROWN + BRIGHT + BLINK, GREEN

END SUB

SUB HelpEditOld

Blinking = False: Name$ = "": a$ = ""

FOR col = 35 TO 45
     a$ = CHR$(SCREEN(14, col))
     Name$ = Name$ + a$
NEXT col

IF SCREEN(14, 33) = 175 THEN
     Blinking = True
END IF


PCOPY 1, 2
SCREEN 0, , 2, 1

COLOR RED, WHITE
Center "ͻ", 10
Center " Help Info ", 10
Center "                                                                 ", 11: BlackSquare
Center "                                                                 ", 12: BlackSquare
Center "ͼ", 13: BlackSquare
Center " Press a Key to Exit ", 13
COLOR BLACK, WHITE

Center " Use the Arrow keys to move the cursor.  To edit, press ENTER. ", 11
Center " To delete an address, press delete.                           ", 12

COLOR WHITE, BLACK

LOCATE 14, 10
PRINT STRING$(66, " ");

IF Blinking = True THEN
     COLOR BLACK + BRIGHT + BLINK, BLACK
     LOCATE 14, 33: PRINT ""; : LOCATE 14, 47: PRINT "";
END IF

COLOR BLACK + BRIGHT, BLACK
LOCATE 14, 35: PRINT Name$;

SCREEN 0, , 2, 2

DO: LOOP WHILE INKEY$ = ""

SCREEN 0, , 1, 1


END SUB

SUB HelpInfo

PCOPY 2, 3
SCREEN 0, , 3, 2


COLOR RED, WHITE
Center "ͻ", 10
Center " Help Info ", 10
Center "                                                   ", 11: BlackSquare
Center "                                                   ", 12: BlackSquare
Center "                                                   ", 13: BlackSquare
Center "                                                   ", 14: BlackSquare
Center "ͼ", 15: BlackSquare
Center " Press a Key to Exit ", 15
COLOR BLACK, WHITE

Center "ARROW, HOME, END or TAB keys to move the cursor.", 11
Center "Delete or BACKSPACE keys to delete, Insert to", 12
Center "insert a space.  F10 to save data and restart.", 13
Text$ = CHR$(34) + "|" + CHR$(34) + " in the street address = another line"
Center Text$, 14

COLOR WHITE, BLACK

LOCATE 16, 17
PRINT STRING$(52, " ");

SCREEN 0, , 3, 3
DO: LOOP WHILE INKEY$ = ""
SCREEN 0, , 2, 2

END SUB

SUB HelpMenu

COLOR RED, WHITE
Center "ͻ", 10
Center " Help Info ", 10
Center "                                                              ", 11: BlackSquare
Center "                                                              ", 12: BlackSquare
Center "                                                              ", 13: BlackSquare
Center "                                                              ", 14: BlackSquare
Center "                                                              ", 15: BlackSquare
Center "                                                              ", 16: BlackSquare
Center "ͼ", 17: BlackSquare
Center " Press a Key to Exit ", 17

COLOR WHITE, BLACK
LOCATE 18, 10: PRINT STRING$(64, " ");
COLOR BLACK, WHITE

Center " Use ARROW keys to select, then press ENTER.  This program ", 11
Center " was written using an EPSON action printer 4000 (24 pin).  ", 12
Center " The labels used were AVERY (Dot Matrix Printer Labels).   ", 13
Text$ = "SIZE: 3" + CHR$(34) + " x 15/16" + CHR$(34) + " (1 across)"
Center Text$, 14
COLOR BROWN + BRIGHT, WHITE
Center " *** Note: MAKE SURE TO READ THE SECTION ON LABELS IN YOUR    ", 15
Center "           PRINTER'S USER'S MANUAL. ***                       ", 16
COLOR BLACK, WHITE

END SUB

SUB HelpPrint

Blinking = False: Name$ = "": a$ = ""

FOR col = 35 TO 45
     a$ = CHR$(SCREEN(16, col))
     Name$ = Name$ + a$
NEXT col

IF SCREEN(16, 33) = 175 THEN
     Blinking = True
END IF

PCOPY 1, 2
SCREEN 0, , 2, 1

COLOR RED, WHITE
Center "ͻ", 10
Center " Help Info ", 10
Center "                                                              ", 11: BlackSquare
Center "                                                              ", 12: BlackSquare
Center "                                                              ", 13: BlackSquare
Center "                                                              ", 14: BlackSquare
Center "ͼ", 15: BlackSquare
Center " Press a Key to Exit ", 15
COLOR BLACK, WHITE

Center "Use HOME, END or the Arrow keys to move the cursor.  To make", 11
Center "selection(s); press the space bar to select one, or press S ", 12
Center "to select all, or press D to de-select all addresses.  When ", 13
Center "ready to print, press F7.                                   ", 14

COLOR WHITE, BLACK

LOCATE 16, 10
PRINT STRING$(64, " ");

IF Blinking = True THEN
     COLOR BLACK + BRIGHT + BLINK, BLACK
     LOCATE 16, 33: PRINT ""; : LOCATE 16, 47: PRINT "";
END IF

COLOR BLACK + BRIGHT, BLACK
LOCATE 16, 35: PRINT Name$;

SCREEN 0, , 2, 2

DO: LOOP WHILE INKEY$ = ""

SCREEN 0, , 1, 1


END SUB

SUB HighLight
COLOR WHITE + BRIGHT, RED
END SUB

SUB Menu (Box() AS Boxes, DOSName AS NameType, ScreenINFO AS ScreenType)

X = 1

MenuRestart:

SCREEN 0, , 1, 1: COLOR RED, GREEN: CLS

REDIM Text$(4)
Text$(1) = "Enter New Label"
Text$(2) = "Edit Old Label"
Text$(3) = "Print Label(s)"
Text$(4) = "Quit"

COLOR BLACK, WHITE
Center "ͻ", 10
Center "                                 ", 11
Center "ͼ", 12
Center "X M A S / M A I L   L A B E L S", 11
NormalVideo

Center "Version 1.0  -  (AGO)", 6

Center Text$(1), 15
Center Text$(2), 16
Center Text$(3), 17
Center Text$(4), 18
Center "F1 = Help", 22

ShowMenu:

CALL NormalVideo: Center Text$(OLDx), 14 + OLDx
CALL HighLight: Center Text$(X), 14 + X: NormalVideo

MenuLoop:

DO
     Choice$ = INKEY$
LOOP WHILE Choice$ = ""

IF LEN(Choice$) = 1 THEN
     SELECT CASE ASC(Choice$)
          CASE ENTER
               SELECT CASE X
                    CASE 1
                         CALL EnterLabelData(Box(), DOSName, File$)
                    CASE 2
                         COLOR RED, GREEN
                         LOCATE 1, 1: PRINT STRING$(80, "");
                         LOCATE 25, 1: PRINT STRING$(80, "");
                         COLOR WHITE + BRIGHT, RED
                         Center "Edit Old Label", 1
                         Center "F1 = Help  ENTER = Edit  ESC = Exit", 25
                         COLOR RED, GREEN
                         VIEW PRINT 2 TO 24: CLS 2
                         CALL SortMessage
                         SHELL "DIR *.?? > .DAT"
                        
                         DOSName.ReStart = False
                         CALL Decode(File$, PrintLabels)
                        
                         IF File$ = "" THEN
                              VIEW PRINT
                              DOSName.ReStart = True
                              GOTO MenuRestart:
                         END IF
                         CALL EnterLabelData(Box(), DOSName, File$)

                         VIEW PRINT: GOTO MenuRestart:
                    CASE 3
                         PrintLabels = True
                        
                         COLOR RED, GREEN
                         LOCATE 1, 1: PRINT STRING$(80, "");
                         LOCATE 25, 1: PRINT STRING$(80, "");
                         COLOR WHITE + BRIGHT, RED
                         Center "Print Label(s)", 1
                         Center "F1 = Help  F7 = Print  ESC = Exit", 25
                         COLOR RED, GREEN
                         VIEW PRINT 2 TO 24: CLS 2
                         CALL SortMessage
                         SHELL "DIR *.?? > .DAT"
                        
                         DOSName.ReStart = False
                         CALL Decode(File$, PrintLabels)
                        
                         PrintLabels = False
                         DOSName.ReStart = True
                         VIEW PRINT: GOTO MenuRestart:
                    CASE 4
                         SCREEN 0, , 0, 0: LOCATE ScreenINFO.row, ScreenINFO.row
                         END
               END SELECT
          CASE ESC
               SCREEN 0, , 0, 0: LOCATE ScreenINFO.row, ScreenINFO.col
               END
          CASE ELSE
               GOTO MenuLoop:
     END SELECT
ELSEIF LEN(Choice$) = 2 THEN
     SELECT CASE ASC(RIGHT$(Choice$, 1))
          CASE UP
               OLDx = X
               IF X = 1 THEN
                    X = 4
               ELSE
                    X = X - 1
               END IF
               GOTO ShowMenu:
          CASE DOWN
               OLDx = X
               IF X = 4 THEN
                    X = 1
               ELSE
                    X = X + 1
               END IF
               GOTO ShowMenu:
          CASE HOME
               OLDx = X: X = 1: GOTO ShowMenu:
          CASE ENDKEY
               OLDx = X: X = 4: GOTO ShowMenu:
          CASE F1
               PCOPY 1, 2
               SCREEN 0, , 2, 1
               CALL HelpMenu
               SCREEN 0, , 2, 2
               DO: LOOP WHILE INKEY$ = ""
               SCREEN 0, , 1, 1
               GOTO MenuLoop:
          CASE ELSE
               GOTO MenuLoop:
     END SELECT
END IF






END SUB

SUB NEWCursor (cell, element, Box() AS Boxes)


SELECT CASE cell
     CASE 1
          LOCATE 9, 10 + element: PRINT Box(cell, element).Char;
     CASE 2
          LOCATE 11, 10 + element: PRINT Box(cell, element).Char;
     CASE 3
          LOCATE 14, 10 + element: PRINT Box(cell, element).Char;
     CASE 4
          LOCATE 17, 10 + element: PRINT Box(cell, element).Char;
END SELECT


END SUB

SUB NormalVideo
COLOR BLACK, GREEN
END SUB

SUB OLDCursor (cell, element, Box() AS Boxes)


SELECT CASE cell
     CASE 1
          LOCATE 9, 10 + element: PRINT Box(cell, element).Char;
     CASE 2
          LOCATE 11, 10 + element: PRINT Box(cell, element).Char;
     CASE 3
          LOCATE 14, 10 + element: PRINT Box(cell, element).Char;
     CASE 4
          LOCATE 17, 10 + element: PRINT Box(cell, element).Char;
END SELECT



END SUB

SUB RightFlush (Text$, row)

col = 80 - LEN(Text$): LOCATE row, col: PRINT Text$;

END SUB

SUB SortMessage

Blinking = False: Name$ = "": a$ = ""

FOR col = 35 TO 45
     a$ = CHR$(SCREEN(14, col))
     Name$ = Name$ + a$
NEXT col

IF SCREEN(14, 33) = 175 THEN
     Blinking = True
END IF

COLOR RED, WHITE
Center "ͻ", 11
Center "                        ", 12: BlackSquare
Center "ͼ", 13: BlackSquare
COLOR BLACK, WHITE

Center "Sorting addresses...", 12

COLOR WHITE, BLACK

LOCATE 14, 29
PRINT STRING$(26, " ");

IF Blinking = True THEN
     COLOR BLACK + BRIGHT + BLINK, BLACK
     LOCATE 14, 33: PRINT ""; : LOCATE 14, 47: PRINT "";
END IF

COLOR BLACK + BRIGHT, BLACK
LOCATE 14, 35: PRINT Name$;

LOCATE 2, 1

END SUB

