		----------------------------------------
		-- Machine Level Programming for 386+ --
		----------------------------------------

-- Warning: These routines are not safe. They require a knowledge of 
-- machine-level programming. You can easily crash your system.
-- Only superficial checking of argument values is provided.

-- These routines, along with peek(), poke() and call(), let you access all 
-- of the features of your computer.  You can read and write to any memory 
-- location, and you can create and execute machine code subroutines.

-- Writing characters to screen memory with poke() is much faster than  
-- using puts().
-- address of start of screen memory 
--	 mono monitor: #B0000
--	color monitor: #B8000

-- see demo\callmach.ex for an example of calling a machine language routine

constant M_ALLOC = 16,
	 M_FREE = 17

-- biggest address on a 32-bit machine
constant MAX_ADDR = power(2, 32)-1

type machine_addr(atom a)
-- a legal machine address 
    return a > 0 and a <= MAX_ADDR and floor(a) = a
end type

global function allocate(integer n)
-- allocate n bytes of memory and return the address
    return machine_func(M_ALLOC, n)
end function

global procedure free(machine_addr a)
-- free the memory at address a
    machine_proc(M_FREE, a)
end procedure

global function int_to_bytes(atom x)
-- returns value of x as a sequence of 4 bytes: 
--	{bits 0-7,  (least significant)
--	 bits 8-15,
--	 bits 16-23,
--	 bits 24-31} (most significant)
-- This is the order of bytes in memory on 386+ machines.
-- This routine is useful when you need to poke numbers 
-- greater than one byte into memory.
    sequence result

    result = {0,0,0,0}
    result[1] = remainder(x, #100)
    x = floor(x / #100)
    result[2] = remainder(x, #100)
    x = floor(x / #100)
    result[3] = remainder(x, #100)
    x = floor(x / #100)
    result[4] = remainder(x, #100)
    return result
end function

global function bytes_to_int(sequence s)
-- converts 4-byte sequence back into a single integer value
    return s[1] + 
	   s[2] * #100 + 
	   s[3] * #10000 + 
	   s[4] * #1000000
end function

