		-- re-tab a file --
-- make better use of tabs to minimize file size
-- and also delete blanks at end of line
-- usage:  ex retab < src > dest

constant TAB_WIDTH = 8

type natural(integer x)
    return x >= 0
end type

function tab(natural pos)
-- compute equivalent number of spaces for tab
    return(floor(pos / TAB_WIDTH) + 1) * TAB_WIDTH
end function

function retab(sequence line)
-- make better use of tabs & delete trailing blanks
-- to shrink line if possible
    natural i, leading_white
    sequence better_line

    i = 1
    leading_white = 0
    better_line = ""
    while i < length(line) do
	-- count leading white space
	if line[i] = ' ' then
	    leading_white = leading_white + 1
	elsif line[i] = '\t' then
	    leading_white = tab(leading_white)
	else
	    exit
	end if
	i = i + 1
    end while
    while leading_white >= TAB_WIDTH do
	better_line = better_line & '\t'
	leading_white = leading_white - TAB_WIDTH
    end while
    while leading_white >= 1 do
	better_line = better_line & ' '
	leading_white = leading_white - 1
    end while
    better_line = better_line & line[i..length(line)]
    i = length(better_line)
    while i >= 1 do
	-- delete trailing blanks
	if find(better_line[i], " \t") then
	    better_line = better_line[1..i-1] &
			  better_line[i+1..length(better_line)]
	elsif better_line[i] != '\n' then
	    exit
	end if
	i = i - 1
    end while
    return better_line
end function

procedure process_file()
    object line
    sequence better_line
    natural savings

    savings = 0
    while 1 do
	line = gets(0)
	if atom(line) then
	    exit
	end if
	better_line = retab(line)
	savings = savings + length(line) - length(better_line)
	puts(1, better_line)
    end while
    printf(2, "saved %d bytes\n", savings)
end procedure

process_file()

