/***********************************************************************
*                                                                      *
*   This file is provided on an AS-IS basis.                           *
*   It shows how to access a PIPDLL from the socket side.              *
*   It is not complete, so (of course) it will not compile             *
*                                                                      *
*   ------------------------------------------------------------------ *
*                                                                      *
*   No copyright by Markus Schmidt, 1993                               *
*                                                                      *
***********************************************************************/

#define INCL_WINMESSAGEMGR
#define INCL_WINWINDOWMGR
#define INCL_WINDIALOGS

#define INCL_DOSMODULEMGR
#define INCL_DOSFILEMGR
#define INCL_DOSPROCESS

#define INCL_NOCOMMON
#include <os2.h>
#include <string.h>

#define PIP_INCL_SOCKET
#include "pip.h"



int main(void);
int pipInitSocket(unsigned char *dllname, PIP_SOCKET *, PIP_PLUG *);
void InfoMsg(char *txt);
void ErrorMsg(char *txt);

static PIP_SOCKET pipSocket= { 0, };
static PIP_PLUG   pipPlug=   { 0, };
static HAB hab;
static HMQ hmq;


int main()
{
	int rc;
	hab = WinInitialize(0);             /* Initialize PM  */
	hmq = WinCreateMsgQueue(hab, 0);    /* Create a message queue */

	rc= pipInitSocket("PIPASCII", &pipSocket, &pipPlug);
	if (rc==PIP_OK) {
		rc= pipPlug.pipIntro(&pipSocket, &pipPlug);
		rc= pipPlug.pipInit(&pipSocket, &pipPlug);
		rc= pipPlug.pipSetup(&pipSocket, &pipPlug);
		rc= pipPlug.pipSend(&pipSocket, &pipPlug, NULL, NULL);
		rc= pipPlug.pipReceive(&pipSocket, &pipPlug, NULL, NULL);
		rc= pipPlug.pipCleanup(&pipSocket, &pipPlug);
	}

	WinDestroyMsgQueue(hmq);
	WinTerminate(hab);

	return (0);
}

int pipInitSocket(unsigned char *dllname, PIP_SOCKET *pxs, PIP_PLUG *pxp)
{
	HMODULE hmDll;
	int rc;

	rc= DosLoadModule("", 0, dllname, &hmDll);
	if (rc!=0) 
		return (PIP_ERROR);

	// Load adresses into plug
	rc+= DosQueryProcAddr(hmDll, 0,"pipIntro",  &(pxp->pipIntro));
	rc+= DosQueryProcAddr(hmDll, 0,"pipInit",  &(pxp->pipInit));
	rc+= DosQueryProcAddr(hmDll, 0,"pipSetup", &pxp->pipSetup);
	rc+= DosQueryProcAddr(hmDll, 0,"pipSend",  &pxp->pipSend);
	rc+= DosQueryProcAddr(hmDll, 0,"pipReceive", &pxp->pipReceive);
	rc+= DosQueryProcAddr(hmDll, 0,"pipCleanup", &pxp->pipCleanup);

	if (rc!=0) 
		return (PIP_ERROR);

	// reset everything
	memset(pxs, 0, sizeof(*pxs));

	// load socket
	pxs->hab= hab;

	pxs->PipVersion= PIP_VERSION;
	pxs->hmPlugDll= hmDll;

	pxs->ioConPutChar= conputc;
	pxs->ioConPutData= conputs;

	pxs->ioSerQueryAvail= serquery;
	pxs->ioSerGetChar=	sergetc;
	pxs->ioSerPutChar=	serputc;
	pxs->ioSerUngetData=serungets;
	pxs->ioSerPutData=	serputs;
	pxs->ioSerPutBrk=	sersendbrk;

	pxs->dlgErrorMsg= 	ErrorMsg;
	pxs->dlgInfoMsg= 	InfoMsg;

	pxs->dlgHwndFrame= 	HWND_DESKTOP;
	pxs->hfComDevice= 	0;
	pxs->ulBaud=	  	0;

	pxs->PlugPrivate=	(void*)0;

	return (PIP_OK);
}
	





/***********************************************************************
*    Show an error message                                             *
*                                                                      *
*                                                                      *
***********************************************************************/
void 
ErrorMsg(char *txt)
{
	WinMessageBox(HWND_DESKTOP, 0, txt, "Error", 
				0, MB_OK | MB_ERROR | MB_MOVEABLE);
}


/***********************************************************************
*    Show an error message                                             *
*                                                                      *
*                                                                      *
***********************************************************************/
void 
InfoMsg(char *txt)
{
	WinMessageBox(HWND_DESKTOP, 0, txt, "Information", 
				0, MB_OK | MB_INFORMATION | MB_MOVEABLE);
}

