
{ Another one of my miscellaneous programs }

{ SPLIT, Fast File Splitter Version 2.0 }
{ By Toupao Chieng of Clovis West H.S.  }
{ April 16, 1991, 9:47:50 pm            }

program TurboSplit(input, output);
{ This is simple pascal program to split large files into 2 or more smaller
  files. The purpose is to enable backing up of large ZIP or any other type
  files (binary/text) onto floppy disks. You can of-course back it up with a
  backup program such as PC-Backup or Norton Backup, but it's too much of a
  problem.

  SPLIT is a freeware, please share it with your friends if you like it.
  There is no charge for using this program, neither there is a warranty.
  Feel free to modify it, customize it to your own needs.

  NOTE: To use this program, more than 64K RAM must be free to allocate
        big read/write buffer. The reason is because of speed.
}

{$S-,I-,R-,D-}

uses
  Crt, Dos, FastTTT5;

const
  Version = '2.0';                      { program version }
  DefNum: byte = 2;                     { default number of files to create }
  MaxWordSize = 65534;                  { max bytes to allocate in memory }

var
  Dir: DirStr;                          { directory string }
  Name: NameStr;                        { file name string }
  Ext: ExtStr;                          { file extension string }
  SourceFile: file;                     { source file }
  TargetFile: file;                     { target files }
  UseVerify: boolean;                   { verify while creating files }
  UseLimit: boolean;                    { use file size limit }
  SizeLimit: longint;                   { maximum size for all files }

function GetClock: longint;
{ Retruns the current time }
var
  Hour: word;
  Minute: word;
  Second: word;
  Sec100: word;
begin
  GetTime(Hour, Minute, Second, Sec100);
  GetClock := 1000 * ((longint(Hour) * 3600) +
                      (longint(Minute) * 60) +
                      (longint(Second))) + Sec100;
end; { GetClock }

function Int2Str(Number: longint): string;
{ Converts an integer to string }
var
  Temp: string;
begin
  Str(Number, Temp);
  Int2Str := Temp;
end; { Int2Str }

function Upper(S: string): string;
{ Converts all characters of a string to uppercase }
var
  I: byte;
begin
  for I := 1 to Length(S) do
    S[I] := UpCase(S[I]);
  Upper := S;
end; { Upper }

function SplitFile(Source, Target: PathStr; NumFiles: byte): byte;
{ Split the Source file into NumFiles Target files, return program
  code.
}

var
  BRead: Word;                          { size of block read }
  BWrite: Word;                         { size of block written }
  FileBuf: pointer;                     { file buffer }
  WordSize: word;                       { read/write buffer size }
  SplitSize: longint;                   { size to split into }
  FSize: longint;                       { source file size }
  BCount: longint;                      { current byte count }
  TCount: longint;                      { total byte count }
  StrSize: string;                      { string value of BCount }
  ExtCount: byte;                       { extension count }
  Drive: byte;                          { output drive }
  Loop: byte;                           { loop control }
  Ch: Char;                             { keypressed character }

begin         { make sure this is enough memory before beginning }
  if MemAvail < MaxWordSize + 2048 then begin
    SplitFile := 6;                     { not enough memory to work with }
    Exit;                               { exit }
  end;
              { try to open source file }
  Assign(SourceFile, Source);
  System.FileMode := 0;                 { get hidden/readonly/system files }
  Reset(SourceFile, 1);                 { try to open file }
  System.FileMode := 2;                 { set back to read/write }
  if IOResult <> 0 then begin
    SplitFile := 1;                     { source file not found! }
    Exit;                               { exit out }
  end;                                  { if }
              { get output drive and make sure there is enough space }
  FSplit(Target, Dir, Name, Ext);       { separate file into its components }
  if Dir[2] <> ':' then
    Drive := 0                          { assume output is in current drive }
  else
    Drive := Ord(UpCase(Dir[1])) - 64;
  FSize := FileSize(SourceFile);
  if DiskFree(Drive) < FSize then begin
    SplitFile := 3;                     { not enough space for output files }
    Exit;                               { exit out }
  end;
             { try to open target file }
  Target := Dir + Name;                 { rename it without any extension }
  Assign(TargetFile, Target + '.1');
  Rewrite(TargetFile, 1);               { try to make output file }
  if IOResult <> 0 then begin
    SplitFile := 2;                     { can make output file }
    Exit;                               { exit out }
  end;                                  { if }
             { determine the split size }
  if UseLimit then
    SplitSize := SizeLimit              { use size limit }
  else begin
    SplitSize := FSize div NumFiles;    { divide to equal portions }
    if NumFiles * SplitSize < FSize then
    repeat
      SplitSize := SplitSize + 1;
    until NumFiles * SplitSize >= FSize;
  end; { else }

  BCount := 0;
  TCount := 0;
  ExtCount := 1;
  Write('Generating file: "', Upper(Target + '.' + Int2Str(ExtCount)) + '"');
  GetMem(FileBuf, MaxWordSize);         { allocate big read/write buffer }
  repeat
    if SplitSize - BCount < MaxWordSize then
      WordSize := SplitSize - BCount
    else
      WordSize := MaxWordSize;
    BlockRead(SourceFile, FileBuf^, WordSize, BRead);
    BlockWrite(TargetFile, FileBuf^, BRead, BWrite);
    if KeyPressed then begin
      Ch := ReadKey;
      if Ch = #3 then begin             { CTRL-C pressed! }
        Close(SourceFile);
        Close(TargetFile);
        for Loop := 1 to ExtCount do begin
          Assign(TargetFile, Target + '.' + Int2Str(ExtCount));
          Erase(TargetFile);            { erase all incomplete files }
        end;                            { for }
        SplitFile := 4;                 { user break }
        Exit;                           { exit out }
      end;                              { if }
    end;                                { if }
    BCount := BCount + BRead;
    TCount := TCount + BRead;
    StrSize := Int2Str(BCount);
    PlainWrite(WhereX, WhereY, ' Writting ' + StrSize + ' bytes...');
    if (BCount >= SplitSize) and (FSize - TCount > 0) then begin
      Close(TargetFile);
      GotoXY(WhereX + Length(StrSize) + 18, WhereY);
      Writeln('finished.');
      BCount := 0;                      { reset byte counter }
      ExtCount := ExtCount + 1;         { inc extension counter }
      Write('Generating file: "', Upper(Target + '.' + Int2Str(ExtCount)) + '"');
      Assign(TargetFile, Target + '.' + Int2Str(ExtCount));
      Rewrite(TargetFile, 1);
      if IOResult <> 0 then begin
        for Loop := 1 to ExtCount do begin
          Assign(TargetFile, Target + '.' + Int2Str(ExtCount));
          Erase(TargetFile);            { erase all incomplete files }
        end;                            { for }
        SplitFile := 2;                 { can make output file }
        Exit;
      end;                              { if }
    end;                                { if }
  until (BRead = 0) or (BRead <> BWrite);
  FreeMem(FileBuf, MaxWordSize);       { dellocate big buffer }
  Close(SourceFile);
  if FileSize(TargetFile) = 0 then
    Erase(TargetFile)
  else
    Close(TargetFile);
  GotoXY(WhereX + Length(StrSize) + 18, WhereY);
  Writeln('finished.');
  if BRead <> BWrite then
    SplitFile := 5                      { target disk is full }
  else
    SplitFile := 0;                     { split successful }
end; { SplitFile }

procedure Usage;
{ displays a syntax screen if no parameter or invalid parameter is specified }
begin
  Writeln('Usage: SPLIT [source_file] [target_file] [options]');
  Writeln;
  Writeln('  source_file      (drive:\path\) source file to split');
  Writeln('  target_file      (drive:\path\) target file name (optional)');
  Writeln('  options          any of the below options (optional)');
  Writeln;
  Writeln('Available options: (use either / or -)');
  Writeln('  /n    number of files to create (default: /n2)');
  Writeln('  /s    size limit (in bytes) of all files');
  Writeln('  /v    turn verify on when creating files');
  Writeln;
  Writeln('Examples:');
  Writeln('  SPLIT wp.zip /s362492 /v  ;splits WP.ZIP into separate files with each');
  Writeln('                            ;file containing no more than 362492 bytes.');
  Writeln;
  Writeln('  SPLIT myprogs.zip /n3 /v  ;splits MYPROGS.ZIP into 3 separate files with');
  Writeln('                            ;each file having approximately the same size.');
  Writeln;
  Writeln('Notes:');
  Writeln('  SPLIT.EXE is a free program, copy and distribute it freely among friends');
  Writeln('  and others if you wish. There is no charge, neither there is a warranty.');
  Halt;
end; { Usage }

var
  InFile: string;
  OutFile: string;
  Verify: boolean;
  Results: byte;
  BeginTime: longint;

procedure Initialize;
{ Setup default values, process the command line }
var
  I: byte;
  Error: integer;
  WorkStr: string;
begin
  if ParamCount = 0 then
    Usage;
  UseVerify := False;
  UseLimit := False;
  InFile := ParamStr(1);
  if ParamCount > 1 then begin
    OutFile := ParamStr(2);
    if (OutFile[1] in ['/', '-']) then
      OutFile := InFile;
                           { possibility of bugs around here! }
    if ((OutFile[2] = ':') and (Length(OutFile) < 4) or
        (OutFile[3] = '\')) or (OutFile[Length(OutFile)] = '\') then begin
      FSplit(InFile, Dir, Name, Ext);
      OutFile := OutFile + Name;
    end;                                { if }
  end else
    OutFile := InFile;
  for I := 2 to ParamCount do begin
    WorkStr := ParamStr(I);
    if WorkStr[1] in ['/', '-'] then begin
      case UpCase(WorkStr[2]) of
        'V': begin
          GetVerify(Verify);
          SetVerify(True);
          UseVerify := True
        end;
        'S': begin
          Delete(WorkStr, 1, 2);
          Val(WorkStr, SizeLimit, Error);
          if Error <> 0 then begin
            Writeln;
            Writeln(^G'invalid size (', WorkStr, ')');
            Halt;
          end;                          { if }
          UseLimit := True;
        end;
        'N': begin
          Delete(WorkStr, 1, 2);
          Val(WorkStr, DefNum, Error);
          if Error <> 0 then begin
            Writeln;
            Writeln(^G'invalid number of files (', WorkStr, ')');
            Halt;
          end;                          { if }
          if DefNum > 20 then begin
            Writeln;
            Writeln(^G'too many files to make (', DefNum, ')');
            Halt;
          end;                          { if }
        end else begin
          Writeln;
          Writeln(^G'invalid option (', WorkStr, ')');
          Halt;
        end;                            { else }
      end;                              { case }
    end;                                { if }
  end;                                  { for }
end; { Initialize }

begin                                   { main program body }
  Writeln('SPLIT  Version ', Version, '   by Toupao Chieng     04/16/91');
  Initialize;
  Writeln;
  Writeln('Source filename: "', Upper(InFile), '"');
  BeginTime := GetClock;
  Results := SplitFile(InFile, OutFile, DefNum);
  if UseVerify then
    SetVerify(Verify);
  if Results <> 0 then begin
    Writeln(^G);
    case Results of
      1: Writeln('Can''t open source file!');
      2: Writeln('Can''t make output files!');
      3: Writeln('Not enough space on target drive!');
      4: Writeln('^C - User break!');
      5: Writeln('Can''t write. Disk is full!'); { should never occur here! }
      6: Writeln('Not enough memory tTITLE:         SNR.EXE             VERSION: 4.0

PURPOSE:       Multiple simultaneous Search 'N' Replace program

DATE:          7/19/90

AUTHOR:        THOMAS A. LUNDIN
               c/o Graphics Unlimited Inc.
               3000 Second Street No.
               Minn