
#include <stdio.h>
#include <math.h>
#include <stdarg.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdlib.h>


/* --------- program to make binary data files for PLOTTER ------------- */
/* ------- to use, modify function f() as desired and recompile -------- */


float f(float x, float z)
{
  float a,b,c,d,e;

  a = (float)(x*x+z*z);
  b = (float)sqrt(a);
  c = (float) fabs(cos(7.0*b));
  d = sqrt(c);
  if (fabs(1.0 + 30.0*a) <= 10e-4) {
    printf("Denominator near 0\n");
    printf("x = %.2f, z=%.2f, b = %.2f, c = %.2f\n",x,z,b,c);
    getch();
  }
  e = (float)(((2.0*d))/(1.0 + 30.0*a));
  return e;
}

#define MAXDIV  101
int getint(char *x, ...);     /* extract ints from string s */
int getfloat(char *x, ...);   /* extract floats from string s */

main()
{
  FILE *fp;

  int i,j,num;
  float deltaX, deltaZ;
  float X[MAXDIV],Z[MAXDIV];
  float Y[MAXDIV][MAXDIV];

  float Xmin,Xmax,Zmin,Zmax;
  int numX,numZ;
  char filename[32];
  int theta0=0,alpha0=0;
  char title[71],s[80];

  clrscr();
  while (1) {
    printf("\tEnter name for data file: "); gets(filename);
    if (!filename[0]) exit(0);
    printf("\tEnter function title (formula, etc. 70 chars max:\n\t"); gets(s);
    j=strlen(s);
    for (i=0; i<j; i++) title[i] = s[i];
    for (i=j; i<70; i++) title[i] = ' ';
    title[70] = 0;              /* cut off after 70 characters */
a:
    printf ("\tEnter Xmin, Xmax, Zmin, Zmax: "); gets(s);
    if (!s[0]) exit(1);
    if (getfloat(s, &Xmin, &Xmax, &Zmin, &Zmax) != 4) {
      printf("\tPlease reenter\n");
      goto a;
    }
b:
    printf("\tEnter number of x_divs, y_divs: "); gets(s);
    if (!s[0]) exit(0);
    if (getint(s, &numX, &numZ) != 2) {
      printf("\tPlease reenter\n");
      goto b;
    }
    printf("\tEnter default angles theta and alpha (-45 to 45): "); gets(s);
    if (!s[0]) exit(0);
    if (getint(s, &theta0, &alpha0) != 2) {
      printf("\tPlease reenter\n");
      goto b;
    }
    printf("\tEvaluating ");
    deltaX = (float)(Xmax - Xmin)/(numX-1);
    deltaZ = (float)(Zmax - Zmin)/(numZ-1);
    for (i=0; i<numX; i++) {
      X[i] = Xmin + i*deltaX;
    }
    for (i=0; i<numZ; i++) {
      Z[i] = Zmin + i*deltaZ;
    }
    for (j=0; j<numZ; j++) {
      for (i=0; i<numX; i++) {
        Y[j][i] = f(X[i],Z[j]);
      }
      printf("*");
    }
    printf("\n\tWriting ");
    fp = fopen(filename,"w+b");
    fwrite(title, sizeof(char), 70, fp);
    fwrite(&numX, sizeof(int), 1, fp);
    fwrite(&numZ, sizeof(int), 1, fp);
    fwrite(X, sizeof(float), numX, fp);
    fwrite(Z, sizeof(float), numZ, fp);
    for (j=0; j<numZ; j++) {
      fwrite(&Y[j], sizeof(float), numX, fp);
      printf(".");
    }
    fwrite(&theta0, sizeof(int), 1, fp);
    fwrite(&alpha0, sizeof(int), 1, fp);
    fclose(fp);

    printf("\n\n\tPress R to repeat, else to quit... "); i = getche();
    printf("\n");
    if (i != 'r' && i != 'R') break;
  }
}


/*
   extract integers from string s, put them into specified variables
   arguments should be pointers to ints, e.g. getint(s,&x1,&x2,&x3).
   Assumes numbers are written in standard ASCII form: no isolated or repeated
   minus signs, no decimals, no spaces inside numbers, no exponents, etc.
*/

int
getint(char *t, ...)
{
  int cnt=0;
  char *p,s[80];
  int *arg;
  va_list ap;

  s[0] = ' '; s[1] = '\0';
  strcat(s,t);             /* be sure string starts with a space */
  va_start(ap,s);
  p = s;
  while ((arg = va_arg(ap, int *)) != NULL)
    {
     /* move past invalid numerical characters */
a:
     while (*p && !isdigit(*p) && *p != '-') p++;
     if (!*p)
       break;
     /* minus signs must be preceded by a space, followed by a digit */
     if (*p == '-') {
       if (*(p-1) != ' ' || !isdigit(*(p+1))) {
         p++;
         goto a;
       }
     }
     *arg = atoi(p);
     if (*p == '-') p++;                 /* skip leading minus sign */
     while(isdigit(*p)) p++;             /* move through remaining valids */
     cnt++;                              /* finished with current number */
    }
  return cnt;
}

/* 
   extract float values from string s, put them into specified variables
   arguments should be pointers to floats, e.g. getfloat(s,&x1,&x2,&x3)
   assumes numbers are written in standard ASCII form: no isolated or repeated
   minus signs or decimals, no spaces inside numbers, no exponents, etc.
*/

int
getfloat(char *t, ...)
{
  int cnt=0;
  char *p,s[80];
  float *arg;
  va_list ap;

  s[0] = ' '; s[1] = '\0';
  strcat(s,t);             /* be sure string starts with a space */
  va_start(ap,s);
  p = s;
  while ((arg = va_arg(ap, float *)) != NULL)
    {
     /* move past invalid numerical characters */
a:
     while (*p && !isdigit(*p) && *p != '-'&& *p != '.')
       p++;
     if (!*p)
       break;
     /* decimal points must be preceded by a digit or a space and followed
        by a digit or space */
     if (*p == '.') {
       if ((*(p-1) != ' ' && !isdigit(*(p-1))) ||
          ((*(p+1) != ' ' && !isdigit(*(p+1))))) {
         p++;
         goto a;
       }
     /* and if preceded by a space, must be folloewd by a digit */
       if (*(p-1) == ' ' && !isdigit(*(p+1))) {
         p++;
         goto a;
       }
     }
     /* minus signs must be preceded by a space and followed by a digit */
     if (*p == '-') {
       if (*(p-1) != ' ' || !isdigit(*(p+1))) {
         p++;
         goto a;
       }
     }
     *arg = atof(p);
     if (*p == '-' || *p == '.') p++;     /* skip leading minus or decimal */
     while(isdigit(*p) || *p == '.') {
      if(*p == '.' && !isdigit(*(p+1))) {
        p++;
        continue;
      }
      p++; /* move through remaining valids */
    }
   cnt++;                               /* finished with current number */
  }
  return cnt;
}

