/* 
 * Simple example of a program to generate a data file for a round explosion 
 * for EXPLOD.EXE.  Use a command similar to "cc example.c" to compile, and
 * the command "example >circle.dat" to run.  Run EXPLOD.EXE with the command
 * "explod circle.dat" to see the results.
 */

rnd (maxval)
{
#   define MAX_RAND 32768       /* max value returned by rand() */
    long l = (long) maxval * rand() / MAX_RAND;
    return ((int) l);
}

main ()
{
#   define XSIZE 200
#   define YSIZE 120
    int dest_x, dest_y;
    int i = 0;

    /* Print the file header */
    printf ("# EXPLOD DATA FILE generated by example.c\n");
    printf ("300  # number of points\n");
    printf (" 50  # number of frames\n");
    printf ("  9  # gravity\n");
    printf ("  0  # wind\n");
    printf ("  2  # trail length\n");

    for (i=0; i<300; i++)   /* loop to generate 300 points */
    {
        /* Find a dest coordinate inside the ellipse of size (XSIZE, YSIZE) */
        while (1)
        {
	    /* Generate a point */
            dest_x = rnd (2*XSIZE) - XSIZE;
            dest_y = rnd (2*YSIZE) - YSIZE;

	    /* Accept the point if it is within the oval */
	    if ((long) YSIZE * YSIZE * dest_x * dest_x  +  
	 	(long) XSIZE * XSIZE * dest_y * dest_y  
		<  (long) XSIZE * XSIZE * YSIZE * YSIZE)
		break;
        }
	printf ("0 0  %d %d\n", dest_x, dest_y);
    }
}
