


            PrintCADD - 3D Reference Guide

        Copyright 1991, Birdseye Software Ltd.
		
		   9610, 153 Street
		   Edmonton, Alberta, Canada
		   T5P 2A3
		 
		   Phone (403) 484-3540



                     CONTENTS


 Introduction - Foreword
		  - What is Shareware
		  - Disclaimer
		  - Registration form
		  - Distribution agreement
		  - Notational Conventions
		  - Abbreviations

    Chapter 1 - 3D Geometry and Coordinate Systems

		  - Axes
		  - UCS
		  - Units of Measurement
              - Surfaces
               
    Chapter 2 - Starting Up

		  - Required hardware
		  - Required files
		  - Installation
		  - General control
		  - Menu types
		  - Readouts
		  - Command execution
		  - Help System
		  - Tutor System

    Chapter 3 - Menus and Commands Reference

		  - Main menu
		  - Draw menu
			- Snaps
			- Locks
			- Typed coordinates
			- Polar coordinates
		      - Transparent commands
			- Cursor stepping
		  - File menu
			- Creating drawings and fonts
			- Loading drawings and fonts
			- Purging files
		  - Line menu
			- Lines
			- Triangles
			- Rectangles
			- Parallelograms
		  - Curv menu
			- Circles
			- Arcs
			- Ellipses
			- Spline curves
		  - Text menu
			- Box text
			- Left justified
			- Right justified
			- Centered
			- Between
			- Font selection
		  - Dims menu
			- Alined dimensioning
			- Horizontal dimensioning
			- Vertical dimensioning
			- Angular dimensioning
			- Dual dimensioning
			- Arrow styles
			- Dimension text alignment
		  - Grup menu
			- Selection sets
			- Moving
			- Scaling
			- Rotating
			- Copying
			- Changing 
			- Deleting
		  - Surf menu
			- Extrusions
			- Joined surfaces
			- Cut surfaces
			- Revolved surfaces
			- Radial arrays
			- Parts system
		  - Colr menu
			- Line color
			- Line style
			- Pattern colors
			- Pattern styles
			- Pattern editing
		  - Layr menu
			- Selecting layers
			- Creating layers
			- Locking layers
		  - Mdfy menu
			- Moving points
			- Stretching
			- Surfacing
			- Deleting
		  - Vars menu
			- Readout controls
			- Cursor style and size
			- Blips
			- Drawing sizing
			- Limits
			- Automatic sizing
		  - Zoom menu
			- Zooming
			- Scaling
			- Panning
			- Recentering
		  - Rdrw menu
			- Redrawing
			- Regenerating
			- Hidden line
			- Rendering
		  - View menu
			- View rotations
			- Plan views
			- Aimed views
			- UCS views
		  - Wndw menu
			- Multiple windows
			- Creating windows
			- Resizing windows
			- Parallel and perspective views
			- Aspect
		  - UCS menu
			- 3 point coordinate systems
			- UCS to view
			- Units control
			- Grids
		  - Touchup menu
			- WARNING ! Read documentation before using
			- File data will not be retained while in use
		  - PrintEd menu
			- High resolution bitmaps
			- Free hand drawing
			- Printfile touchup
		  - Print menu
			- Ports
			- Selecting print drivers
			- Color interpretation
			- Window dumps
			- High resolution print plots (Printfiles)
		  - Plot menu
			- HPGL 
			- Plotting
			- Plot drivers
			- Plot files
			- Scaling
		  - Driver menu
			- Create new print drivers
		  - System menu
			- Set your colors
			- Set mouse and keyboard
			- Set directories
			- Set optimizations
		  - Help menu
			- Context sensitive help
			- Indexed help
			- Fully transparent - available at all times
			- Tutor system
			- Make your own help files

    Chapter 4 - File makeup
		  - Drawing files 
		  - Learn what the file is made of
		  - Font files
		  - Part files


Note: To make the reference guide easier to update, I have 			taken out the page numbers.  The user should load this document to their
favorite word processor and format it before printing.  In
certain instances this guide will refer to pictures and 
diagrams.  These diagrams are included in the "tutor*.gvf"
files and can be loaded into view within PrintCADD 3-D 
itself.
	
------------------------------------------------------------
                    Introduction
------------------------------------------------------------

Foreword:

      From the beginning, the difference between mankind
and other species has been, the ability to create devices
that extend our capabilities beyond what is given to us
at birth.  We make clothes and homes to protect us from
the elements, roads and cars to make us faster, cranes
and bulldozers to give us strength and telescopes and
radios to extend our senses.  This obsession with
building and creating is what truly separates us from
other forms of life.
      With the advent of the computer this ability to
create has been greatly enhanced.  Computer aided
drafting and design allows us an outlet for our creative
energies and allows us to see errors in our design
process before they become too costly.
      "Costly" is the main reason why PrintCADD-3D was
designed.  With most three dimensional drafting and
design systems running into thousands of dollars, a lot
of people with creative talents or valid CADD needs are
eliminated from being able to use this technology. 
	 PrintCADD-3D allows people to use this technology
without the expense.
      I hope that you will find this program useful.

      Thankyou for the support,



      Greg Bone (Author and Programmer of PrintCADD-3D)


What is Shareware

	Shareware distribution gives users a chance to try 
software before buying it. If you try a Shareware program
and continue using it, you are expected to register. 
	Copyright laws apply to both Shareware and commercial
software, and the copyright holder retains all rights, with 
a few specific exceptions as stated below. 
	Shareware is a distribution method, not a type of 
software. You should find software that suits your needs and
pocketbook, whether it's commercial or Shareware. The 
Shareware system makes fitting your needs easier, because 
you can try before you buy. And because the overhead is low, 
prices are low also.  Shareware has the ultimate money-back 
guarantee -- if you don't use the product, you don't pay for
it.

Disclaimer

Users of PrintCADD 3-D must accept this disclaimer of warranty:

"PrintCADD 3-D is supplied as is.  The author disclaims all
warranties, expressed or implied, including, without 
limitation, the warranties of merchantability and of fitness 
for any purpose.  The author assumes no liability for damages, 
direct or consequential, which may result from the use of 
PrintCADD 3-D."

	PrintCADD 3-D is a "shareware program" and is provided 
at no charge to the user for evaluation.  Feel free to share 
it with your friends, but please do not give it away altered 
or as part of another system.  The essence of "user-supported" 
software is to provide personal computer users with quality 
software without high prices, and yet to provide incentive 
for programmers to continue to develop new products.  If you 
find this program useful and find that you are using 
PrintCADD 3-D and continue to use PrintCADD 3-D after a 
reasonable trial period, you must make a registration payment 
of $75.00 to Birdseye Software Ltd..  The $75.00 registration 
fee will license one copy for use on any one computer at any 
one time.  You must treat this software just like a book.  An 
example is that this software may be used by any number of 
people and may be freely moved from one computer location to 
another, so long as there is no possibility of it being used 
at one location while it's being used at another.  Just as a 
book cannot be read by two different persons at the same time.
	Commercial users of PrintCADD 3-D must register and pay 
for their copies of PrintCADD 3-D within 30 days of first use 
or their license is withdrawn.  Site-License arrangements may 
be made by contacting Birdseye Software Ltd..
	Anyone distributing PrintCADD 3-D for any kind of 
remuneration must first fillout and send a copy of the 
distributers form to Birdseye Software Ltd. at the address at
the top of the manual for authorization. This authorization 
will be automatically granted to distributors recognized by 
the (ASP) as adhering to its guidelines for shareware 
distributors, and such distributors may begin offering 
PrintCADD 3-D immediately (However Birdseye Software Ltd. must 
still be advised so that the distributor can be kept up-to-date 
with the latest version of PrintCADD 3-D.).
	You are encouraged to pass a copy of PrintCADD 3-D along
to your friends for evaluation.  Please encourage them to 
register their copy if they find that they can use it.  All 
registered users will receive a copy of the latest version of 
the PrintCADD 3-D system, a manual, 1/2 hour of support and 
the removal of the registration reminder screen from the 
program.
	To order PrintCADD 3-D, you can use the form built into 
the PrintCADD 3-D help system.  The form may be printed by 
pressing the "F3" function key at each of the three help pages 
that contain the form.
	You may also print a copy of the following form if you 
wish.  Check off the item and optimizations and fill out the 
rest of the form.

Registration form

PrintCADD 3-D Order and Registration Form
=========================================

PrintCADD 3-D Registration Pak:  ( )

Includes: Manual, 1/2     $ 75.00 U.S.
	    hour support
	    optimized       $ 85.00 Can.
	    version of
	    PrintCADD 3-D

Optimized disk only:             ( )

Includes: One optimized   $ 25.00 U.S.
	    version of 
	    PrintCADD 3-D   $ 30.00 Can.

------------------------------------------

Optimizations:

LIM 4.0 ( )  286,386,486 ( )  NoMath ( )

Math CoProcessor ( )  No Optimize  ( )

------------------------------------------

Disk Size: 5.25" 360 K ( )  1.2 Meg  ( )

	     3.5"  720 K ( )  1.44 Meg ( )

------------------------------------------

Payment by: Cheque ( )  Visa ( )  MC ( )

Card #:___________________________________

Expiry Date: Month ________ Year _________

Signature: _______________________________

------------------------------------------

Name:        _____________________________

Address:     _____________________________

City, State: _____________________________

Zip Code:    _____________________________

Phone #:     _____________________________

------------------------------------------

***** Postage and Handling included ******
*** Please allow 4 weeks for shipping ****

------------------------------------------


PrintCADD 3-D Distribution Licensing Agreement

    Anyone wishing to charge people a fee for giving them a 
copy of PrintCADD 3-D must have the written authorization of 
the author, without which, the distributor is guilty of 
copyright violation.  To receive such authorization, send 
this completed application, along with a copy of your 
software library's order form to:

	Birdseye Software Ltd.
	9610  153 Street
	Edmonton, Alberta, Canada
	T5P 2A3

    Include $7 to cover the cost of processing the
application and of sending you the latest version of 
PrintCADD 3-D. For distributors already recognized by the 
Association of Shareware Professionals, this application is 
not necessary.

Name of Organization: ____________________________________

Your Name: _______________________________________________

Address:   _______________________________________________
              
	     _______________________________________________

Terms of Distribution of PrintCADD 3-D:

1. The fee charged may not exceed $10, including postage,
   mailer and any other charges.

2. Your library's catalog or listing must state that this
   program is not free, but is copyrighted software that is
   provided to allow the user to evaluate it before paying.

3. The offering and sale of PrintCADD 3-D will be stopped at
   any time the author so requests.

4. Copies must be made from the copy of PrintCADD 3-D sent
   to you with this agreement. This is required for control.

5. Problems or complaints about the program will be reported
   to the author for investigation.

In return for a license to charge a fee for the distribution
of PrintCADD 3-D, I agree to comply with the above terms of
distribution.

         Signed,


______________________________________    ______________
         your signature                        date


__________________________   _________    ______________
       Greg Bone             control #         date



Notational Conventions:


      In order to read this manual it is necessary
that you understand the references to the different
commands.  The menus contained within PrintCADD 3-D
form a "path" system where one menu leads to the next
menu and so on until the end of the path is reached at
which time the "command" is performed.
      There are three conventions used in this manual
to convey the "path" that the user must follow in
order to perform the "command".
1 -    Square brackets "[" and "]" denote the
      selection of a "main" menu item.  eg. [Edit]
      means select "Edit" from the "main" menu.
 
2 -   Curly braces, "{" and "}" at either end of a
      word denote a preview or drop down menu
      selection.  eg {CAD/CAM} means select the
      "CAD/CAM" menu.

3 -   Brackets, "<" and ">" at either end of a word
      denote a "bracket" menu selection.  eg <X Scale>
      means select "X Scale" from the "bracket" menu.

      eg.  [Edit] {CAD/CAM} {Vars} {Cursor} <3-D>     
      means select the "Edit" menu from the "main"
      menu, then select "CAD/CAM" from the "Edit" menu
      that appears, then select "Vars" from the
      "CAD/CAM" menu that appears, then select
      "Cursor" from the "Vars" menu that appears and
      finally select "3-D" from the "Cursor" bracket
      menu that appears.



Abbreviations used in this manual:

UCS  - User coordinate system

MLB  - Mouse Left Button

MRB  - Mouse Right Button

------------------------------------------------------------		Chapter 1 - 3-D Geometry and Coordinate Systems
------------------------------------------------------------

Axes

      Three dimensional drafting offers the advantage
of creating more than one view out of a given drawing. 
You are actually constructing a model rather than a
drawing a view.  As such, the process is somewhat more
time consuming than standard 2-D drafting but not
overly slow.  You will be rewarded for your effort
with an actual model that can be displayed and printed
from almost any angle or distance.  This also reduces
the errors as the process is similar to actual
construction and clearances and design flaws are much
more apparent.  There is no doubt that in the long run
3-D drafting and modelling will save you time, money
and effort.
      Normal 2-D drafting requires the use of two axes
named X and Y.  The X axis is considered the horizontal 
axis and Y the vertical axis.  Three dimensional drafting 
requires a third axis called Z.  Z is considered the depth 
axis. 
      Normally when looking at a drawing we consider the 
X axis to increase in value as it goes to the right and 
the Y axis to increase in value as it goes up.  In this 
way we can define any point on a sheet of paper. This is 
also true of the "top plan", default view in PrintCADD 3-D. 
      In PrintCADD 3-D the Z axis increases in value
as the cursor moves towards the viewer.  This allows
the user to define any point in three dimensional
space.
      Consider though what happens when you decide to
view the object from a front view.  The X axis still
increases in value from left to right but the Z axis
increases in value as you go up the screen and the Y
axis increases in value as the cursor goes away from
the viewer.
      This can be very confusing especially
considering there are literally an infinite number of
views of any given object.  Fortunately there is a
better way for the user to enter the points that he
wishes into the computer.  This is known as a user
coordinate system.

UCS

      User coordinate systems allow the user to tell
the computer which way he wishes the X, Y and Z axes
to run and where the 0 or origin point should be.  The
user can set up a new coordinate system at any time
and thus work according to the current view rather
than having to transpose coordinates into the system
ie two inches up the left means two inches deep and so
on.
      Another ability of the UCS is that since it can
be set in any direction you could for instance set it
so that the X axis ran along the bottom edge of a roof
while the Y axis would run from the bottom corner of
the roof to the top corner of the roof.  The origin
could be a corner of the roof.  You could then easily
draw a skylight on the surface of the roof and be
guaranteed that all measurements are in relation with
the surface of the roof.   
      There are several concepts pictured in figure 2
to make note of.  The first is that most of the
drawing commands make use of the current UCS for
positioning.  Notice how the circle hugs the surface
of the roof.  This is because corner A was selected as
the UCS origin, corner B was selected as a point along
the X axis and corner C was selected as a point in the
positive Y plane.  Thus when you press your right or
left arrows (or move your mouse left or right) the
cursor will travel parallel to the line between A and
B.  If you press your up and down arrows the cursor
will travel parallel to the line between A and C.  If
you press your numeric keypad + and - keys you will
move at right angles to the surface formed by A B C.
Notice how the three lines of the 3-D cursor point in
the directions of movement.  Another point is that the
readouts at the bottom of the screen, will express
these distances along these axes as offsets from
corner A.  Notice that Z = 0 so the cursor is
travelling neither above or below the surface of the
roof. 
      You may also notice that the letters in the
corners of the surfaces lie on the surfaces they
represent ie A, B and C lay on the surface of the roof
while D, E and F lie on the front of the house and G,
H and I lie on the side of the house.  The word
Skylight however remains parallel to the edges of the
screen because the UCStoView command was used before
creating it.  Likewise dimensions, rectangles,
circular curves and ellipses are modified by the
current UCS.  The degree to which each command is
modified is discussed in the menus section of the
manual.
      The {Edit} {CAD/CAM} {Surf} {Thickness} command
is also modified by the UCS as the direction of the Z
axis determines the direction in which {Thickness} is
applied to a surface.
      The last item to notice in the drawing is that
you may work in any view of a drawing including
perspective views.  This allows great flexibility in
establishing several different UCS's in one view.  The
drawing of the house was created in less than 5
minutes because once the view was established it was
easy to set up the UCS D-E-F to draw the door and
front window, the UCS G-H-I to draw the side windows
and the UCS A-B-C to draw the skylight.  Also the
cursor will grow smaller or larger in size as it goes
further from or closer to the view point making it
easier to judge where you are in the drawing.  You may
even set up other views of the same object in
different windows and because the cursor is shown in
all views you will know if you are connecting to the
right point.  Each view may even have a different UCS
so that in one window you can work on the side of the
house while in another you could work on the roof. 
      UCS's may seem a little complicated at first but
once you realize there usefulness your job will become
much easier.

Units of Measurement

      Another topic to be covered in this chapter is
units of measurement.  Units control the dimensioning and
measurement of an object as well as the coordinate
readouts at the bottom of the screen.  They also
control the way user input is interpreted by the
system.  This is usually called "parsing".
      The internal composition of the file is known as
homogenous.  Homogenous means that when coordinates
are entered into the system the UCS is taken into
account and the numbers are converted to an internal
floating point format.  The format would be as if
looking at the drawing from top plan view.  When a
view is required the angle of the view is taken into
account and the top plan view of the drawing file is
read and converted to this different view.  When a
readout or dimension is needed by the user then the
angle of the UCS is taken into account and the top
plan view of the drawing file is converted as before.
The point is, that the internal format can be looked
at in a number of different ways. 
      The {Units} and {UCSAbsRel} commands also
control the way this drawing file is looked at.  The
{Units} command has three basic modes - inch,
centimeter and generic.  In inch mode the drawing file
is interpreted as inches with 1.000000 being equal to
1 inch.  If the {Units} command was set to a
centimeter mode then the 1.000000 internal format
would be converted by multiplying by 2.54 to render
centimeters.  It would also divide user given
coordinates by 2.54 to convert the centimeters given
into the inch format of the database.  This allows
dual dimensioning.  The generic mode allows a way to
use any measurement you wish.  As the numbers are not
formatted on input or output but simply taken as the
number given, you can use the {Edit} {CAD/CAM} {Dims}
{Pre/Suffix} command to express the units you are
working in.  In this manner 1.000000 could be light
years or angstroms.
      The {Edit} {CAD/CAM} {Vars} {UCSAbsRel} command
controls what the readouts will be showing.  If you
select < UCS Absolute > the readouts will show the
cursor's distance along each of the UCS axes from the
origin.  If you select < UCS Relative > you will see
the distances along each UCS axis relative to the last
point entered into the system.  Selecting < Database >
will allow you to see the homogenous coordinates of
the cursor ie the coordinates that PrintCADD 3-D would
store internally.
      The final point deals with the way PrintCADD 3-D
looks at rotations.  PrintCADD 3-D uses the right hand
rule.  Normally when rotations are applied to objects 
on the screen you will be asked for two endpoints of an 
axis to rotate the object about. The second endpoint is 
taken by the system to represent the positive direction 
of the axis.  By placing your right hand so that the 
fingers wrap around the axis and your thumb points in 
the positive direction alongthe axis then your fingers 
will show you the directionof rotation.  When dealing 
with polar coordinates the system uses the UCS Z axis 
for the right hand rule.

Surfaces

      In PrintCADD 3-D all components of the drawing
are grouped into surfaces.  This includes all geometry
such as lines and curves as well as text and
dimensions.  In some instances the geometry may be
broken down into more than one surface.  An example of
this is dimensions where the arrows are on one
surface, the leaders or dimension lines are on another
and the text is on yet another.  This allows you to
manipulate the text without affecting the arrows and
vice versa.  Most surfacing of geometry occurs
automatically within PrintCADD 3-D but there are also
ways to override the process in order to create your
own surface groupings.
      There are three basic types of surfaces in 
PrintCADD 3-D.  The three types are "closed", "open"
and "current".  The "open" type is not considered in
hidden line elimination and geometry may be of any
type and does not neccesarily have to lie on a single
plane.  The "closed" surface must enclose an area and
all points on the surface must be co-planar ie laying
on a single plane.  The "current" surface type is
assigned to the group of lines that lies between the
last "open" or "closed" surface and what the user is
currently constructing.
      Surfaces also control the assignment of layer,
line color, line style, fill color and fill pattern
attributes thus all geometry that lies on a single
surface will be of the same layer, color, style and
pattern.
      PrintCADD 3-D automatically assigns the "closed"
surface type to rectangles, parallelograms and circles
or ellipses with 360 degrees or more of arc.  All
[Edit] {CAD/CAM} {Surf} commands also assign the
"closed" surface type to surfaces constructed as a
result of the command.  The "open" surface type is
automatically assigned to all text strings and
dimensions.  If one of these automatically assigned
entities is drawn, then the "current" surface is
collected into a single "open" surface and is assigned
the current layer, style, pattern and colors.  The
automatically assigned surface, (Rectangle,
parallelogram, circle, text, dimension), being drawn
is also assigned these attributes.
      By use of the {Mdfy} {SurfLast} command you may 
assign either a "closed" or "open" surface type to the
current" surface.
      All surfaces also have a center or fill point. 
On closed surfaces this point must lie in the interior 
of the surface and be co-planar with all other points 
of the surface.  By careful use of the {UCS} and {Mdfy}
 {MovCentPt} commands you can guarantee the alignment 
of this point.  (Automatic closed surfaces center this 
point properly without user intervention)
      It is important to realize the exact nature of 
the surface groupings performed by PrintCADD 3-D in 
order to obtain properly constructed drawings.
      In figure 4 a rectangle (A) is drawn and 
PrintCADD 3-D assigns the "closed" surface type.  Then 
two lines and an arc (B) are drawn and collected into 
the "current" surface. When the 360 degree circle (C) 
is drawn, PrintCADD 3-D assigns the "open" surface type
to "current" surface (B) and then the "closed" surface 
type to (C).  Thus in effect the circle command (C) has 
created two surfaces, the unassigned "current" surface 
consisting of two lines and the arc and the 360 degree 
circle surface.  The two surfaces are then assigned 
thickness with the {Edit} {CAD/CAM} {Surf} {Thickness} 
command and a hidden line view (Figure 5) is rendered 
with the{Edit} {CAD/CAM} {Rdrw} {QuickHide} command.  
Notice that surface (B) has not been considered for 
this view because it is now an "open" surface but the 
surfaces that constitute its "thickness" have been 
assigned the"closed" surface type.
      The {Thickness} command whose effects are shown 
in figure 5 points to another important concept of 
three dimensional geometry - extruded surfaces.  
Extruded surfaces or extrusions are simply the extension
 of a surface along a path (Normally the UCS Z axis) 
into three dimensional space.
      PrintCADD 3-D handles this by breaking down the
surface into its individual line segments and then 
forming a parallelogram by taking the two endpoints of 
the line segment and moving them in the direction and 
the distance of the extrusion to form two more corner 
points.  The two original endpoints and the two extruded 
endpoints are then joined to form the extruded sides of 
the surface.  This continues with each line segment of 
the surface until all sides of the surface are formed.  
Finally a copy of the original surface is made and 
placed at the extrusion distance and direction thus 
forming a 3-D object.
      
------------------------------------------------------------
	Chapter 2 - Starting Up
------------------------------------------------------------

Required Hardware

	This system has been designed to work on an IBM 
(TM) or IBM comatible computer system.  The system 
requires a VGA or EGA video adaptor and 540 K of "free" 
RAM.  Birdseye software also manufactures versions of 
this software that can use (LIM 4.0 and higher) expanded 
memory.  This will cut down substantially on the amount 
of "free" RAM required thus allowing more TSR programs 
or utilities.  The program "will" load up in 
environments that do not have enough memory so refer to 
the [File] {DOScoms} <MemLeft> command to decide if you 
do indeed have enough memory available.  Also see this 
command in the help system.  Erratic behaviour may 
result if the value given is below 48000.  Any user 
that has 640K of RAM should be able to reduce their 
environment needs to operate this program.  For 
instance, DOS 4.01 with expanded memory manager, ramdisk 
driver, himem driver, diskcache driver and mouse should 
be able to operate quite easily, however, if the 
DOS 4.01 file management utility, "Shell" or other 
similar utility is installed, the memory may fall below 
requirements.

Required Files

	This system relies on several files to operate 
successfully.  The files and what they do, are listed 
below.

README.DOC   - A brief description file.  All addendums to 				   the software will also be here.

PRCAD.DOC	 - This manual file.

PRCAD.EXE    - This file is the program.  Type "Prcad" 				   "Enter" to start.  The software will not
		   operate without this file.

PRCAD.HLP	 - This file is required when the help system is
		   accessed.

PRCAD.TUT	 - This file is required for the tutor system to
		   operate.

PRCAD.DEF	 - The software will automatically create this
		   file when PrintCADD is started for the first
		   time.  If this file is present before 
		   installation, then delete it!  This file may
		   contain configuration data that is not valid
		   for your system.

TUTOR*.GVF   - These files are drawing files that are 
		   required by the tutor system for the purpose 
		   of their lessons.

TUTOR*.LYR   - These files contain layer information for the
		   tutor drawing files.  They are required for the
		   the tutor drawing files to work properly.  If
		   these files are not available, simply make 
		   copies of a layer file from another drawing that
		   contains five or more layers and rename
		   them "TUTOR1.LYR", "TUTOR2.LYR" etc.  While the
		   layer names will not be correct, the system will 
		   be able to load and use the files.  This
		   process can be used on any drawing file. Just 
		   make sure the number of layers in the copied 
		   layer file meets or exceeds the number of layers 
		   in the drawing file that requires a layer 
		   information file.

The following files can be produced by the software.

*.GVF	 - These are drawing files.

*.LYR	 - These are layer information files.  Each 					   drawing requires one.  The name before the
		   extension in the drawing name and the layer
		   name must match.

*.FNT	 - These are fonts.  A minimum of one font is 				   required for text and dimensioning.

*.PRD	 - These are printer driver files.

*.PLD	 - These are plot driver files.

*.SRF	 - These are part files.  Each one holds an 					   individual part.

*.PFL	 - These files are produced by the system via the
		   [Output] {Print} {PrintFile} command.  Because
		   of the large amount of disk space required for
		   these files, there will be no samples of these 
		   files.  The user must create one to allow use 
		   of the [Edit] {PrintEd} command.  See [Output]
		   {Print} {PrintFile}.

*.HPG	 - These files are produced by the system when
		   the [Output] {Plot} <Port> option is set to
		   "File".

PAG*.2DF	 - These files are produced by the system when
		   additional buffer space is required to hold
		   all the elements of a drawing file.  These 				   files may be 		   deleted.

Installation

	PrintCADD 3-D has a very simple installation procedure.  
Simply copy the files that come with the system into their 
own directory, type "PRCAD" and press the "Enter" key.  The 
software will ask the user to select the appropriate video 
driver and reboot itself to this new video mode.  The user 
may then go to the [System] menu and set the default 
characteristics of the system. (See [System] Menu)

General Control

      PrintCADD 3-D has three basic modes of operation, 
menu mode, draw mode and keyboard mode.  If you see one of 
the menus described below you are in menu mode.  If you 
have a mouse installed you will also see an arrow shaped 
cursor.  
	Draw mode can be recognized by the appearance of a 
crosshair or box shaped cursor in the drawing window as well 
as aprompt appearing at the top of the screen followed by"@" 
eg. "Center point @".
      Keyboard mode can be recognized by the appearance of 
a prompt followed by either a greater than sign (>) or an 
equal sign (=).  When the prompt is followed by ">" then the 
system is expecting text input (eg. "Drawing name >").  When 
the prompt is followed by "=" then the system is expecting 
numeric input eg. "Zoom level =".  In either case anything
typed at the keyboard will appear to the right of the prompt 
and pressing the "Enter" key will send the users response to 
the system.   
      Menu mode is controlled by a series of drop
down, list, preview and bracket menus that offer the
user access to commands or selections that in turn may
make other menus available, prompt for user input or
perform the command directly.
      User input may be in the form of typed in text
and coordinates (keyboard mode), cursor selected
coordinates (draw mode) or list selection and bar menu
selected answers (menu mode).
      If you are using the keyboard you may select
commands and menus by using the right, left, up and
down arrow keys to select the menu item you are
interested in and then pressing the "Enter" or
"Return" key to perform the command.  Another way of selecting 
the command is to press the first letter of the command.  The 
highlight bar will jump to the closest selection that starts 
with that letter.  Again, the "Enter" key must be pressed once 
the command is highlighted.
      The "Escape" key is used to abort the command unless an 
explicit <Exit> or {Exit} command is available within the 
current menu. 
      If you are using the mouse you may select the
menu item by placing the mouse arrow on the command
and pressing the left mouse button to highlight the
command.  Once the command is highlighted you must
again press the left mouse button to invoke the
command.  Pressing the right mouse button or "MRB"
aborts the command in the same way as the "Escape"
key.  

Menu types

      The highlight bar on the main menu is controlled
by the left and right arrow keys.  A drop down sub
menu appears below the highlighted menu item.
      Drop down menus are controlled by the up and
down arrow keys to highlight the correct menu selection
and then the enter key is pressed to advance further
into the menu tree.
      Bracket menus are controlled by the left and
right arrow keys.  Once the correct menu item is
selected, enter is pressed to invoke the item.
      List menus are controlled by using the up and
down arrows to control the highlight marker.  If the
highlight is placed on the top or bottom list item
then the list will scroll up or down several items and 
allow you to proceed with your selection.  Pressing the 
"Enter" key will then select the item from the list.
      Preview menus are controlled by the up, down, left 
and right arrow keys.  As each selection is highlighted 
in the upper section a different set of selections 
appears in the lower box.  This allows you to preview 
the commands that are associated with the upper 
selections thus allowing easy perusal of the menu system.
Once you have selected the correct upper menu item you 
press enter to drop the highlight to the bottom menu.  
You may then select the correct command with the up and 
down arrows and invoke the command by pressing enter.  
Notice how selecting the {Rdrw} command in figure 12 
produces a different set of selections in the bottom menu 
than the {Dims} does in figure 13. Once in the bottom 
menu pressing escape will take you back to the top menu.  
Notice that there is an explicit {Exit} command in the 
top menu.  This prevents accidentally escaping from the 
preview menu. 
      You may also notice in figure 13 that there is a 
dashed line around the {Dims} command.  This allows you 
to know which upper command menu you are currently 
selecting from.  It takes a certain amount of practice 
to navigate these menus successfully but once mastered 
you will find that it is both easy and efficient to have 
the menus set up in this manner.  You will find that a 
mouse makes this process considerably easier.
      In "draw" mode you may control the cursor through 
use of the numeric keypad or mouse.  If you are using 
the numeric keypad make certain that the "Num Lock" key 
is off and refer to figure 8 for direction of movement 
for each key.  Pressing the key produces a {Grid Size} 
movement of the draw cursor along the UCS axis 
corresponding to that key.  If the "Shift" key is held 
down while the numeric keypad key is pressed the movement 
will be 10 x {GridSize} allowing you to move much quicker 
across the screen.
      Once you have positioned the cursor press the
"Enter" or "Mouse left button" to enter the
coordinates of the cursor into the system.  Remember
you may also press "Escape" or "Mouse right button" to
invoke a snap or enter the coordinate via "keyboard"
mode. 

Readouts

      PrintCADD 3-D keeps the user aware of a variety
of information through the use of readouts that change
depending on the current context of the system.
      There are three principle areas of the screen
that display this information.
      The bottom line of the screen is used to show
the current cursor coordinates while in the {Edit}
menu system. Remember that the coordinates displayed
here are in terms of the setting of the {Edit}
{CAD/CAM} {Vars} {AbsRelDBas} command.
      The top line of the screen displays information
that is pertinent to the {Main} menu, {Edit} menu and
{Output} {Print} menu depending on which is active. 
Certain "bracket" menus may also display information
on this line depending upon which information seems
relative to the menu.  Each of these readouts are
discussed in the menus and commands section under the
menu item that invokes them.
      The third area used for readouts is the top line
of each window which displays information that is
pertinent to that particular window and its view.  The
information in this area may be scrolled if the window
is too small to display all the information.  (See
{Edit} {CAD/CAM} {Vars} {WndwRdOut} in menus and
commands section)
      Keeping all this information on the screen may
seem confusing at first but once you get used to these
readouts and their purposes you will find that a lot
of mistakes can be avoided and that the software is in
fact, easier to use.

Command Execution

	All command references in this manual start at the 
main menu and work through the menu tree until the command 
itself is performed.  Although the complete tree is used 
in this reference, in fact, most commands can be accessed 
more directly by selecting another command within the 
current menu or by dropping down one or more levels and 
proceeding up another branch of the menu tree.

Help

	In addition to the other keys and their functions, 
the "F1" function key may be pressed at any time to access 
context sensitive help or the indexed help.  When the "F1" 
key is pressed, the software will display the menu, "Help
< Context > < Index > < Exit >".
	If the user selects <Context>, the system will display 
help on that particular section of the menu.  In most 
instances, the help will come up at the beginning of the 
help section devoted to that menu system rather than the 
command itself.  The user may have to page down a few pages 
to find the exact command.  The reason for this is that 
there may be important information at the beginning of the 
section that will be overlooked by going directly to the 
command.
	If the user selects the <Index> option, the system 
will display the help index.  Refer to the [Help] {Index} 
command for further information.
	If the user selects <Exit>, the system will return 
the user to the point where the help system was invoked.

Tutor

	The tutor system may be invoked at any time by 
pressing the "F2" function key.  The software will transport the user to where the lesson, that was in progress, was left off.  See [Help] {Tutor} for a complete explanation of this command.


------------------------------------------------------------
Chapter 3 - Menus and Commands Reference
------------------------------------------------------------

Main Menu
 
     The main menu appears on the top line of the
screen and allows the user access to the five sub
menus, [File], [Edit], [Output], [System] and [Help].
These five sub menus divide the software into
categories that roughly correspond to their names. 
	There is also one other menu system that may be
invoked when the system is in "Draw" mode.  "Draw"
mode can be recognized by the appearance of a cursor
in the current drawing window.  There will also be a 
prompt for some type of point selection ie "Select 
first corner point @","Select offset point @".  This 
menu may be accessed by pressing the escape key or 
the mouse right button.  You may recognize that 
several of the menu items seem the same as those in 
the [Edit] {CAD/CAM} menu.  The difference is that 
these selections are "Transparent".  For instance 
you may be prompted "Select start point" at which 
time you could press escape, select "Zoom Factor" to 
zoom in on a section of drawing and continue with 
selecting the point.
      Although this menu does not appear on the main 
menu further references to this menu will be termed 
[Draw].  This menu has many important features and 
will be discussed next.  Other main menu items will 
be discussed later in this chapter.
	
[Draw] Menu

      The first set of commands in the [Draw] menu
deal with snaps and locks.  Snaps will actually enter
the point selected into your drawing file while locks
confine the cursor movement to a certain path but do
not enter a point until the enter key is pressed.
Snaps and locks offer a great deal of power and should
be mastered.  Three dimensional snaps are slightly
different from their 2-D counterparts and therefore
act somewhat differently.  What is important to keep
in mind is that a point that is selected may be a
point that lies at a different depth than what you
appeared to select.  By having several different
windows with different view angles this problem can be
kept to a minimum ie if the selection cursor appears
at the correct point in all views you have selected
the correct point.
      Other commands in this menu allow transparent
zooming and panning while another set of commands
allow typed in coordinates.
      Coordinates may be typed in several different
ways depending on the setting of the [Edit] {CAD/CAM}
{UCS} {Units} command.  If this setting is one of the
inch modes (Denoted by "or ') then input can be in
several different methods.
      You may type in coordinates 4' 6 7/8", 4 6 7/8,
54 7/8" or 54.875".  All would produce the same
results.  You may also precede the coordinate with a
"-" minus sign to force parsing of the coordinate as a
negative coordinate.
      In centimeter mode (Denoted by "cm" or "m")
coordinates may be entered either as 2 m 22.1 cm, 
2 22.1, 2m 22 1/10  or 222.1 cm producing the same
result in any case.
      In generic mode (No denotation) coordinates may
be entered 57.6513 or using scientific notation ie
5.76513E1 where the value after "E" represents the
power that the mantissa is raised to.  In this case
use the [Edit] {CAD/CAM} {Dims} {Pre/Suffix} <Suffix>
command to supply the units of measurement when
dimensioning.
      In general the user should not enter numbers
larger than 9,999,999 or smaller than .0000001 as
PrintCADD 3-D will have a chance of overflow values
being generated. 

[Draw] {NearSnap} 

      This command allows you to place a point on any
other point contained in your current drawing file.
Points that reside on layers that are turned off are
not considered. 
      You would normally use this command by
positioning your cursor in the current window (denoted
by a highlighted readout bar) visually near the point
you wish to snap to.  You would then press escape or
right mouse button to invoke the [Draw] menu.  Select
{NearSnap} and the system will start to find points
that fall visually within [Edit] {CAD/CAM} {Vars}
{Aperture} range of the cursor.  When PrintCADD 3-D
finds a point with the given criteria it will
highlight the surface that the point resides on and
place an oversized cursor on the point.  This process
will take place in all open windows.
      A bracket menu will then appear, "This point ?
< Snap > < Moveto > < Next > < Exit >".  If this is
the correct point then select, "< Snap >" and 
PrintCADD 3-D will snap your cursor to this position,
enter the point into the system and return you to the
current operation.  If you select "< Moveto >" the
system will move the cursor to that point but will not
enter the point into the system.  If you select, 
"< Next >", the system will find the next point that
fills the criteria and offer the same bracket menu
again.  If you select < Exit > then you will be
returned to where you were before invoking the [Draw]
menu. 

[Draw] {GridSnap}

      This command is similar to the [Draw] {NearSnap} 
command but it will only find points in the current 
{VisiGrid}.  If a visible grid has not been set up via 
the [Edit] {CAD/CAM} {UCS} {VisiGrid} command then the 
[Draw] {GridSnap} command is ignored and you are 
returned to where you were before invoking the command. 
Another difference is that {VisiGrids} are not 
associated with a surface so their is no highlighting 
of surfaces before the Bracket menu prompt. 

[Draw] {PerpSnap}

      This command is normally invoked by placing the
first point of a command and then placing the cursor
on the line segment you wish to snap perpendicularly
to. Select the {PerpSnap} command from the [Draw]
menu.  PrintCADD 3-D will then highlight the surface
that the line segment resides on and place oversized
cursors at the endpoints of the line segment.  A
bracket menu will then appear at the top of the
screen  "This line ? < Snap > < Moveto > < Next >
< Exit >".  If you select,  "< Snap >", the system will
snap the cursor to a point that will form a perpendicular 
between the first point entered and the line segment or 
the extension of the line segment. Because these 
perpendiculars are three dimensional in nature a certain 
view of the snap may seem non perpendicular but in fact 
there will be a 90 degree angle formed in 3-D space.  
This can be confirmed by measuring the angle with the 
[Edit] {CAD/CAM} {Dims} {Pointer} <Angle> command. 

[Draw] {CenterSnap}

      This command allows you to snap to the center
point of a selected surface.  This command is normally
used on the automatic closed surfaces produced by
circular and elliptical arcs 360 degrees and over as
well as {CAD/CAM} {Line} {Rectangle} and {CAD/CAM}
{Line} {Prllogram} commands.  The reason for this is
that the centres of such surfaces were precisely
aligned by PrintCADD 3-D when they were created. 
After placing the drawing cursor on a line segment of
the surface you wish to snap to the center of, invoke
the [Draw] {CenterSnap} command and the system will
highlight a surface and place an oversized cursor at
the center of the surface.  You will then see the
bracket menu, "Center of this surface ? < Snap > 
< Moveto > < Next > < Exit >".  If you select 
"< Snap >",  the software will snap the cursor to the
center of the surface and enter this point into the
drawing.  


[Draw] {MidPtSnap}

      This command allows you to snap to the precise
midpoint of a selected line segment.  Place your
drawing cursor within aperture distance of the line
segment you wish to snap to the midpoint of and invoke
the [Draw] {MidPtSnap} command.  PrintCADD 3-D will
highlight the surface that the line segment resides on
and place oversized cursors at the endpoints of the
segment.  You will then see the bracket menu: This
line ? < Yes > < No > < Exit >.  Proceed as with all
previous snap commands. 


[Draw] {Locks} <AlongLock>

      This command restricts the cursor to moving
along a path that lies along a selected line segment. 
It does not enter a point into the system.  The
selection process is identical to the [Draw]
{PerpSnap} and [Draw] {MidPtSnap} commands.  The
command remains in effect until a point is entered,
the drawing command is aborted or the [Draw] {Locks
Off} command is selected. 

[Draw] {Locks} <Parallel Lock>

      This command is similar to the [Draw]
{AlongLock} command except that the drawing cursor is
limited to a path that runs parallel to the selected
line segment.  You normally invoke this command after
entering the first point of a command into the system. 
This point establishes the offset of the cursor path
from the selected line segment.  After selecting the
line segment that you wish cursor travel parallel to,
the system will confine the path such that the line
between the first point entered and the current cursor
position remains parallel to the selected line
segment. 


[Draw] {Locks} <Perp Lock>

      This command is similar to the [Draw] <Parallel
Lock> command except that movement is confined to a
path that is perpendicular (right angle) to the line
segment selected and that intersects the last point
entered into the system.

[Draw] {Locks} <Locks Off>

      This command aborts any lock that is in effect. 

[Draw] {Coords} and {MoveTo} commands

      The {Coords} and {Moveto} commands are very
similar in nature except that the {Coords} command
enters the point into the system and the {Moveto}
command moves the cursor to the position indicated but
does not enter the point into the system.
      These commands allow the user to enter points or
move the cursor directly rather than using the mouse
or keyboard.  This is normally a more accurate way of
describing points as well because incrementing the
cursor by a small amounts may cause additive errors. 
Additive errors are caused by the fact that most real
numbers can not be precisely described by computers. 
The computer can get very close, (normally within
1/10,000,000 of the real value), but, because this
slight bit of error is added with each movement of the
cursor, it may turn into a number that is rather
significant.
      There are two normal methods of describing
points in PrintCADD 3-D.  The first is by use of X, Y
and Z values that describe distances of travel along
each of theses axes or axis coordinates.  The second
type is known as polar coordinates.  These are
described to the system by a relative point that
describes the starting point, the angle the travel
will take in the current UCS and the distance to
travel.
      Each of the bracket commands in these two menus,
offers a way of supplying one of these points to the
system.  The bracket menu commands accept input from
the user via the prompts "X =", "Y =" and "Z =" or
"Angle =", "Distance =".  

[Draw] {Coords}/{Moveto} <AbsUCS>

      This command allows you to enter coordinates in
terms of the current user coordinate system.  For more
information read [Edit] {CAD/CAM} {UCS} section.

[Draw] {Coords}/{Moveto} <RelUCS>

      This command allows you to enter points in terms
of relative offsets along the current UCS X, Y and Z
axes.  The offsets are in relation to the last point
entered into the system. 

[Draw] {Coords}/{Moveto} <DBase>
 
      This command allows you to enter a coordinate in
terms of the drawing database.  These coordinates are
in terms of [Edit] {CAD/CAM} {View} {Top Plan}.  It is
normally easier to enter coordinates in other terms as
described below. 

[Draw] {Coords}/{Moveto} <PolDeg>

      This command allows the user to enter a polar
coordinate into the system using degrees.  The angle
is in terms of the current UCS Z axis and the right
hand rule.

[Draw] {Coords}/{Moveto} <PolRad>

      This command allows the user to enter a polar
coordinate into the system using radians.  The angle
is in terms of the current UCS Z axis and the right
hand rule.

[Draw] {Moveto} <LastPt>

      This command allows the user to move the cursor
to the position that the system feels was the last
point entered into the system.  Because intermediate
selections such as [Draw] {UCS} <3point> or [Draw]
{Zoom/Pan} may reset this point the user can assure
himself that this is the correct "last" or "relative"
point.  These points are important because the system
uses them for measurement reference, polar coordinates
,"parallel" locks and "perpendicular" locks.

[Draw] {Moveto} <SetRel>

      Normally the system sets the last point entered
as the relative point.  This command allows the user
to overide this setting with their own relative point. 
The user places his cursor on the point that he wishes
the system to use as the "relative" point and then
selects this command.  The system will then move the
relative point to the cursor position and return the
user to "draw" mode.

[Draw] {UCSAline}

      This command is designed to realign the cursor
to the current User Coordinate System.  (See [Edit]
{CAD/CAM} {UCS} section for more information.)  The
cursor will be adjusted so that it lies precisely on
the {Units} grid established by the last command to
set the units.  This is needed because snaps and user
entered coordinates may pull the cursor off of the
{Units} grid.  For example your {Units} grid might be
set to '  1/2" spacing and your [Edit] {CAD/CAM}
{Vars} {RelAbsDbas} is set to < Absolute UCS >. 
Snapping to the midpoint of a line might produce a
current cursor position of 3/4".  Your cursor would
then increment to 1 1/4", 1 3/4", 2 1/4", 2 3/4" etc. 
not 1 1/2", 2 0/2 ", 2 1/2", 3 0/2" etc. as shown by
coordinate readouts at the bottom of the screen.  The
reason is that the readouts merely display to the
closest 1/2".  It is normally best to establish
coordinates by setting your readouts to {RelAbsDbas}
< Relative UCS > to avoid confusion. 

[Draw] {CursrSpace}

      This command establishes a new cursor grid
spacing relative to the current UCS origin.  It is
especially useful if you find that your cursor can not
get within {Aperture} distance of a point you wish to
snap to because your current grid spacing is too
coarse.  You will be prompted for the amount of space
to move along the X, Y and Z axes of the current user
coordinate system each time an arrow key is pressed or
the mouse moved. 

[Draw] {Zoom/Pan} <Factor>

      This command allows you to zoom in or out of a
drawing by a factor.  Once the command is selected you
will see the prompt, "Zoom Factor =".  Answering to the
prompt with a number greater than 1 causes a magnification 
of the drawing by the number indicated.  A number less 
than 1 causes a zoom out or demagnification of the screen.  
After typing in the factor of zoom you will be prompted to 
select a point to zoom about.  Press enter once your 
cursor is over the point you wish to zoom and the screen 
will be zoomed and displayed with the point selected in 
the center of the screen.  See the [Edit] {CAD/CAM} {Zoom} 
command for more information. 

[Draw] {Zoom/Pan} <Level>

      This command sets zoom as a factor of the area
set for the current drawing when it was created or
last set with the [Edit] {CAD/CAM} {Vars} {Limits}
command.  For example if your limits were set to 10'
then a {ZoomLevel} of 2 would present an area of 5' x
5' on the screen.  A {ZoomLevel} of .5 would present a
screen area of 20' x 20'.  At the prompt  "Zoom Level
=", enter the new zoom level and you will be prompted
for a new center of zoom.  Once the point is selected
the zoom will be performed. 

[Draw] {Zoom/Pan} <Previous>

      This command allows you to zoom to the last zoom
or pan that was set by one of the zoom commands in the
current editing session.  If you have not used a zoom
command in the current editing session then the zoom
performs the same as the [Edit] {CAD/CAM} {Zoom}
{Limits} command.  This command is especially useful
if you wish to return to your original level of zoom
after zooming in to add detail or snapping to a point.

[Draw] {Zoom/Pan} <PullPan>

      This command allows you to pull a section of
drawing to a different position on the screen.  You
will be prompted for two different points.  The first
prompt will be, "Point to Pull @".  Select the point
you wish to pull upon.  You will then be prompted, 
"New position @".  Select the point where you wish the
point that was first selected to appear on the screen. 
Once this point is selected PrintCADD 3-D will perform
the desired panning action and return you to where you
left off. 

[Draw] {Zoom/Pan} <ReCenter>

      Selecting this command causes a panning motion of 
the screen such that the current drawing cursor position 
becomes the center of the screen. 

[Draw] {Redraw}

      This command will redraw the screen removing any 
blips or ghosted entities.  (See [Edit] {CAD/CAM} 
{Rdrw} {Redraw})

[Draw] {UCS} <3Point>

      This command allows the user to set up another UCS 
by prompting for three  points.  The first point is used 
as the origin point of the coordinate system.   The 
second point marks a point on the UCS X axis while the 
third point marks a point in the positive Y direction.  
The third point does not have to be on the Y axis.

[Draw] {UCS} <UCStoView>

      This command is useful when you find that your 
cursor does not seem to allow you to move in a direction 
that you wish.  This is normally caused because the UCS 
X or Y axis lies in a direction that is close to the Z 
direction of the current view ie moving along the 
X - axis of the current UCS is the same as moving deeper 
into the drawing.  This command aligns the UCS with the 
current view such that moving along the X axis causes 
movement of the cursor parallel to the bottom of the 
window while moving along the Y axis causes movement 
parallel to the side of the window.  Z axis movement 
causes no apparent movement of the cursor but in fact it 
is moving in the Z direction.  

[Draw] {WndwRdOut}

      This command moves the readouts in the window one 
position to the left.  This is useful if the window you 
are working in is to small to display the entire window 
status line.  You can move the particular readout that 
you are interested into view in this manner.  For 
instance you may wish to keep track of the current view 
rotation angles while using the [Edit] {CAD/CAM} {View} 
{Aim} command.  Normally these readouts would not be 
visible in a small window. By pressing the {WndwRdOut} 
command a couple of times you will shift this readout 
into view on the current window. 

File Menu

      The [File] menu consists of the commands, {Load}, 
{Create}, {DosComs},{Purge} and {Quit}. 

[File] {Load} Command

      The {Load} command allows you to load previously 
created drawing and font files into the system.  
Selecting the {Load} command causes another sub menu 
to appear with the two choices, {Drawing} and {Font}.  
Selecting either of these two commands in turn presents 
the user with a list menu that contains all the files 
that are available in the particular category that you 
have selected ie. {Drawing} or {Font}.  You then select 
the file you are interested in and PrintCADD- 3D loads 
the file.  If you have selected {Font} you will also be 
required to press the key that corresponds to the letter 
you wish to edit.  In effect each letter is its own 
individual drawing contained within the master font file.  
Each of these letter drawings must be contained within a 
certain predefined amount of file space so editing 
previously created fonts may cause problems.  See the 
[File] {Create} commands and the File Structure section 
in the appendix for more information on font files. 

[File] {Create} {Drawing}

      The {Create} command allows you to create a new
drawing or font file.  After selecting {Create} a menu
will appear with the choices, {Drawing} and {Font}. 
If you select {Drawing} you will be prompted for
several pieces of information that will control
different aspects of the drawing.  All of this
information except the filename may be changed within
the system so if you decide that you have not answered
one of the prompts correctly just continue on and
modify it later.  Even the filename may be changed at
the DOS level.  
      The first prompt will be 'Filename >'.  Type in
the name you wish to remember the file by.  The name
may be up to 8 letters long and must follow standard
disk operating system protocol.  This means that the
filename may consist of the letters a-z and A-Z, the
numbers 0-9 and the characters ( ) @ # $ % ^ & ! - _ '
and ~.  Any other characters may cause problems. 
PrintCADD-3D will append the extension .GVF to the
filename. 
      After entering a filename the system will prompt
'Display Units' and a menu will appear below the prompt.  
The system is asking you for the units of measurement 
that will be displayed at the bottom of the screen 
during object construction.  These units will also be 
the units that will be written to the drawing when 
applying dimensioning to the drawing.  Because the 
system keeps all points and vectors in terms of floating 
point inches a conversion process is applied to 
coordinates when they are entered as well as when they 
are displayed.  For instance if you were to enter the 
coordinate 1/4" the system would convert this to the 
number .2500000 and store it.  Later when dimensioning 
the point it would take the coordinate .2500000 and 
convert it back to 1/4", 2/8", 1/2",  .835 cm etc. 
depending upon the display units setting.  Notice that 
1/2" is actually not accurate but is as accurate as the 
system can be to the nearest 1/2".  You may select the 
display units by using the up and down arrows and 
pressing the enter key.  With a mouse simply roll it up 
and down to change the units and press the left mouse 
button to invoke the setting.  You may change the units 
setting later via the [Edit] {CAD/CAM} {UCS} {Units} 
command later on. 
      The next prompt when creating a drawing will be
'Area? Length of longest side >'.  You must type in
the size of the area that you wish to work in.  For
instance typing in "10'" would give you an area of 10
feet by 10 feet to build your drawing in.  In
actuality it is best to give your drawing about twice
as much size as it needs as this will cut down on the
number of regenerations that will have to be performed
when zooming and panning.  This area is also used as
the reference point for the zoom command.  A zoom
level of 2 would give you an area of 5 feet by 5 feet
if the area had been set at 10 feet originally.  This
area can be reset later via the [Edit] {CAD/CAM}
{Vars} {Limits} command later on.    
      The system will then blank the current screen and 
prompt you for two corners of a rectangle.  This 
rectangle represents the area of the screen that you 
wish to assign to your first view window.  As you may 
create up to four windows it may be best to leave some 
room on the screen in which to place other view windows.  
Again, this command can be changed later via the [Edit] 
{CAD/CAM} {Wndw} {ReSize} command. 
      The last three prompts ask for X, Y and Z axis 
spacing.  These prompts are replied to with a distance 
that sets the increment that the drawing cursor will 
travel with each press of the arrows.  The X-axis is 
controlled by the left and right arrows, the Y axis by 
the up and down arrows and the Z axis by the numeric 
keypad plus and minus keys.  Too small an increment may 
cause the drawing cursor to travel very slowly while 
too large an increment may lock the cursor if the 
spacing carries it past the edge of the window.  You 
may reset this distance by either the {Snap} {Grid Size} 
or the [Edit] {CAD/CAM} {UCS}  {Grid Size} commands. 

[File] {Create} {Font}

      This command allows you to create your own font
files.  Creating and editing font files can be
difficult so a thorough understanding of font and
drawing file structure is necessary to accomplish this
task successfully.  (See File Structure in Appendix)
You should also be aware of how ASCII codes are
assigned to the different keys on the keyboard.  (See
ASCII table in appendix)
      Although not absolutely necessary fonts should
always be created in a 1 inch by 1 inch space.  This
will allow the font to conform to other fonts shipped
with the system.  This also allows easy scaling of the
fonts ie a Y-Scale factor of 12 would make the letter
1 foot high. 
      Fonts should be drawn in the default view :
[Edit] {View} {Top Plan}.  The basic geometry should
not be extended along the Z axis.  While this makes
the font 2 dimensional in nature, it still may be
placed at any orientation in 3-D space and extruded
into 3-D after. 
      Each letter of the font should consist of a
single open surface.  This means that you may not use
the [Edit] {Line} {Rectangle}, [Edit] {Line}
{Prllogrm} or any [Edit] {Curv} command that makes a
circular or elliptical arc of 360 degrees or more. 
The reason for this is that the system automatically
forms closed surfaces with these commands.  This
should not really limit the geometry but rectangles
and parallelograms should be made with the [Edit]
{Line} {Line} command instead.  Make closed curves by
limiting the arc to 359.9 degrees and join the first
and last end points of the curve with a line. 
      This command takes you through the same set of
prompts and replies as the [File] {Create} {Drawing}
command as well as two additional prompts. 
      The first additional prompt is 'Storage per
character ='.  This number refers to the amount of
file space in words to allocate for each character in
the font file.  A word is 2 bytes therefore typing in
100 would allocate 200 bytes of space for that
character.  This is normally enough for about 15 line
segments.  Allocating more space would allow more line
segments.  The values quoted are only approximate and
you should allocate more space than you feel you will
require.  Obviously the more room that is allocated
the more complex the font that can be accommodated by
this space. 
      The second additional prompt is 'Number of
Characters ='.  Characters are assigned space starting
with ASCII 32.  If you refer to an ASCII table you
will notice that ascii 32 represents the space bar ie
when you press the space bar your computer system
receives a message from your keyboard that ASCII 32
was pressed.  PrintCADD 3-D intercepts that key and
sends the ASCII 32 letter file to your drawing.  If
you press '!'- exclamation mark, ASCII 33 is
intercepted and the ascii 33 letter file is sent to
your drawing.  You will also notice that ASCII 32 to
ASCII 126 represent all of the characters in a
standard character set so if you answered 95 to the
'Number of Characters =' prompt you would assign space
for a complete font ie ASCII 32 to ASCII 126.  In
truth the PrintCADD 3-D can handle ASCII 127 to 255 as
well but these characters are available only by
pressing the 'Alt' key and typing in the ASCII code
number on the numeric keypad. 
      The 'space bar' key plays an important role in
the font file.  When you have finished replying to the
previous prompts, PrintCADD 3-D creates a font file
and selects the 'space bar' key for the current edit
letter.  The 'space bar' controls the spacing of the
letters via the [Edit] {CAD/CAM} {Line} {Rectangle}
command.  The rectangle size is normally set to the 1" 
x 1" area size but may be varied to give different
spacings.  You must realize that this rectangle is not
shown when the 'space bar' key is pressed but merely
referenced for the spacing of the font.  This allows
you to control spacing by re-editing the 'space bar'
key rectangle via the [Edit] {CAD/CAM} {Mdfy} {Delete}
command to delete the rectangle and reestablishing the
rectangle via the [Edit] {CAD/CAM} {Line} {Rectangle}
command.  See the [File] {Load} {Font} for information
on editing the other characters. 
      There are three other points to keep in mind
when creating and editing fonts.  

1: The system expects  that each letter is contained   
   within its own file space so if one letter of the   
   font overflows into the next characters file space  
   the font will be ruined. 

2: While you may delete the last point, series or      
   surface, if you try to delete beyond the beginning  
   of the letter you may corrupt the font file.  

3: Do not use the [File] {Purge} command as it will    
   also corrupt the file. 

      One other use of the [File] {Create} {Font}
command is to build 'parts'.  A part is really nothing
more than a two character font file.  When building a
part simply reply to the prompts as if building this
two character font and place the actual drawing of the
part in the space assigned to the '!' exclamation mark
character.  When prompted for the amount of space for
each letter, reply '110'.  Because the letter (part)
can not overflow into another letter's assigned space
this will actually allow you to build the part as
complex as you wish without any fear.   
      In general you must be quite careful in the
editing and drawing of fonts.  Although there are a
lot of rules to building a font file, in practice it
is very easy and quick once you get the hang of it.  
They are also very flexible when used as parts files. 
See [File] {Load} {Font} and [Edit] {CAD/CAM} {Text}
for more information. 

[File] {DosComs} < Directory >

      This command is similar to the MSDOS "dir"
command except that the list of files appears within a
list menu.  After selecting < Directory > another
bracket menu will appear, "< Cont > < Mask >
< Directory >".  The < Cont > command produces a list
of files according to the < Mask > and < Directory >
commands.  The < Mask > command allows you to set a
mask using the DOS wildcard characters "?" and "*". 
Consult your DOS manual for an explanation on the use
of these characters.  The < Directory > command will
prompt the user for the directory that you wish to
extract the list of files from.

[File] {DosComs} <Copy>

      This command is similar to the MSDOS "copy"
command except that you will be prompted for the file
to copy and the name to copy to.  This allows you to
make backups and shuffle files around without leaving
PrintCADD 3-D.  

[File] {DosComs} <Delete>

      This command will prompt for the name of the
file to delete.  This allows you to delete files
without leaving PrintCADD 3-D. 

[File] {DosComs} <MkDir>

      This command allows you to create a new
directory without leaving PrintCADD 3-D.  It is
similar to the DOS command of the same name. 

[File] {DosComs} <MemLeft>

      This command is not normally for user use as the
memories reported are actually used for debugging of
the executable file and report the memory available at
this particular time rather than the memory available
after dynamic allocation of different internal arrays.
The "Memory =" should be a minimum of 32000. 

[File] {Purge}

      This command removes all deletions from the
current drawing file.  If you have been deleting
entities in your drawing with the [Edit] {CAD/CAM}
{Grup} {Delete} command then this command will return
the filespace taken by the entities that have been
deleted.  This is possible because the {Grup} {Delete}
command merely marks the selected surface as a deleted
entity rather than actually removing it from the
drawing file.  Although this command does not make the
drawing file smaller, it does recover room that may be
used for the drawing without increasing the file size. 
This will also increase the performance of the file as
the system will not have to deal with them once they
have been purged from the drawing. 

[File] {Quit}

      Once you have selected {Quit} you will see the
bracket menu, "Quit < Yes > < No >".  Selecting < Yes
> will allow you to exit PrintCADD 3-D.  If [System]
{Optimize} has been turned on then you will see the
additional bracket menu "Save Edits < Yes > < No >". 
This allows you to decide whether you wish to save the
changes you have made to your drawing.  See [System]
{Optimize}. 

[Edit] {CAD/CAM} {Line} Menu

      The {Line} menu allows the user to construct
several useful shapes.  These shapes are straight
edged, as opposed to the shapes found in the {Curv}
menu which have curved edges. 


[Edit] {CAD/CAM} {Line} {Line}

      The most basic element of a drawing in PrintCADD
3-D is the line.  The {Line} command allows you to
create straight line segments in an easy and efficient
manner. 
      When this menu item is selected the system goes
into "Draw" mode and the prompt "Start point @"
appears at the top of the screen.  The user may then
select the position of the start point.  Remember that
the [Draw] menu is available at any time during the
point selection selection process by pressing 'Escape'
or 'MRB'. 
      After selecting this point, the system will
display the prompt, "End point @".  When the cursor is
moved a "rubber band" line will form between the point
selected and the current cursor position.
      After the end point is selected, the line will
solidify in place and the system will again prompt,
"End point @".  A rubber band line will again form
between the last point selected and the current cursor
position.  This allows the line to be made
"continuously".  In order to get back to the "Start
point @" prompt, the user must invoke the [Draw] menu
and select {Exit}.  Invoking [Draw] and selecting
{Exit} while at the "Start point @" prompt will take
the user back to the {CAD/CAM} menu.
      The points will be grouped into the "current"
surface till another command determines the type of
surface they form.  
 
[Edit] {CAD/CAM} {Line} {Triangle} 

      The system will prompt the user for three points
that form the vertices of the triangle.  As the points
are selected the system will form "rubber band" lines
between the points to show the shape of the triangle. 
If the user selects {Exit} from the [Draw] menu the
command will abort and the user will be returned to
the {CAD/CAM} menu.  
      The system will form a "closed" surface and
determine a center point that is mathematically within
the confines of the triangle and lying on it's
surface.  

[Edit] {CAD/CAM} {Line} {Rectangle}

      The system will prompt the user for two
diagonally opposite corners of the rectangle.  The
rectangle will "rubber band" between the first point
selected and the cursor.  After selecting the second
point, the rectangle will solidify and the user will
be returned to the {CAD/CAM} menu.  The command can be
aborted by selecting {Exit} from the [Draw] menu.
      The system will determine the center point of
the rectangle and form a "closed" surface.
      If the second point lies at a different depth,
in the current UCS, than the first point, then the
system will make sure that the edges of the rectangle
that are parallel to the Y axis will remain parallel
while the edges parallel to the X axis will remain
parallel to the y = 0 plane.

[Edit] {CAD/CAM} {Line} {Prllogram}

      The system will prompt the user to enter three
points that describe three of the corners of the
parallelogram.  The fourth corner is inferred from the
other three corners.  The system will "rubber band"
the parallelogram when the third point is being
selected.  
      After the third point is entered the
parallelogram will solidify and the user will be
returned to the {CAD/CAM} menu.  
      Selecting {Exit} from the [Draw] menu will abort
the command.
      The system will calculate the center of the
parallelogram and form a "closed" surface.

[Edit] {CAD/CAM} {Curv} menu

      The {Curv} menu allows the user a number of ways
to draw circles, arcs, ellipses and spline curves. 
Selecting any of the sub-menu items in this menu leads
to a bracket menu that further modifies the type of
curve that will be generated.  
      The {PtRadCirc}, {2PtCirc}, {3PtCirc} and
{2PtEllipse} commands all lead to the menu, 
"< Continue > < Sides >=? < Start >=? < End >=?",
where the question marks are numbers.  
      The <Sides> option allows the user to set the
number of straight line segments that make up the
curve by answering the prompt with a number between 3
and 256.
      The <Start> and <End> option allow the user to
set the starting and ending angles of the circle or
ellipse.  The system expects the user to enter these
angles in degrees.  The angles are measured from the
UCS X axis in a manner that conforms to the right hand
rule.  If the difference between the start and end
angles is 360 degrees or more, then the system forms a
"closed" surface.  If the arc is less than 360 degrees
then the arc is held as a "series" in the "current"
surface.

[Edit] {CAD/CAM} {Curv} {PtRadCirc}

      This command prompts the user for a center point
and a point on the edge of the circle or arc.  When
the edge point is being prompted for, a "rubber band"
circle or arc will form that shows the shape the
circle will take.
      If the cursor is moved off of the current UCS
then the distance between the center point and cursor
is measured to form the radius of the circle.  The
circle will always remain parallel to the current UCS
and the center will always remain at the first point
that is selected.
      After selecting the edge point the circle will
solidify and become part of the drawing.
      Selecting {Exit} from the [Draw] menu aborts the
command.

[Edit] {CAD/CAM} {Curv} {2ptCirc}

      This command forms a circle by prompting for two
points that are on diametrically opposite sides of the
circle.  When the second point is being selected the
circle or arc will "rubber band".
      If the cursor is moved off of the UCS then a
point that is exactly half way between the two points
becomes the center of the surface. ie if the second
point is 2 inches deeper than the first point in terms
of the current UCS then the circle's center will be at
1 inch deep.  The distance between the two points is
measured to determine the diameter of the circle.  The
circle will always remain parallel to the current UCS.
      The [Draw]{Exit} command aborts the command.

[Edit] {CAD/CAM} {Curv} {3PtCirc}

      This command allows the user to form a circle by
defining three points along the edge of it.  When the
third point is being selected the circle will "rubber
band".  
      The circle or arc will always form so that the
circle is parallel to the current UCS and at the depth
of the third point entered.  If the previous two
points were at different depths, then the circle forms
so that if the user was looking directly down on the
UCS, (See [Edit] {CAD/CAM} {UCS} {ViewtoUCS}) then the
circle will "appear" to intercept all three points. 
      
[Edit] {CAD/CAM} {Curv} {3PtArc}

      The {3PtArc} command leads to a bracket menu
that allows the user to set the number of <Sides> that
the arc will contain.  After selecting <Continue> from
this bracket menu, the system will prompt the user for
three points.
      The arc will form from the first point through
the second point and end at the third point.  When the
third point is being selected, the arc will "rubber
band".  After the third point is selected the arc will
solidify and the user will be returned to the
{CAD/CAM} menu.  Selecting {Exit} from the [Draw] menu
will abort the command.
      This command is similar to the {3PtCirc} command
in that the arc will appear to intercept all three
points if the user is looking directly down on the
current UCS.  The arc will always remain parallel to
the current UCS and will be at the depth of the third
point entered.

[Edit] {CAD/CAM} {Curv} {2PtEllipse}

      This command allows the user to construct an
ellipse.  The system will prompt for two points.  The
first point defines the center point of the ellipse. 
When the second point is being selected the ellipse
will "rubber band".  Each radius of the ellipse,
(major and minor), is defined by the distance the
cursor is from the center point, measured along the
current UCS X and Y axes.  To achieve a tilted ellipse
define the UCS so that it is tilted in respect to the
edges of the window.  The ellipse always forms
parallel to these two axes and always remains at the
depth of the first point (center point).  Placing the
cursor at a different depth does not effect the
ellipse as distances are always measured along the UCS
X and Y axes.
      The ellipse will solidify once the second point
is selected.  Selecting {Exit} from the [Draw] menu
aborts the command.

[Edit] {CAD/CAM} {Curv} {PtSpline}

      This command leads to a bracket menu that allows
the user to set the number of points that the system
will prompt for and that the spline will intercept. 
The bracket also allows the user to set the number of
line segments between each point via the <Chords>
command.  The total number of line segments that the
system can generate is 256, so the user will be
informed if (<Points> -1) * <Chords> + 1 exceeds 256. 
      When <Continue> is selected from the bracket
menu the system will prompt the user to select each
point in turn until the last point is entered.  When
the last point is entered, the spline curve will form
through all points selected.  Selecting {Exit} from
the [Draw] menu will abort the command.
      The {PtSpline} command is fully 3-D in nature,
so selecting points that are not on the current UCS
will still result in the curve passing through the
selected points.  The {PtSpline} command forms a
"series" in the current "surface".

[Edit] {CAD/CAM} {Curv} {AnchrSplin}

      This command leads to a bracket menu that allows
the user to set the number of <Chords> or line
segments between each selected point.  The number of
points selected is always three.  The other option in
this menu is <AltSpline>.  When <AltSpline> is set to
"No" and <Continue> is selected the user will be
prompted for three points.  The first and second
points will become the start and end points of the
spline while the third point will define the path of
the curve between these two points.  When <AltSpline>
is set to "Yes" the spline will start at the first
point, continue through the second point and end at
the third point. 
      When the third point is being selected the
spline will "rubber band".  This command is fully
three dimensional in nature and the curve will pass
through the three points selected whether they all
reside on the current UCS or not.  Once the third
point is selected the spline will solidify and the
user will be returned to the {CAD/CAM} menu.  The
command may be aborted by selecting {Exit} from the
[Draw] menu.  The {AnchrSplin} command forms a
"series" in the current surface.
  
[Edit] {CAD/CAM} {Text} menu

      This menu system allows the user to annotate
their drawings.  Unlike most other 3-D CADD systems,
the text in this system is treated like any other
object within the system and can be placed at any
orientation in 3-D space.  This allows the user to
build signs or provide the illusion of the text
vanishing off into space.  The user should however
keep all texts on different layers so that different
views don't show the text upside down and backwards 
for instance.  Text will always assume the current
line style and line color.  Each string of text is
given the open surface type.  The {Box}, {StackedBox},
{LeftJustfy}, {RightJstfy}, {Centered} and {Between}
commands will always start by prompting the user for a
string of text to place in the drawing.

[Edit] {CAD/CAM} {Text} {Box}

      This command is perhaps the most flexible of all
the {Text} commands.  After entering the string of
text, the user will be prompted "Left bottom 
corner @".  The user will then select the point that
the left, bottom corner of the text will appear at. 
After selecting this point the system will prompt,
"Length line @" .  The user will then see a "rubber
band" line that connects the first point selected to
the cursor.  This line controls the orientation and
length of the text.  After selecting this point, a
parallelogram will "rubber band" between the points
selected and the current cursor position.  The system
will also display the prompt, "Height / Slant 
corner @".  The user may then select a point that
controls the height and slant (italics) of the
letters.  Once the third point is selected the system
will place the text string so that it fills the
parallelogram and lays flat on its surface.  The
parallelogram is fully 3-D in nature, so the points
selected do not need to fall on the current UCS.
The command may be aborted by selecting {Exit} from
the [Draw] menu.

[Edit] {CAD/CAM} {Text} {StackedBox}

      This command is similar to the {Box} command
except that the letters will fall one below the other
like those on a vertical sign.  The system will prompt
the user for three corners of a parallelogram that the
text will form to fill.  The first point selected will
be the left top corner of the text.  The second point
will control the orientation and height of the string
while the third point controls the width and slant of
the letters.  After the third point is selected the
text will form and the user will be returned to the
{CAD/CAM} menu.  Selecting {Exit} from the [Draw] menu
aborts the command.

[Edit] {CAD/CAM} {Text} {LeftJustfy}

      After the user enters the string of text to be
placed, the system will prompt the user to select a
"Start @" point.  Once this point is selected the text
will form to the right of the point.  The text will be
aligned so that it runs parallel to the UCS X axis and
the height runs parallel to the UCS Y axis.  The depth
of the cursor controls the depth at which the text is
placed.  The height and width of the letters are
controlled by the settings in the {TextScale} menu
which is discussed later in this chapter.
      Selecting {Exit} from the [Draw] menu aborts the
command.

[Edit] {CAD/CAM} {Text} {RightJstfy} 

      This command is similar to the {LeftJustfy}
command except that the text forms to the left of the
point selected.  This command may be aborted by
selecting {Exit} from the [Draw] menu.

[Edit] {CAD/CAM} {Text} {Centered}

      This command is similar to the {LeftJustfy}
command except that the text will be centered about
the point that is selected.  This command may be
aborted by selecting {Exit} from the [Draw] menu.

[Edit] {CAD/CAM} {Text} {Between}

      After entering the text string, the system will
prompt the user for a "Start @" and an "End @" point. 
After entering the second point the system will place
the text string so that its length and orientation is
controlled by the distance and direction of the two
points selected, ie. the text will form between the
two points.  The height of the letters is controlled
by the <Y Scale> factor in the {TextScale} menu.  The
letters will be formed so that the height is
perpendicular (right angle) to the line between the
start and end points.  The height line is also
parallel to the current UCS, ie. adjusting the UCS
controls the direction in which the letters face.
      This command may be aborted by selecting {Exit}
from the [Draw] menu.

[Edit] {CAD/CAM} {Text} {FontSelect}

      After selecting this command, the system will
display the prompt "Select font style _" and display a
list of the currently available fonts.  The user must
select one of the fonts from this list.  Once
selected, the font is used for all subsequent {Text}
and {Dims} commands that create text.  A readout in
the top right hand corner of the screen always
displays the current font while in the {CAD/CAM} menu.
After selection the User will be returned to the
{CAD/CAM} menu.  Pressing "Escape" or "MRB" aborts the
command.

[Edit] {CAD/CAM} {Text} {TextScale}

      This command leads to a bracket menu that
displays the current X scale and Y scale settings and
offers the user three choices.  Selecting <X Scale>
will cause the system to display the prompt 
"X scale =".  At this prompt the user will type in the
size that he wishes the width of the letters to
assume.  Remember that fonts are normally built on a
scale of 1" x 1" so typing in 12 would cause letters
1' in width.  Similarly typing in a <Y Scale> of 12
would cause the system to produce letters 1' high.
      The other menu option available is <Auto>.  When
this command is selected the system looks at the
{AutoSize} setting in the [Edit] {CAD/CAM} {Vars} menu
and automatically determines the <X Scale> and 
<Y Scale> of the letters, ie. if the <AutoSize>
setting is 8" then the scale will be set so that the
letters are 8 inches high and 8 inches wide in the
drawing.  When these values are set to your
satisfaction, press the "Escape" key or "MRB" to
return to the {CAD/CAM} menu.

[Edit] {CAD/CAM} {Dims} menu

      This menu system allows the user to dimension
his drawing in an easy and efficient manner.  Although
the dimensions are not "associative", they are so easy
to construct and manipulate that redimensioning is
still extremely easy.  Dimensions should be assigned
there own layers so that reverse views of the
dimension may be turned off.  This is because
dimensions are also 3 dimensional in nature.  Because
of the number of options that are available through
this menu virtually any type of dimensioning may be
constructed.  The dimensions will assume the current
line style and line color.  The dimensions are broken
down into three surfaces.  The "witness" or
"extension" lines are considered one "open" surface. 
The arrows and dimension lines are considered as one
"open" surface and the dimension text is considered as
one "open" surface.  This allows the user to control
the color and style of these surfaces individually.  
The measurements will be formatted to the current
setting of the {CAD/CAM} {UCS} {Units} menu.

[Edit] {CAD/CAM} {Dims} {Aligned}

      This command allows the user to dimension the
distance between two points.  The user will be
prompted to select three points.  The first two points
selected are the points whose distance is being
measured.  When the third point is being selected a
parallelogram will "rubber band" between the points
selected and the current cursor position.  The
parallelogram roughly describes the shape that the
final dimension will take.  When the third point is
selected, the "extension" lines will form along two
edges of the parallelogram and the dimension lines and
arrows will form along the side opposite the first two
points selected.  The text will form in accordance
with the setting in the {Dims} {Placement} menu.  If
the placement is set to <Aligned>, the text will form
aligned with the dimension lines and arrows.  In this
case the parallelogram describes the "facing" of the
text as well as the slant applied to the text.  
      The user may select {Exit} from the [Draw] Menu
to abort the command.

[Edit] {Cad/CAM} {Dims} {Horizontal}

      This command allows the user to form horizontal
dimensions.  The user will first be prompted,
"Dimension line location @".  The location of this
point determines the location of the dimension lines
and text.  The dimension lines and text will be formed
such that they are parallel to the UCS X axis and
intercepting this point (or would intercept if the
dimension lines were longer).  The next two prompts
are the points to be dimensioned.  The system will
measure the horizontal distance along the UCS X axis
between these two points and form the dimension. 
Notice that the orientation of the UCS defines the
distance, alignment and "facing" of the text.  This
allows the user to do dimensioning that is not
normally possible. (See Illustration)
      Because dimension lines are always parallel to
the UCS X axis, {Dims} {Placement} will react the same
no matter what the setting.
      The user may select {Exit} from the [Draw] menu
to abort the command.

[Edit] {CAD/CAM} {Dims} {Vertical}

      This command allows the user to form vertical
dimensions.  The user will first be prompted,
"Dimension line location @".  The location of this
point determines the location of the dimension lines
and text.  The dimension lines and text will be formed
such that they are parallel to the UCS Y axis and
intercepting this point (or would intercept if the
dimension lines were longer).  The next two prompts
are the points to be dimensioned.  The system will
measure the vertical distance along the UCS Y axis
between these two points and form the dimension. 
Notice that the orientation of the UCS defines the
distance, alignment and "facing" of the text.  This
allows the user to do dimensioning that is not
normally possible. (See Illustration)
      The user may select {Exit} from the [Draw] menu
to abort the command.

[Edit] {CAD/CAM} {Dims} {Pointer}

      This command allows the user to make dimensions
that need to be routed around objects in the way.  It
also allows the user to form angular dimensions.  The
user will be prompted, "First point @".  This point
defines where the arrow head will appear.  The next
prompt is "Next point @".  This point determines the
orientation of the arrow head as well as drawing a
dimension line between the two points.  The system
will continue to prompt for "Next point @", allowing
the user to route the dimension line around objects in
the drawing, until the user selects {Exit} from the
[Draw] menu.  The system will then draw the arrow head
on the first line segment and display a bracket menu,
"Dimension < Text > < Length > < Angle > < None >". 
      If the user selects <Text>, then the system will
prompt the user for a string of text that will be
placed "left justified" at the last point the cursor
was resting on.  
      If the user selects <Length>, then the system
will prompt the user to select two points.  The system
will measure the distance between these two points and
place the length, "left justified" at the last point
the cursor was resting on before {Exit} was selected
from the [Draw] menu.
      If the user selects <Angle>, then the system
will prompt the user for three additional points.  The
three prompts will be, "First angle point @", "Angle
center point @" and "Last angle point @".  The system
will then measure the angle formed by these three
points and display the bracket menu "Angle < Degrees >
< Radians >".  The user must select select the
appropriate dimension type.  The system will then
prompt the user "Decimal points (0 to 6) =".  The user
must type in the number of decimal points of accuracy
that this measurement will be displayed in.  Note that
if the measurement is 89.999 and the user selects 2,
the system will format this number as 90, ie. number
is rounded and trailing zeros are dropped.  The system
will then place the angular dimension, "left
justified" at the last point the cursor was resting on
before {Exit} was selected from the [Draw] menu.

[Edit] {CAD/CAM} {Dims} {ArrowType}

      When this command is selected a drop down menu
will be displayed with 15 (0-14) styles of arrow
heads.  Highlight the appropriate style and press
"Enter" or "MLB" to select as the current style.  The
readout in the top left corner of the screen will
display the current style.

[Edit] {CAD/CAM} {Dims} {ArrowScale}

      When this command is selected the system will
display the bracket menu "Arrow < X Scale > = ? 
< Y Scale > = ? < Auto >".  The question marks will be
the current scale of the arrows.  
      Selecting <X Scale> will allow the user to
change the scaling of the arrow parallel to the
dimension line while selecting <Y Scale> allows the
user to change the scaling perpendicular to the
dimension line.  Although the scaling of the arrows is
not quite identical to that of the fonts, it is close
enough that setting one equivalent to the other will
produce a dimension that looks proper.  
      The <Auto> command uses the value of the
{CAD/CAM} {Vars} {AutoSize} setting to configure the
scaling of the arrows.

[Edit] {CAD/CAM} {Dims} {Overlap}

      This command is used to offset (underlap) the
extension lines from the object being dimensioned and
to extend the lines beyond the tips of the arrow heads
in the dimension.  When this command is selected the
system will display the bracket menu, "Extension
Overlap < Arrow > = ? < Object > = ? < Auto >".  The
question marks will be the current settings of the
overlap.  If either <Arrow> or <Object> is selected
the user will be prompted for a value.  This value is
parsed in the same manner as any length measurement,
ie the value must be in terms of the current setting
of the {CAD/CAM} {UCS} {Units} menu.  However the
units shown by the question mark always reflect the
measurement in terms of floating point internal units,
normally inches.  eg. units parsed in cm. units are
converted to inches for display of overlap.  A
negative number indicates underlap and a positive
number indicates overlap.  After these numbers are
set, press "Escape" or "MRB" to return to the
{CAD/CAM} menu.  The <Auto> option sets the overlaps
to the size specified in the [Edit] {CAD/CAM} {Vars}
{AutoSize} command.  In this case the <Object> setting
is actually negative {AutoSize} causing an underlap on
the object side of the extension lines.

[Edit] {CAD/CAM} {Dims} {Suppress}

      When this command is selected the system will
display the bracket menu "Suppress < Ext1 > = ? 
< Ext2 > = ? < Arw1 > = ? < Arw2 > = ?".  The question
marks will toggle between "No" and "Yes" when each
item is selected.  This allows the user to suppress
the system from creating either the extension lines or
arrowheads on a particular side of the dimension. 
"Ext1" and "Arw1" refer to the side of the dimension
that corresponds to the first point selected while
"Ext2" and "Arw2" correspond to the second point
selected.  After these menu items are set accordingly,
press "Escape" or "MRB" to return to the {CAD/CAM}
menu.

[Edit] {CAD/CAM} {Dims} {Pre/Suffix} 

      This command allows the user to add a prefix or
suffix to the dimension.  One possibility for this
ability is to dimension a drawing in units other than
those shown in the {CAD/CAM} {UCS} {Units} menu.  By
selecting a generic unit, ie. no ', ", cm, m suffix,
and then selecting an appropriate setting for the
<Suffix>, (eg. angstroms, light years), the user may
dimension the drawing with his new unit of
measurement.  This may also be used when tolerances
must be shown in the drawing.  Press "Escape" or "MRB"
to return to the {CAD/CAM} menu.

[Edit] {CAD/CAM} {Dims} {Placement}

      When this command is selected, the system
displays the menu, "Text Placement < Aligned > 
< UCS >".  Selecting <Aligned> causes dimension text
to be aligned with the dimension line while selecting
<UCS> causes the dimension text to align with the UCS
X axis.  
  

[Edit] {CAD/CAM} {Dims} {Orientate}

      When this command is selected, the system
displays the menu, "Text Orientation < Standard >
< Stacked >".  The <Stacked> option makes the
dimension text form one letter on top of the next like
a vertical sign.  The <Standard> option causes the
dimension text to appear normally.
[Edit] {CAD/CAM} {Dims} {DualDim}
      When this command is selected, the system
displays the menu "Dimensioning < Single > < Dual > 
< Prompt >".
      The <Single> option uses the setting in the
{CAD/CAM} {UCS} {Units} menu when forming the
dimension.  This is the normal way that dimensions are
done.
      When <Dual> is selected, the system displays a
menu identical to the {CAD/CAM} {UCS} {Units} from
which the user picks the units to be displayed for the
second dimension.  This is normally one of the metric
units settings if the user is working with ft inch. 
The system will then form dimensions with the second
dimension in brackets next to the first.
      The <Prompt> option causes the system to prompt
the user for the text that will appear in the
dimension.  The prompt will happen after the dimension
points are selected.

[Edit] {CAD/CAM} {Grup} menu

      This menu allows the user to work on a group of
surfaces at one time.  All of the commands in this
menu force the user to define the group of surfaces
before carrying out the command.  The group selection
process is identical for each command in this menu.
      When any one of the {Grup} commands is selected,
the system will display the menu, " < New Group >
< Previous Group >".
      If <New Group> is selected, the system will
discard all surfaces in the previous group (if any)
and proceed.
      If <Previous Group> is selected, the system will
keep any previously selected surfaces (if any) and
proceed.
      The system will then display the selection menu,
"< Add > < Subtract > < BoxAdd > < Finish >".
      If <Add> is selected, the user will be prompted,
"Select Surface @" and the system will go into "Draw"
mode.  The user must then place his cursor on the edge
of a surface he wishes to "Add" to the group and press
"Enter" or "MLB".  The system will then search the
drawing for surfaces that fall within aperture range
of the cursor.  If a surface is found, the system
"ghosts" the surface and displays the standard "Snap"
menu, "This surface ? < Snap > < Moveto > < Next >
< Exit >".  If the user selects <Snap> or <Moveto>,
the system will add this surface to the selection set. 
If the user selects <Next>, the system will attempt to
find the next surface within aperture range.  If one
is not found, the user is returned to the selection
menu.  If <Exit> is selected, the user is returned to
the selection menu. 
      If <Subtract> is selected, the user will again
be prompted to "Select Surface @".  Again, the same
process will be followed to subtract or remove the
selected surface from the selection set.  
      If <BoxAdd> is selected, the user will be
prompted for two opposing corners of a "rubber band"
box.  All surfaces that fall entirely within the box
will be added to the selection set.
      If <Finish> is selected, the user will continue
on with the steps necessary to complete the {Grup}
command.
      If "Escape" or "MRB" is pressed, then the system
will abort the {Grup} command.
      In the current version of the program a maximum
of 256 surfaces can be collected as a group.  The user
will have to perform two or more of the same command
if the group is larger than this.  

[Edit] {CAD/CAM} {Grup} {Move}

      After establishing the selection set, the system
will prompt for two points, "Origin @" and "Offset @". 
These points establish the direction and distance that
the group will be moved, ie. if the second point is 2'
to the left and 3' above the first point, then the
group will be moved 2' to the left and 3' up.  If
{Exit} is selected from the [Draw] menu, the command
will be aborted.  
      After the two points are selected, the system
will display the regeneration menu, "Regenerate -
< Auto > < NewCenter >".  After selecting the
appropriate item, the system will move the group and
perform the regeneration.

[Edit] {CAD/CAM} {Grup} {Scale}

      After establishing the selection set, the system
will prompt the user for a scale factor.  If the user
types in a number less than 1, then the group will be
scaled smaller.  If the number is larger than 1, then
the group will be scaled larger.  If the user presses
"Escape", the command will abort.
      After the scale factor has been entered, the
user will be prompted, "Origin Point @".  This point
serves as the point from which the scaling will be
referenced.  It is normally in the center of the
surfaces to be scaled because all scaled surfaces will
be pulled towards or pushed away from this point,
depending on whether the scaling makes the group
larger or smaller.  The further the surface is from
the origin, the more that the surface will travel from
its placement before the {Scale} command.
      After the origin point is selected, the system
will display the regeneration menu, "Regenerate -
< Auto > < NewCenter >".  After selecting the
appropriate item, the system will scale the group and
perform the regeneration.

[Edit] {CAD/CAM} {Grup} {Rotate}

      After establishing the selection set, the system
will display the bracket menu, "< Continue >
< Rotation Angle > = ?".  The question mark will be a
number, in degrees, that the system will rotate the
object around the user selected axis of rotation.  A
rotation of 180 degrees would, for instance, perform a
"mirroring" of the surface.  All rotations are
performed according to the "right hand rule".  
      If the user selects <Rotation Angle> the system
will prompt for an angle, in degrees, to rotate the
group. 
      Once the user has established the "rotation
angle" and selected <Continue>, the system will prompt
the user to select two points that form the axis of
rotation.  The second point is positive in relation to
the first point, therefore the thumb of the right hand
would point from the first point towards the second
point when figuring out the direction of the rotation. 
      After the two points are selected, the system
will display the regeneration menu, "Regenerate -
< Auto > < NewCenter >".  After selecting the
appropriate item, the system will rotate the group and
perform the regeneration.

[Edit] {CAD/CAM} {Grup} {Copy}

      After establishing the selection set, the system
will prompt for two points, "Origin @" and "Offset @". 
These points establish the direction and distance that
the copy of the group will be moved, ie. if the second
point is 2' to the left and 3' above the first point,
then the copy of the group will be moved 2' to the
left and 3' up from where the original group was.  If
{Exit} is selected from the [Draw] menu, the command
will be aborted.  
      After the two points are selected, the system
will display the regeneration menu, "Regenerate -
< Auto > < NewCenter >".  After selecting the
appropriate item, the system will copy the group and
perform the regeneration.

[Edit] {CAD/CAM} {Grup} {ChangeColr}

      This command changes the color, linestyle,
pattern, pattern foreground color and pattern
background color to the current system settings. 
These colors and attributes are shown in the two icons
in the top left hand corner of the screen while in the
{CAD/CAM} menu.  To change these settings see [Edit]
{CAD/CAM} {Colr}.
      After the selection group is established, the
system will display the regeneration menu,      
"Regenerate - < Auto > < NewCenter >".  Select the
appropriate menu item and the system will regenerate
the drawing with the new colors.

[Edit] {CAD/CAM} {Grup} {ChangeLayr}

      This command changes the layers of the selection
set to that of the current layer setting.  The current
layer setting is shown on the top line of the screen
beside the "Layr=" readout while in the {CAD/CAM}
menu.  See [Edit] {CAD/CAM} {Layr} for information on
setting the current layer.
      After the selection group is established, the
system will display the regeneration menu,      
"Regenerate - < Auto > < NewCenter >".  Select the
appropriate menu item and the system will regenerate
the drawing with the surfaces in the selection set
established on the new layer.

[Edit] {CAD/CAM} {Grup} {OpenSurf}

      This command changes all surfaces in the
selection set to the "open" surface type.
      After the selection group is established, the
system will display the regeneration menu,      
"Regenerate - < Auto > < NewCenter >".  Select the
appropriate menu item and the system will regenerate
the drawing with the new surface types.

[Edit] {CAD/CAM} {Grup} {CloseSurf}

      This command changes all surfaces in the
selection set to the "closed" surface type.
      After the selection group is established, the
system will display the regeneration menu,      
"Regenerate - < Auto > < NewCenter >".  Select the
appropriate menu item and the system will regenerate
the drawing with the new surface types.

[Edit] {CAD/CAM} {Grup} {Delete}

      This command deletes all selected surfaces from
the drawing.
      After the selection group is established, the
system will display the regeneration menu,      
"Regenerate - < Auto > < NewCenter >".  Select the
appropriate menu item and the system will regenerate
the drawing with the selected surfaces deleted from
the drawing.
      After several uses of this command use the
[File] {Purge} command to return the file space
associated with these deleted surfaces into drawing
space.

[Edit] {CAD/CAM} {Surf} menu

      This menu is used for producing three
dimensional objects by using surfaces that already
exist within the drawing.  Rectangles can be turned
into into cubes or pyramids, circles can be
transformed into tubes, globes and cones and splines
can be joined to form meshes.  These are just a few of
the possibilities.  With a little practice and a
thorough understanding of the commands virtually any
3-D object can be made.
      It is normally best to have at least one other
window with an alternate view to confirm that these
commands have performed as expected.  The reason for
this is that some commands may look like they have
done nothing while others may look like they have done
the job but both may be simply an optical illusion
produced by the current view angle. See individual
commands for more information on these effects.

[Edit] {CAD/CAM} {Surf} {Thickness}

      This command is used to extrude a surface along
the Z axis of the current UCS by a user defined
amount.  When the command is selected, the system will
display the prompt, "Select surface @".  The user must
move the cursor close to the edge of the surface being
extruded and press "Enter" or "MLB".  The system will
then display the standard surface "snap" menu to
verify surface identification.  After the user has
verified the surface, the system will display the
prompt, "Thickness =".  The user then types in the
thickness he wishes the surface to have and the system
extrudes the surface the required thickness along the
UCS Z axis.  Keep in mind that, if your view is
aligned with the UCS and the window is in parallel
projection mode, the thickness will not be seen until
the view is rotated. 

[Edit] {CAD/CAM} {Surf} {Extrude}

      This command is similar to the {Thickness}
command except that the extrusion is performed along a
user specified axis rather than the UCS Z axis.  The
user must be careful to add a certain amount of depth
to the extrusion or the surfaces will be coplanar and
not 3-D in nature even though they appear at first
glance to be 3-D.  
      The user will be asked to select and verify the
surface that needs to be extruded.  After verification
the system will prompt for two points, "Origin @" and
"Offset @".  These two points show the system the
direction and distance of the extrusion.  For instance
if the offset point is 2' to the left, 1' above and 3'
deeper than the origin point, then the surface will be
extruded 2' to the left, 1' up and 3' deep.
      After the second point is entered, the system
will form the extrusion and return the user to the
{CAD/CAM} menu.

[Edit] {CAD/CAM} {Surf} {CutToPlane}

      This command allows the user to "cut" an
extrusion with a defined cutting plane.  This would,
for instance, allow the user to mate a rectangle
defining the top of a chimney to the roof of a house.
      The user will be asked to select the surface
that requires extrusion.  This is done by the normal
surface selection process.  
      Once the surface is selected, the system will
ask the user to specify the depth of the extrusion. 
If the surface does not meet the cutting plane before
the specified depth, the system will work in a similar
manner to the {Thickness} command.  It is therefore
necessary to specify a distance that is beyond the
depth of the cutting plane.
      The system will then prompt the user to select
three points that specify the cutting plane.  In the
case of the chimney rectangle to roof extrusion the
user would specify three corners of the roof.  The
system will then form the required extrusion and
return the user to the {CAD/CAM} menu. It should be
noted that the extrusion is not "capped" by another
surface.

[Edit] {CAD/CAM} {Surf} {Join}

      This command is used to join one surface to
another surface.  Normally the surfaces are of the
same shape but of different sizes.  For instance
joining a circle to another circle of 0 radius could
result in a cone.  Joining a square to another square
with 0 length sides could result in a pyramid.  
      While this command is very powerful, it has a
number of pitfalls.  As the first line segment in one
surface is joined to the first line segment of the
second surface, an "hourglass" shape might happen if
one circle was constructed from a front plan UCS and
the other circle was constucted from a back plan UCS.
Even if a single line, constructed left to right, was
joined to another line, constructed right to left,
this "hourglass" shape would appear.  If the user is
trying to join two complex surfaces it may be best to
join the surface to a scaled copy of itself.  If one
surface has more line segments than another surface,  
then the segments are joined until one of the surfaces
runs out of segments.  
      Virtually all of these problems can be overcome
with a little experimentation.
      When this command is selected the system will
ask the user to select and verify the two surfaces to
be joined.  After the second surface is selected, the
system will "join" the two surfaces and the user will
be returned to the {CAD/CAM} menu.

[Edit] {CAD/CAM} {Surf} {Revolve}

      This command allows the user to revolve a
surface about a user defined axis of revolution,
producing revolved surfaces. 
      One of the things to keep in mind when using
revolved surfaces, is the number surfaces that will be
produced by the command.  For instance, revolving a
256 <Sides> circle into a 256 <Sides> globe will
produce 256 x 256 surfaces.  The 65,536 surfaces will
take over 5 megabytes of hard disk space and an
extremely long time to render.  As well, the limit to
the number of closed surfaces in one view on which
hidden line elimination can be performed, is 8000, so
producing an object of this complexity serves very
little purpose. 
      When this command is selected, the system will
display the bracket menu, "< Continue > < Sides > = ?
< End Angle > = ?".  The <Sides> option allows the
user to establish the number of "sides" that the
object will have.  The more sides, the smoother the
surface.  The <End Angle> option establishes the
angle, in degrees, through which the surface is
revolved.  When <Continue> is selected the system will
prompt the user to select and verify the surface to be
revolved.  After the surface has been established, the
system will prompt the user for two points on the axis
of revolution, "First rotation axis point @" and
"Second rotation point @".  As normal, the second
point is positive in relation to the first point and
shows the direction of the thumb for the right hand
rule.
      After the second point is selected the system
will revolve the surface and return the user to the
{CAD/CAM} menu.

[Edit] {CAD/CAM} {Surf} {RadArray}

      This command allows the user to make radial
arrays of the surface selected.  A radial array is
simply an object where copies of the selected surface
are laid down in a circle or arc.
      When this command is selected, the bracket menu,
"< Continue > < Sides > = ? < End Angle > = ?", will
appear.  The <Sides> option establishes the number of
copies that the radial array will have while the 
<End Angle> option establishes the amount of angle, in
degrees, that copies of the surface will be
distributed through.
      After the user selects <Continue> the surface
will prompt the user to select and verify the surface
to be copied.  After verification of the surface the
user will be prompted to select two points that
describe the rotation axis.  The second point is
positive in relation to the first point and describes
the direction in which the thumb points, in the right
hand rule. 
      Once the rotation axis has been established, the
system will form the radial array and return the user
to the {CAD/CAM} menu.

[Edit] {CAD/CAM} {Surf} {Surf Part}

      This menu allows the user to insert previously
constructed parts into the drawing.  See [File]
{Create} {Font} for information on the construction of
these parts.
      When this command is selected the user will be
prompted to select the part for insertion from a
"list" menu.  Once the part has been selected, the
system displays the bracket menu, "< Box > 
< Stacked > < Between > < Left > < Right >".  
      These commands correspond to similar selections
in the [Edit] {CAD/CAM} {Text} menu.
      The <Box> option will prompt the user to select
three corners of a "rubber band" parallelogram that
describe the shape and "facing" of the inserted part. 
Once the third corner of the parallelogram is selected
the system will insert the part and return the user to
the {CAD/CAM} menu.
      The stacked option is similar to the <Box>
option except that if the points are entered in the
same order, the "surf part" will be rotated by 90
degrees.  This basically allows the algorythm to fit a
different set of selection points.
      The <Between> option allows the user to place
the part between two points.  After the user selects
<Between>, the system will display the "scaling" menu,
"< X scale > = ? < Y scale > = ? < Auto >".  This menu
allows the user to establish the size of the object
along the Y axis.  The <X scale> option is ignored as
the part will be "stretched" along the X axis to fill
the gap between two user selected points.  The <Auto>
option scales the object so that it will become the
size set in the [Edit] {CAD/CAM} {Vars} {AutoSize}
command.  To continue, the user must press "Escape" or
"MRB".  The user will then be prompted, "Start @" and
"End @".  These are the two points that the part will
be placed "between".  Once the second point is
selected the system will insert the part in the
drawing and return the user to the {CAD/CAM} menu.
      The <Centered> option will again allow the user
to select the <X scale> and <Y scale> of the part via
a "scaling" menu.  Once the scaling is established the
user must press "Escape" or "MRB" to continue.  The
user will then be prompted to select the point at
which the part will "center" around.  Once this point
is selected, the system will draw the part so that it
aligns with the UCS X and Y axes at the scale
selected.  The user will then be returned to the
{CAD/CAM} menu.
      The <Left> and <Right> options are identical to
the <Centered> option except that the part will be
left justified or right justified to the point
selected.

[Edit] {CAD/CAM} {Colr} menu

      The settings in this menu establish the color
and style of lines within a surface as well as the
pattern and color of the fill for the surface.  The
surface will not assume these characteristics until
the surface is established as an "open" or "closed"
surface type, ie. the "current" surface will simply
assume the characteristics of the surface established
previously until the "current" surface becomes either
"closed" or "open" type.  Even then the screen needs a
"redraw" to see the true colors.  This may seem a
little confusing at first but really shouldn't be a
concern as these colors can be changed very easily via
the [Edit] {CAD/CAM} {Grup} {ChangeColr} command.  See
the "Surfaces" section in "3-D geometry and Coordinate
Systems" chapter.

[Edit] {CAD/CAM} {Colr} {Line Color}

      When this command is selected the system will
display a drop down menu with 15 choices for line
color.  Select the color that you wish the "current"
surface and all subsequent surfaces to assume for the
lines that mark the edge of the surface.  After
selection, the arrow icon, second from the left at the
top of the screen, will show the color selected.

[Edit] {CAD/CAM} {Colr} {Line Style}

      When this command is selected a drop down menu
will appear that allows the user to select 1 of 15
line styles that the "current" surface and all
subsequent surfaces will assume.  This is the style of
the lines that outline the edge of the surface.  After
selection, the arrow icon at the top of the screen,
will show the style selected.

[Edit] {CAD/CAM} {Colr} {PattFgdCol}

      This command allows the user to select 1 of 15
colors that will be used as the "foreground" color of
the pattern used for filling the interior of "closed"
surfaces.  The pattern icon in the top left hand
corner of the screen will reflect the color selected. 
The user must use the [Edit] {CAD/CAM} {Rdrw} 
{Quickhide} command to actually show the surfaces with
the selected colors.

[Edit] {CAD/CAM} {Colr} {PattBgdCol}

      This command allows the user to select 1 of 15
colors that will be used as the "background" color of
the pattern used for filling the interior of "closed"
surfaces.  The pattern icon in the top left hand
corner of the screen will reflect the color selected. 
The user must use the [Edit] {CAD/CAM} {Rdrw} 
{Quickhide} command to actually show the surfaces with
the selected colors.  This command will do nothing if
the current pattern is solid as the solid pattern has
no background attribute.

[Edit] {CAD/CAM} {Colr} {SysPattern}

      This command allows the user to select 1 of 15
patterns numbered 0 to 14 built in to PrintCADD 3-D. 
The second pattern, "1", in the list is especially
useful as it blends the foreground and background
colors to produce many other colors.  The pattern icon
in the top left hand corner of the screen will reflect
the pattern selected.  The user must use the [Edit]
{CAD/CAM} {Rdrw} {Quickhide} command to display the
drawing with the surfaces patterned accordingly.

[Edit] {CAD/CAM} {Colr} {UsrPattern}

      This command allows the user to select 1 of 15
patterns numbered 15 to 29 that the user has designed
via the [Edit] {CAD/CAM} {Colr} {UsrPattMake} command. 
The pattern icon in the top left hand corner of the
screen will reflect the pattern selected.  The user
must use the [Edit] {CAD/CAM} {Rdrw} {Quickhide}
command to display the drawing with the surfaces
patterned accordingly.


[Edit] {CAD/CAM} {Colr} {UsrPattMake}

      This command allows the user to design their own
patterns for use in drawings.  The patterns designed,
are held in the "Prcad.def" file so if the user wishes
to transfer drawings using these patterns to another
system then the "Prcad.def" file should be transferred
as well.  If the user does not transfer this file then
the surfaces which use these patterns will simply use
the pattern that is defined in the target system.  If
the user redefines a user pattern then all surfaces
using the user pattern will assume the new pattern
definition.
      When this command is selected, the system will
display the user pattern menu.  The user must then
select the pattern "slot" they wish to edit.  Once the
pattern "slot" has been selected, the system will
prompt the user for 8 numbers between 0 and 255. 
These numbers are converted to there binary (base 2)
equivalents to form an 8 by 8 pattern where the binary
1's assume the pattern foreground color and the binary
0's assume the pattern background color.

    Number typed in     Binary equivalent
------------------------------------------------------
      1                    00000001
      1                    00000001
      1                    00000001
      255                  11111111
      16                   00010000
      16                   00010000
      16                   00010000
      255                  11111111
------------------------------------------------------

The preceding table would produce a "brick" pattern.

      After definition of the pattern the system will
use the defined pattern as the current system pattern. 
The pattern icon in the top left hand corner of the
screen will reflect this pattern.
      Due to a bug in the Microsoft (Copyright)
Professional Development System 7 and QuickBasic
(Copyright) compilers, the system, (PrintCADD 3-D),
may decide that the pattern has a chance of locking
the system when used and require the user to redefine
the pattern.  Even so, some patterns may be overlooked
and the user should be aware of some rules when
designing the pattern.  

1 - The first number in the pattern must be non zero. 

2 - Do not use 2 consecutive numbers that are 0.  

3 - Test the pattern before using in a drawing

[Edit] {CAD/CAM} {Layr} menu.

      This menu is used to divide the drawing into
manageable blocks of information.  As a drawing
becomes more complex, different operations performed
on the drawing will take more time to complete.  This
is especially true of operations that require screen
regenerations.  There also may be times when it would
be advantageous to "turn off" parts of the drawing
before printing.  For instance, text might be
displayed backwards because the current view is
looking from behind the text.  Yet another use of
layers is to allow surfaces that have been assigned
the "open" surface type to be displayed in hidden line
and "quickhide" views.  This allows the user to
display text or dimensions via the [Edit] {CAD/CAM}
{Rdrw} {DrawLayer} command even though it has been
"hidden" from the drawing.
      All surfaces are assigned to a layer.  When the
layer is "locked off", the layer will not be shown or
recalculated when a regeneration is performed.  This
can save a lot of time if the layer is not needed. 
For instance the user could "lock off" the 
"living room", "bedroom" and "kitchen" layers while
working on the "bathroom" layer.  After finishing the
"bathroom" layer the other layers could be "locked on"
to show the complete view.

[Edit] {CAD/CAM} {Layr} {Select}

      This command allows the user to select the layer
to be used from a list menu that displays all of the
available layers in the drawing.  The "current"
surface and all subsequent surfaces will be assigned
to this layer.  If the layer is currently "locked off"
then it will be "locked on" automatically.  The
current layer is displayed beside the "La=" readout on
the top line of the screen.

[Edit] {CAD/CAM} {Layr} {Create}

      This command allows the user to create a new
layer for use in the current drawing.  The system will
display the prompt, "Layer Name >".  The user may use
up to 13 letters to "name" the layer.  Once the name
is entered the layer will become the current layer. 
The user may create up to 255 layers per drawing.

[Edit] {CAD/CAM} {Layr} {Lock}

      This command allows the user to turn a layer on
or off.  This command has no effect on the current
layer because the current layer may never be turned
off.  
      When this command is selected, the system will
display a list menu of all the layers in the current
drawing.  Beside each layer name is either a "-" or a
"X".  The "-" means the layer is turned off while the
"X" means the layer is turned on.  The user must
select the layer to toggle the layer on or off.  Once
the layers are set to the user's wishes, press
"Escape" or "MRB" to return to the {CAD/CAM} menu.  A
window regeneration must be performed before the
command takes effect.

[Edit] {CAD/CAM} {Layr} {Change}

      This command allows the user to change the name
associated with a layer.  This is especially useful
for changing the name, "No Name", that is
automatically assigned by the system to the first
layer of the drawing.  
      When this command is selected, the system will
display a list of all layers in the drawing.  The user
must select the name to be changed.  Once the layer
name is selected the user will be prompted for a new
name to assign to the layer.  The user types in the
new name and the system will change the name and make
this layer the current layer before returning the user
to the {CAD/CAM} menu.

[Edit] {CAD/CAM} {Mdfy} menu

      This "modify" menu allows the user to change the
position of points and allows the user to assign the
"closed" or "open" surface type to the "current"
surface.  It also allows the user to delete items
starting with the last point entered all the way back
to the beginning of the drawing.

[Edit] {CAD/CAM} {Mdfy} {Move Point}

      This command allows the user to move any visible
point in the drawing to a new location.  When using
this command it is normally a good idea to make sure
that the current UCS lies parallel to any "closed"
surface(s) that contain points to be moved.  This
assures that the point will be moved to a point that
is co-planar with the other points on the surface.  
      The system will display the prompt, "Point to
move @", and display a box shaped cursor.  The user
must move the box so that it surrounds the point to be
moved and press "Enter" or "MLB".  The system will
highlight the surface that the point belongs to, place
an oversized cursor on the point and then display the
snap menu, "This point ? < Snap > < Moveto > < Next >
< Exit >".  If the user selects <Snap> or <Moveto> the
system will move the cursor so it rests on the point
and display the prompt, "New location @".  The user
must then move the cursor to the new location and
press "Enter" or "MLB" or use other items available in
the [Draw] menu to relocate the point.  Once the new
location point is established, the system will display
another bracket menu, "< Another Point > < ReDraw >
< RegenAll >".  Selecting <Another Point> will allow
the user to move another point.  The <Redraw> option
will redraw the current window with the points at
there new positions and return the user to the
{CAD/CAM} menu.  The <RegenAll> option will update all
windows and return the user to the {CAD/CAM} menu.  If
the user presses "Escape" or "MRB", the system will
redraw the window if a point has been moved or return
the user directly to the {CAD/CAM} menu if a point has
not been moved.
      It is important to note that in certain
instances the user must move two points to achieve the
desired effect.  For instance the user may have to
move both the start point and the end point of a 360
degree circle or rectangle to keep the surface
"closed".  In these instances, it is possible to use
the <Near Snap> option from the [Draw] menu to provide
precise alignment of these two points. 

[Edit] {CAD/CAM} {Mdfy} {MoveCentPt}

      This command allows the user to move the
"center" or "fill" point of a surface.  The command
works in an identical manner to the {Move Point}
command except that box cursor must be moved so that
it straddles an edge of the surface whose center point
is being moved and the snap menu places the over sized
cursor at the current center point position of the
surface.  
      The user should not move the center points of
rectangles, 360 degree circles, parallelograms or surf
parts as these points have been aligned precisely by
the system and provide a useful reference point for
the {CenterSnap} command.

[Edit] {CAD/CAM} {Mdfy} {Stretch}

      This command allows the user to stretch a
selected portion of the drawing to a new location.  It
is useful when modifying portions of the drawing to
become shorter or longer.  It is also a fast method
for relocating a portion of the drawing.
      The user will be asked to draw a box around the
portion of the drawing that needs to be "stretched". 
All points (vertices) within this box will be
affected.  This includes the center (fill) points that
fall within the box so be sure that that your
"stretch" does not modify these points so they fall
outside of the surface or you will be forced to use
the {Mdfy} {MoveCentPt} command to realine the center
points with the interior of the surface.
      Once the box is drawn, the program will prompt
the user to select two points that specify the
distance and the direction of the "stretch".
      Once these two points are selected, the system
will display the bracket menu, "< Redraw > 
< RegenAll >.  If the user wishes to update the
current window only, the <Redraw> command will provide
the faster alternative.
      After the user has selected the appropriate
command the system will redraw or regenerate to the
new view and return the user to the {CAD/CAM} menu.

[Edit] {CAD/CAM} {Mdfy} {SurfLast}

      This command allows the user to assign the
"closed" or "open" surface type to the "current"
surface.
      When this command is selected, the system
displays the bracket menu, "< Closed Surface > 
< Open Surface >".  In either case, if the current
surface contains any entities, the user will be
prompted, "Center point @".  The user must then place
the cursor at the position for the center point and
press "Enter" or "MLB".  If the user presses "Escape"
or "MRB", the surface will still be formed but the
center point will be automatically assigned by the
system.  If there are no entities in the "current"
surface, then the user will not be prompted for a
center point but will be returned to the {CAD/CAM}
menu.  

[Edit] {CAD/CAM} {Mdfy} {DeleteLast}

      When this command is selected, the system will
display the bracket menu, "< Regen > < RegenAll >  
Delete last - < Line > < Series > < Surface >".
      If the user selects <Line>, then the system will
delete the last line segment entered into the drawing
file.  If the line is part of a "closed" or "open"
surface, then the surface is turned into the "current"
surface.  The system will place a "blip" at the end
point the line being deleted from the system.  If the
line being deleted is the first line in a line series,
then the system will place a "blip" at both ends of
the line segment.  This command can be selected
continuously until the whole the drawing file is
deleted.
      If the user selects <Series>, then the last line
series entered into the drawing file will be deleted. 
All points in the line series will be marked with
"blips" by the system.  This command can be selected
continuously until the whole drawing file is deleted.
      If the user selects <Surface>, then the last
surface entered into the drawing file will be deleted. 
This command can be selected continuously until the
whole drawing file is deleted.  The system will draw
blips at each point on the surface being deleted.
      If the user selects <Regen>, the system will
regenerate the current window with the deleted
entities removed.
      If the user selects <RegenAll>, the system will
regenerate all windows with the deleted entities
removed.
      The user must be careful with this command as it
will even delete lines, series and surfaces that are
assigned to layers that have been "turned off".

[Edit] {CAD/CAM} {Vars} menu

      This menu allows the user to assign settings to
various system variables.

[Edit] {CAD/CAM} {Vars} {AbsRelDbas}

      This menu allows the user to select the manner
in which the readouts at the bottom of the screen
display the cursor coordinates.  When the user selects
this command, the system displays the bracket menu,
"Display Coordinates < UCS > < Relative > 
< Database >"
      If the user selects <UCS>, the system will
display the coordinates in terms of distances from the
the UCS origin along each axis of the current UCS. 
This is normally termed as "absolute" coordinates.
      If the user selects <Relative> the system will
display coordinates in terms of distances from the
last point entered along each axis of the current UCS.
These coordinates are usually termed as "relative".
      If the user selects <Database>, the system will
display coordinates in terms of PrintCADD 3-D's
internal database.  This "absolute" coordinate system
is identical to the UCS invoked when a drawing file is
first created.  It basically conforms to a top plan
view with the origin in the center of the {Limits}
setting.

[Edit] {CAD/CAM} {Vars} {Aperture}

      The setting of this variable controls several
facets of PrintCADD 3-D.  It controls the size of the
cursor and the size of the area that the snap search
will look at on the screen when searhing for snap
objects.
      When this command is selected, the user is
prompted to enter a number between 1 and 25.  This
number is multiplied by the length of a horizontal
pixel unit in the current window to give a length that
is used by the system for the aforementioned sizes. 
This allows the user to set cursor size and snap
radius as apparent screen size rather than as a given
length.  Even after a "zoom" or selection of another
window the size will remain in pixels and therefore
allow the user to know how close he must come to an
objject to have it selected by a snap.  The user will
also be able to judge the distance with a greater
ammount of certainty because the size of the cursor
reflects the size of this snap distance. 

[Edit] {CAD/CAM} {Vars} {CursorType}

      When this command is selected, the system will
display the bracket menu, "< + > < X > < Box > 
< 3-D >".
      When <+> is selected the drawing cursor will
take on the shape of "+".  It will be the width and
height of the {Vars} {Aperture} setting.
      When <X> is selected the drawing cursor will
take on the shape of "X".  It will be the width and
height of the {Vars} {Aperture} setting.
      When <Box> is selected the drawing cursor will
take on the shape of a square box.  It will be the
width and height of the {Vars} {Aperture} setting.
      When <3-D> is selected the drawing cursor will
be formed from three intersecting lines.  One line
will run parallel to the UCS X axis, one line will run
parallel to the UCS Y axis and one line will run
parallel to the UCS Z axis. The three lines will
intersect at the current cursor position.  Each line
will be three times the size of the {Vars} {Aperture}
setting.  The reason for this is that the directions
of the UCS axes will be much more evident with a
longer line.  Each line will be a different color.  In
perspective viewing mode the cursor will grow smaller
as it goes away from the eye position and grow larger
as it gets nearer to the eye position.  It will be
equal to the {Vars} {Aperture} setting at the viewing
distance set when the window was put into
"perspective" mode.  The 3-D cursor will be shown only
in the current drawing window.  Other windows will use
the "+" cursor.  This prevents the cursors in other
windows from over shooting the floating point accuracy
of the system when they are put close to the view
point of their own windows.  
      One general note on all cursors is that when the
cursor falls behind the viewing point in "perspective"
viewing mode it will not reflect the true position of
the cursor.  If the cursor in the "current" window
"freezes" while in "perspective" viewing mode it is an
indication that the cursor either is behind the
"clipping" point or that the user would be moving the
cursor behind the clipping point, if it was moved any
further.  The 3-D cursor will normally become
extremely large before this happens reflecting it's
closeness to the view point.

[Edit] {CAD/CAM} {Vars} {Blipmode}

      This command allows the user to control the
shape of "blips" left on the screen when a point is
entered into the system.  "Blips" mark a point that
has been selected on the screen.  They are temporary
in nature and will dissapear after a window "redraw"
or "regenerate" command.
      The command works similarly to the {Vars}
{CursorType} command except the bracket menu that
appears has an additional option.  The additional
option is <Off> which stops the system from using
"blips" when a point is entered.  Even when {Blipmode}
is set to "off", the system may still leave blips for
certain commands.  The [Edit] {CAD/CAM} {Mdfy}
{DeleteLast} is an example of this type of command.

[Edit] {CAD/CAM} {Vars} {DragLevel}

      This command is used to set the number of
"elements" that will be displayed when the [Edit]
{CAD/CAM} {View} {Aim} <File> command is used.  See
the "PrintCADD 3-D Files" section of the manual for
more information on "elements".

[Edit] {CAD/CAM} {Vars} {Limits}

      This command allows the user to specify the
amount of area that will be shown on the screen at a
zoom level of 1.  This area also controls the size of
the regeneration area.  The user will always see a
dashed or dotted white line around the regeneration
area.  The size of this box on its shortest side will
be the length of the {Limits} setting unless the user
has used a {Regen-New} or <Regen-New> command to
temporarily override the size of the regeneration
field.  In this case, the user may reset the
regeneration box by performing a {Zoom}{ Limits} and
{Rdrw} {Regen-new} command to set the regeneration
limits back to the former setting.  No matter what the
size of the regeneration field though, the zoom level
readout at the top of each window will show the amount
of zoom as a reflection of the {Limits} setting.  For
more information see the [File] {Create} {Drawing}
command.

[Edit] {CAD/CAM} {Vars} {WindwRdOut}

      This command allows the user to shift the
readouts at the top of the current window one readout
field to the left thus allowing a different set of
values to be displayed.  The "Wind=" readout shows the
number which is associated with a window.  The first
window created is assigned "1", the second, "2", the
third, "3" and the fourth, "4".  This allows the user
to select the appropriate window when using the [Edit]
{CAD/CAM} {Wndw} {Select} command.  
      The "Zm=" readout tells the user the level of
"zoom" that a window has.  
      The "Proj=" readout tells the user whether the
window is a parallel projection, "Prll" or a
perspective projection, "Persp".  
      The "View= X rotation, Y rotation, Z rotation"
tells the user the amount of rotation around the X, Y
and Z view axes.  
      The "Winsiz= X length by Y length" tells the
user the length of the window along the X and Y axes. 
      The "Pixsiz= X pixels by Y pixels" tells the
user the dimensions of the window by the number of
screen pixels that it covers.

[Edit] {CAD/CAM} {Vars} {AutoSize}

      This command allows the user to set up the
scaling that the system will use for the <Auto>
commands.  These include the {Text} {TextScale}
<Auto>, {Dims} {ArrowScale} <Auto>, {Dims} {Overlap}
<Auto> and the various {Surf Part} <Auto> commands. 
This means that text, dimensions, arrowheads and
overlap may be kept consistent throughout the drawing.
      When this command is selected, the system will
display the bracket menu, "Automatic sizing < Length >
< Pixels >".  When the <Length> option is selected the
user will be prompted to enter the length that these
various entities will become.  The <Pixels> option
allows the user to enter this size in horizontal pixel
lengths of the "current" window.  In this manner the
user will be better able to judge the size that the
entities will become, in comparison to the overall
drawing.
	After the user has entered the appropriate size,
the system sets all affected scales to this size.  If 
the user then sets the scale to another value, within 
the individual scaling menus, they may select <Auto> 
from the scaling menu to return to this "master" scale.

[Edit] {CAD/CAM} {Zoom} menu

      This menu allows the user to perform "zooming"
and "panning".
      A "zoom" is where the drawing is enlarged as if
put under a magnifying glass.  "Zooms" are in terms of
the {Limits} setting.  For instance, if the {Limits}
of the drawing was set to 10 feet then a "zoom" level
of 2 would produce a visible area of 10 divided by 2
or 5 feet by 5 feet in the window.  A "zoom" of 5
would produce an area of 2 feet by 2 feet.
      A "pan" is where the drawing is moved  left,
right, up or down to show an area of the drawing that
was not visible in the window before the "pan" was
performed.  A "pan" is normally needed after a "zoom"
because by "zooming" into the drawing causes portions
of the drawing to not be visible.
      "Zooming" and "panning"  have been optimized to
perform as quickly as possible because the user will
normally perform a great many of these operations when
making a drawing. 
      From time to time, when the user "Zooms" into a
drawing a large amount, (normally over 50), the system
may display the prompt, "Incomplete Redraw 
< Continue > < Regen-New >".  This means that the
system may have "cut" certain line segments out of the
view because they caused a coordinate "overflow"
condition.  In more cases then not, the drawing will
still look fine to the viewer because the "zoomed"
view does not contain the points that were "cut" out. 
In this case the user can select <Continue> without
any consequences.  If the user finds that these "cuts"
did affect his view then he may select <Regen-New> to
regenerate the drawing at this new level of "zoom".  
However when the view is "zoomed" back out only the
small portion of the view that was <Regen-New>'ed will
be visible.  In this case the user should perform an
[Edit] {CAD/CAM} {Zoom} {ZoomLimits} and [Edit]
{CAD/CAM} {Rdrw} {Regen-New} to re-establish the
"zoom" and regeneration limits back to the original
view and size.


[Edit] {CAD/CAM} {Zoom} {Factor}

      When this command is selected, the system will
display the prompt, "Zoom factor =".  The user must
then type in the zoom factor required.  The zoom
factor is a number that represents the amount that the
current view will be "zoomed" by.  For instance, if
the current "zoom" level is 4 and the user types in 3
at the prompt, then the "zoom" level will become 12.  
Once the "zoom" factor has been established, the
system will display the prompt, "Zoom center @".  The
user must select the point in the current window that
the view will be "zoomed" around.  This point will
become the center of the window in the "zoomed" view.

[Edit] {CAD/CAM} {Zoom} {Level}

      When this command is selected, the system will
display the prompt, "Zoom level =".  The user must
then type in the level of zoom required.  Once the
"zoom" level has been established, the system will
display the prompt, "Zoom center @".  The user must
select the point in the current window that the view
will be "zoomed" around.  This point will become the
center of the window in the "zoomed" view.  The
current "zoom" level is shown on the readout line of
each window.

[Edit] {CAD/CAM} {Zoom} {ZoomScale}

      This command should be used if the user wishes
to produce printfiles or plotted output at a specific
scale.  The program will zoom the current window so
that it produces a specific scale on the hard copy
material.  The {QuikPrint} command, however, will not
print to this scale.
      When this command is selected, the user will be
prompted for the width of the page that the hard copy
is being scaled for.  The user must answer this prompt
in units appropriate for the setting of the {UCS}
{Units} menu.  
      The program will then prompt the user for a
scale factor.  This factor is in terms of the area
represented by the window to the physical area that
will be produced by the plot or printfile.  For
example, if the user replied 50 to the prompt, the
system would produce a scale where 1 unit in the plot
represented 50 real units.
      After the user has given an appropriate scale,
the system will zoom the current window so that
printed or plotted output will assume this scale.  The
program will then return the user to the {CAD/CAM}
menu.

[Edit] {CAD/CAM} {Zoom} {WndwZoomIn}

      This command allows the user to draw a box
around the area that they wish to "zoom" into.  The
system will display the prompt, "Zoom box corner @". 
The user must then select one corner of the box.  The
system will then display the prompt, "Zoom box
opposite corner".  As the user moves the cursor, a
"rubber band" box will form between the first point
selected and the current cursor position.  The user
then positions the box so it surrounds the area to be
zoomed and presses "Enter" or "MLB".  The zoom will be
performed so that the area within the box fills the
window.

[Edit] {CAD/CAM} {Zoom} {WndwZmOut}

      This command allows the user to draw a box
around the area that the current view within the
window will be put into.  This causes a zoom out
action.  The prompts are similar to the {WndwZoomIn}
command.

[Edit] {CAD/CAM} {Zoom} {ZmPrevious}

      This command causes the view to return to the
view before the last zoom or pan command was selected. 
For instance, if the user zoomed in to a level of "5"
and then zoomed out to a level of "2", then selecting
{ZmPrevious} would cause the screen to zoom back to a
level of "5".  If the user pans to the left 20 feet
and then selects {ZmPrevious}, the view would pan back
to the right 20'.  
      If there was no previous zoom or pan command in
the current drawing session, then the system will
perform a {ZoomLimits} command.  
      If the viewing angle has changed, the system
will zoom the view so that the previous zoom level is
achieved and the center point (cursor position when
zoom or pan performed) is again centered in the view,
but the view angle will not be changed. 

[Edit] {CAD/CAM} {Zoom} {ZoomLimits}

      This command zooms the view to a zoom level of
"1" and pans the view so that the database origin, (0,
0, 0), is in the center of the window.  This command
is very useful if the user has inadvertently "lost"
the view, as it resets the view to original zoom and
pan coordinates. 

[Edit] {CAD/CAM} {Zoom} {PullPan}

      This command allows the user to "pull" another
section of the drawing into view.  When this command
is selected, the system will display the prompt,
"Point to pull @".  The user must then select the
point on the drawing he wishes to "pull" on.  The
system will then prompt the user, "New position @". 
The user must then select point that the first point
selected will appear at on the screen.  After this
point is selected, the system will pan the view so
that the first point selected will appear at the
position of the second point selected.

[Edit] {CAD/CAM} {Zoom} {ReCenter}

      This command pans the view so that the current
cursor position becomes the center of the view in the
current window.

[Edit] {CAD/CAM} {Rdrw} menu

      This menu gives access to commands that provide
hidden line elimination and shading of the view. 
There are also utility commands that redraw and
regenerate the view.  Although the hidden line
algorythms are quite rudimentary and may not provide a
perfect rendering of the view, the user may, through
use of the tools provided in this menu, touch up the
view so that it is accurate.  What is lost in
precision of the view, is gained via the speed of the
rendering process.  These algorythms are substantially
faster than other, more accurate, algorythms.
      
[Edit] {CAD/CAM} {Rdrw} {ReDraw}

      This command redraws the current window
eliminating blips or ghosting that may have occurred
during use of other commands available in the system. 

[Edit] {CAD/CAM} {Rdrw} {ReGenerate}

      This command is used when the regeneration area
requires re-centering.  This is not normally required,
if the regeneration area has been set approximately
twice as large as the drawing area via the [Edit]
{CAD/CAM} {Vars} {Limits} command, but it will be
invoked automatically by the system when certain other
commands are used.
      The user will normally know when a regeneration
is required by the system because the bracket menu,
"Regenerate < Auto > < NewCenter >" will appear on the
top line of the screen.
      The way in which the <Auto> option works depends
on whether the current window is in "perspective" view
mode or "parallel" view mode.
      In "perspective" mode the screen will regenerate
at the current zoom level around exactly the same
point that was used for the previous regeneration, ie.
the drawing will pan back so this point is centered
and then do the regeneration.
      In "parallel" mode the screen will regenerate
around the center of the current window at the current
zoom level.  The drawing will not pan.
      The <NewCenter> option allows the user to select
the point at which the drawing will regenerate around. 
The system will display the prompt, "View center @"
and the user must then select the point that the
regeneration will be centered about.  This point will
become the center of the window in the new
regeneration.

[Edit] {CAD/CAM} {Rdrw} {RegenAll}

      This command will regenerate all windows that
are currently open.
      When this command is selected, the system will
display the regeneration bracket menu, "Regenerate
< Auto > < NewCenter >".  The menu is referring to the
current window only.  All other windows will
regenerate around their previously established
regeneration points while the current window will
regenerate according to the users selection from this
regeneration menu.

[Edit] {CAD/CAM} {Rdrw} {QuickHide}

      This command performs hidden line elimination
and shading on the view in the current window.  The
surfaces will be filled with the patterns that were
established when they were drawn.  The system will
also display the information line, "Sorting XXXX
surfaces  YYYY surfaces available.".  "XXXX" will be a
number that indicates the number of surfaces in the
current window.  "YYYY" will be a number that depends
upon the amount of available RAM in the computer and
indicates the maximum number of surfaces that
PrintCADD 3-D can handle.  This information may flash
by to quickly to see unless there are a significant
amount of surfaces in the current view.  The surfaces
are sorted according to the distance of the center
point of each surface from the view point.  The
surfaces are then displayed starting with the surface
whose center point is furthest from the view and
working towards the surface whose center point is
closest.  As each suface is displayed it blocks out
those surfaces behind it.  In many cases this produces
very good results while in others the results may not
be as good.  In virtually all cases however, the user
will be able to get a good idea of the relative view
point and the depths of the various surfaces.  This
will allow the user to re-order the surfaces with
other commands available in this menu.

[Edit] {CAD/CAM} {Rdrw} {HiddenLine}

      This command works in a similar fashion to the
previous {QuickHide} command except that the surfaces
will be screen background color.  This gives the
illusion of hidden line elimination but the surfaces
will not be patterned or shaded.

[Edit] {CAD/CAM} {Rdrw} {FillSurf}

      This command allows the user to fill surfaces
whose "center" or "fill" point was not within the
window when the {QuickHide} command was performed.  It
also allows the user to "pull" surfaces that should
not have been blocked to the front of the view.  This
essentially allows the user to re-order the surfaces
so that the view in the window is correct.
      When this command is selected, the system will
display the prompt, "Select surface @".  The user must
then place the cursor so that it falls within
"aperture" range of an edge on the surface.  The
system will then display the snap verification menu. 
After the user has verified the surface that he wishes
to fill, the system will display the prompt, "Fill
point @".  The user must then select a point on the
interior of the surface to be filled.  The system will
then fill the surface with the colors and patterns
that were selected for it when it was drawn.

[Edit] {CAD/CAM} {Rdrw} {PullSurf}

      This command is similar to the {FillSurf}
command except that the user does not need to select
the fill point.  The system will use the center point
that was established when the surface was drawn.  If
the fill point is not within the window the surface
will not be filled.

[Edit] {CAD/CAM} {Rdrw} {LinSurf}

      This command is identical to the {FillSurf}
command except that the surface will be filled with
the screen background color thus performing hidden
line elimination rather than shading of the surface.

[Edit] {CAD/CAM} {Rdrw} {NoClearRdw}

      This command does not clear the screen before
doing a redraw.  This command is useful if the user
has used a dashed line style for surfaces that have
had hidden line or shading done on them.  The hidden
lines will then appear as dashed lines in the window.

[Edit] {CAD/CAM} {Rdrw} {OutLinSurf}

      This command allows the user to outline a hidden
or open surface.  The user will be asked to select and
verify the surface.  The system will then draw that
particular surface.  This command is useful if the
user wishes to reveal text or dimensions that were
hidden by the hidden line elimination.  This command
has a down side in that the user must know where the
surface was before the hidden line elimination was
done because it will be hidden.  Usually this isn't a
problem but the user may wish to use the {DrawLayer}
command, discussed next, to perform this operation.

[Edit] {CAD/CAM} {Rdrw} {DrawLayer}

      When this command is selected the system will
display a list of layers used in the drawing.  The
user must select the layer they wish to have drawn. 
This command is very useful if the user needs to
reveal text or dimensions in a hidden line view of the
drawing.  By keeping the items that need to be
revealed in a separate layer, the user will be able to
reveal them with this command.

[Edit] {CAD/CAM} {View} menu

      This menu allows the user to rotate the viewing
angle of the drawing.  Through a combination {View},
zoom and pan the user will be able to derive any view
of the drawing they wish.

[Edit] {CAD/CAM} {View} {RotateXYZ}

      This command allows the user to set the viewing
angle by telling the system the amount of rotation
around each of the three principle axes of the
database.  The drawing will always be revolved about
the database origin, (0, 0, 0).  This command is easy
to use, if the user only needs rotation about one of
the axes, but becomes considerably more complicated
when two or three axes are used.  The system always
considers X rotation, then Y and finally Z.  The user
may wish to use other methods within this menu to
accomplish these complex rotations and then note the
view angles in the readout of the window for reuse. 
      When this command is selected, the system will
first display the regeneration menu, "Regenerate 
< Auto > < NewCenter >".  In this instance the
<NewCenter> option is probably the best as the system
will center the view about this point once the view
rotation has been done to the database.  The system
will then display, in turn, the prompts, "X rotation
=", "Y rotation =" and "Z rotation =".  The user must
answer these prompts with a number that represents the
degrees that the database will be revolved about each
axis.  After the last prompt is answered, the system
will perform the view rotation.

[Edit] {CAD/CAM} {View} {Aim}

      This command allows the user to perform a
"dynamic" rotation of the drawing using either a
"selection set" of surfaces in the drawing or the
first {Vars} {DragLevel} amount of drawing "elements"
that fall within the boundaries of the window at the
view angle being shown.  
      When this command is selected the system will
display the regeneration menu, "Regenerate < Auto >
< NewCenter >".  Again the <NewCenter> option is
probably the best as the user will be able to select
the point that the view will keep centered in the
window. 
      The system will then display the bracket menu, 
"Aim type < File > < Group >".  The <File> option uses
the {Draglevel} setting to determine the number of
elements that will be displayed for "aiming" purposes
while the <Group> option allows the user to select the
surfaces they wish to use as an "aiming" device.
      If the <Group> option is selected the user will
have to go through a selection process that is
identical to that of the [Edit] {CAD/CAM} {Grup}
commands.  This group, however, is a completely
different "group" than those used in the {Grup}
commands, so the <Previous Group> option is only valid
if you have already selected an "Aim" selection set,
not a {Grup} selection set.  See [Edit] {CAD/CAM}
{Grup} menu for information on establishing selection
sets.  After the selection set is established the
system will display the "Aim" bracket menu.
      If the <File> option is selected the system will
go directly to the "Aim" menu, "< Axis > = X  <-90> 
<-45> <-10> <-5> <-1> <1> <5> <10> <45> <90> 
< Regen >".
      The <Axis> option will toggle between "X", "Y"
and "Z" and represents the axis about which rotation
will be done.  
      The <numbers> represent the amount of rotation
that will be applied to the selected axis.  When one
of the <numbers> is selected the "elements" or
"selection set" will be rotated around the given axis
thus allowing the user to "aim" the view. 
      The <Regen> option will cause the drawing to be
regenerated with the new view and return the user to
the {CAD/CAM} menu.
      If the user presses "Escape" or "MRB" the system
will redraw the old view and return the user to the
{CAD/CAM} menu.



[Edit] {CAD/CAM} {View} {TopPlan} ... {LeftPlan}

      The various "Plan" views allow the user to
select the direction in which the view is directed. 
{TopPlan} is the original view when the drawing is
first created.  All other {Plan} views refer to other
directions of view.  The user will be prompted to use
<Auto> or <NewCenter> and then the view will be
regenerated with the appropriate viewing angle.  After
the drawing is regenerated, the system will display
the menu, "Set UCS to view < Yes > < No >".  This menu
allows the user to make certain that the UCS and view
correspond.  If the user selects <Yes> the system will
perform a command identical to that of the [Edit]
{CAD/CAM} {UCS} {UCStoView} command and then return
the user to the {CAD/CAM} menu.

[Edit] {CAD/CAM} {View} {ViewToUCS}

      This command allows the user to align the view
to the current UCS.  After this command is performed,
the view will be aligned so that the user is looking
directly down on the current UCS.  The origin of the
UCS will be in the center of the window, the bottom
and top of the window will be parallel to the X axis
of the UCS and the left and right borders of the
window will be parallel to the Y axis of the UCS. 
Once the user is comfortable with the idea of "User
Coordinate Systems" and how they are used and created,
they will find that this is probably the easiest
manner in which to get a view.  The user can use a
combination of {CAD/CAM} {UCS} {3Point} and
{ViewToUCS} to precisely align the window in a certain
viewing direction.  See [Edit] {CAD/CAM} {UCS}
{3Point}.

[Edit] {CAD/CAM} {View} {Look}

      When the user selects this command the system
"hides" the {CAD/CAM} menu, allowing the user to see
anything that lies under it.  To have the menu return,
press any key or mouse button.  

[Edit] {CAD/CAM} {Wndw} menu

      PrintCADD 3-D can have up to 4 windows.  Each
window can have an independent view angle, zoom, pan
and projection type.  Each window will show where the
cursor lies in relation to its own view angle and all
"rubber band" drawing entities will show independently
in each window as the entity is being placed.  This
allows the user to visually assure themselves that the
drawing is being properly constructed in 3-D space. 
Each window also has its own independent UCS, allowing
the user to select windows without having to go
through the process of re-setting or adjusting the
UCS.  Windows may be any shape allowing the user to
utilize the screen space to it's maximum, ie long
narrow windows for tall objects and long side views or
square windows for symetrical objects.

[Edit] {CAD/CAM} {Wndw} {Select}

      This command allows the user to select the
"current" window.  Many commands relate to the
"current" window.  For example, when the user selects
{Redraw}, the "current" window redraws, if the user
selects {UCS} {3Point} then the UCS is for the
"current" window, if the user selects a {Zoom} command
then the zoom is performed in the "current" window.
      The current window can be recognised by the fact
that it's upper "readout" line is highlighted.  The
window's "number" will be visible in the upper left
hand corner of the readout (That is if the readout has
not been "shifted" via the {Vars} {WndwRdOut}
command).  The {Select} command uses this number to
identify which window is being selected.
      When this command is selected, the system
displays the menu, "< Window 1 > < Window 2 > 
< Window 3 > < Window 4 >".  After the user selects
the window that they wish to make "current", the
system will display the menu, "Regenerate < Auto > 
< NewCenter >".  This prompt is referring to the
"current" window, not the one that you are about to
make current.  This allows the system to determine how
the window will be when you return to it.  It also
determines how it will be regenerated when the {Rdrw}
{RegenAll} command is used.  After the user has
selected the appropriate response, the system will
regenerate the selected window and highlight the upper
readout bar.  The user will then be returned to the
{CAD/CAM} menu.

[Edit] {CAD/CAM} {Wndw} {Create}

      When this command is selected, the system will
display the regeneration menu.  The system is
referring to the current window, not the one that is
being created.  After the user has selected the
appropriate response, the system will display the
prompt, "Upper left window corner @".  The cursor will
not be restricted to the current window but will be
free to move throughout the "window area".  The [Draw]
menu will not be available for use.  The user must
then move the cursor to the point that they wish to
use as the upper left corner of the window.  Unlike
other drawing commands the window corner will be
entered whether the "Enter", "Escape", "MLB" or "MRB"
is pressed.  Although windows are allowed to overlap
this may become confusing because two cursors and two
drawing objects will appear in the same window.  This
may have other uses though, especially when used in
conjunction with screen capture utilities or the DOS
graphics command.  
      After the user has selected this point, the
system will display the prompt, "Lower right window
corner @".  The system will "rubber band" a box
between the previously selected point and the cursor,
allowing the user to visualize where the window will
appear.  Once this point is selected, the system will
form a window and regenerate the drawing oriented in a
"Top Plan" fashion within this window.  This window
will be given a number and will become the current
window.

[Edit] {CAD/CAM} {Wndw} {Close}

      When this command is selected, the system will
display the menu, "Window to close ? < Window 1 >
< Window 2 > < Window 3 >".  In fact, only those
windows which are allowed to be closed, will be shown
in brackets to the right of the prompt.  The current
window ca never be closed.  Once the user has selected
the appropriate window to be closed, the system will
blank the area that the window used to cover and
return the user to the {CAD/CAM} menu.

[Edit] {CAD/CAM} {Wndw} {Resize}

      After this menu item is selected, the system
will display the regeneration menu.  After the user
has selected the appropriate resonse, the system will
blank the area that the current window used to be in
and display the prompt, "Upper left window corner @". 
The user must then select the position on the screen
where the upper left window corner will appear.  The
system will then display the prompt, "Lower right
window corner @".  A "rubber band" box will appear
between the previously selected point and the cursor. 
Once the second corner of the box is selected, the
system will regenerate the window and the user will be
returned to the {CAD/CAM} menu.

[Edit] {CAD/CAM} {Wndw} {Projection}

      This menu allows the user to select from two
different types of projection.  The "parallel"
projection receives it's name from the fact that the
"projectors" remain parallel even as they go further
into the distance.  On the other hand, the
"perspective projectors" converge towards a single
point as they go further from the viewing position.  
"Projectors" are lines that run parallel to the "view"
Z axis.  If the user does either a {ViewToUCS} or a
{UCStoView} then the "view" Z axis and the UCS Z axis
will be in the same direction.
      The parallel projection is useful from a
drafting stand point because the X and Y lengths can
be measured directly from the a plan view without fear
that lines which are parallel but at a greater
distance will be smaller.
      The perspective view gives a much more realistic
view of an object.  The depth of objects can be
conveyed because items grow smaller as they get
further away.
      When this command is selected, the system will
display the menu, "< Parallel > < Perspective >".
      If the user selects <Parallel>, the system will
display the menu, "Regenerate < Auto > < NewCenter >". 
After the user has selected the appropriate response
the system will regenerate the window to a "parallel"
view and return the user to the {CAD/CAM} menu.
      If the user selects <Perspective>, the system
will display the prompt, "Vanishing Point @".  The
user must select the point to which all of the
projectors will eventually converge. 
      Once the vanishing point is selected, the system
will display the prompt, "Viewing distance =".  If the
viewing position is closer to the object, then the
perspective effect will be more pronounced and vice
versa.  The user may use the standard methods, based
on the setting of {UCS} {Units}, for giving this
distance to the system.  The view point will be set
back this amount of distance from the plane that is
parallel to the current view and intersects the
database origin.   
      Once the viewing distance is set, the system
will display the prompt, "Clipping distance =".  The
clipping distance is measured from the eye, forward. 
This allows the user to cut away walls or other
obstructions that lie between the view point and the
object that the user wishes to view.  Again, this
length may be given in units that correspond to
imperial, metric or scientific depending on the
setting of the {UCS} {Units} setting.
      The system will then display the regeneration
menu.  After the user has responded appropriately, the
system will regenerate the view in perspective mode.

[Edit] {CAD/CAM} {Wndw} {Aspect}

      This command adjusts the aspect of the current
window to provide the user with a "square" view.  This
command is needed because not all monitors offer an
exact ratio of four units width to 3 units height. 
This is the normal ratio that PrintCADD 3-D uses
internally when presenting the drawing in the window. 
This ratio is normalized to a value of 1 for the user. 
The user may find the exact value for use on his
monitor by drawing a large square on the screen,
making sure that the UCS and view are aligned.  The
user must then measure the square on each side with a
ruler.  The level of aspect, to make the square appear
square, is then the ratio of the height of the square
over the width of the square.
      When this command is selected, the system will
display the prompt, "Aspect (.1-10) =".  The user must
then type in the ratio that they require.  The system
will then display the regeneration menu and will
regenerate the window with the correct aspect after
the appropriate selection is made.
      One other use for this command may be to square
up {Quik Print}'s made in the [Output] menu.  By
experimentation with the {Aspect} menu item a user
should be able to make these prints appear with the
proper aspect no matter what the printer and video
mode.  This is what PrintCADD 3-D does automatically
when doing {Plot Print}'s.

[Edit] {CAD/CAM} {UCS} menu

      This menu controls most of the aspects of the
user coordinate system.  As the UCS controls the
behaviour of a great many of the commands in PrintCADD
3-D, the user should have a thorough understanding of
this term and it's application.  The user may want to
review the chapter on 3-D geometry and coordinate
systems at the beginning of the manual.

[Edit] {CAD/CAM} {UCS} {3Point}

      This command allows the user to establish a user
coordinate system via the use of three points.  The
user will be prompted, in turn, to select the origin
of the UCS, a point on the X axis of the UCS and a
point in the positive Y direction of the UCS.  The
system will then be able to determine the directions
in which all three axes of the UCS run, as well as to
align the cursor so that it runs parallel to these
three axes when the appropriate keys are pressed or
the mouse is moved.

[Edit] {CAD/CAM} {UCS} {UCStoView}

      When this command is selected, the system aligns
the UCS so that the origin is in the center of the
window, the X axis runs parallel to the top and bottom
of the window, the Y axis runs parallel to the left
and right sides of the window and the Z axis runs
perpendicularly to the window.  The UCS is thus
aligned with the view.  This command is especially
useful if the user wishes to keep text square to the
view.

[Edit {CAD/CAM} {UCS} {Origin}

      This command alines the UCS so that it
corresponds directly to the internal database
maintained by PrintCADD 3-D.  This conforms to the top
plan view with the origin in the center of the window,
established when the drawing was first created.

[Edit] {CAD/CAM} {UCS} {CursrSpace}

      This command sets the amount of space that the
cursor will jump parallel to the current UCS axes when
the appropriate key is pressed or the mouse moved. 
Mouse movement is actually governed by a multiplier
effect that detects the speed of the mouse as well,
but the movements will be a multiple of the basic
spacing units in the X and Y directions.  It is
important to note that, as the cursor moves towards
the view point in perspective viewing mode that these
jumps seem to get larger.  In fact the jump remains
the same, but the divergence of the projectors as they
approach the view point becomes larger.  This is
consistent with the fact that although an inch at 100'
can barely be seen while at 1' away from the eye it is
easily seen.  In either case 1 inch remains 1 inch. 
When this command is selected the system will prompt,
"X axis spacing =", "Y axis spacing =" and "Z axis
spacing =".  The user may respond to these prompts
with a length that is consistent with the current
setting of the {UCS} {Units} command.  The user will
be returned to the {CAD/CAM} menu after these prompts
are answered.

[Edit] {CAD/CAM} {UCS} {Units}

      This menu item controls the type of units that
the system will display in the coordinate readouts at
the bottom of the screen.  It also controls the units
that the dimensioning utilities will apply to the
drawing as well as the way in which lengths are parsed
by the system.  
      When this command is selected, the system will
display a list menu that contains 43 different
formats, in 3 groups, for use within the program.  The
first 21 use imperial measurements, the next 15 are
metric, while the last 7 are "generic".  
      If the user selects any one of the first 21
formats, the system will parse user input as imperial
measurements.  The coordinate readouts will format
according to the format displayed in the list menu and
all dimensions, other than angular, will use this
format.  
      Choosing one of the other two groups will have
the same effect.  
      The user may freely choose any unit, at any
time, however, the "generic" input will be stored in
the file as inches.  Generic is useful when
dimensioning because the ', ", m and cm signs can be
replaced by the users own "suffix", (See {CAD/CAM}
{Dims} {Pre/Suffix}).
      After the user has selected the measurement, the
system will return the user to the {CAD/CAM} menu.

[Edit] {CAD/CAM} {UCS} {VisiGrid}

      This command allows the user to create a grid
that can cover any parallelogram shaped surface.  The
user can use this grid for [Draw] {GridSnap} snaps. 
The user may align the grid at any orientation in 
3-D space.  
      When the user selects this command, the system
will display the menu, "Grid Type < Off > < Dot > 
< Line >".  
      The <Off> command allows the user to turn the
current grid off.  The grid will not dissapear until a
{Redraw} or {Regenerate} is performed.  The grid will,
however, become inactive.
      The <Dot> command draws a grid with dots while
the <Line> command draws a grid of intersecting lines. 
In either case, if one of these commands is selected,
the system will display the prompt, "First corner @". 
The user must then select a point for the first corner
of the parallelogram that describes the grid.  This
corner is the "origin" of the grid.  The grid will be
measured outward from this point along the two edges
of the parallelogram.  After this point is selected,
the system will prompt for the second and third
corners of the parallelogram.  The system will "rubber
band" the parallelogram, allowing the user to
visualise the shape of the grid.
      After all three points on the parallelogram are
selected the system will display the prompt, "Grid
spacing origin @".  This point will be used as the
relative point of the grid spacing.  After this point
is selected, the system will display the prompt, "Grid
spacing offset @".  The distance between these two
points determines the spacing that will be applied to
the grid.
      The system will then draw the grid and return
the user to the {CAD/CAM} menu.

[Edit] {CAD/CAM} {Exit}

      When this command is selected the user will be
returned to the "Main" menu.

[Edit] {Touchup} menu system

      This menu system is identical to the {CAD/CAM}
menu system.  The difference between these two menus
lies in the fact that most of the commands are
temporary.  The user can then have a drawing that
contains a house plan and pull a view from the
drawing.  He may then "touch it up" with dimensions,
"title it" and "personalize it" with a client's name
before printing it.  All of these changes will be
temporary.  The user can then exit the program and
when the drawing is retreived again, the changes will
be gone.
      Not all changes are temporary.  If the user uses
the {Grup} or {Mdfy} menu items on objects in the
drawing file, that were in place before entering the
"Touchup menu", then these items will be changed.  
      If the user enters the {CAD/CAM} menu system,
the system will warn the user that changes will be
lost and then regenerate the drawing with all changes
eliminated.
      Refer to the {CAD/CAM} commands for information
regarding the use of each command.

[Edit] {PrintEd} menu

      This menu system allows the user to edit {Print
Plot} files.  It performs bitmap oriented editing on
these files.  Some of the uses for this feature
include adding borders to the file, using "freehand"
drawing to "sign" the file or enhancing a feature of
the {Print Plot} that did not stand out when printed. 
Essentially, the user has control over each dot that
the printer will print.  The user may even keep a
{Print Plot} of a drawing with nothing in it and use
this feature to draw and print quick sketches.
      When this command is selected, the system
displays a list of all available {Print Plot} files as
well as the prompt, "Select printfile to edit _". 
After the user has selected the appropriate file, the
system will display the {Regenerate} menu.  The system
is referring to the regeneration that will take place
once the {PrintEd} menu is exited.
      The system then blanks the screen and displays a
box within a box, an "X = 0" readout, a "Y = 0"
readout and the prompt, "Pan mode @".  The user will
be able to move the inner box via the keyboard or
mouse.  The outer box represents the printfile as it
would look if printed to paper while the inner box
represents the amount of that file that the screen can
hold for editing at one time.  Because the printfiles
vary in their "aspect" according to the printer that
the printfile was destined for, the inner box may not
bear a resemblance to the screen shape.  The "X" and
"Y" readouts at the top of the screen tell the user
how many inches the inner box is away from the top
corner of the "paper".  As this system can print long
Y axis plots the Y readout may continue to grow even
though the box seems to have hit the bottom of the
paper.  Similarly, when panning up, the readout will
continue to decrease even though the inner box is
touching the outer box.
      After the user has selected the area that needs
editing, the system will load the selected area to the
screen and display the menu, "< Draw > < Line > 
< Blot > < Fill > < Bitpan > < Reload > < Exit >". 

[Edit] {PrintEd} <Draw> 

      If the user selects <Draw> the system will go
into a "freehand" drawing mode, the prompt, "Press
Scroll Lock to toggle draw mode", as well as a cursor,
will appear.  The user may use the numeric keypad and
"Shift" keys to move the cursor.  When using the keys,
the user must press "Scroll Lock" "on" to start
drawing and "Scroll Lock" "off" to move the cursor
without drawing.
      If the user has a mouse then the mouse will draw
while "MLB" is pressed and stop once it is released. 
      The user must press "Escape" or "MRB" to exit
back to the {PrintEd} menu.

[Edit] {PrintEd} <Line>

      If the user selects <Line>, the system will go
into a line drawing mode, the prompt, "Start point @",
as well as a cursor, will appear.  The user may use
the numeric keypad and "Shift" keys to move the
cursor.  This command is very similar to the [Edit]
{CAD/CAM} {Line} {Line} command in the way that it
works.  After the user has selected the start point,
the system will display the prompt, "End point @". 
The system will "rubber band" a line between the start
point and the cursor.  After the user selects an end
point, the line will solidify and the system will
continue to display the prompt, "End point @".  The
user may continue to draw lines or press "Escape" or
"MRB" to exit back to the start point prompt.  At this
point the user can either, move the cursor and select
another start point or, press "Escape" or "MRB" to
exit back to the {PrintEd} menu.

[Edit] {PrintEd} <Blot>

      If the user selects <Blot>, the system will
display another bracket menu, "< Continue > < Mode > =
"Blot" or "Erase"   < Size > = 10".  
      If <Mode> is selected the system will toggle
between "Blot" and "Erase".  In "Blot" mode the person
will be able to draw with a square shaped drawing
tool.  In "Erase" mode the user will be erasing with
this tool.  
      The <Size> command allows the user to change the
size of the square drawing tool to between 1 and 30
pixels along a side.
      When <Continue> is selected, the system will
display the prompt, "Press scroll to toggle blot mode
@" and a cursor will appear.  The user may use the
numeric keypad and "Shift" keys to move the drawing
tool.  When using the keys, the user must press
"Scroll Lock" "on" to start bloting or erasing and
"Scroll Lock" "off" to move the tool without drawing.
      If the user has a mouse then the mouse will
erase or blot while "MLB" is pressed and stop once it
is released. 
      The user must press "Escape" or "MRB" to exit
back to the {PrintEd} menu.

[Edit] {PrintEd} <Fill>

      This command allows the user to "grab" a pattern
and use it to fill an area.  The user will be able to
"match" a pattern that already exists in the drawing. 
      When this command is selected, the system will
display the prompt, "Place box around pattern you wish
to duplicate @", and a box shaped cursor will appear
on the screen.
      The system will "grab" the pattern that falls
under this box when "Enter" or "MLB" is pressed.  The
system will then display the prompt, "Fill @", and the
box shaped cursor will turn into a "crosshair" style
cursor.  The user must then select the area to fill. 
The area should be totally enclosed or the fill
pattern will "leak" out the sides of the area.  This
pattern may not be identical to the pattern selected
due to a bug in the Microsoft PD7 (C) and QuickBasic
(C) compilers as documented in the PrintCADD 3-D help
files.  The system will adjust patterns that have a
chance of locking the computer, into patterns that
shouldn't lock the computer.  If this happens to one
of the patterns the user has selected and the results
when filling the area are unsatisfactory, then the
user should select <ReLoad> from the {PrintEd} menu.
      The user should be aware of the fact that
intricate patterns that fill inside of other intricate
patterns can take an extremely long time to do their
job.

[Edit] {PrintEd} <BitPan>

      This command allows the user to pan to another
portion of the {Print Plot} file.  When the user
selects this command, the system displays a virtually
identical panning menu to the one encountered when the
{PrintEd} menu was entered.  The one difference is
that there will be a third box on the page.  This
third box represents the area that you were just
working on.  In this manner you will be able to judge
the next area that you may have to work on a little
easier.  
      After the user selects the new area, the system
will save the current area if the user has worked on
it, and pan to the new area.  The user will be
returned to the {PrintEd} menu.

[Edit] {PrintEd} <ReLoad>

      This command allows the user to "reload" te area
of the {Print Plot} that they were working on, thus
erasing any changes that may have been made to the
drawing.  This can come in handy if a "fill" has
leaked out the edge of a surface and blotted the
entire area.
      When this command is selected, the system will
reload the screen and return the user to the {PrintEd}
menu.

[Edit] {PrintEd} <Exit>

      When the user selects this command, the system
saves the {Print Plot} file, if the user has made any
changes, and then regenerates the drawing that was
being worked on before the {PrintEd} menu was entered. 
It then returns the user to the [Edit] menu.

[Output] menu

      This menu system allows the user to get hardcopy
from the drawings.  It is designed to work with most
IBM (C) 8 and 24 pin, Epson (C) 8 and 24 pin and Tandy
(C) 24 pin dot matrix printers.  The system also
prints to Laserjet (C) printers.  Most other printers
on the market are compatible with one of these
printers.  

[Output] {Print} {Printer}

      When this command is selected, the system will
display the prompt, "Select print driver _" along with
a list of all print drivers available for use.  The
user must select the print driver that he wishes to
use.  This is the driver that will be used by
PrintCADD 3-D for printing the drawing.  Although
these driver files may be renamed at the DOS level by
the user, when shipped by Birdseye software, these
drivers are named according to a code.  The first 8
letters of the print driver file name represent the
code.
      The first two letters of the code indicate the
manufacturer of the printer.  These codes are, "IB"
for IBM (C), EP for Epson (C), TA for Tandy (C) and HP
for Hewlett Packard (C).  The next two numbers
indicate the number of pins the printer has,  "08" for
8 pin printers, 24 for 24 pin printers and "01" for
laser printers.  The next letter indicates whether the
printer is laser, "L"  or dot matrix, "D". the final
three numbers indicate the horizontal resolution, in
dots per inch, of the print driver.
      All printer driver file names have the
extension, ".PRD".

[Output] {Print} {Port}

      When this command is selected, the readout at
the top of the screen will switch from "Lpt1" to
"Lpt3" and then "Com1" to "Com4" and finally back to
"Lpt1".  This represents the DOS printer port towards
which output will be directed.  See your DOS manual if
you do not understand these terms.  If the user has a
serial printer, then they should use the DOS "Mode"
command to set the baud rate and appropriate protocol
for the serial port.  Look under "Mode" in the DOS
manual that comes with your computer for information
on how to set this protocol.

[Output] {Print} {Shading}

      "Shading" cause the system to interpret the
color of the pixel as a group of four dots.  When this
command is selected, the readout at the top of the
screen, "Shade =", will toggle between "Yes" and "No".
      The "Yes" option effectively halves the
resolution of the printing in both the vertical and
horizontal directions but allows the user to produce
printings that are shaded according to the color of
the pixels. 
      The "No" option simply prints the pixel as a
single dot if it is not background color.  This
provides the highest resolution available but the user
should make use of "patterns" to determine the shading
of the various surfaces within the drawing.
      
[Output] {Print} {PrintFile} <Create>

      This command allows the user to produce files,
that may later be printed, that are formatted to the
width of the page and the "aspect" of the printer
driver.  This means users can use their printers as 
long Y axis plotters.
      These files may also be edited via the [Edit]
{PrintEd} commands.
      These files are constructed from the current
view in the current window.  They are formatted so
that the current view width will exactly format to the
width of the page defined in the current printer
driver.  The length of the printed page will keep the
same ratio as the current window displays on the
screen. ie if the window shows an area of 2 feet in
width by 3 feet in length and the print driver has a
width of 8 inches then the length of the printout will
be 12 inches.  The scale of this drawing would be 8
inches to 24 inches or 1 to 3.  By use of the {Zoom}
{ZoomScale} command the user may set the scale of the
printfile to whatever is needed.
      As the resolution of the print driver increases,
and the length to width ratio increases, the amount of
information that must be processed increases
dramatically, eg. a laser printfile at 300 dpi and 10
inches in length will have to encode 300 x 300 x 8 x
10 or 7,200,000 printer dots and requires a printfile
of over 900,000 bytes.
      For these reasons it helps to have a fast
computer and ample disk space when doing very high
resolution printfiles.  Also remember that the shape
of the window plays an important roll in determining
the file size.
      When this command is selected, the system will
display the prompt, "Printfile name >".  The user must
reply with an 8 or less letter name for the file using
standard DOS conventions.  This name will then have
the extension, ".PFL" appended to it.
      The system will then display the menu, "Filesize
= ????K  Redraws = ??  < Touchup >
< Continuous > < Abort >".  The size of the file is
shown in kilobytes and the "Redraws =" refers to the
number of redraws that the system will have to perform
in order to create the required printfile.  This
allows the user to establish some sort of reference to
the resources that are required before proceeding with
the printfile.  
      If the user selects <Touchup>, the system will
display the message "Creating printfile ..." and
proceed to allocate disk space for the printfile.  The
system will then draw a portion of the drawing in the
current window formatted to the aspect of the printer. 
This may cause some distortion of the shown picture if
the aspect of the screen and the printer driver are
not the same.  The system will also display the menu,
"< Cont > < Abort > < QHide > < LHide > < OutLn > 
< FSurf > < LSurf > < DLay >".  This menu allows the
user to perform various "touchups" to what is shown
before it is saved to the file.  
      The <Cont> command proceeds to save what is
shown to the printfile and then redraws the screen
with a different portion of the drawing shown and
displays the "touchup" menu once more.  This process
is repeated until all sections of the drawing have
been drawn and touched up.  The system will then
redraw the view that was originally in the window and
return the user to the {Print} menu.
      The <Abort> command allows the user to abort
this process.  The file will be erased from disk and
the system will return to the {Print} menu.
      All other commands in this menu work identically
to the commands shown in the follwing table and the
user should refer to these other commands for
explanations on their use and purpose.

  Menu Item              Refer to
------------------------------------------------------
   <QHide>  -  [Edit] {CAD/CAM} {Rdrw} {QuickHide}
   <LHide>  -  [Edit] {CAD/CAM} {Rdrw} {HiddenLine}
   <OutLn>  -  [Edit] {CAD/CAM} {Rdrw} {OutLinSurf}
   <FSurf>  -  [Edit] {CAD/CAM} {Rdrw} {FillSurf}
   <LSurf>  -  [Edit] {CAD/CAM} {Rdrw} {LineSurf}
   <DLay>   -  [Edit] {CAD/CAM} {Rdrw} {DrawLayer}
------------------------------------------------------

      If the user selects <Continuous>, the system
will create the file as before but will not stop to
display the "touchup" menu between each redraw.  
      If the user selects <Abort>, the system will
abort the process and return the user to the {Print}
menu.

[Output] {Print} {PrintFile} <Print>

      When this command is selected, the system will
display a list of all printfiles.  The user must then
select the printfile to be printed.  The system will
then display the menu, "Get printer ready < Continue >
< Abort >".
      If the user selects <Continue>, then the system
will print the printfile to the currently selected
printer port and then return the user to the {Print}
menu.
      The <Abort> command aborts the printing process
and returns the user to the {Print} menu.

[Output] {Print} {QuickPrint}

      This command allows the user to dump the
contents of the current window to the printer.  The
print is not corrected for aspect so the user must use
a print driver that is similar in aspect to the
current video mode or perform a correction of the
aspect using the [Edit] {CAD/CAM} {Wndw} {Aspect}
command.
      When this command is selected the system
displays a box within a box overlaid on the current
screen.  The user may use the arrow and shift keys or
the mouse to move the inner box.  The outer box
represents a sheet of paper while the inner box
represents the shape and the positioning of the
printed output.
      After the user has positioned the box correctly
they must press "Enter" or "MLB" in order to continue
the operation.
      The system will then display the menu, "Get
printer ready < Continue > < Abort >".
      If the user selects <Continue>, then the system
will print the printfile to the currently selected
printer port and then return the user to the {Print}
menu.
      The <Abort> command aborts the printing process
and returns the user to the {Print} menu.

[Output] {Print} {Exit}

      This command returns the user to the main menu.

[Output] {Plot} 

      This command allows the user to send output to the plotter or to a file as HPGL.  Your plotter must be compatible with this plotting language.  The user can also build plot drivers that provide custom setup of the plotter.
	When this command is selected, the software will display the menu, "< Port > = Lpt1 < MirrorX > = 0 
< MirrorY > = 0 < MakeDriver > < Plot >".
	Each time the <Port> option is selected, the software will cycle through the ports, "Lpt1", "Lpt2", "Lpt3", "Com1", "Com2", "Com3", "Com4" and "File".  If the "File"  option is selected, the system will prompt for a filename when the <Plot> option is selected.  If one of the "Com" options is selected, the user must set the appropriate communications parameters via the DOS "Mode" command.  For information on this command, refer to the DOS manual for your computer.
	The <Mirror> options allow the user to flip the file about the "X" or "Y" plotting axes.  When a zero, (0), is displayed, it means that the axis will not be flipped.  To mirror the axis simply select the appropriate <Mirror> option and the zero, (0), will turn to a one ,(1).
	The <MakeDriver> option allows the user to customize their own plot driver. When this command is selected, the software will prompt the user for several pieces of information.  Some of this information is measured according to the settings of the [Edit] {CAD/CAM} {UCS} {Units} menu so be aware of the way it is being parsed ie don't use metric if you are giving the units in inches.

"Initialization codes >"

	The software requires the user to type in a string of letters or "escape" codes that set the plotter in HPGL mode and initialize the plotter.  The normal initialization code for HPGL plotters is simply, "IN;".  If the user requires that escape codes be sent to select HPGL mode, then they must use the "Alt" key in conjunction with the numeric keypad to create the appropriate code. eg "Alt" "27" would produce the ASCII code # 27 or "Escape".  The system will display the code as a left pointing arrow.  The user may also rotate the plot with the sequence "RO90;".  This would put an HPGL laser printer into "landscape" mode.  The user could invoke a clipping window via the, "IW;" command.  The user might also try executing a laser printer macro that printed the company logo on the paper before plotting.  These are just a few of the ways that initialization codes can be used to produce customized plots.

"Finish codes >" 

	These codes are the same as the initialization codes except that they are sent to the plotter at the end of the plotting sequence.  The user could send a page feed command or return the plotter to its previous mode.

"Plot width ="

	The user must type in the width of the plot.  This data will be parsed according to the {UCS} {Units} setting.  Make different drivers for different sized plots.

"Plot length ="

	The user must type in the length of the plot.

"Step size ="

	The user must type in the stepping size for the plotter.  It is normally .001 inches.  On some lasers it may be 1/1024 inches.  Check the plotter manual for this specification.  

"Number of pens (1-15) ="

	The user must type in the number of available pens on this plotter.  Any color in the drawing that is higher than this pen number is converted to the highest available pen number.

"Number of styles (1-15) ="

	The user must type in the number of line styles that the plotter can use.  Any line style in the drawing that is higher than this pen number will be converted to the highest available style number.  HPGL laser printers normally have 7 styles, "ST;" and "ST1;" to "ST6".  "ST0;" is not supported.

"Name for driver file >"

	The user must type in a name, 8 letters or less, that they wish to remember their newly created driver by.  The system will append the extension, ".PLD", to the name given and save the plot driver.  The user will then be returned to the {Plot} menu.

	The <Plot> option invokes the plotting process.  The software will first display a list of plot drivers from which the user may select the one they wish.  If the <Port> option is set to "File", the system will then prompt the user for the name that they wish to remember this plot file by.  The user must type in a name that is 8 characters or less and the system will append the extension, ".HPG" to the filename.  The system will then send the plot commands to the file.  The "File" option is very useful when debugging plot drivers because HPGL files can normally be loaded into a word processor for analyzing the output.  The user will find that they can also use the DOS, "Copy" command to send this file to the port of their choice.  
	To "Scale" plots, the user must use the {Zoom} {ZoomScale} command to scale the window so that it conforms with the width of the output device.  Plots will be clipped exactly to the view in the current window.  They will however, exactly fit the width denoted in the <MakeDriver> command.
	After the system has finished plotting, the user will be returned to the {Plot} menu.
	
[Output] {Driver} <Print Driver>

      This command allows the user to "build" printer
drivers.  PrintCADD 3-D is shipped with pre-made
printer drivers that cover most types of printers but
the user may find that on their personal clone
printer, the print is not quite square or that they
need access to other modes of printing not normally
available.  This command allows the user to take care
of these situations as well as being able to customize
page sizes and take advantage of wide body printers.
      In order to take advantage of this feature, the
user must be familiar with escape codes and in
particular the escape codes used on the printer in
question.  For this reason it is almost a necessity
that the user have his or her printer manual
available.  The user must also know the printing
resolutions of the printer in question. 
      All escape codes are entered as decimal numbers,
so if the printer lists hexadecimal escape codes, then
these must be converted to base 10 before proceeding. 
Likewise, if the printer manual lists letter codes,
then the user must use an ASCII table to cross
reference the actual decimal ASCII value of the letter
before proceeding.  Fortunately most printer manuals
list all three of these values as well as the
resolutions of the different printing modes.
      When the system requests the values for an
escape sequence or control code, the user enters a
single number between 0 and 255.  The system will then
again display the same request so that another number
between 0 and 255 may be entered. 
      Once the user has entered all the codes for a
particular sequence, they must press the "escape" key
to proceed to the next prompt. 
      Several of the prompts ask for actual values and
in this case the user must simply type in the
particular value rather than the ASCII code for the
value.
      The following section explains each prompt and
gives examples of the appropriate response for each
prompt.  Text following the semi colons (;) are
comments.  "Enter" means press "Enter" or "Return"
key.  "Escape" means press "Escape" or "Esc" key.  For
further information examine the PrintCADD 3-D help
system and the sample printer drivers given therein.

"Setup code ="

      The system requires the user to enter the
control or escape sequence that sets the appropriate
page size, paper feed and if required top of form set.
This sequence is sent by system before printing
begins.

IBM (c) 24 pin triple density (180 horizontal DPI) X24

Setup code = 27 "Enter"   ; 27 means escape
Setup code = 65 "Enter"   ; 65 n/72 inch paper feed
Setup code = 8  "Enter"   ; 8/72 inch paper feed
Setup code = 27 "Enter"   ; escape sequence
Setup code = 50 "Enter"   ; make paper feed active
Setup code = 27 "Enter"   ; escape sequence
Setup code = 67 "Enter"   ; page length, top of form
Setup code = 0  "Enter"   ; required filler
Setup code = 11 "Enter"   ; 11 inch page
Setup code = "Escape"     ; next prompt

"Line start code ="

This code is sent before the graphics information is
sent to the printer.  It normally sets the appropriate
graphics mode.

Line start code = 27  "Enter" ; escape sequence
Line start code = 91  "Enter" ; bit image mode
Line start code = 103 "Enter" ; bit image mode
Line start code = "Escape"    ; next prompt

"Name code ="

This code will be one of "IBM", "Epson", "Tandy" or
"HP".  This code determines the way in which the
system  will format the length of line data which
needs to be sent in conjunction with the graphics mode
selection.  The "IBM" code is designed for formatting
this information according to IBM X24 modes.  Note
that IBM 8 pin printers actually use the "Epson"
method of formatting this data.  The "Epson" code
formats data for Epson 8 and 24 pin printers as well
as IBM 8 pin printers.  The "Tandy" mode sends data in
accordance with Tandy's older 24 pin printers ie DMP
2100, 2100p and 2110.  I believe most newer Tandy
printers use "Epson" modes.  The "HP" code formats
data for HP laserjets and compatibles.  These codes
must be entered by converting each letter in the code
to the corresponding ASCII value as follows.

Name code = 73 "Enter"  ; ASCII "I"
Name code = 66 "Enter"  ; ASCII "B"
Name code = 77 "Enter"  ; ASCII "M"
Name code = "Escape"    ; Next prompt
 
"Tail code =" 

This prompt is used by IBM 24 pin printers to inform
the printer of the actual image mode selected.  It is
referred to as the tail code because this code is sent
after the line length data but before the actual data
itself.

Tail code = 11 "Enter"  ; 180 DPI Triple Density
Tail code = "Escape"    ; Next prompt

"CRLF code ="

This code is the carriage return, line feed code.  It
is not normally used on HP laserjets.  Some printers
send automatic line feeds when a carriage return is
sent so this code must be set according to each
printer.  It usually consists of "13", carriage return
and "10", line feed.

CRLF code = 13 "Enter"  ; Carriage return
CRLF code = 10 "Enter"  ; Line feed
CRLF code = "Escape"    ; Next prompt

"Form feed code ="

This code causes a form feed to be sent after the
current print.  In some cases it may be better to
ignore this code so that printing may resume where the
last print left off.

Form feed code = 12 "Enter"  ; Form feed
Form feed code = "Escape"    ; Next prompt

"Number of pins ="

This prompt refers to the number of pins in the print
head of the dot matrix printer.  For HP Laserjets and
compatibles the user must answer "1".  In 8 pin
printing modes on 24 pin printers the user must answer
"8".

Number of pins = 24 "Enter"   ; 24 pins

"Total pin columns ="

This refers to the total number of pin columns across
the page.  The user may adjust this number to a
narrower page than is actually available if they wish
but on laser printers the number must be an even
multiple of 8.

Total pin columns = 1440 "Enter" ; 180 DPI x 8"

"Columns per inch ="

Enter the number of print columns in 1 inch as
described in the printer manual for a particular mode
of printing.

Columns per inch = 180 "Enter" ; 180 DPI

"Rows per inch ="

The user must refer to the printer manual to determine
the number of rows per inch.  Note that a lot of IBM
compatible 24 pin printers actually only print 180
rows per inch meaning that the line feeds and rows per
inch may have to be adjusted to work properly.  

Rows per inch = 216 "Enter" ; 72/8 LFPI * 24 pins

"Print driver name >"

The system needs an 8 or less character name to save
the file by.  The system will then append ".PRD" to
this name, save it and make it the current printer
driver for the system.  The system will then return to
the [Output] menu.  If the user presses "Escape" at
this prompt, the system will not save the print
driver. 

Print driver name > IB24D180 "Enter"  ; finished

[System] menu

      This menu system allows the user to set system
configuration parameters.  The settings in this menu
will be saved in the "PRCAD.DEF" file and will be
restored each time the system is started.  If this
file is present before the initial setup, ie it has
been copied from another computer to your own, and the
system does not seem to work properly or at all, even
though it should, then it could be because of invalid
information contained in this file.  In this case, the
user should delete the file and the system will
automatically create a new "PRCAD.DEF" file on the
next invocation of the PrintCADD 3-D.

[System] {Video}

      This menu allows the user to select the video
mode for their particular computer.  In the standard
version of PrintCADD 3-D there are three different
selections available.

{EGA 640x200 16 color}
      This selection allows the user that has an EGA
video card connected to a CGA monitor to use the
system.  It is also the default video mode as this
mode can also be viewed on EGA and VGA monitors that
have been connected to EGA or VGA video cards.  The
640x200 refers to the screen resolution in this video
mode.  There are 640 horizontal pixels and 200
vertical pixels.  Aspect of the screen is
automatically compensated for.

{EGA 640x350 16 color}
      This selection can be used by used when the user
has an EGA or VGA monitor connected to an EGA or VGA
video card.  There are 640 horizontal pixels by 350
vertical pixels in this mode.  Screen aspect is
automatically compensated for.

{VGA 640x480 16 color}
      This selection requires that the user possess
both a VGA card and VGA monitor.  There are 640
horizontal pixels and 480 vertical pixels.  This
normally provides the user with a 1 to 1 aspect ratio
as the horizontal to vertical ratio is the same as the
screen width to screen height ratio in most instances.
ie 640 / 480 = 4 / 3

      In the future Birdseye Software will be
providing drivers for, or versions of, PrintCADD 3-D
that provide other screen resolutions and
compatibilities.  Contact Birdseye Software for more
information.

[System] {Colors}

      This selection allows the user to customize the
colors of various parts of PrintCADD 3-D.  The user
must select the particular item from the pop up menu
that appears and then another pop up menu will appear
with all available colors for that menu item.  The
user must then highlight the appropriate choice and
press "Enter" or "MLB".  The system will then return
the user to the item menu.  If the user presses
"Escape" or "MRB" then the system will not change the
color setting for that menu item.
      The menu items and a brief explanation of each
follows below.

{Top Text}
      This menu item changes the color of the top menu
bar.  This is normally referred to as the main menu.

{Menu Text}
      This item changes the color of the menu items
that appear in the various drop down, pop up and
bracket menus that appear in the system.

{Data Text}
      This menu item changes the color of the various
readouts that appear on the top and bottom lines of
the screen.

{Help Text}
      This menu item controls the color of the text
that appears in the help reference.


{Error Text}
      This menu item controls the color of error
messages.

{WindowLine}
      This menu item controls the color of the lines
that frame each of the drawing windows.

{Input Text}
      This menu item controls the color of the text
that is typed in by the user.

{MenuLine}
      This menu item controls the color of the lines
that frame the pop up and drop down menus.

{ShadowLine}
      This menu item controls the color of the shadow
that displays to the right and below pop up and drop
down menus.

{Cursor}
      This menu item controls the color of the drawing
cursor.  When the 3-D cursor type has been selected,
it selects the color of the X axis line.  The Y axis
line will assume the color of the next color higher on
the color menu while the Z axis color will be one
higher color than the Y axis (2 higher than X axis).

[System] {Palette}

      This menu allows the user to set the color of
each color in the various color menus.  Although only
15 colors are available in the color menus, each one
of these colors can be set to 1 of 16 colors in EGA
640 x 200 mode, 1 of 64 colors in EGA 640 x 350 mode
or 1 of 262,144 colors in VGA 640 x 480 mode. (See
[System] {Video})
      The system will first display a pop up menu with
all 15 colors displayed on it.  The user must
highlight and select the color slot that they wish to
change.
      The method of establishing the new color for
this color slot will now depend on the current video
mode.
      In EGA 640 x 200 mode the user will be prompted
to select a number between 0 and 15.  The user must
then type in the number of the color they wish to use
in this slot.  The system will change the color of the
slot and return the user to the color pop up menu. 
the user may then select another color slot to change
or press "Escape" or "MRB" to return to the [System]
menu.
      In EGA 640 x 350 mode the user will be asked to
type in a red, green and blue intensity value.  The
intensity values in this mode are between 0 and three
with three being the highest intensity available.  For
instance a red value of 3, a green value of 0 and a
blue value of 0 would give a bright red.  A red value
of 3 , a green value of 3 and a blue value of 3 would
give bright white.
      The VGA 640 x 480 mode is identical to the EGA
640 x 350 mode except that the intensity values for
red, green and blue can be varied between 0 and 63.  

[System] {Mouse}

      This menu allows the user to enable or disable
the ability of the system to use a mouse.  The user
must have a valid Microsoft (c) or compatible mouse
and driver in order to enable this option.  If in
doubt, try it.  There are also many digitizing
tablets, trackballs and other types of devices that
are compatible with this interface so look at the
reference manual that comes with the input device to
see if it will work.  Birdseye Software would be
appreciative if users would notify us of devices they
have tied and the results.  We may even be able to
write drivers for a particular type of device if we
receive the appropriate information for the device.


[System] {Keyboard}

      This menu allows the user to select the
appropriate keyboard driver for the system in
question.  If in doubt, select each driver in turn and
see if the keyboard responds properly.  It is normally
the arrow keys that won't work properly if the wrong
driver has been selected.

[System] {Directry}

      When this command is selected the system will
display the menu, "Directory < Drawing > = ?" where
"?" will be replaced by either "Off" or "On".  
      If the "?" = "Off", then selecting <Drawing>
will cause the system to display the prompt, "Drawing
files path >".  The user must respond with the name of
a valid path name to a directory that the system will
use to store the drawing files in.  The path name must
include a drive identifier ie a:, b:, c: etc..  The
system will then turn the <Drawing> setting to "On"
and return the user to the [System] menu.
      If the user prefers to leave the setting at
"Off" then the system will use the directory that
PrintCADD 3-D resides in for storing the drawing
files.
      This menu may only be accessed before a file is
loaded into the system.

[System] {Optimize}

      This command allows the user to take full
advantage of RAM disks to increase the overall filing
speed of the system.  Certain commands may very well
double or more in speed.
      Another advantage of this command is to insure
file integrity.  The system is forced to work on a
copy of the drawing file rather than the drawing file
itself.  This means that if the computer happens to
lock up due to power failure, static or other problem,
then the original file is in no danger of being
corrupted.  At the end of any editing session on a
file the system will prompt the user as to whether or
not they wish to save the editing session. If the user
responds affirmatively then PrintCADD 3-D will copy
the contents of this temporary file back to the
original file thus updating the original.  If the user
responds negatively then any edits in the current
session will not be saved.
      When this command is selected, the system will
display the menu, "Optimize < Drawing > = ? 
< Redraws > = ?" where the question marks will be
replaced by either "Off" or "On".
      The <Drawing> refers to an "optimization" of the
drawing files while the <Redraws> option allows the
user to optimize the temporary "redraw" files.  In
either case when the command is selected, the system
will prompt the user for a valid path, that includes a
drive identifier, where the temporary copy of the file
will be stored.  If the user has set the path to a RAM
disk then the overall operation of commands on the
file will be quicker.  As redraw files are only
temporary in any case, the user should only optimise
these files if a RAM disk has been set up.
      This menu may only be accessed before a file is
loaded into the system.

[Help] menu

      This menu system gives the user access to online
help on most aspects of PrintCADD 3-D.  It also
contains some useful utility routines.

[Help] {Index}

      This menu item allows the user to access the
index of the help system.  When this command is
selected, the system will display a two column menu
that contains various subjects.  The user must
highlight the appropriate subject and press "Enter" or
"MLB".  
      The system will then display help on the subject
selected.  The user may use the "Page Up" keys or
"Page Down" keys to display more help or place the
mouse cursor on the <PgUp> or <PgDn> at the bottom of
the page and press "MLB".  Pressing the "F3" key will
send the current page of help to the printer on Lpt1
while pressing the "Escape" key will return the user
to the index.
      The index itself has three pages that can be
accessed by the "Page Up" and "Page Down" commands. 
The third page is provided for users to set up their
own index as provided by the [Help] {HelpEdit}
command.

[Help] {Tutor}

      The tutor system was designed to give the user their first step through the PrintCADD 3-D environment.  The user can accesss the tutor system at any time by pressing the "F2" function key.  This allows the user to leave off in the lesson, perform a set of actions required by the lesson, and continue on with the lesson by pressing the "F2" key.  The tutor system will remember where the lesson was left off.
	The tutor system is broken down into 10 lessons that cover most of the major aspects of PrintCADD 3-D.  The system also uses tutor graphics files to convey some of the concepts.  The "PRCAD.TUT" file and the "TUTOR*.GVF" files must reside in the startup directory for the system to find them.
	When {Tutor} is selected, the software will display the menu, "Tutor lesson = 1 < Current >  < Next > < Previous >
< First > < Exit >".
	Selecting the <Current> option continues on with the lesson in progress. (In this case #1).
	Selecting the <Next> option progresses to the start of the next lesson, (In this case, the start of #2).
	Selecting the <Previous> option causes the system to goto the start of the previous lesson, (In this case there is no lesson previous to #1, so the lesson will goto the start of lesson #1).
	The <First> option takes the user to the start of lesson #1.
	The < Exit> option takes the user back to the [Help] menu system. 

[Help] {HelpEdit}

      This command allows the user to set up there own
help screens and index page.  This is especially
useful if the user has created parts files, print
drivers or fonts whose names are cryptic because of
the 8 letter limit enforced by DOS.  The user may then
pass on this information by distributing their parts
files with the appropriate help imbedded in the help
system.  This command may also be useful for shareware
distributors that might like to promote themselves or
another product that could be used in conjunction with
this package.  In effect the user will be able to
advertise within the product itself.
      When this command is selected, the system will
display the menu, "< Edit > < Link > < Exit >".
      If the user selects <Edit>, the system will
display the prompt "Page (3, 171-200) >".  Selecting
page 3 allows the user to edit the index while pages
171 to 200 can be the actual help pages.  After the
user has replied to the prompt, the system will then
display the appropriate page and go into edit mode. 
The editor will display a box shaped cursor where the
current letter will be placed.  The cursor is always
in "overwrite" mode except when being moved with the
arrow keys.  
      The "Enter" key returns the cursor to the left
border of the page.  
      The "Backspace" key moves one character to the
left blotting the character to the left.  
      The user may also move the cursor by moving the
mouse pointer to a point on the page and pressing
"MLB".  
      The user must press "Escape" to save the page
and return to the "< Edit > < Link > < Exit >" menu.
      If the user selects <Link>, the system will
prompt the user for the column and row number of the
index as well as the page that this index should be
linked to.
      The <Exit> command returns the user to the
[Help] menu.

------------------------------------------------------------
	Chapter 4 - File Makeup
------------------------------------------------------------

Drawing File Makeup

      This section of the manual is devoted to
explaining the actual makeup of the individual files.
This information, while not necessary, may provide
help to the user who is mystified by some of the terms
and what they actually mean.  This information may
also be used by those who have some programming
experience, to produce file transfer or file 
modification utilities.  While the information in this
section is correct at the current time, Birdseye
Software reserves the right to change the files and
there makeup as seems appropriate.
      Having said that, we will attempt to keep the
routines in their current state and merely add to what
is available.  Changes to the file design, that are
currently being considered, will be noted in each
section.
      If you have made a utility that you believe
could be of use to people using PrintCADD 3-D, you
should contact Birdseye Software and we will make an
effort to advertise your utility in our help system.

Drawing files

      Drawing files in PrintCADD 3-D can be recognized
by the ".GVF" extension on the name.  The coordinates
used in the files are single precision 32 bit floating
point IEEE numbers.  These numbers are of the standard
used by most programming languages.
      All coordinates are a group of three of these
numbers where the first number represents a distance
along the X axis, the second number is measured along
the Y axis and the third number is measured along the
Z axis.
      All coordinates entered into PrintCADD 3-D are
converted from polar, metric, UCS offsets, etc., to an
inch based internal format that marks the points as
offsets from a top plan view.
      The files also use signed 16 and 32 bit integer
formats for other types of information.


Header Information
      
      All drawing files are preceded by a header
section that defines the various defaults for the
file.

The first section of the header defines the 4 possible
windows available to the drawing.  Each window
consists of the following data fields.

      Information                      Format
------------------------------------------------------
Left corner of current view         Single Floating
Lower corner of current view        Single Floating
Right corner of current view        Single Floating
Upper corner of current view        Single Floating
Available flag                      2 Byte Integer
Active flag					      2 Byte Integer 
Graphics cursor type	      2 Byte Integer	
Currently executing routine	2 Byte Integer
Left corner of highlight 	2 Byte Integer
Lower corner of highlight	2 Byte Integer
Right corner of highlight	2 Byte Integer
Upper corner of highlight	2 Byte Integer
Left pixel corner		      2 Byte Integer
Upper pixel corner		      2 Byte Integer
Right pixel corner		      2 Byte Integer
Lower pixel corner		      2 Byte Integer
Left pixel clip		      2 Byte Integer
Upper pixel clip		      2 Byte Integer
Right pixel clip		      2 Byte Integer
Lower pixel clip		      2 Byte Integer
Rotation around X axis	      Single Floating
Rotation around Y axis 		      Single Floating
Rotation around Z axis	      Single Floating
Sine of X rotation		      Single Floating
Cosine of X rotation	      Single Floating
Sine of Y rotation		      Single Floating
Cosine of Y rotation	      Single Floating
Sine of Z rotation		      Single Floating
Cosine of Z rotation	      Single Floating
Cursor offset UCS X 	      Single Floating'
Cursor offset UCS Y 	      Single Floating'
Cursor offset UCS Z		      Single Floating'
Cursor offset X 		      Single Floating'
Cursor offset Y 		      Single Floating'
Cursor offset Z 		      Single Floating'
Parallel - Perspective flag	2 Byte Integer
View point X			      Single Floating
View point Y			      Single Floating
View point Z			      Single Floating
Zoom level			      Single Floating
UCS origin X			      Single Floating
UCS origin Y			      Single Floating
UCS origin Z			      Single Floating
UCS cosine X axis X move		      Single Floating
UCS cosine X axis Y move	      Single Floating
UCS cosine X axis Z move	      Single Floating
UCS cosine Y axis X move	      Single Floating
UCS cosine Y axis Y move	      Single Floating
UCS cosine Y axis Z move	      Single Floating
UCS cosine Z axis X move	      Single Floating
UCS cosine Z axis Y move	      Single Floating
UCS cosine Z axis Z move	      Single Floating
Viewing aspect			      Single Floating
Previous zoom level 	      Single Floating'
Vanishing point X		      Single Floating
Vanishing point Y		      Single Floating
Center of window X		      Single Floating'
Center of window Y		      Single Floating'
Center of window Z		      Single Floating'
cursor override			      Single Floating'
------------------------------------------------------

After the four windows comes the general information
for the file.

      Information                      Format
------------------------------------------------------
Video mode				      2 Byte Integer
First measurement suffix            3 Char String
Second measurement suffix           3 Char String
First measurement divisor	4 Byte Integer
Second measurement divisor	Single Floating
Third measurement divisor	Single Floating'
Measurement system		      2 Byte Integer
Left drawing limit		      Single Floating
Lower drawing limit		      Single Floating
Right drawing limit		      Single Floating
Upper drawing limit		      Single Floating
Cursor speed X axis		      Single Floating
Cursor speed Y axis		      Single Floating
Cursor speed Z axis		      Single Floating
Text X scale			      Single Floating
Text Y scale			      Single Floating
Arrows X scale			      Single Floating
Arrows Y scale			      Single Floating
Current layer			      Single Floating
Padding                               6 Bytes
------------------------------------------------------

The actual drawing information then follows the
header.  This section is organized according to 2 byte
integer codes that represent the type of information
and following specification fields for each code.

Closed surface                2 byte integer code = 30
Open surface                  2 byte integer code = 31
Current surface               2 byte integer code = 32

These surface types are all followed by the following
specification fields

End of surface file address         4 Byte Integer
Layer number                        2 Byte Integer
Center point X
Center point Y
Center point Z
Color
Line type
Pattern foreground color
Pattern background color
Pattern type

Following the surface type and specification fields,
the program will place data that belongs to that
surface.  Their are three basic data types that belong
to surfaces, the continuous line, the circular curve
and the spline curve.

Continuous line               2 byte integer code = 4
Number of data points               2 Byte Integer
Data X coordinate                   Single Floating
Data Y coordinate                   Single Floating
Data Z coordinate                   Single Floating
Data X coordinate                   Single Floating
Data Y coordinate                   Single Floating
Data Z coordinate                   Single Floating
etc. for number of data points
Number of data points               2 Byte Integer
Continuous line               2 byte integer code = 4

Notice that the coordinate values are terminated by
the number of data points and the continuous line
code.  This allows the program to look both backwards
and forwards through the data file.

Circular curve                2 byte integer code = 11
Number of data points               2 Byte Integer
Reserved                            Single Floating
Reserved                            Single Floating
Reserved                            Single Floating
Reserved                            Single Floating
Number of data points               2 Byte Integer
Data X coordinate                   Single Floating
Data Y coordinate                   Single Floating
Data Z coordinate                   Single Floating
Data X coordinate                   Single Floating
Data Y coordinate                   Single Floating
Data Z coordinate                   Single Floating
etc. for number of data points
Number of data points               2 Byte Integer
Circular curve                2 byte integer code = 11




Other curve                   2 byte integer code = 10
Number of data points               2 Byte Integer
Reserved                            2 Byte integer
Number of data points               2 Byte Integer
Data X coordinate                   Single Floating
Data Y coordinate                   Single Floating
Data Z coordinate                   Single Floating
Data X coordinate                   Single Floating
Data Y coordinate                   Single Floating
Data Z coordinate                   Single Floating
etc. for number of data points
Number of data points               2 Byte Integer
Other curve                   2 byte integer code = 10

Be advised that other types of data blocks are being
considered.

The surface groups are terminated by a surface end
sequence.

Closed surface end            2 byte integer code = 33
Surface start address               4 Byte Integer
Closed surface end            2 byte integer code = 33

Open surface end              2 byte integer code = 33
Surface start address               4 Byte Integer
Open surface end              2 byte integer code = 33

Current surface end      2 byte integer code = 0 or -1

The 0 or -1 code also marks the end of the file.  Any
data past this point will be meaningless.  This code
will very rarely be a -1, but may if last session was
not terminated properly.

Font files

      Font files are virtually identical to drawing
files in that they have the same header and consist of
the same data types.  There are, however, differences
in the way they are laid out, and in the way they are
imported and portrayed by the software.  

1.    The font file actually consists of one header
      and several partitions.  Each partition can
      contain one letter and each letter consists of
      one surface.

                  Font File Addressing
      ------------------------------------------------
                                      -----+  File    
       Header information                    Start
                                           
                                      -----
       Space for the spacebar character      ASCII 32
                                      -----
       Space for the letter !                ASCII 33 
                                      -----
       Space for the letter "                ASCII 34
                                      -----
       Space for the letter #                ASCII 35
                                      -----
       Space for the letter $                ASCII 36
                                      -----
       Space for the letter %                 etc.
      ------------------------------------------------

2.    Remember that the spacebar character contains
      the bounding rectangle.  If the rectangle is
      made thinner, then the letters will space more
      closely or even overlap.  Conversely, if the
      rectangle is made wider, then the gap between
      letter will become larger.

3.    Each ASCII code has an equal amount of drawing
      space.  The amount of space is determined when
      the font is created by the users answer to the
      prompt, "Character space in words (2 bytes) >".
      
4.    There are a maximum of 224 ASCII code spaces.
      as 0 through 31 can not be used out of the
      total 256 ASCII codes. The user may use the
      "Alt" key and the numeric keypad to access
      codes above 126. ie "Alt" 251 = ASCII 251

5.    When the character is brought into the drawing,
      the program looks only at the first surface in
      the character space therefore any surfaces 
      beyond the first are ignored.  The character's Z
      axis information is also ignored.  The character
      is then scaled, rotated and translated to the
      position in the drawing that was dictated by the
      user.

6.	There is a font header that resides between the 
	padding bytes of the normal header.  It contains 2 			additional pieces of information that are used to
	calculate the offset of each letters individual file.

Number of characters               2 Byte Integer
Space per character                2 byte integer
Code for space bar starts here

Parts files

      Part files are created in the same manner as the
font files except that they consist of only two
characters, the spacebar code and the exclamation mark
character.  After this two character font has been
created, it must be renamed with the extension,
".SRF".  This allows the system to see it as a part.
