PROGRAM variant_record_example;

TYPE kind_of_vehicle = (car,truck,bicycle,boat);

     vehicle = RECORD
       owner_name   : STRING[25];
       gross_weight : INTEGER;
       value        : REAL;
       CASE what_kind : kind_of_vehicle OF
         car     : (wheels : INTEGER;
                    engine : STRING[8]);
         truck   : (motor  : STRING[8];
                    tires  : INTEGER;
                    payload : INTEGER);
         bicycle : (tyres   : INTEGER);
         boat    : (prop_blades : BYTE;
                    sail    : BOOLEAN;
                    power   : STRING[8]);
       END; (* of RECORD *)

VAR sunfish,ford,schwinn,mac : vehicle;

BEGIN  (* main program *)

  ford.owner_name := 'Walter'; (* fields defined in order *)
  ford.gross_weight := 5750;
  ford.value := 2595.00;
  ford.what_kind := truck;
  ford.motor := 'V8';
  ford.tires := 18;
  ford.payload := 12000;

  WITH sunfish DO
  BEGIN
    what_kind := boat; (* fields defined in random order *)
    sail := TRUE;
    prop_blades := 3;
    power := 'wind';
    gross_weight := 375;
    value := 1300.00;
    owner_name := 'Herman and George';
  END;

  ford.engine := 'flathead';  (* tag-field not defined yet but it *)
  ford.what_kind := car;      (* must be before it can be used    *)
  ford.wheels := 4;
    (* notice that the non variant part is not redefined here *)

  mac := sunfish; (* entire record copied, including the tag-field *)

  IF ford.what_kind = car THEN        (* this should print *)
    WRITELN(ford.owner_name,' owns the car with a ',ford.engine,
            ' engine');

  IF sunfish.what_kind = bicycle THEN  (* this should not print *)
    WRITELN('The sunfish is a bicycle which it shouldn''t be');

  IF mac.what_kind = boat THEN         (* this should print *)
    WRITELN('The mac is now a boat with',mac.prop_blades:2,
             ' propeller blades.');

END.  (* of main program *)