PROGRAM enumerated_types;

TYPE days = (mon,tue,wed,thu,fri,sat,sun);
     time_of_day = (morning,afternoon,evening,night);

VAR  day              : days;
     time             : time_of_day;
     regular_rate     : REAL;
     evening_premium  : REAL;
     night_premium    : REAL;
     weekend_premium  : REAL;
     total_pay        : REAL;

BEGIN  (* main program *)

WRITELN('Pay rate table':33);
WRITELN;
WRITE('  DAY        Morning  Afternoon');
WRITELN('  Evening    Night');
WRITELN;

regular_rate := 12.00;     (* This is the normal pay rate *)
evening_premium := 1.10;   (* 10 percent extra for working late *)
night_premium := 1.33;     (* 33 percent extra for graveyard *)
weekend_premium := 1.25;   (* 25 percent extra for weekends *)

  FOR day := mon TO sun DO
  BEGIN

    CASE day OF
      mon : WRITE('Monday   ');
      tue : WRITE('Tuesday  ');
      wed : WRITE('Wednesday');
      thu : WRITE('Thursday ');
      fri : WRITE('Friday   ');
      sat : WRITE('Saturday ');
      sun : WRITE('Sunday   ');
    END;  (* of CASE statement *)

    FOR time := morning TO night DO
    BEGIN
      CASE time OF
        morning   : total_pay := regular_rate;
        afternoon : total_pay := regular_rate;
        evening   : total_pay := regular_rate * evening_premium;
        night     : total_pay := regular_rate * night_premium;
      END;  (* of CASE statement *)

      CASE day OF
        sat : total_pay := total_pay * weekend_premium;
        sun : total_pay := total_pay * weekend_premium;
      END;  (* of CASE statement *)

      WRITE(total_pay:10:2);

    END;  (* of "time" loop *)
    WRITELN;
  END; (* of FOR loop *)
 END.  (* of main program *)


