PROGRAM a_dynamic_storage_record;

CONST  number_of_friends = 50;

TYPE full_name = RECORD
      first_name : STRING[12];
      initial    : CHAR;
      last_name  : STRING[15];
      END;

     date      = RECORD
      day        : BYTE;
      month      : BYTE;
      year       : INTEGER;
      END;

     person_id = ^person;
     person    = RECORD
      name       : full_name;
      city       : STRING[15];
      state      : STRING[2];
      zipcode    : STRING[5];
      birthday   : date;
      END;

VAR   friend             : ARRAY[1..number_of_friends] OF person_id;
      self,mother,father : person_id;
      temp               : person;
      index              : BYTE;

BEGIN  (* main program *)
  new(self);   (* create the dynamic variable *)
  self^.name.first_name := 'Charley';
  self^.name.initial    := 'Z';
  self^.name.last_name  := 'Brown';
  WITH self^ DO
  BEGIN
    city := 'Anywhere';
    state := 'CA';
    zipcode := '97342';
    birthday.day := 17;
    WITH birthday DO
    BEGIN
      month := 7;
      year := 1938;
    END;
  END;    (* all data for self now defined *)

  new(mother);
  mother := self;
  new(father);
  father^ := mother^;
  FOR index := 1 to number_of_friends DO
  BEGIN
    new(friend[index]);
    friend[index]^ := mother^;
  END;

  temp := friend[27]^;
  WRITE(temp.name.first_name,' ');
  temp := friend[33]^;
  WRITE(temp.name.initial,' ');
  temp := father^;
  WRITE(temp.name.last_name);
  WRITELN;

  dispose(self);
{ dispose(mother); } (* since mother is lost, it cannot
                        be disposed of                  *)
  dispose(father);
  FOR index := 1 TO number_of_friends DO
    dispose(friend[index]);

END. (* of main program *)