PROGRAM scaler_operations;

TYPE days = (mon,tue,wed,thu,fri,sat,sun);
     work = mon..fri;
     rest = sat..sun;

VAR  day      : days; (* This is any day of the week *)
     workday  : work; (* These are the the working days *)
     weekend  : rest; (* The two weekend days only *)
     index    : 1..12;
     alphabet : 'a'..'z';
     start    : 'a'..'e';

BEGIN  (* main program *)
(*  The following statements are commented out because they contain
    various errors that will halt compilation.

  workday := sat;   sat is not part of workday's subrange.
  rest := fri;      fri is not part of weekend's subrange.
  index := 13;      index is only allowed to go up to 12,
  index := -1;        and down to 1.
  alphabet := 'A'   alphabet, as defined, includes only the
                      lower case alphabet.
  start := 'h'      h is not in the first five letters.

  End of commented out section.  *)

workday := tue;
weekend := sat;
day := workday;
day := weekend;
index := 3+2*2;
start := 'd';
alphabet := start;
                          (* since alphabet is "d"    *)
start := succ(alphabet);  (* start will be 'e'        *)
start := pred(alphabet);  (* start will be 'c'        *)
day := wed;
day := succ(day);  (* day will now be 'thu' *)
day := succ(day);  (* day will now be 'fri' *)
index := ord(day); (* index will be 4 (fri = 4) *)

END. (* of main program *)
