PROGRAM amortization_table;

VAR month                 : 1..12;
    starting_month        : 1..12;
    balance               : REAL;
    payment               : REAL;
    interest_rate         : REAL;
    annual_accum_interest : REAL;
    year                  : INTEGER;
    number_of_years       : INTEGER;
    original_loan         : REAL;


PROCEDURE calculate_payment; (* ***************** calculate payment *)
VAR temp  : REAL;
    index : INTEGER;
BEGIN
  temp := 1.0;
  FOR index := 1 TO 12*number_of_years DO
    temp := temp * (1.0 + interest_rate);
  payment := original_loan*interest_rate/(1.0 - 1.0/temp);
END;

PROCEDURE initialize_data; (* ********************* initialize data *)
BEGIN
  WRITELN('   Pascal amortization program');
  WRITELN;
  WRITE('Enter amount borrowed                         ');
  READLN(original_loan);
    balance := original_loan;
  WRITE('Enter interest rate as percentage (i.e. 13.5) ');
  READLN(interest_rate);
    interest_rate := interest_rate/1200.0;
  WRITE('Enter number of years of payoff               ');
  READLN(number_of_years);
  WRITE('Enter month of first payment (i.e. 5 for May) ');
  READLN(starting_month);
  WRITE('Enter year of first payment (i.e. 1985)       ');
  READLN(year);
    calculate_payment;
  annual_accum_interest := 0.0;  (* This is to accumulate Interest *)
END;

PROCEDURE print_annual_header; (* ************** print annual header *)
BEGIN
  WRITELN;
  WRITELN;
  WRITELN('Original loan amount = ',original_loan:10:2,
          '   Interest rate = ',1200.0*interest_rate:6:2,'%');
  WRITELN;
  WRITELN('Month    payment  interest    princ   balance');
  WRITELN;
  WRITELN(lst);
  WRITELN(lst);
  WRITELN(lst,'Original loan amount = ',original_loan:10:2,
          '   Interest rate = ',1200.0*interest_rate:6:2,'%');
  WRITELN(lst);
  WRITELN(lst,'Month    payment  interest    princ   balance');
  WRITELN(lst);
END;

PROCEDURE calculate_and_print; (* ************** calculate and print *)
VAR interest_payment : REAL;
    principal_payment : REAL;
BEGIN
  IF balance > 0.0 THEN
  BEGIN
    interest_payment := interest_rate * balance;
    principal_payment := payment - interest_payment;
    IF principal_payment > balance THEN
    BEGIN  (* loan payed off this month *)
      principal_payment := balance;
      payment := principal_payment + interest_payment;
      balance := 0.0;
    END
    ELSE
    BEGIN  (* regular monthly payment *)
      balance := balance - principal_payment;
    END;
    annual_accum_interest := annual_accum_interest + interest_payment;
    WRITELN(month:5,payment:10:2,interest_payment:10:2,
            principal_payment:10:2,balance:10:2);
    WRITELN(lst,month:5,payment:10:2,interest_payment:10:2,
            principal_payment:10:2,balance:10:2);
  END; (* of IF balance > 0.0 THEN *)
END;

PROCEDURE print_annual_summary; (* ************ print annual summary *)
BEGIN
  WRITELN;
  WRITELN('Total interest for ',year:5,' = ',
           annual_accum_interest:10:2);
  WRITELN;
  WRITELN(lst);
  WRITELN(lst,'Total interest for ',year:5,' = ',
           annual_accum_interest:10:2);
  annual_accum_interest := 0.0;
  year := year + 1;
  WRITELN(lst);
END;

BEGIN   (* ********************************************* main program *)
  initialize_data;
  REPEAT
    print_annual_header;
    FOR month := starting_month TO 12 DO
    BEGIN
      calculate_and_print;
    END;
    print_annual_summary;
    starting_month := 1;
  UNTIL balance <= 0.0;
END. (* of main program *)