PROGRAM list_pascal_source_files;

CONST max_lines_per_page = 50;

                (* Note; This will not compile if you are using
                   TURBO Pascal 2.0. Change the definitions for
                   "file_to_print" and "input_line" to STRING[25]
                   and STRING[140] to allow this program to
                   compile with TURBO Pascal 2.0, since READ and
                   READLN do not work with ARRAY OF CHAR.     *)

VAR input_file      : TEXT;
    file_to_print   : ARRAY[1..25] OF CHAR;
    input_line      : ARRAY[1..140] OF CHAR;
    line_number     : INTEGER;
    lines_printed   : INTEGER;
    page_no         : INTEGER;
    index           : INTEGER;

PROCEDURE initialize; (* ****************************** initialize *)
BEGIN
  WRITE('Enter filename ');
  READLN(file_to_print);
  ASSIGN(input_file,file_to_print);
  RESET(input_file);
  line_number := 1;
  lines_printed := 66; (* This is to force a header immediately *)
  page_no := 1;
END;

PROCEDURE read_a_line; (* **************************** read a line *)
BEGIN
  FOR index := 1 TO 140 DO input_line[index] := ' ';
  READLN(input_file,input_line);
END;

PROCEDURE format_and_display; (* **************** format and display *)

VAR line_length : BYTE;

BEGIN
  WRITE(line_number:6,'  ');
    FOR index := 1 TO 140 DO
    BEGIN
      IF input_line[index] <> ' ' THEN line_length := index;
    END;
  IF line_length <= 70 THEN
    BEGIN               (* line length less than 70 characters *)
      FOR index := 1 TO line_length DO
        WRITE(input_line[index]);
      WRITELN;
    END
  ELSE
    BEGIN               (* line length more than 70 characters *)
      FOR index := 1 TO 70 DO
        WRITE(input_line[index]);
      WRITELN('<');
      WRITE('        ');
      FOR index := 71 TO line_length DO
        WRITE(input_line[index]);
      WRITELN;
    END;
END;

PROCEDURE format_and_print; (* ****************** format and print *)

VAR line_length : BYTE;

BEGIN
  WRITE(lst,line_number:6,'  ');
    FOR index := 1 TO 140 DO
    BEGIN
      IF input_line[index] <> ' ' THEN line_length := index;
    END;
  IF line_length <= 70 THEN
    BEGIN               (* line length less than 70 characters *)
      FOR index := 1 TO line_length DO
        WRITE(lst,input_line[index]);
      WRITELN(lst);
      lines_printed := lines_printed + 1;
    END
  ELSE
    BEGIN               (* line length more than 70 characters *)
      FOR index := 1 TO 70 DO
        WRITE(lst,input_line[index]);
      WRITELN(lst,'<');
      WRITE(lst,'        ');
      FOR index := 71 TO line_length DO
        WRITE(lst,input_line[index]);
      WRITELN(lst);
      lines_printed := lines_printed + 2;
    END;
  line_number := line_number + 1;
END;

PROCEDURE check_for_page; (* ********************** check for page *)
BEGIN
  IF lines_printed > Max_lines_per_page THEN
  BEGIN
    IF page_no > 1 THEN WRITELN(lst,char(12));
    FOR index := 1 TO 3 DO WRITELN(lst);
    WRITE(lst,'     ');
    WRITELN(lst,'Source file ',file_to_print,'Page':24,page_no:4);
    page_no := page_no + 1;
    lines_printed := 1;
    WRITELN(lst);
  END;
END;

BEGIN  (* ******************************************* main program *)
  initialize;
  check_for_page;
  REPEAT
    read_a_line;
    format_and_display;
    format_and_print;
    check_for_page;
  UNTIL eof(input_file);
  WRITELN(lst,char(12));
END.  (* of main program *)