PROGRAM example_of_constants;

CONST  max_size = 12; (* Pascal assumes this is a BYTE type, but it
                         can be used as an integer also *)
       index_start   : INTEGER = 49; (* This is a typed constant *)
       check_it_out  : BOOLEAN = true; (* Another typed constant *)

TYPE bigarray  = ARRAY[1..max_size] OF INTEGER;
     chararray = ARRAY[1..max_size] OF CHAR;

VAR  airplane   : bigarray;
     seaplane   : bigarray;
     helicopter : bigarray;
     cows       : chararray;
     horses     : chararray;
     index      : INTEGER;

BEGIN  (* main program *)
  FOR index := 1 TO max_size DO
  BEGIN
    airplane[index] := index*2;
    seaplane[index] := index*3 + 7;
    helicopter[max_size - index + 1] := index + airplane[index];
    horses[index] := 'X';
    cows[index] := 'R';
  END;
END.  (* of main program *)

