PROGRAM amortization_table;

VAR month : 1..12;
    starting_month : 1..12;
    balance : REAL;
    payment : REAL;
    interest_rate : REAL;
    annual_accum_interest : REAL;
    year : INTEGER;

PROCEDURE initialize_data; (* ********************* initialize data *)
BEGIN
  balance := 2500.0;
  starting_month := 5;
  payment := 100.0;
  interest_rate := 0.13/12.0;
  annual_accum_interest := 0.0;  (* This is to accumulate Interest *)
  year := 1985;
END;

PROCEDURE print_annual_header; (* ************** print annual header *)
BEGIN
  WRITELN;
  WRITELN('Month    payment  interest    princ   balance');
  WRITELN;
END;

PROCEDURE calculate_and_print; (* ************** calculate and print *)
VAR interest_payment : REAL;
    principal_payment : REAL;
BEGIN
  IF balance > 0.0 THEN
  BEGIN
    interest_payment := interest_rate * balance;
    principal_payment := payment - interest_payment;
    IF principal_payment > balance THEN
    BEGIN  (* loan payed off this month *)
      principal_payment := balance;
      payment := principal_payment + interest_payment;
      balance := 0.0;
    END
    ELSE
    BEGIN  (* regular monthly payment *)
      balance := balance - principal_payment;
    END;
    annual_accum_interest := annual_accum_interest + interest_payment;
    WRITELN(month:5,payment:10:2,interest_payment:10:2,
            principal_payment:10:2,balance:10:2);
  END; (* of IF balance > 0.0 THEN *)
END;

PROCEDURE print_annual_summary; (* ************ print annual summary *)
BEGIN
  WRITELN;
  WRITELN('Total interest for ',year:5,' = ',
           annual_accum_interest:10:2);
  annual_accum_interest := 0.0;
  year := year + 1;
  WRITELN;
END;

BEGIN   (* ********************************************* main program *)
  initialize_data;
  REPEAT
    print_annual_header;
    FOR month := starting_month TO 12 DO
    BEGIN
      calculate_and_print;
    END;
    print_annual_summary;
    starting_month := 1;
  UNTIL balance <= 0.0;
END. (* of main program *)