#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<fcntl.h>
#include	<io.h>
#include	"video.h"
#include	"files.h"

short fieldno;

typedef struct
{
	long next;
	long prev;
	
	long customerptr;
	long customernext;
	long customerprev;
	
	char type[1];
	unsigned short transaction_date;
	char title[20];
} transaction;

transaction blanktransaction =
{
	-1,
	-1,
	
	-1,
	-1,
	-1,
	
	' ',
	BLANKDATE,
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
};

transaction transaction;
int transactionfile;
long transactionptr;

#define	transactionmiscoff	0

typedef struct
{
	long next;
	long prev;
	
	char account_name[20];
	
	long transactionfirst;
	long transactionlast;
	
	char address_3[20];
	char address_2[20];
	char address_1[20];
	char full_name[20];
} customer;

customer blankcustomer =
{
	-1,
	-1,
	
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
	
	-1,
	-1,
	
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
};

customer customer;
int customerfile;
long customerptr;
int customerindexfile;

#define	customermiscoff	12

typedef struct
{
	long next;
	long prev;
	
	char title[20];
	
	unsigned short release_date;
	double rent;
	signed char in_stock;
	signed char copies;
	char category[20];
} video;

video blankvideo =
{
	-1,
	-1,
	
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
	
	BLANKDATE,
	0,
	0,
	0,
	' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',
};

video video;
int videofile;
long videoptr;
int videoindexfile;

#define	videomiscoff	28

void wait (void)
{
	printstr (30,20,"Press any key to continue",25);
	cursor (56,20);
	getkey ();
}

void show_video (void)
{
	printstr (10,6,"Category",8);
	printstr (10,7,"Copies",6);
	printstr (10,8,"Copies in Stock",15);
	printstr (10,9,"Rental Charge",13);
	printstr (10,10,"Release Date",12);
	printstr (30,5,video.title,20);
	printstr (30,6,video.category,20);
	printint (30,7,video.copies,2);
	printint (30,8,video.in_stock,2);
	printfloat (30,9,video.rent,2,2);
	printdate (30,10,video.release_date);
}

void alter_video (void)
{
	show_video ();

CATEGORY:
	editstr (video.category,20,30,6,DF_RETURN | DF_ESC | DF_DOWN);
	switch (dir)
	{
		case DIR_ESC:
			goto END;
	}

COPIES:
	editbyte (&video.copies,2,30,7,DF_RETURN | DF_ESC | DF_UP | DF_DOWN);
	switch (dir)
	{
		case DIR_ESC:
			goto END;
		case DIR_UP:
			goto CATEGORY;
	}

IN_STOCK:
	editbyte (&video.in_stock,2,30,8,DF_RETURN | DF_ESC | DF_UP | DF_DOWN);
	switch (dir)
	{
		case DIR_ESC:
			goto END;
		case DIR_UP:
			goto COPIES;
	}

RENT:
	editfloat (&video.rent,2,2,30,9,DF_RETURN | DF_ESC | DF_UP | DF_DOWN);
	switch (dir)
	{
		case DIR_ESC:
			goto END;
		case DIR_UP:
			goto IN_STOCK;
	}

RELEASE_DATE:
	editdate (&video.release_date,30,10,DF_RETURN | DF_ESC | DF_UP);
	switch (dir)
	{
		case DIR_UP:
			goto RENT;
	}

END:
	Write (videofile,videoptr,&video,sizeof video);
}

void add_video (void)
{
	printstr (10,5,"Title",5);
	video = blankvideo;
	createindex (videofile,&videoptr,&video,sizeof video,videomiscoff,video.title,20,videoindexfile,30,5,DF_RETURN | DF_ESC);
	switch (dir)
	{
		case DIR_ESC:
			goto CANCEL;
	}
	alter_video ();
	return;

CANCEL:
	deleteindex (videofile,videoptr,&video,videomiscoff,video.title,20,videoindexfile);
}

void edit_video (void)
{
	printstr (10,5,"Title",5);
	select (videofile,videoindexfile,&videoptr,&video,sizeof video,video.title,20,30,5,DF_RETURN | DF_ESC);
	switch (dir)
	{
		case DIR_ESC:
			goto CANCEL;
	}
	alter_video ();

CANCEL:;
}

void display_video (void)
{
	printstr (10,5,"Title",5);
	select (videofile,videoindexfile,&videoptr,&video,sizeof video,video.title,20,30,5,DF_RETURN | DF_ESC);
	switch (dir)
	{
		case DIR_ESC:
			goto CANCEL;
	}
	show_video ();
	wait ();

CANCEL:;
}

void remove_video (void)
{
	char sure[1];
	
	printstr (10,5,"Title",5);
	select (videofile,videoindexfile,&videoptr,&video,sizeof video,video.title,20,30,5,DF_RETURN | DF_ESC);
	switch (dir)
	{
		case DIR_ESC:
			goto CANCEL;
	}
	show_video ();
	printstr (30,20,"Are you sure? (Y/N) ",20);
	cursor (50,20);
	sure[0] = getkey ();
	if (!memicmp (sure,"Y",1))
		deleteindex (videofile,videoptr,&video,videomiscoff,video.title,20,videoindexfile);

CANCEL:;
}

void show_customer (void)
{
	printstr (10,6,"Full Name",9);
	printstr (10,7,"Address",7);
	printstr (30,5,customer.account_name,20);
	printstr (30,6,customer.full_name,20);
	printstr (30,7,customer.address_1,20);
	printstr (30,8,customer.address_2,20);
	printstr (30,9,customer.address_3,20);
}

void alter_customer (void)
{
	show_customer ();

FULL_NAME:
	editstr (customer.full_name,20,30,6,DF_RETURN | DF_ESC | DF_DOWN);
	switch (dir)
	{
		case DIR_ESC:
			goto END;
	}

ADDRESS_1:
	editstr (customer.address_1,20,30,7,DF_RETURN | DF_ESC | DF_UP | DF_DOWN);
	switch (dir)
	{
		case DIR_ESC:
			goto END;
		case DIR_UP:
			goto FULL_NAME;
	}

ADDRESS_2:
	editstr (customer.address_2,20,30,8,DF_RETURN | DF_ESC | DF_UP | DF_DOWN);
	switch (dir)
	{
		case DIR_ESC:
			goto END;
		case DIR_UP:
			goto ADDRESS_1;
	}

ADDRESS_3:
	editstr (customer.address_3,20,30,9,DF_RETURN | DF_ESC | DF_UP);
	switch (dir)
	{
		case DIR_UP:
			goto ADDRESS_2;
	}

END:
	Write (customerfile,customerptr,&customer,sizeof customer);
}

void add_customer (void)
{
	printstr (10,5,"Account Name",12);
	customer = blankcustomer;
	createindex (customerfile,&customerptr,&customer,sizeof customer,customermiscoff,customer.account_name,20,customerindexfile,30,5,DF_RETURN | DF_ESC);
	switch (dir)
	{
		case DIR_ESC:
			goto CANCEL;
	}
	alter_customer ();
	return;

CANCEL:
	deleteindex (customerfile,customerptr,&customer,customermiscoff,customer.account_name,20,customerindexfile);
}

void edit_customer (void)
{
	printstr (10,5,"Account Name",12);
	select (customerfile,customerindexfile,&customerptr,&customer,sizeof customer,customer.account_name,20,30,5,DF_RETURN | DF_ESC);
	switch (dir)
	{
		case DIR_ESC:
			goto CANCEL;
	}
	alter_customer ();

CANCEL:;
}

void display_customer (void)
{
	printstr (10,5,"Account Name",12);
	select (customerfile,customerindexfile,&customerptr,&customer,sizeof customer,customer.account_name,20,30,5,DF_RETURN | DF_ESC);
	switch (dir)
	{
		case DIR_ESC:
			goto CANCEL;
	}
	show_customer ();
	wait ();

CANCEL:;
}

void remove_customer (void)
{
	char sure[1];
	
	printstr (10,5,"Account Name",12);
	select (customerfile,customerindexfile,&customerptr,&customer,sizeof customer,customer.account_name,20,30,5,DF_RETURN | DF_ESC);
	switch (dir)
	{
		case DIR_ESC:
			goto CANCEL;
	}
	show_customer ();
	printstr (30,20,"Are you sure? (Y/N) ",20);
	cursor (50,20);
	sure[0] = getkey ();
	if (!memicmp (sure,"Y",1))
		deleteindex (customerfile,customerptr,&customer,customermiscoff,customer.account_name,20,customerindexfile);

CANCEL:;
}

void enter_transactions_show (void)
{
	printstr (0,(-1),transaction.title,20);
	printdate (30,(-1),transaction.transaction_date);
	printstr (50,(-1),transaction.type,1);
}

void enter_transactions_edit (void)
{
	switch (fieldno)
	{
		case 0:
			goto TITLE;
		case 1:
			goto LOAN_DATE;
		case 2:
			goto TYPE;
	}

TITLE:
	editstr (transaction.title,20,0,(-1),DF_RETURN | DF_ESC | DF_UP | DF_DOWN | DF_RIGHT | DF_PGUP | DF_PGDN | DF_HOME | DF_END | DF_INS | DF_DEL);
	switch (dir)
	{
	}
	return;

LOAN_DATE:
	editdate (&transaction.transaction_date,30,(-1),DF_RETURN | DF_ESC | DF_UP | DF_DOWN | DF_LEFT | DF_RIGHT | DF_PGUP | DF_PGDN | DF_HOME | DF_END | DF_INS | DF_DEL);
	switch (dir)
	{
	}
	return;

TYPE:
	editstr (transaction.type,1,50,(-1),DF_RETURN | DF_ESC | DF_UP | DF_DOWN | DF_LEFT | DF_PGUP | DF_PGDN | DF_HOME | DF_END | DF_INS | DF_DEL);
	switch (dir)
	{
	}
	return;
}

void enter_transactions (void)
{
	printstr (10,5,"Account Name",12);
	select (customerfile,customerindexfile,&customerptr,&customer,sizeof customer,customer.account_name,20,30,5,DF_RETURN | DF_ESC);
	switch (dir)
	{
		case DIR_ESC:
			goto CANCEL;
	}
	show_customer ();
	printstr (0,11,"Film Title",10);
	printstr (30,11,"Transaction Date",16);
	printstr (50,11,"Type (L/R)",10);
	scrolledit (transactionfile,&transactionptr,&transaction,foffset (transaction,customerptr),sizeof transaction,customerfile,customerptr,&customer,foffset (customer,transactionfirst),sizeof customer,&blanktransaction,transactionmiscoff,3,enter_transactions_show,enter_transactions_edit,0,13,80,12);

CANCEL:;
}

void display_transactions (void)
{
	printstr (10,5,"Account Name",12);
	select (customerfile,customerindexfile,&customerptr,&customer,sizeof customer,customer.account_name,20,30,5,DF_RETURN | DF_ESC);
	switch (dir)
	{
		case DIR_ESC:
			goto CANCEL;
	}
	show_customer ();
	printstr (0,11,"Film Title",10);
	printstr (30,11,"Transaction Date",16);
	printstr (50,11,"Type (L/R)",10);
	scrolledit (transactionfile,&transactionptr,&transaction,foffset (transaction,customerptr),sizeof transaction,customerfile,customerptr,&customer,foffset (customer,transactionfirst),sizeof customer,&blanktransaction,transactionmiscoff,3,enter_transactions_show,0,0,13,80,12);

CANCEL:;
}

execmenuitem menu00[] =
{
	"Add a Video",0,add_video,
	"Edit a Video",0,edit_video,
	"Display a Video",0,display_video,
	"Remove a Video",0,remove_video,
	0
};

execmenuitem menu01[] =
{
	"Add a Customer",0,add_customer,
	"Edit a Customer",0,edit_customer,
	"Display a Customer",0,display_customer,
	"Remove a Customer",0,remove_customer,
	0
};

execmenuitem menu02[] =
{
	"Enter Transactions",0,enter_transactions,
	"Display Transactions",0,display_transactions,
	0
};

execmenuitem menu[] =
{
	"Videos",menu00,0,
	"Customers",menu01,0,
	"Transactions",menu02,0,
	0
};

main (void)
{
	long r;
	
	transactionfile = opencreate ("transaction.dat");
	customerfile = opencreate ("customer.dat");
	customerindexfile = opencreate ("customer.idx");
	videofile = opencreate ("video.dat");
	videoindexfile = opencreate ("video.idx");
	
	miscfile = open ("misc.dat",O_RDWR);
	if (miscfile < 0)
	{
		miscfile = open ("misc.dat",O_CREAT | O_TRUNC | O_RDWR,0777);
		if (miscfile < 0)
		{
			printf ("Can't create file misc.dat\n");
			return 1;
		}
		mblank3 ();
		mblank4 ();
		mblank4 ();
	}
	
	initvideo ();
	execmenu (menu,-1,-1,0,0);
	return 0;
}