#define	BLANKDATE			(1 + 1*32 + 80*32*16)

#define	dateday(d)			((d) % 32)
#define	datemonth(d)		(((d) / 32) % 16)
#define	dateyear(d)			((d) / (32*16))

#define	makedate(d,m,y)	(y*32*16 + m*32 + d)

#define	foffset(s,f)		((char *)&s.f - (char *)&s)

enum
{
	DIR_RETURN,
	DIR_ESC,
	DIR_UP,
	DIR_DOWN,
	DIR_LEFT,
	DIR_RIGHT,
	DIR_PGUP,
	DIR_PGDN,
	DIR_HOME,
	DIR_END,
	DIR_INS,
	DIR_DEL,
	MAXDIR
};

enum
{
	DF_RETURN = 1 << DIR_RETURN,
	DF_ESC = 1 << DIR_ESC,
	DF_UP = 1 << DIR_UP,
	DF_DOWN = 1 << DIR_DOWN,
	DF_LEFT = 1 << DIR_LEFT,
	DF_RIGHT = 1 << DIR_RIGHT,
	DF_PGUP = 1 << DIR_PGUP,
	DF_PGDN = 1 << DIR_PGDN,
	DF_HOME = 1 << DIR_HOME,
	DF_END = 1 << DIR_END,
	DF_INS = 1 << DIR_INS,
	DF_DEL = 1 << DIR_DEL,
};

typedef struct execmenuitemstruct
{
	char *text;
	struct execmenuitemstruct *submenu;
	void (*function)();
} execmenuitem;

extern dir;

void printint (int,int,long,int);
void printfloat (int,int,double,int,int);
void printdate (int,int,unsigned short);
void printstr (int,int,char *,int);
void editlong (long *,int,int,int,int);
void editbyte (signed char *,int,int,int,int);
void editshort (short *,int,int,int,int);
void editfloat (double *,int,int,int,int,int);
void editdate (unsigned short *,int,int,int);
void editstr (char *,int,int,int,int);
void execmenu (execmenuitem *,int,int,int,int);
getkey (void);
void cursor (int,int);
validdate (unsigned short);
void beep (void);
unsigned short atodate (char *);
