/*  Phone directory format in version 3.01  */


#define DIAL_RECORD     struct dial_records
#define MAX_FON_SIZE    1000
#define FON_LEN         sizeof(DIAL_RECORD)      /* 131 */
#define MEMO_LEN        30

DIAL_RECORD {                /* number of records = file length / FON_LEN */
     char name[30];          /* name of remote system */
     char password[15];      /* user password */
     char f1;                /* filler */
     char script[8];         /* name script file */
     char f2;
     char log[8];            /* name of log file */
     char f3;
     char phone[20];         /* phone number */
     char f4;
     char para[9];           /* COM parameter e.g. "115200N81" */
     char port;              /* COM Port '1'-'8', '0' use default (in TM.CFG) */
     char f5;
     char total[5];          /* Total number of connection */
     char f6[2];
     char last[8];           /* Last log on date "MM-DD-YY" */
     char f7;
     char term;              /* terminal (T)ty (A)nsi VT(5)2 VT(1)02 */
     char connectTo;         /* Connect to (C)omputer (M)odem */
     char lineFeed;          /* Add line feed (Y)es (N)o */
     char carriageReturn;    /* Add carriage return (Y)es (N)o */
     char localEcho;         /* Local echo (Y)es (N)o */
     char wrap;              /* Auto wrap (Y)es (N)o */
     char destBs;            /* Destructive backspace (Y)es (N)o */
     char autoLog;           /* Auto log session (Y)es (N)o */
     char longDistance;      /* Long distance (Y)es (N)o */
     char stripHigh;         /* Strip high bit (Y)es (N)o */
     char tagSeparator;      /* 0=space, 1=enter, 2=comma */
     char guessInitial;      /* Use initial guessing (Y)es (N)o */
     char reserved[2];       /* reserved for future usage */
     char prefix;            /* Prefix 1-4 */
     char suffix;            /* Suffix 1-4 */
     char protocol;          /* Protocol XYZRBGSTMAC */
     char crlf[2];           /* End of line CR and LF */
} *dial_record[MAX_FON_SIZE];

char *dial_memo[MAX_FON_SIZE];

