//
// Mini Java Editor Compiler
//

import java.io.*;

class MJECompiler extends Object {
  Table errors = new Table();

  public boolean compile(String file) {
    return compile(file, "");
  }

  public boolean compile(String file, String options) {
    try {
      String fs = System.getProperty("file.separator");

      String cpath = System.getProperty("java.home") + fs + "bin" + fs +
	"javac " + options + " ";

      Process ps = Runtime.getRuntime().exec(cpath + file);	
      DataInputStream ds = new DataInputStream(ps.getInputStream());

      errors.removeAllElements();
      String str = new String();

      while (str != null) {
  	str = ds.readLine();

	if (str != null)    
 	  if (str.startsWith(file)) {
	    String msg = str.substring(file.length() + 1);

	    for (int i = 1; i < 5; i++)
       	      if (msg.charAt(i) == ':') {
		int pos = 0;

 	        String line = msg.substring(0, i);
	        String err = msg.substring(i + 2, msg.length());
		String code = ds.readLine().trim();
		String tmp = ds.readLine();

		for (int j = 0; j < tmp.length(); j++)
		  if (tmp.charAt(j) == '^')
		      pos = j;

		errors.addElement("*** " + err);
	        errors.addElement("    " + line + " (" + pos + "): " + code);
	      }
	  }
      }
    }
    catch (Exception err) {
      errors.addElement("Error compiling file.");
      return false;
    }

    if (errors.size() == 0)
      return true;
    else
      return false;
  }
}
