//
// Mini Java Editor dialogs
// By Thye Chean and Joe Nall
//

import java.awt.*;

//
// Compiler options dialog
//

class OptionsDialog extends Dialog {
  MJE editor;
  TextField lineText; 
  Choice fonts, styles, sizes;
  public String result;

  public OptionsDialog(Frame parent) {
    super(parent, "Compiler Options...", false);
    editor = (MJE) parent;

  // Add compiler options

    lineText = new TextField(editor.options, 15);
    HPanel p1 = new HPanel();
    p1.add(0, new Label("Compiler Options:"));
    p1.add(0, lineText);

  // Add font selection
   
    fonts = new Choice();
    styles = new Choice();
    sizes = new Choice();

    for (int i = 0; i < editor.fonts.length; i++)
      fonts.addItem(editor.fonts[i]);

    fonts.select(editor.font.getName());

    for (int i = 0; i < editor.styles.length; i++)
      styles.addItem(editor.styles[i]);
   
    styles.select(editor.font.getStyle());

    for (int i = 8; i < 24; i += 2)
      sizes.addItem(new Integer(i).toString());

    sizes.select(new Integer(editor.font.getSize()).toString());

    HPanel p2 = new HPanel();
    p2.add(0, new Label("Font:"));
    p2.add(0, fonts);
    p2.add(0, styles);
    p2.add(0, sizes);

  // Add close button

    HPanel p3 = new HPanel(5, 0, 80);
    p3.add(0, new Button("Close"));

    add("North", p1);
    add("Center", p2);
    add("South", p3);
  }

  public boolean handleEvent(Event evt) {
    if (evt.id == Event.WINDOW_DESTROY) 
      dispose();

    return super.handleEvent(evt);
  }

  public boolean action(Event evt, Object obj) {
    if (evt.target instanceof Button) {
      String str = (String) obj;
      editor.options = lineText.getText();

      String font = fonts.getSelectedItem();
      int style = 0;

      for (int i = 0; i < editor.styles.length; i++)
	if (editor.styles[i].equals(styles.getSelectedItem()))
	  style = i;

      int size = new Integer(sizes.getSelectedItem()).intValue();

      editor.changeFont(new Font(font, style, size));
      dispose();
      return true;
    }

    return false;
  }
}

//
// Go to line dialog
//

class GotoDialog extends Dialog {
  MJEWindow win;
  TextField lineText;

  public GotoDialog(Frame parent) {
    super(parent, "Go to Line...", false);

    win = (MJEWindow) parent;
    lineText = new TextField("", 7);

    HPanel buttons = new HPanel();
    buttons.add(0, new Button("Go"));
    buttons.add(0, new Button("Close"));
    add("West", new Label("Line:"));
    add("East", lineText);
    add("South", buttons);
  }

  public boolean handleEvent(Event evt) {
    if (evt.id == Event.WINDOW_DESTROY) 
      dispose();

    return super.handleEvent(evt);
  }

  public boolean action(Event evt, Object obj) {
    if (evt.target instanceof Button) {
      String str = (String) obj;

      if (str.equals("Close"))
        dispose();
      else if (str.equals("Go")) {
	try {
      	  win.gotoLine(new Integer(lineText.getText()).intValue());
	}
	catch (Exception err) { }
      }

      return true;
    }

    return false;
  }
}

//
// Find dialog
//
  
class FindDialog extends Dialog {
  MJEWindow win;
  TextField findText, replaceText;
  Checkbox match;

  public FindDialog(Frame parent) {
    super(parent, "Find...", false);

    win = (MJEWindow) parent;
    findText = new TextField("", 10);
    replaceText = new TextField("", 10);    
    match = new Checkbox("Match Case");

    HPanel p1 = new HPanel();
    p1.add(0, new Label("Find:"));
    p1.add(0, findText);
    p1.add(0, new Label("Replace:"));
    p1.add(0, replaceText);

    HPanel p2 = new HPanel();
    p2.add(0, match);
    p2.add(0, new Button("Find"));
    p2.add(0, new Button("Replace"));
    p2.add(0, new Button("Close"));

    add("North", p1);
    add("South", p2);
  }

  public boolean handleEvent(Event evt) {
    if (evt.id == Event.WINDOW_DESTROY) 
      dispose();

    return super.handleEvent(evt);
  }

  public boolean action(Event evt, Object obj) {
    if (evt.target instanceof Button) {
      String name = (String) obj;
      TextArea area = win.getTextArea();

    // Close 

      if (obj.equals("Close")) {
	dispose();
	return true;
      }

    // Replace text

      if (obj.equals("Replace")) {
	int start = area.getSelectionStart();
	int end = area.getSelectionEnd();

	if (end > start) 
	  area.replaceText(replaceText.getText(), start, end);
      }

    // Find text

      String txt, str;
	
      if (match.getState()) {
	txt = area.getText();
	str = findText.getText();
      }
      else {
        txt = area.getText().toLowerCase();
	str = findText.getText().toLowerCase();
      }

      area.requestFocus();
      int pos = txt.indexOf(str, area.getSelectionEnd());
	
      if (pos > 0)
	area.select(pos, pos + str.length());
	
      return true;
    }

    if (evt.target instanceof Checkbox)
	return true;
	
    return false;
  }
}

//
// Info dialog
//

class InfoDialog extends Dialog {
  public InfoDialog(Frame parent, String title, String msg) {
    super(parent, title, true);

    HPanel p = new HPanel(5, 0, 80);
    p.add(0, new Button("Close"));

    add("North", new Label(msg));
    add("South", p);	
  }

  public boolean handleEvent(Event evt) {
    if (evt.id == Event.WINDOW_DESTROY) 
      dispose();

    return super.handleEvent(evt);
  }

  public boolean action(Event evt, Object obj) {
    dispose();
    return true;
  }
}

