/*
 * java.net.PlainSocketImpl.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <native.h>
#include "../native/java.io/FileDescriptor.h"
#include "java.net/SocketImpl.h"
#include "java.net/InetAddress.h"
#include "java.net/PlainSocketImpl.h"
#include "nets.h"

/*
 * Create a stream or datagram socket.
 */
void
java_net_PlainSocketImpl_socketCreate(struct Hjava_net_PlainSocketImpl* this, long /* bool */ stream)
{
	int fd;
	int type;

	if (stream == 0) {
		type = SOCK_DGRAM;
	}
	else {
		type = SOCK_STREAM;
	}

	fd = threadedCreateSocket(AF_INET, type, 0);
	if (fd < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
	unhand(unhand(this)->super.fd)->fd = fd;
}

/*
 * Connect the socket to someone.
 */
void
java_net_PlainSocketImpl_socketConnect(struct Hjava_net_PlainSocketImpl* this, struct Hjava_net_InetAddress* daddr, long dport)
{
	int r;
	struct sockaddr_in addr;

#if defined(BSD44)
	addr.sin_len = sizeof(addr);
#endif
	addr.sin_family = AF_INET;
	addr.sin_port = htons(dport);
	addr.sin_addr.s_addr = htonl(unhand(daddr)->address);

	r = threadedConnect(unhand(unhand(this)->super.fd)->fd, (struct sockaddr*)&addr, sizeof(addr));
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}

/*
 * Bind this socket to an address.
 */
void
java_net_PlainSocketImpl_socketBind(struct Hjava_net_PlainSocketImpl* this, struct Hjava_net_InetAddress* laddr, long lport)
{
	int r;
	struct sockaddr_in addr;

#if defined(BSD44)
	addr.sin_len = sizeof(addr);
#endif
	addr.sin_family = AF_INET;
	addr.sin_port = lport;
	addr.sin_addr.s_addr = unhand(laddr)->address;

	r = bind(unhand(unhand(this)->super.fd)->fd, (struct sockaddr*)&addr, sizeof(addr));
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}

/*
 * Turn this socket into a listener.
 */
void
java_net_PlainSocketImpl_socketListen(struct Hjava_net_PlainSocketImpl* this, long count)
{
	int r;

	r = listen(unhand(unhand(this)->super.fd)->fd, count);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}

/*
 * Accept a connection.
 */
void
java_net_PlainSocketImpl_socketAccept(struct Hjava_net_PlainSocketImpl* this, struct Hjava_net_SocketImpl* sock)
{
	int r;
	int alen;
	struct sockaddr_in addr;

	alen = sizeof(addr);
#if defined(BSD44)
	addr.sin_len = sizeof(addr);
#endif
	addr.sin_family = AF_INET;
	addr.sin_port = unhand(sock)->port; /* localport ?? */
	addr.sin_addr.s_addr = unhand(unhand(sock)->address)->address;

	r = threadedAccept(unhand(unhand(this)->super.fd)->fd, (struct sockaddr*)&addr, &alen);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}

/*
 * Return how many byts can be read without blocking.
 */
long
java_net_PlainSocketImpl_socketAvailable(struct Hjava_net_PlainSocketImpl* this)
{
	return (0);
}

/*
 * Close this socket.
 */
void
java_net_PlainSocketImpl_socketClose(struct Hjava_net_PlainSocketImpl* this)
{
	int r;

	r = close(unhand(unhand(this)->super.fd)->fd);
	if (r < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}
