/*
 * java.lang.Double.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdlib.h>
#include <native.h>
#include "defs.h"
#include "java.lang/Double.h"

/*
 * Convert double to string.
 */
struct Hjava_lang_String*
java_lang_Double_toString(double val)
{
	char str[MAXNUMLEN];

	sprintf(str, "%g", val);
	return (makeJavaString(str, strlen(str)));
}

/*
 * Convert string to double object.
 */
struct Hjava_lang_Double*
java_lang_Double_valueOf(struct Hjava_lang_String* str)
{
	struct Hjava_lang_Double* obj;
	char buf[MAXNUMLEN];

	javaString2CString(str, buf, sizeof(buf));

	obj = (struct Hjava_lang_Double*)execute_java_constructor(0, "java.lang.Double", 0, "()V");
	unhand(obj)->value = atof(buf);

	return (obj);
}

/*
 * Convert double to long long.
 */
long long
java_lang_Double_doubleToLongBits(double val)
{
	return (*(long long*)&val);
}

/*
 * Convert long long to double.
 */
double
java_lang_Double_longBitsToDouble(long long val)
{
	return (*(double*)&val);
}
