/*
 * readClassConfig.h
 * Configure the class reader.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __readclassconfig_h
#define __readclassconfig_h

#include "classMethod.h"
#include "errors.h"
#include "lookup.h"

/*
 * Add a class to the system.
 */
#define	ADDCLASS(this, super, access, constants)			\
	classThis = addClass(this, super, access, constants);		\
	if (classThis == 0) {						\
		throwException(ClassFormatError);			\
	}

/*
 * Add the interfaces.
 */
#define	READINTERFACES(fp, this, count)					\
	do {								\
		createInfo cinfo;					\
		classes** interfaces;					\
		u2 iface;						\
		int i;							\
		if (count == 0) {					\
			return;						\
		}							\
		interfaces = (classes**)calloc(sizeof(classes**), count);\
		if (interfaces == 0) {					\
			throwException(OutOfMemoryError);		\
		}							\
		for (i = 0; i < count; i++) {				\
			readu2(&iface, fp);				\
			getClass(iface, this->constants, &cinfo);	\
			interfaces[i] = cinfo.class;			\
		}							\
		addInterfaces(this, count, interfaces);			\
	} while(0)

/*
 * Read in a field.
 */
#define	READFIELD(fp, this)						\
	do {								\
		field_info f;						\
		readu2(&f.access_flags, fp);				\
		readu2(&f.name_index, fp);				\
		readu2(&f.signature_index, fp);				\
		addField(this, &f);					\
	} while (0)

/*
 * Read in a method.
 */
#define	READMETHOD(fp, this)						\
	do {								\
		method_info m;						\
		readu2(&m.access_flags, fp);				\
		readu2(&m.name_index, fp);				\
		readu2(&m.signature_index, fp);				\
		methodThis = addMethod(this, &m);			\
	} while(0)


/*
 * Process the attributes.
 */
#define	READATTRIBUTE(fp, this, method)					\
	do {								\
		u2 idx;							\
		u2 len;							\
		readu2(&idx, fp);					\
		readu4(&len, fp);					\
DBG(		printf("Attribute '%s'\n", (char*)this->constants->data[idx]); )\
		if (this->constants->tags[idx] == CONSTANT_Utf8 &&	\
		    strcmp((char*)this->constants->data[idx], "Code") == 0) {\
			addCode(method, len, fp);			\
		}							\
		else {							\
			seekm(fp, len);					\
		}							\
	} while(0)

#endif
