/*
 * gc.h
 * The garbage collector.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __gc_h
#define __gc_h

#define	GC_FREE		0
#define	GC_MARK		1
#define	GC_UNMARK	2
#define	GC_GARBAGE	3
#define	GC_UNMARK2	4
#define	GC_GARBAGE2	5

struct _object;
typedef struct _gcRef {
	int		flags;			/* State of this entry */
	int		idx;			/* This entry index */
	struct _object*	obj;			/* Used - the object */
	struct _gcRef*	next;			/* Free - the next free */
} gcRef;

#define	GCREFTABLESZ		1024
#define	GCREFMAX		1024

void add_object(struct _object*, bool);
void invokeGarbageCollector(void);

#endif
