/*
 * classMethod.h
 * Class, method and field tables.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __classmethod_h
#define __classmethod_h

#include "gtypes.h"
#include "access.h"
#include "constants.h"
#include "object.h"

#define	MAXMETHOD		64

/* Class state */
#define	CSTATE_OK		0
#define	CSTATE_NEEDINIT		1
#define	CSTATE_DOINGINIT	2

struct _constants;
struct _methods;
struct _fields;
struct _methodTable;
struct _exception;

typedef struct _classes {
	object			head;		/* A class is an object too */
	struct _classes*	next;
	char*			name;
	char*			sig;
	int			accflags;
	char*			supername;
	struct _classes*	superclass;
	struct _constants*	constants;
	struct _methods*	methodList;
	struct _fields*		fieldList;
	int			fsize;
	struct _fields*		staticFieldList;
	int			sfsize;
	struct _methodTable*	mtable;
	int*			staticFields;
	struct _classes**	interface;
	int			interface_len;
	struct _classes*	nextInit;
	struct _classes*	prevInit;
	int			state;
	bool			final;
} classes;

typedef struct _methods {
	struct _methods*	next;
	strpair*		pair;
	accessFlags		accflags;
	char*			code;
	int			codelen;
	struct _instn*		insn;
	nativecode*		ncode;
	nativecode*		ncode_end;
	struct _constants*	constants;
	struct _exception*	exception_table;
	int			exception_table_len;
	struct _methods*	exception_next;
	int			stacksz;
	int			localsz;
	int			ins;
	int			outs;
	classes*		class;
	struct _tableswitch*	tableswitches;
	struct _lookupswitch*	lookupswitches;
} methods;

typedef struct _methodTable {
	classes*		class;
	struct {
		strpair*	tag;
		void*		method;
	} m[MAXMETHOD];
} methodTable;

#define	MTABLE_CLASS		0
#define	MTABLE_METHODOFFSET	4
#define	MTABLE_METHODSIZE	8
#define	MTABLE_TAG		0
#define	MTABLE_METHOD		4

typedef struct _fields {
	struct _fields*		next;
	char*			name;
	char*			sig;
	accessFlags		accflags;
	classes*		class;
	int			size;
	int			offset;
} fields;

#define	CLASSHASHSZ		128
#define	CLASSMAXSIG		256

struct _Code;
struct _method_info;

classes*	addClass(constIndex, constIndex, u2, struct _constants*);
methods*	addMethod(classes*, struct _method_info*);
void 		addMethodCode(methods*, struct _Code*);
classes*	lookupClass(char*);
classes*	simpleLookupClass(char*);
classes*	lookupArray(char*);
fields*		lookupClassField(char*, char*, bool);
void		countInsAndOuts(char*, int*, int*);
int		sizeofSig(char**);
void		establishMethod(methods*);
void		addInterfaces(classes*, int, classes**);

#endif
