/*
 * sigs.c
 * Translate a class into stubs.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>

/*
 * Translate signature into argument count.
 */
char*
translateSig(char* str, FILE* fp, int* argp)
{
	int j;
	int arg;

	switch (*str++) {
	case 'L':
		arg = 1;
		fprintf(fp, "struct H");
		for (j = 0; str[j] != ';'; j++) {
			if (str[j] == '/') {
				fputc('_', fp);
			}
			else {
				fputc(str[j], fp);
			}
		}
		fputc('*', fp);
		str += j + 1;
		break;
	case '[':
		arg = 1;
		switch (*str++) {
		case 'B':
			fprintf(fp, "HArrayOfByte*");
			break;
		case 'C':
			fprintf(fp, "HArrayOfChar*");
			break;
		case 'D':
			fprintf(fp, "HArrayOfDouble*");
			break;
		case 'F':
			fprintf(fp, "HArrayOfFloat*");
			break;
		case 'I':
		case 'Z':	/* Bool */
			fprintf(fp, "HArrayOfInt*");
			break;
		case 'S':
			fprintf(fp, "HArrayOfShort*");
			break;
		case 'J':
			fprintf(fp, "HArrayOfLong*");
			break;
		case '[':
			fprintf(fp, "HArrayOfArray*");
			/* Skip rest of definition */
			while (*str == '[') {
				str++;
			}
			if (*str++ == 'L') {
				while (*str++ != ';')
					;
			}
			break;
		case 'L':
			fprintf(fp, "HArrayOfObject*");
			while (*str++ != ';')
				;
			break;
		}
		break;
	case 'B':
		arg = 1;
		fprintf(fp, "long /* byte */");
		break;
	case 'C':
		arg = 1;
		fprintf(fp, "long /* char */");
		break;
	case 'D':
		arg = 2;
		fprintf(fp, "double");
		break;
	case 'F':
		arg = 1;
		fprintf(fp, "float");
		break;
	case 'I':
		arg = 1;
		fprintf(fp, "long");
		break;
	case 'J':
		arg = 2;
		fprintf(fp, "long long");
		break;
	case 'S':
		arg = 1;
		fprintf(fp, "long /* short */");
		break;
	case 'Z':
		arg = 1;
		fprintf(fp, "long /* bool */");
		break;
	case 'V':
		arg = 0;
		fprintf(fp, "void");
		break;
	default:
		abort();
	}

	if (argp != 0) {
		(*argp) += arg;
	}

	return (str);
}

/*
 * Translate signature to union type.
 */
char*
translateSigType(char* str, char* type)
{
	switch (*str++) {
	case 'L':
		type[0] = 'p';
		while (*str != ';') {
			str++;
		}
		str++;
		break;
	case '[':
		type[0] = 'p';
		if (*str++ == 'L') {
			while (*str != ';') {
				str++;
			}
			str++;
		}
		break;
	case 'B': case 'C': case 'I': case 'S': case 'Z':
		type[0] = 'i';
		break;
	case 'D':
		type[0] = 'd';
		break;
	case 'F':
		type[0] = 'f';
		break;
	case 'J':
		type[0] = 'l';
		break;
	case 'V':
		type[0] = 'v';
		break;
	}
	return (str);
}
