/*
 * constants.h
 * Manage constants.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __constant_h
#define __constant_h

/*
 * Constant pool definitions.
 */
#define	CONSTANT_Class			7
#define	CONSTANT_Fieldref		9
#define	CONSTANT_Methodref		10
#define	CONSTANT_InterfaceMethodref	11
#define	CONSTANT_String			8
#define	CONSTANT_Integer		3
#define	CONSTANT_Float			4
#define	CONSTANT_Long			5
#define	CONSTANT_Double			6
#define	CONSTANT_NameAndType		12
#define	CONSTANT_Utf8			1
#define	CONSTANT_Unicode		2

#define	CONSTANT_Unknown		0
#define	CONSTANT_Chararray		128

typedef u2	constIndex;

typedef struct _constants {
	u2	size;
	u1*	tags;
	u4*	data;
} constants;

#define	STRHASHSZ		128

typedef struct _strconst {
	struct _strconst*	next;
	struct _stringClass*	string;
	char			data[0];
} strconst;

constants*	readConstantPool(FILE*);
char*		addStringConstant(strconst*);

#endif
