/*
 * native.h
 * Native method support.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#ifndef __native_h
#define __native_h

struct _methods;
struct _classes;
struct _thread;

/* From object.h */
#define	__object_h
typedef struct _object {
	struct _methodTable*	mtable;
	unsigned int		idx;
	unsigned int		size;
	struct _thread*		holder;
	int			count;
	struct _thread*		muxWaiters;
	struct _thread*		cvWaiters;
	char			data[0];
} object;

/* From baseClasses.h */
typedef struct _stringClass {
	object		head;
	object*		value;
	int		offset;
	int		count;
} stringClass;

/* Build an object handle */
#define	HandleTo(class)					\
	struct H##class {				\
		object obj;				\
		struct Class##class data[0];		\
	}

/* Turn a handle into the real thing */
#define	unhand(o)	((o)->data)

/* Some internal machine object conversions to "standard" types. */
#define	Hjava_lang_Object	_object
#define	Hjava_lang_String	_stringClass
#define	Hjava_lang_Class	_classes

/* Array types */
#define	HArray			struct _object	/* Stub compatibity */
#define	HArrayOfByte		struct _object
#define	HArrayOfChar		struct _object
#define	HArrayOfDouble		struct _object
#define	HArrayOfFloat		struct _object
#define	HArrayOfInt		struct _object
#define	HArrayOfShort		struct _object
#define	HArrayOfLong		struct _object
#define	HArrayOfArray		struct _object
#define	HArrayOfObject		struct _object

extern char* javaString2CString(struct Hjava_lang_String*, char*, int);
extern struct Hjava_lang_String* makeJavaString(char*, int);

long	do_execute_java_method(void*, object*, char*, char*, struct _methods*, int, ...);
long	do_execute_java_class_method(char*, char*, char*, ...);
object* execute_java_constructor(void*, char*, struct _classes*, char*, ...);

void	SignalError(void*, char*, char*);

void	classname2pathname(char*, char*);

#endif
