/*
 * java.io.FileInputStream.c
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include <stdio.h>
#include <assert.h>
#include "files.h"
#include "java.io/FileInputStream.h"
#include "java.io/FileDescriptor.h"

/*
 * Open a file for input.
 */
void
java_io_FileInputStream_open(struct Hjava_io_FileInputStream* this, struct Hjava_lang_String* name)
{
	char str[MAXPATHLEN];
	int fd;

	javaString2CString(name, str, sizeof(str));
	fd = open(str, O_RDONLY);
	unhand(unhand(this)->fd)->fd = fd;
	if (fd < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
}

/*
 * Close file.
 */
void
java_io_FileInputStream_close(struct Hjava_io_FileInputStream* this)
{
	int r;

	if (unhand(unhand(this)->fd)->fd >= 0) {
		r = close(unhand(unhand(this)->fd)->fd);
		unhand(unhand(this)->fd)->fd = -1;
		if (r < 0) {
			SignalError(0, "java.io.IOException", SYS_ERROR);
		}
	}
}

/*
 * Read in bytes.
 */
long
java_io_FileInputStream_readBytes(struct Hjava_io_FileInputStream* fh, HArray* bytes, long off, long len)
{
	long ret;

	ret = read(unhand(unhand(fh)->fd)->fd, &bytes->data[off], len);
	if (ret < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
	return (ret);
}

/*
 * Read a single byte.
 */
long
java_io_FileInputStream_read(struct Hjava_io_FileInputStream* fh)
{
	long ret;
	unsigned char byte;

	ret = read(unhand(unhand(fh)->fd)->fd, &byte, 1);
	if (ret < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
	return (byte);
}

/*
 * Skip forward in stream.
 */
long long
java_io_FileInputStream_skip(struct Hjava_io_FileInputStream* fh, long long off)
{
	long long ret;

	ret = lseek(unhand(unhand(fh)->fd)->fd, off, 1);
	if (ret < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
	return (ret);
}

/*
 * Return the number of bytes available to read without blocking.
 */
long
java_io_FileInputStream_available(struct Hjava_io_FileInputStream* fh)
{
	int fd;
	struct stat buf;
	int ret;
	long long sret;

	fd = unhand(unhand(fh)->fd)->fd;
	ret = fstat(fd, &buf);
	sret = lseek(fd, 0, 1);
	if (ret < 0 || sret < 0) {
		SignalError(0, "java.io.IOException", SYS_ERROR);
	}
	return (buf.st_size - sret);
}
