/*
 * soft1.c
 * Soft instruction implementations.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#include "gtypes.h"
#include "needs.h"
#include "md.h"

#ifdef NEED_soft_lmul
/*
 * Multiple two longs (64 bits).
 */
void
soft_lmul(long long v2, long long v1)
{
	*(&v1) = v1 * v2;
}
#endif

#ifdef NEED_soft_ldiv
/*
 * Divide two longs (64 bits).
 */
void
soft_ldiv(long long v2, long long v1)
{
	*(&v1) = v1 / v2;
}
#endif

#ifdef NEED_soft_lrem
/*
 * Divide two longs (64 bits) and retrieve remainder.
 */
void
soft_lrem(long long v2, long long v1)
{
	*(&v1) = v1 % v2;
}
#endif

#ifdef	NEED_soft_frem
void
soft_frem(float v2, float v1)
{
	*(&v1) = v1 - (int)(v1 / v2) * v2;
}
#endif

#ifdef	NEED_soft_drem
void
soft_drem(double v2, double v1)
{
	*(&v1) = v1 - (int)(v1 / v2) * v2;
}
#endif

#ifdef	NEED_soft_lshl
void
soft_lshl(uint32 i1, long long v1)
{
	*(&v1) = v1 << i1;
}
#endif

#ifdef	NEED_soft_lshr
void
soft_lshr(uint32 i1, long long v1)
{
	*(&v1) = v1 >> i1;
}
#endif

#ifdef	NEED_soft_lushr
void
soft_lushr(uint32 i1, unsigned long long v1)
{
	*(&v1) = v1 >> i1;
}
#endif

#ifdef NEED_soft_lcmp
void
soft_lcmp(long long v2, long long v1)
{
	long long ret;

	if (v1 > v2) {
		ret = 1;
	}
	else if (v1 == v2) {
		ret = 0;
	}
	else {
		ret = -1;
	}
	*(&v1) = ret << 32;
}
#endif

#ifdef NEED_soft_fcmpl
void
soft_fcmpl(float v2, float v1)
{
	int ret;
	if (v1 > v2) {
		ret = 1;
	}
	if (v1 == v2) {
		ret = 0;
	}
	else {
		ret = -1;
	}
	*(int*)&v1 = ret;
}
#endif

#ifdef NEED_soft_fcmpg
void
soft_fcmpg(double v2, double v1)
{
	long long ret;
	if (v1 > v2) {
		ret = 1;
	}
	if (v1 == v2) {
		ret = 0;
	}
	else {
		ret = -1;
	}
	*(long long*)&v1 = ret << 32;
}
#endif

#ifdef NEED_soft_dcmpl
void
soft_dcmpl(double v2, double v1)
{
	long long ret;
	if (!finite(v1) || !finite(v2)) {
		ret = -1;
	}
	else {
		ret = v1 < v2;
	}
	*((long long*)&v1) = ret << 32;
}
#endif

#ifdef NEED_soft_dcmpg
void
soft_dcmpg(double v2, double v1)
{
	long long ret;
	if (!finite(v1) || !finite(v2)) {
		ret = 1;
	}
	else {
		ret = v1 > v2;
	}
	*((long long*)&v1) = ret << 32;
}
#endif
