/*
 * external.c
 * Handle method calls to other languages.
 *
 * Copyright (c) 1996 Systems Architecture Research Centre,
 *		   City University, London, UK.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * Written by Tim Wilkinson <tim@sarc.city.ac.uk>, February 1996.
 */

#define	DBG(s)

#include "config.h"
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>
#include "gtypes.h"
#include "classMethod.h"
#include "external.h"
#include "errors.h"
#include "exception.h"

/*
 * Some version of dlsym need an underscore, some don't.
 */
#if defined(HAVE_DYN_UNDERSTORE)
#define	STUB_PREFIX		"_Kaffe_"
#define	STUB_PREFIX_LEN		7
#else
#define	STUB_PREFIX		"Kaffe_"
#define	STUB_PREFIX_LEN		6
#endif

static void* libHandle[MAXLIBS];
char libraryPath[MAXLIBPATH];

void
initNative(void)
{
	char lib[MAXLIBPATH];
	char* ptr;
	char* nptr;

	ptr = getenv(LIBRARYPATH);
	if (ptr == 0) {
		fprintf(stderr, "No library path set.\n");
		return;
	}
	strcpy(libraryPath, ptr);

	/* Find the default library */
	for (ptr = libraryPath; ptr != 0; ptr = nptr) {
		nptr = strchr(ptr, ':');
		if (nptr == 0) {
			strcpy(lib, ptr);
		}
		else {
			strncpy(lib, ptr, nptr - ptr);
			lib[nptr-ptr] = 0;
			nptr++;
		}
		strcat(lib, "/");
		strcat(lib, NATIVELIBRARY);
		strcat(lib, ".");
		strcat(lib, LIBRARYSUFFIX);

		if (loadNativeLibrary(lib) == 0) {
			return;
		}
	}
	fprintf(stderr, "Failed to locate native library ... aborting.\n");
	fflush(stderr);
	exit(1);
}

int
loadNativeLibrary(char* lib)
{
	int i;

	/* Find a library handle */
	for (i = 0; i < MAXLIBS; i++) {
		if (libHandle[i] == 0) {
			goto open;
		}
	}
	return (-1);

	/* Open the library */
	open:
	libHandle[i] = dlopen(lib, 1);
	if (libHandle[i] == 0) {
		return (-1);
	}
	return (0);
}

void
native(methods* m)
{
	char stub[MAXSTUBLEN];
	char* ptr;
	int i;
	void* func;

	/* Construct the stub name */
	strcpy(stub, STUB_PREFIX);
	ptr = m->class->name;
	for (i = STUB_PREFIX_LEN; *ptr != 0; ptr++, i++) {
		if (*ptr == '/') {
			stub[i] = '_';
		}
		else {
			stub[i] = *ptr;
		}
	}
	stub[i] = '_';
	stub[i+1] = 0;
	strcat(stub, m->pair->s1);
	strcat(stub, "_stub");

DBG(	printf("Method = %s.%s%s\n", m->class->name, m->pair->s1, m->pair->s2);)
DBG(	printf("Native stub = '%s'\n", stub);fflush(stdout);		)

	/* Find the native method */
	for (i = 0; i < MAXLIBS && libHandle[i] != 0; i++) {
		func = dlsym(libHandle[i], stub);
		if (func != 0) {
			/* Fill it in */
			m->ncode = func;
			return;
		}
	}
	fprintf(stderr, "Failed to locate native function:\n\t%s.%s%s\n", m->class->name, m->pair->s1, m->pair->s2);
	fflush(stderr);

	throwException(UnsatisfiedLinkError);
}

/*
 * Return the library path.
 */
char*
getLibraryPath(void)
{
	return (libraryPath);
}
