//****************************************************************************
//*    Class: CallbackTimer.java                                             *
//* Comments: Implements a callback timer class. Used with TimeOut interface *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.util;

//****************************************************************************
//* CallbackTimer                                                            *
//****************************************************************************

/**
 * CallbackTimer is a class that works in conjunction with the Timed
 * interface. When a class implements the Timed interface it is eligible
 * to be called back by an instance of this, the CallbackTimer, class.
 *
 * This class extends Thread so it must be started, and can be suspended while
 * running.
 *
 * @see EventTimer
 *
 * @version		1.00, 1 May 1996
 * @author		Jerry Ablan, munster@mcs.net
 */

public class
CallbackTimer
extends Thread
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	/**
	 * The number of milliseconds between timeouts
	 */
	private int					myInterval;
	/**
	 * The object to call when the timeout occurs
	 */
	private TimeOut				myTarget;

//****************************************************************************
//* CallbackTimer                                                            *
//****************************************************************************

	/**
	 * Constructs a CallbackTimer object.
	 *
	 * @param target The object that is requesting the timer
	 * @param interval The number of milliseconds between notifications
	 */

	public
	CallbackTimer( TimeOut target, int interval )
	{
		//	Save my values...
		myTarget = target;
		myInterval = interval;

		//	Indicate that this is not a user thread...
		setDaemon( true );
	}

//****************************************************************************
//* run                                                                      *
//****************************************************************************

	/**
	 * Waits until the the specified period of time has elapsed and then
	 * calls the tick() method of the target object.
	 */

	public void
	run()
	{
		//	Do this forever!
		while ( true )
		{
			try
			{
				//	Wait until next interval...
				sleep( myInterval );
			}
			catch ( InterruptedException ie ) {}

			//	Notify the target...
			myTarget.timeOut( this );
		}
	}
}