//****************************************************************************
//*                                                                          *
//*    Class: SequenceGenerator.java                                         *
//*   Author: Gerald H. Ablan, Jr.                                           *
//*     Date: April 28, 1996                                                 *
//*                                                                          *
//* Comments: Generates a unique sequence for a table                        *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.sql;

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

//	JDBC Imports...
import							java.sql.*;
import							imaginary.sql.*;

//****************************************************************************
//* SequenceGenerator                                                        *
//****************************************************************************

/**
 * This class will generate a unique sequence for a table. Some RDBMS's
 * can do this on the server side. This class retrieves all the rows and
 * calculates the maximum and adds one.
 *
 * @version		1.00, 26 Apr 1996
 * @author		Jerry Ablan, munster@mcs.net
 */

public class
SequenceGenerator
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	int							currentValue = 1;
	JifConnector				myConnection;
	String						myTable;
	String						myColumn;

//****************************************************************************
//* Constructors                                                             *
//****************************************************************************

	/**
	 * Creates a SequenceGenerator object
	 * @param connector The database connection object
	 * @param table The table to check
	 * @param column The column to get
	 */

	public
	SequenceGenerator( JifConnector connector, String table, String column )
	{
		myConnection = connector;
		myTable = table;
		myColumn = column;

		setCurrentValue();
	}

//****************************************************************************
//* getNextValue                                                             *
//****************************************************************************

	public int
	getNextValue()
	{
		currentValue++;
		return( currentValue );
	}

//****************************************************************************
//* getCurrentValue                                                          *
//****************************************************************************

	public int
	getCurrentValue()
	{
		return( currentValue );
	}

//****************************************************************************
//* setCurrentValue                                                          *
//****************************************************************************

	protected void
	setCurrentValue()
	{
		//	The first row returned by this SQL statement is the largest number...
		String sql = "select " + myColumn + " from " + myTable + " order by " + myColumn + " desc";

		try
		{
			if ( myConnection.myStatement.execute( sql ) )
			{
				//	Check the first row!
				ResultSet rs = myConnection.myStatement.getResultSet();
				rs.next();
				currentValue = rs.getInteger( 1 );
			}
		}
		catch ( SQLException e )
		{
			//	No records? Set to 1...
			currentValue = 1;
		}
	}

}