//****************************************************************************
//*    Class: ScreenLog.java                                                 *
//* Comments: A standard logging pathway to the screen                       *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Package                                                                  *
//****************************************************************************

package							jif.log;

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import							jif.util.*;

//****************************************************************************
//* ScreenLog                                                                *
//****************************************************************************

/**
 * An class that defines screen destinations for log files
 *
 * @version		1.00, 26 Apr 1996
 * @author		Jerry Ablan, munster@mcs.net
 */

public class
ScreenLog
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	private String				appName;

//****************************************************************************
//* Constructor                                                              *
//****************************************************************************

	/**
	 * Builds a ScreenLog object
	 * @param name The name of the application using this log
	 */

	public
	ScreenLog( String name )
	{
		appName = name;
	}

//****************************************************************************
//* log                                                                      *
//****************************************************************************

	/**
	 * Handles the default log case, which is write to screen...
	 * @param logLevel The severity of the log entry
	 * @param logEntry The log entry
	 */

	public void
	log( char logLevel, String logEntry )
	{
		String	logLine = appName + "|";

		//	Use the jif.util.FileDate for this new method...
		logLine += ( new FileDate() ).toFileString() + "|";
		logLine += logLevel + "|";
		logLine += logEntry;
		
		//	Let the system define how lines are terminated...
		logLine += System.getProperty( "line.separator" );

		//	Write it out to the screen...
		System.out.print( logLine );
	}

}