//****************************************************************************
//* Interface: JifApplication.java                                           *
//*  Comments: The interface that all JIFlets need to adhere to.             *
//*                                                                          *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* package                                                                  *
//****************************************************************************

package							jif.jiflet;

//****************************************************************************
//* Application                                                              *
//****************************************************************************

/**
 * Defines a standard interface for Jiflets
 *
 * @see jif.jiflet.Jiflet
 *
 * @version		1.00, 1 May 1996
 * @author		Jerry Ablan, munster@mcs.net
 */

public interface
JifApplication
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	/**
	 * These constants define the JIF Log Levels (JLL) that can be
	 * used for logging.
	 */

	public static final char 	JLL_DEBUG = 'D';
	public static final char 	JLL_INFO = 'I';
	public static final char 	JLL_WARNING = 'W';
	public static final char 	JLL_ERROR = 'E';
	public static final char 	JLL_FATAL = 'F';

//****************************************************************************
//* init                                                                     *
//****************************************************************************

	public void init();

//****************************************************************************
//* log                                                                      *
//****************************************************************************

	public void log( char logLevel, String logEntry );

}
