//****************************************************************************
//*    Class: JifServer.java                                                 *
//*   Author: Gerald H. Ablan, Jr.                                           *
//*  Version: 1.0                                                            *
//*                                                                          *
//* Comments: Implements a class for messaging between clients and servers   *
//*                                                                          *
//****************************************************************************
//*                             Revision History                             *
//****************************************************************************
//* 05.11.96: GHA - Creation                                                 *
//* xx.xx.xx:                                                                *
//****************************************************************************

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import							java.net.*;
import							java.io.*;
import							java.awt.*;
import							java.util.*;
import							jif.*;

//****************************************************************************
//* JifServer                                                                *
//****************************************************************************

public class
JifServer
extends Jiflet
{
	protected int			port;
	protected ServerSocket	listener;
	protected ThreadGroup	threadGroup;
	protected List			clientList;
	protected Vector		clients;
	protected JifVoyeur		voyeur;

	public
	JifServer( String args[] )
	{
		super( "JIF Server Status", "jifServer", args );
	}

	public void
	init()
	{
		try
		{
			listener = new ServerSocket( DEFAULT_SERVER_PORT );
		}
		catch ( IOException ioe )
		{
			suicide( ioe, "Exception creating server socket" );
		}

		threadGroup = new ThreadGroup( "JifServer JifClients" );
		clientList = new List();

		add( "Center", clientList );
		resize( 400, 200 );
		show();

		clients = new Vector();
		voyeur = new JifVoyeur( this );

		super.init();
	}

	public void
	run()
	{
		try
		{
			while ( true )
			{
				Socket client = listener.accept();

				JifClient c = new JifClient( client, threadGroup, 3, voyeur );

				synchronized( clients )
				{
					clients.addElement( c );
					clientList.addItem( c.toString() );
				}

				//	All kids love log!
				log( "Client [" + client.getInetAddress().getHostName() + ":" + client.getPort() + "] accepted" );
			}
		}
		catch ( IOException ioe )
		{
			suicide( ioe, "Exception while listening for clients" );
		}
	}

	public static void
	main( String args[] )
	{
		new JifServer( args );
	}

}