//****************************************************************************
//*                                                                          *
//*   Jiflet: EmployeePickList.java                                          *
//*   Author: Gerald H. Ablan, Jr.                                           *
//*     Date: April 28, 1996                                                 *
//*                                                                          *
//* Comments: An employee picklist                                           *
//*                                                                          *
//****************************************************************************

//****************************************************************************
//* Imports                                                                  *
//****************************************************************************

import 							jif.jiflet.*;
import							jif.widgets.*;
import							jif.sql.*;

import 							java.awt.*;
import 							java.sql.*;
import							java.util.Vector;

import							imaginary.sql.*;

//****************************************************************************
//* Employee                                                                 *
//****************************************************************************

public class
EmployeePickList
extends PickList
{

//****************************************************************************
//* Members                                                                  *
//****************************************************************************

	//	Our database connection!
	JifConnector				myConnection;
	Vector						rowMap = new Vector( 5 );

//****************************************************************************
//* Constructor                                                              *
//****************************************************************************

	public
	EmployeePickList( Frame daddy, JifConnector aConnector )
	{
		//	Phone home
		super( daddy, "Employee Selector" );

		//	Need a connector!
		myConnection = aConnector;

		//	Initialize myself!
		init();
	}

//****************************************************************************
//* init                                                                     *
//****************************************************************************

	public void
	init()
	{
		int rows = retrieveEmployees();

		if ( rows > 0 && getParent() instanceof Jiflet )
			( ( Jiflet )getParent() ).verboseLog( "Retrieved " +
				Integer.toString( rows ) + " Employees" );
	}

//****************************************************************************
//* retrieveEmployees                                                        *
//****************************************************************************

	int
	retrieveEmployees()
	{
		String		sql;
		boolean		rv = false;
		int			rows = 0;

		sql = "select * from emp_t order by last_name, first_name";

		try
		{
			rv = myConnection.myStatement.execute( sql );
		}
		catch ( SQLException e )
		{
			//	No employees to return...
			return( 0 );
		}

		//	Is this a result set?
		if ( rv )
		{
			try
			{
				ResultSet rs = myConnection.myStatement.getResultSet();

				//	Spin through the results and add them to the list...
				while ( rs.next() )
				{
					EmployeeRecord er = new EmployeeRecord( rs );

					//	Add to list...
					if ( er.emp_id != -1 )
					{
						myList.addItem( er.nice_name );

						//	Add to row mapper...
						rowMap.insertElementAt( er, rows );

						//	Increment row counter...
						rows++;
					}
				}
			}
			catch ( SQLException e )
			{
				//	Indicate an error!
				rows = -1;
			}
		}

		//	We're done!
		return( rows );
	}

//****************************************************************************
//* getRecord                                                                *
//****************************************************************************

	public EmployeeRecord
	getRecord( int where )
	{
		return( ( EmployeeRecord )rowMap.elementAt( where ) );
	}

}
